/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.ArrayUtil;
import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.ions.Charge;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.biology.variants.Variant;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.PeptideVariantMatches;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationParameters;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.XYPlottingDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.genes.GeneDetailsDialog;
import com.compomics.util.gui.spectrum.FragmentIonTable;
import com.compomics.util.gui.spectrum.IntensityHistogram;
import com.compomics.util.gui.spectrum.MassErrorBubblePlot;
import com.compomics.util.gui.spectrum.MassErrorPlot;
import com.compomics.util.gui.spectrum.SequenceFragmentationPanel;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.math.statistics.distributions.NonSymmetricalNormalDistribution;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.gui.MatchValidationDialog;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceDialog;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferencePeptideLevelDialog;
import eu.isas.peptideshaker.gui.protein_sequence.ProteinSequencePanel;
import eu.isas.peptideshaker.gui.protein_sequence.ProteinSequencePanelParent;
import eu.isas.peptideshaker.gui.protein_sequence.ResidueAnnotation;
import eu.isas.peptideshaker.gui.tablemodels.PeptideTableModel;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import eu.isas.peptideshaker.gui.tablemodels.PsmTableModel;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.scoring.PSMaps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.data.JSparklinesDataset;
import no.uib.jsparklines.extra.ChromosomeTableCellRenderer;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesMultiIntervalChartTableCellRenderer;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;

public class OverviewPanel
extends JPanel
implements ProteinSequencePanelParent {
    private ArrayList<Boolean> panelsShownUponMaximze;
    private ProgressDialogX progressDialog;
    private long currentSpectrumMatchKey = ExperimentObject.NO_KEY;
    private HashMap<Double, HashMap<int[], Integer>> coverage;
    private String currentProteinAccession;
    private String currentProteinSequence = "";
    private SpectrumPanel spectrumPanel;
    private boolean displaySpectrum = true;
    private boolean displayCoverage = true;
    private boolean displayProteins = true;
    private boolean displayPeptidesAndPSMs = true;
    private long[] proteinKeys = new long[0];
    private long[] peptideKeys = new long[0];
    private long[] psmKeys = new long[0];
    private final PeptideShakerGUI peptideShakerGUI;
    private ArrayList<String> proteinTableToolTips;
    private ArrayList<String> peptideTableToolTips;
    private ArrayList<String> psmTableToolTips;
    private ChartPanel coverageChart;
    private ChartPanel ptmChart;
    private ChartPanel peptideVariationsChart;
    private ProteinSequencePanel proteinSequencePanel;
    private ProteinSequencePanel ptmSequencePanel;
    private ProteinSequencePanel peptideVariationSequencePanel;
    private MassErrorBubblePlot massErrorBubblePlot;
    private MassErrorPlot massErrorPlot;
    private IntensityHistogram intensityHistogram;
    private SequenceFragmentationPanel sequenceFragmentationPanel;
    private double lastMzMaximum = 0.0;
    private final int spectrumSubPlotDividerLocation = 80;
    private final int coveragePanelDividerLocation = 82;
    private boolean isSelfUpdating = true;
    private JSlider accuracySlider;
    private JLayeredPane backgroundLayeredPane;
    private JPanel bubbleAnnotationMenuPanel;
    private JPanel bubbleJPanel;
    private JToolBar bubblePlotJToolBar;
    private JPanel bubblePlotTabJPanel;
    private JPanel contextMenuPeptidesBackgroundPanel;
    private JPanel contextMenuProteinsBackgroundPanel;
    private JPanel contextMenuPsmsBackgroundPanel;
    private JPanel contextMenuSequenceCoverageBackgroundPanel;
    private JPanel contextMenuSpectrumBackgroundPanel;
    private JSplitPane coverageJSplitPane;
    private ButtonGroup coveragePeptideTypesButtonGroup;
    private JRadioButtonMenuItem coverageShowAllPeptidesJRadioButtonMenuItem;
    private JRadioButtonMenuItem coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem;
    private JCheckBoxMenuItem coverageShowPossiblePeptidesJCheckBoxMenuItem;
    private JRadioButtonMenuItem coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem;
    private JMenuItem deselectAllMenuItem;
    private JButton exportPeptidesJButton;
    private JButton exportProteinsJButton;
    private JButton exportPsmsJButton;
    private JButton exportSequenceCoverageContextJButton;
    private JButton exportSpectrumJButton;
    private JPanel fragmentIonJPanel;
    private JScrollPane fragmentIonsJScrollPane;
    private JButton hideCoverageJButton;
    private JButton hidePeptideAndPsmsJButton;
    private JButton hidePeptideAndPsmsJButton2;
    private JButton hideProteinsJButton;
    private JButton hideSpectrumPanelJButton;
    private JSlider intensitySlider;
    private JPanel ionTableAnnotationMenuPanel;
    private JToolBar ionTableJToolBar;
    private JPopupMenu.Separator jSeparator1;
    private JButton maximizeSpectrumPanelJButton;
    private JPanel overviewJPanel;
    private JSplitPane overviewJSplitPane;
    private JScrollPane peptideScrollPane;
    private JTable peptideTable;
    private JButton peptidesHelpJButton;
    private JPanel peptidesJPanel;
    private JLayeredPane peptidesLayeredPane;
    private JPanel peptidesPanel;
    private JSplitPane peptidesPsmJSplitPane;
    private JSplitPane peptidesPsmSpectrumFragmentIonsJSplitPane;
    private JScrollPane proteinScrollPane;
    private JTable proteinTable;
    private JButton proteinsHelpJButton;
    private JPanel proteinsJPanel;
    private JLayeredPane proteinsLayeredPane;
    private JPanel proteinsLayeredPanel;
    private JPanel psmJPanel;
    private JTable psmTable;
    private JButton psmsHelpJButton;
    private JLayeredPane psmsLayeredPane;
    private JPanel psmsPanel;
    private JPanel secondarySpectrumPlotsJPanel;
    private JMenuItem selectAllMenuItem;
    private JPopupMenu selectJPopupMenu;
    private JPopupMenu sequenceCoverageExportPopupMenu;
    private JPanel sequenceCoverageInnerPanel;
    private JPanel sequenceCoverageJPanel;
    private JPopupMenu sequenceCoverageJPopupMenu;
    private JLayeredPane sequenceCoverageLayeredPane;
    private JButton sequenceCoverageOptionsJButton;
    private JMenuItem sequenceCoveragePlotExportMenuItem;
    private JMenuItem sequenceCoverageSequenceExportMenuItem;
    private JPanel sequenceCoverageTitledPanel;
    private JButton sequenceCoveragetHelpJButton;
    private JPanel sequencePtmsPanel;
    private JPanel sequenceVariationsPanel;
    private JPopupMenu.Separator showCoverageAfterSeparator;
    private JButton showCoverageJButton;
    private JPopupMenu.Separator showPeptidesAfterSeparator;
    private JButton showPeptidesAndPsmsJButton;
    private JPopupMenu.Separator showProteinsAfterSeparator;
    private JPopupMenu.Separator showProteinsBeforeSeparator;
    private JButton showProteinsJButton;
    private JPopupMenu.Separator showSpectrumAfterSeparator;
    private JButton showSpectrumJButton;
    private JPanel slidersPanel;
    private JSplitPane slidersSplitPane;
    private JScrollPane spectraScrollPane;
    private JPanel spectrumAnnotationMenuPanel;
    private JPanel spectrumContainerJPanel;
    private JButton spectrumHelpJButton;
    private JPanel spectrumJPanel;
    private JTabbedPane spectrumJTabbedPane;
    private JToolBar spectrumJToolBar;
    private JLayeredPane spectrumLayeredPane;
    private JPanel spectrumMainJPanel;
    private JPanel spectrumMainPanel;
    private JPanel spectrumOuterJPanel;
    private JPanel spectrumPaddingPanel;
    private JSplitPane spectrumSplitPane;
    private JToolBar toolBar;

    public OverviewPanel(PeptideShakerGUI parent) {
        this.peptideShakerGUI = parent;
        this.initComponents();
        this.proteinTable.getTableHeader().setReorderingAllowed(false);
        this.peptideTable.getTableHeader().setReorderingAllowed(false);
        this.psmTable.getTableHeader().setReorderingAllowed(false);
        this.proteinTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OverviewPanel.this.proteinTableMouseClicked(e);
            }
        });
        this.peptideTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OverviewPanel.this.peptideTableMouseClicked(e);
            }
        });
        this.psmTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OverviewPanel.this.psmTableMouseClicked(e);
            }
        });
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.proteinScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        JPanel peptideCorner = new JPanel();
        peptideCorner.setBackground(this.peptideTable.getTableHeader().getBackground());
        this.peptideScrollPane.setCorner("UPPER_RIGHT_CORNER", peptideCorner);
        JPanel psmCorner = new JPanel();
        psmCorner.setBackground(this.psmTable.getTableHeader().getBackground());
        this.spectraScrollPane.setCorner("UPPER_RIGHT_CORNER", psmCorner);
        JPanel ionTableCorner = new JPanel();
        ionTableCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.fragmentIonsJScrollPane.setCorner("UPPER_RIGHT_CORNER", ionTableCorner);
        SelfUpdatingTableModel.addSortListener((JTable)this.proteinTable, (ProgressDialogX)new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
        SelfUpdatingTableModel.addSortListener((JTable)this.peptideTable, (ProgressDialogX)new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
        SelfUpdatingTableModel.addSortListener((JTable)this.psmTable, (ProgressDialogX)new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
        SelfUpdatingTableModel.addScrollListeners((JTable)this.proteinTable, (JScrollPane)this.proteinScrollPane, (JScrollBar)this.proteinScrollPane.getVerticalScrollBar());
        SelfUpdatingTableModel.addScrollListeners((JTable)this.peptideTable, (JScrollPane)this.peptideScrollPane, (JScrollBar)this.peptideScrollPane.getVerticalScrollBar());
        SelfUpdatingTableModel.addScrollListeners((JTable)this.psmTable, (JScrollPane)this.spectraScrollPane, (JScrollBar)this.spectraScrollPane.getVerticalScrollBar());
        this.proteinScrollPane.getViewport().setOpaque(false);
        this.peptideScrollPane.getViewport().setOpaque(false);
        this.spectraScrollPane.getViewport().setOpaque(false);
        this.fragmentIonsJScrollPane.getViewport().setOpaque(false);
        this.spectrumJTabbedPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.setUpTableHeaderToolTips();
        this.updateSeparators();
        this.formComponentResized(null);
    }

    private void setUpTableHeaderToolTips() {
        this.proteinTableToolTips = new ArrayList();
        this.proteinTableToolTips.add(null);
        this.proteinTableToolTips.add("Starred");
        this.proteinTableToolTips.add("Protein Inference Class");
        this.proteinTableToolTips.add("Protein Accession Number");
        this.proteinTableToolTips.add("Protein Description");
        this.proteinTableToolTips.add("Chromosome Number");
        this.proteinTableToolTips.add("Protein Sequence Coverage (%) (Confident / Doubtful / Not Validated / Possible)");
        this.proteinTableToolTips.add("Number of Peptides (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Number of Spectra (Confident / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("MS2 Quantification");
        this.proteinTableToolTips.add("Protein Molecular Weight (kDa)");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.add("Protein Score");
        } else {
            this.proteinTableToolTips.add("Protein Confidence");
        }
        this.proteinTableToolTips.add("Validated");
        this.peptideTableToolTips = new ArrayList();
        this.peptideTableToolTips.add(null);
        this.peptideTableToolTips.add("Starred");
        this.peptideTableToolTips.add("Protein Inference Class");
        this.peptideTableToolTips.add("Peptide Sequence");
        this.peptideTableToolTips.add("Peptide Start Index");
        this.peptideTableToolTips.add("Number of Spectra (Confident / Doubtful / Not Validated)");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.peptideTableToolTips.add("Peptide Score");
        } else {
            this.peptideTableToolTips.add("Peptide Confidence");
        }
        this.peptideTableToolTips.add("Validated");
        this.psmTableToolTips = new ArrayList();
        this.psmTableToolTips.add(null);
        this.psmTableToolTips.add("Starred");
        this.psmTableToolTips.add("Identification Software Agreement");
        this.psmTableToolTips.add("Peptide Sequence");
        this.psmTableToolTips.add("Precursor Charge");
        this.psmTableToolTips.add("m/z Error");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.psmTableToolTips.add("Peptide Spectrum Match Score");
        } else {
            this.psmTableToolTips.add("Peptide Spectrum Match Confidence");
        }
        this.psmTableToolTips.add("Validated");
    }

    private void setTableProperties() {
        this.setProteinTableProperties();
        this.setPeptideTableProperties();
        this.setPsmTableProperties();
    }

    private void setProteinTableProperties() {
        ProteinTableModel.setProteinTableProperties(this.proteinTable, this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColorNonValidated(), this.peptideShakerGUI.getSparklineColorNotFound(), this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful(), this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat(), this.getClass(), this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength());
        this.proteinTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.reselect();
                    }
                });
            }
        });
    }

    private void setPeptideTableProperties() {
        this.peptideTable.getColumn(" ").setMaxWidth(50);
        this.peptideTable.getColumn(" ").setMinWidth(50);
        this.peptideTable.getColumn("Start").setMinWidth(50);
        this.peptideTable.getColumnModel().getColumn(6).setMaxWidth(90);
        this.peptideTable.getColumnModel().getColumn(6).setMinWidth(90);
        this.peptideTable.getColumn("").setMaxWidth(30);
        this.peptideTable.getColumn("  ").setMaxWidth(30);
        this.peptideTable.getColumn("  ").setMinWidth(30);
        this.peptideTable.getColumn("PI").setMaxWidth(37);
        this.peptideTable.getColumn("PI").setMinWidth(37);
        HashMap<Integer, Color> peptideInferenceColorMap = new HashMap<Integer, Color>();
        peptideInferenceColorMap.put(0, this.peptideShakerGUI.getSparklineColor());
        peptideInferenceColorMap.put(1, Color.YELLOW);
        peptideInferenceColorMap.put(2, Color.ORANGE);
        peptideInferenceColorMap.put(3, Color.RED);
        HashMap<Integer, String> peptideInferenceTooltipMap = new HashMap<Integer, String>();
        peptideInferenceTooltipMap.put(0, "Unique to a single protein");
        peptideInferenceTooltipMap.put(1, "Belongs to a group of related proteins");
        peptideInferenceTooltipMap.put(2, "Belongs to a group of related and unrelated proteins");
        peptideInferenceTooltipMap.put(3, "Belongs to unrelated proteins");
        this.peptideTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.peptideShakerGUI.getSparklineColor(), peptideInferenceColorMap, peptideInferenceTooltipMap));
        this.peptideTable.getColumn("Start").setCellRenderer((TableCellRenderer)new JSparklinesMultiIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        Color nonValidatedColor = this.peptideShakerGUI.getSparklineColorNonValidated();
        if (!this.peptideShakerGUI.getIdentificationParameters().getFastaParameters().isTargetDecoy()) {
            nonValidatedColor = this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorNotFound();
        }
        ArrayList<Color> sparklineColors = new ArrayList<Color>();
        sparklineColors.add(this.peptideShakerGUI.getSparklineColor());
        sparklineColors.add(this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
        sparklineColors.add(nonValidatedColor);
        this.peptideTable.getColumn("#Spectra").setCellRenderer((TableCellRenderer)new JSparklinesArrayListBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), sparklineColors, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers));
        ((JSparklinesArrayListBarChartTableCellRenderer)this.peptideTable.getColumn("#Spectra").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth(), new DecimalFormat("0"));
        this.peptideTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.peptideTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        this.peptideTable.getColumnModel().getColumn(6).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.peptideTable.getColumnModel().getColumn(6).getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        this.peptideTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.reselect();
                    }
                });
            }
        });
    }

    private void setPsmTableProperties() {
        this.psmTable.getColumn(" ").setMaxWidth(50);
        this.psmTable.getColumn(" ").setMinWidth(50);
        this.psmTable.getColumnModel().getColumn(6).setMaxWidth(90);
        this.psmTable.getColumnModel().getColumn(6).setMinWidth(90);
        this.psmTable.getColumn("").setMaxWidth(30);
        this.psmTable.getColumn("").setMinWidth(30);
        this.psmTable.getColumn("  ").setMaxWidth(30);
        this.psmTable.getColumn("  ").setMinWidth(30);
        this.psmTable.getColumn("ID").setMaxWidth(37);
        this.psmTable.getColumn("ID").setMinWidth(37);
        HashMap<Integer, Color> psmColorMap = new HashMap<Integer, Color>();
        psmColorMap.put(4, this.peptideShakerGUI.getSparklineColor());
        psmColorMap.put(3, Color.CYAN);
        psmColorMap.put(1, Color.YELLOW);
        psmColorMap.put(2, Color.ORANGE);
        HashMap<Integer, String> psmTooltipMap = new HashMap<Integer, String>();
        psmTooltipMap.put(4, "ID Software Agree");
        psmTooltipMap.put(3, "ID Software Agree - PTM Certainty Issues");
        psmTooltipMap.put(1, "ID Software Disagree");
        psmTooltipMap.put(2, "First Hit(s) Missing");
        this.psmTable.getColumn("ID").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(Color.lightGray, psmColorMap, psmTooltipMap));
        this.psmTable.getColumn("m/z Error").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(-this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getPrecursorAccuracy()), Double.valueOf(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getPrecursorAccuracy()), this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("m/z Error").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        int maxCharge = this.peptideShakerGUI.getMetrics().getMaxCharge();
        this.psmTable.getColumn("Charge").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(maxCharge), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("Charge").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 30);
        this.psmTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.psmTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
        this.psmTable.getColumnModel().getColumn(6).setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumnModel().getColumn(6).getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 20, this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat());
        if (this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().isPrecursorAccuracyTypePpm().booleanValue()) {
            this.psmTableToolTips.set(this.psmTable.getColumn("m/z Error").getModelIndex(), "m/z Error (ppm)");
        } else {
            this.psmTableToolTips.set(this.psmTable.getColumn("m/z Error").getModelIndex(), "m/z Error (Da)");
        }
        this.psmTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.reselect();
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.selectJPopupMenu = new JPopupMenu();
        this.selectAllMenuItem = new JMenuItem();
        this.deselectAllMenuItem = new JMenuItem();
        this.sequenceCoverageJPopupMenu = new JPopupMenu();
        this.coverageShowAllPeptidesJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem = new JRadioButtonMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.coverageShowPossiblePeptidesJCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.coveragePeptideTypesButtonGroup = new ButtonGroup();
        this.sequenceCoverageExportPopupMenu = new JPopupMenu();
        this.sequenceCoveragePlotExportMenuItem = new JMenuItem();
        this.sequenceCoverageSequenceExportMenuItem = new JMenuItem();
        this.backgroundLayeredPane = new JLayeredPane();
        this.overviewJPanel = new JPanel();
        this.overviewJSplitPane = new JSplitPane();
        this.proteinsJPanel = new JPanel();
        this.proteinsLayeredPane = new JLayeredPane();
        this.proteinsLayeredPanel = new JPanel();
        this.proteinScrollPane = new JScrollPane();
        this.proteinTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)OverviewPanel.this.proteinTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.proteinsHelpJButton = new JButton();
        this.exportProteinsJButton = new JButton();
        this.hideProteinsJButton = new JButton();
        this.contextMenuProteinsBackgroundPanel = new JPanel();
        this.coverageJSplitPane = new JSplitPane();
        this.sequenceCoverageJPanel = new JPanel();
        this.sequenceCoverageLayeredPane = new JLayeredPane();
        this.sequenceCoverageTitledPanel = new JPanel();
        this.sequencePtmsPanel = new JPanel();
        this.sequenceCoverageInnerPanel = new JPanel();
        this.sequenceVariationsPanel = new JPanel();
        this.sequenceCoveragetHelpJButton = new JButton();
        this.exportSequenceCoverageContextJButton = new JButton();
        this.hideCoverageJButton = new JButton();
        this.sequenceCoverageOptionsJButton = new JButton();
        this.contextMenuSequenceCoverageBackgroundPanel = new JPanel();
        this.peptidesPsmSpectrumFragmentIonsJSplitPane = new JSplitPane();
        this.peptidesPsmJSplitPane = new JSplitPane();
        this.peptidesJPanel = new JPanel();
        this.peptidesLayeredPane = new JLayeredPane();
        this.peptidesPanel = new JPanel();
        this.peptideScrollPane = new JScrollPane();
        this.peptideTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)OverviewPanel.this.peptideTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.peptidesHelpJButton = new JButton();
        this.exportPeptidesJButton = new JButton();
        this.hidePeptideAndPsmsJButton = new JButton();
        this.contextMenuPeptidesBackgroundPanel = new JPanel();
        this.psmJPanel = new JPanel();
        this.psmsLayeredPane = new JLayeredPane();
        this.psmsPanel = new JPanel();
        this.spectraScrollPane = new JScrollPane();
        this.psmTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)OverviewPanel.this.psmTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.psmsHelpJButton = new JButton();
        this.exportPsmsJButton = new JButton();
        this.hidePeptideAndPsmsJButton2 = new JButton();
        this.contextMenuPsmsBackgroundPanel = new JPanel();
        this.spectrumMainJPanel = new JPanel();
        this.spectrumLayeredPane = new JLayeredPane();
        this.spectrumMainPanel = new JPanel();
        this.slidersSplitPane = new JSplitPane();
        this.spectrumJTabbedPane = new JTabbedPane();
        this.fragmentIonJPanel = new JPanel();
        this.fragmentIonsJScrollPane = new JScrollPane();
        this.ionTableJToolBar = new JToolBar();
        this.ionTableAnnotationMenuPanel = new JPanel();
        this.bubblePlotTabJPanel = new JPanel();
        this.bubbleJPanel = new JPanel();
        this.bubblePlotJToolBar = new JToolBar();
        this.bubbleAnnotationMenuPanel = new JPanel();
        this.spectrumContainerJPanel = new JPanel();
        this.spectrumJToolBar = new JToolBar();
        this.spectrumAnnotationMenuPanel = new JPanel();
        this.spectrumSplitPane = new JSplitPane();
        this.secondarySpectrumPlotsJPanel = new JPanel();
        this.spectrumOuterJPanel = new JPanel();
        this.spectrumPaddingPanel = new JPanel();
        this.spectrumJPanel = new JPanel();
        this.slidersPanel = new JPanel();
        this.accuracySlider = new JSlider();
        this.intensitySlider = new JSlider();
        this.spectrumHelpJButton = new JButton();
        this.exportSpectrumJButton = new JButton();
        this.hideSpectrumPanelJButton = new JButton();
        this.maximizeSpectrumPanelJButton = new JButton();
        this.contextMenuSpectrumBackgroundPanel = new JPanel();
        this.toolBar = new JToolBar();
        this.showProteinsBeforeSeparator = new JPopupMenu.Separator();
        this.showProteinsJButton = new JButton();
        this.showProteinsAfterSeparator = new JPopupMenu.Separator();
        this.showPeptidesAndPsmsJButton = new JButton();
        this.showPeptidesAfterSeparator = new JPopupMenu.Separator();
        this.showSpectrumJButton = new JButton();
        this.showSpectrumAfterSeparator = new JPopupMenu.Separator();
        this.showCoverageJButton = new JButton();
        this.showCoverageAfterSeparator = new JPopupMenu.Separator();
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.selectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectJPopupMenu.add(this.selectAllMenuItem);
        this.deselectAllMenuItem.setText("Deselect All");
        this.deselectAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.deselectAllMenuItemActionPerformed(evt);
            }
        });
        this.selectJPopupMenu.add(this.deselectAllMenuItem);
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowAllPeptidesJRadioButtonMenuItem);
        this.coverageShowAllPeptidesJRadioButtonMenuItem.setSelected(true);
        this.coverageShowAllPeptidesJRadioButtonMenuItem.setText("All Peptides");
        this.coverageShowAllPeptidesJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowAllPeptidesJRadioButtonMenuItem);
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem);
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.setText("Enzymatic Peptides");
        this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem);
        this.coveragePeptideTypesButtonGroup.add(this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem);
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem.setText("Non Enzymatic Peptides");
        this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItem);
        this.sequenceCoverageJPopupMenu.add(this.jSeparator1);
        this.coverageShowPossiblePeptidesJCheckBoxMenuItem.setSelected(true);
        this.coverageShowPossiblePeptidesJCheckBoxMenuItem.setText("Possible Coverage");
        this.coverageShowPossiblePeptidesJCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.coverageShowPossiblePeptidesJCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageJPopupMenu.add(this.coverageShowPossiblePeptidesJCheckBoxMenuItem);
        this.sequenceCoveragePlotExportMenuItem.setText("Sequence Coverage Plot");
        this.sequenceCoveragePlotExportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.sequenceCoveragePlotExportMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageExportPopupMenu.add(this.sequenceCoveragePlotExportMenuItem);
        this.sequenceCoverageSequenceExportMenuItem.setText("Protein Sequence");
        this.sequenceCoverageSequenceExportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.sequenceCoverageSequenceExportMenuItemActionPerformed(evt);
            }
        });
        this.sequenceCoverageExportPopupMenu.add(this.sequenceCoverageSequenceExportMenuItem);
        this.setOpaque(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                OverviewPanel.this.formComponentResized(evt);
            }
        });
        this.overviewJPanel.setBackground(new Color(255, 255, 255));
        this.overviewJPanel.setOpaque(false);
        this.overviewJPanel.setPreferredSize(new Dimension(900, 800));
        this.overviewJSplitPane.setBorder(null);
        this.overviewJSplitPane.setDividerLocation(300);
        this.overviewJSplitPane.setDividerSize(0);
        this.overviewJSplitPane.setOrientation(0);
        this.overviewJSplitPane.setResizeWeight(0.5);
        this.proteinsJPanel.setOpaque(false);
        this.proteinsLayeredPanel.setBorder(BorderFactory.createTitledBorder(null, "Proteins", 0, 0, new Font("sansserif", 1, 14)));
        this.proteinsLayeredPanel.setOpaque(false);
        this.proteinTable.setModel((TableModel)((Object)new ProteinTableModel()));
        this.proteinTable.setGridColor(new Color(204, 204, 204));
        this.proteinTable.setOpaque(false);
        this.proteinTable.setSelectionMode(0);
        this.proteinTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseMoved(evt);
            }
        });
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.proteinTableMouseReleased(evt);
            }
        });
        this.proteinTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.proteinTableKeyReleased(evt);
            }
        });
        this.proteinScrollPane.setViewportView(this.proteinTable);
        this.proteinTable.getAccessibleContext().setAccessibleName("ProteinTable");
        GroupLayout proteinsLayeredPanelLayout = new GroupLayout(this.proteinsLayeredPanel);
        this.proteinsLayeredPanel.setLayout(proteinsLayeredPanelLayout);
        proteinsLayeredPanelLayout.setHorizontalGroup(proteinsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 938, Short.MAX_VALUE).addGroup(proteinsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 918, Short.MAX_VALUE).addContainerGap())));
        proteinsLayeredPanelLayout.setVerticalGroup(proteinsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 255, Short.MAX_VALUE).addGroup(proteinsLayeredPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsLayeredPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 243, Short.MAX_VALUE).addContainerGap())));
        this.proteinsLayeredPane.add(this.proteinsLayeredPanel);
        this.proteinsLayeredPanel.setBounds(0, 0, 950, 300);
        this.proteinsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.proteinsHelpJButton.setToolTipText("Help");
        this.proteinsHelpJButton.setBorder(null);
        this.proteinsHelpJButton.setBorderPainted(false);
        this.proteinsHelpJButton.setContentAreaFilled(false);
        this.proteinsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.proteinsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonMouseExited(evt);
            }
        });
        this.proteinsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.proteinsHelpJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.proteinsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.proteinsHelpJButton);
        this.proteinsHelpJButton.setBounds(930, 0, 10, 19);
        this.exportProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setToolTipText("Copy to File");
        this.exportProteinsJButton.setBorder(null);
        this.exportProteinsJButton.setBorderPainted(false);
        this.exportProteinsJButton.setContentAreaFilled(false);
        this.exportProteinsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setEnabled(false);
        this.exportProteinsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportProteinsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportProteinsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportProteinsJButtonMouseExited(evt);
            }
        });
        this.exportProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.exportProteinsJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.exportProteinsJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.exportProteinsJButton);
        this.exportProteinsJButton.setBounds(920, 0, 10, 19);
        this.hideProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/hide_grey.png")));
        this.hideProteinsJButton.setToolTipText("Hide Proteins (Shift+Ctrl+P)");
        this.hideProteinsJButton.setBorder(null);
        this.hideProteinsJButton.setBorderPainted(false);
        this.hideProteinsJButton.setContentAreaFilled(false);
        this.hideProteinsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/hide.png")));
        this.hideProteinsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.hideProteinsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.hideProteinsJButtonMouseExited(evt);
            }
        });
        this.hideProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.hideProteinsJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.hideProteinsJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.hideProteinsJButton);
        this.hideProteinsJButton.setBounds(910, 0, 10, 19);
        this.contextMenuProteinsBackgroundPanel.setOpaque(false);
        GroupLayout contextMenuProteinsBackgroundPanelLayout = new GroupLayout(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setLayout(contextMenuProteinsBackgroundPanelLayout);
        contextMenuProteinsBackgroundPanelLayout.setHorizontalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        contextMenuProteinsBackgroundPanelLayout.setVerticalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.proteinsLayeredPane.setLayer(this.contextMenuProteinsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setBounds(910, 0, 40, 19);
        GroupLayout proteinsJPanelLayout = new GroupLayout(this.proteinsJPanel);
        this.proteinsJPanel.setLayout(proteinsJPanelLayout);
        proteinsJPanelLayout.setHorizontalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 960, Short.MAX_VALUE));
        proteinsJPanelLayout.setVerticalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 300, Short.MAX_VALUE));
        this.overviewJSplitPane.setTopComponent(this.proteinsJPanel);
        this.coverageJSplitPane.setBorder(null);
        this.coverageJSplitPane.setDividerLocation(350);
        this.coverageJSplitPane.setDividerSize(0);
        this.coverageJSplitPane.setOrientation(0);
        this.coverageJSplitPane.setResizeWeight(1.0);
        this.sequenceCoverageJPanel.setOpaque(false);
        this.sequenceCoverageTitledPanel.setBackground(new Color(255, 255, 255));
        this.sequenceCoverageTitledPanel.setBorder(BorderFactory.createTitledBorder(null, "Protein Sequence Coverage", 0, 0, new Font("sansserif", 1, 14)));
        this.sequenceCoverageTitledPanel.setOpaque(false);
        this.sequencePtmsPanel.setBackground(new Color(255, 255, 255));
        this.sequencePtmsPanel.setOpaque(false);
        this.sequencePtmsPanel.setLayout(new BoxLayout(this.sequencePtmsPanel, 2));
        this.sequenceCoverageInnerPanel.setOpaque(false);
        this.sequenceCoverageInnerPanel.setLayout(new BoxLayout(this.sequenceCoverageInnerPanel, 2));
        this.sequenceVariationsPanel.setBackground(new Color(255, 255, 255));
        this.sequenceVariationsPanel.setOpaque(false);
        this.sequenceVariationsPanel.setLayout(new BoxLayout(this.sequenceVariationsPanel, 2));
        GroupLayout sequenceCoverageTitledPanelLayout = new GroupLayout(this.sequenceCoverageTitledPanel);
        this.sequenceCoverageTitledPanel.setLayout(sequenceCoverageTitledPanelLayout);
        sequenceCoverageTitledPanelLayout.setHorizontalGroup(sequenceCoverageTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceCoverageTitledPanelLayout.createSequentialGroup().addContainerGap().addGroup(sequenceCoverageTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceVariationsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.sequenceCoverageInnerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.sequencePtmsPanel, -1, 918, Short.MAX_VALUE)).addContainerGap()));
        sequenceCoverageTitledPanelLayout.setVerticalGroup(sequenceCoverageTitledPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(sequenceCoverageTitledPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.sequencePtmsPanel, -2, 7, -2).addGap(2, 2, 2).addComponent(this.sequenceCoverageInnerPanel, -1, 167, Short.MAX_VALUE).addGap(2, 2, 2).addComponent(this.sequenceVariationsPanel, -2, 7, -2).addGap(0, 0, 0)));
        this.sequenceCoverageLayeredPane.add(this.sequenceCoverageTitledPanel);
        this.sequenceCoverageTitledPanel.setBounds(0, 0, 950, 230);
        this.sequenceCoveragetHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.sequenceCoveragetHelpJButton.setToolTipText("Help");
        this.sequenceCoveragetHelpJButton.setBorder(null);
        this.sequenceCoveragetHelpJButton.setBorderPainted(false);
        this.sequenceCoveragetHelpJButton.setContentAreaFilled(false);
        this.sequenceCoveragetHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.sequenceCoveragetHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.sequenceCoveragetHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.sequenceCoveragetHelpJButtonMouseExited(evt);
            }
        });
        this.sequenceCoveragetHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.sequenceCoveragetHelpJButtonActionPerformed(evt);
            }
        });
        this.sequenceCoverageLayeredPane.setLayer(this.sequenceCoveragetHelpJButton, JLayeredPane.POPUP_LAYER);
        this.sequenceCoverageLayeredPane.add(this.sequenceCoveragetHelpJButton);
        this.sequenceCoveragetHelpJButton.setBounds(930, 0, 10, 19);
        this.exportSequenceCoverageContextJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSequenceCoverageContextJButton.setToolTipText("Export");
        this.exportSequenceCoverageContextJButton.setBorder(null);
        this.exportSequenceCoverageContextJButton.setBorderPainted(false);
        this.exportSequenceCoverageContextJButton.setContentAreaFilled(false);
        this.exportSequenceCoverageContextJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSequenceCoverageContextJButton.setEnabled(false);
        this.exportSequenceCoverageContextJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportSequenceCoverageContextJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportSequenceCoverageContextJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportSequenceCoverageContextJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.exportSequenceCoverageContextJButtonMouseReleased(evt);
            }
        });
        this.sequenceCoverageLayeredPane.setLayer(this.exportSequenceCoverageContextJButton, JLayeredPane.POPUP_LAYER);
        this.sequenceCoverageLayeredPane.add(this.exportSequenceCoverageContextJButton);
        this.exportSequenceCoverageContextJButton.setBounds(920, 0, 10, 19);
        this.hideCoverageJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/hide_grey.png")));
        this.hideCoverageJButton.setToolTipText("Hide Coverage (Shift+Ctrl+E)");
        this.hideCoverageJButton.setBorder(null);
        this.hideCoverageJButton.setBorderPainted(false);
        this.hideCoverageJButton.setContentAreaFilled(false);
        this.hideCoverageJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/hide.png")));
        this.hideCoverageJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.hideCoverageJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.hideCoverageJButtonMouseExited(evt);
            }
        });
        this.hideCoverageJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.hideCoverageJButtonActionPerformed(evt);
            }
        });
        this.sequenceCoverageLayeredPane.setLayer(this.hideCoverageJButton, JLayeredPane.POPUP_LAYER);
        this.sequenceCoverageLayeredPane.add(this.hideCoverageJButton);
        this.hideCoverageJButton.setBounds(910, 0, 10, 19);
        this.sequenceCoverageOptionsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_gray.png")));
        this.sequenceCoverageOptionsJButton.setToolTipText("Coverage Options");
        this.sequenceCoverageOptionsJButton.setBorder(null);
        this.sequenceCoverageOptionsJButton.setBorderPainted(false);
        this.sequenceCoverageOptionsJButton.setContentAreaFilled(false);
        this.sequenceCoverageOptionsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/contextual_menu_black.png")));
        this.sequenceCoverageOptionsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.sequenceCoverageOptionsJButtonMouseReleased(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.sequenceCoverageOptionsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.sequenceCoverageOptionsJButtonMouseExited(evt);
            }
        });
        this.sequenceCoverageLayeredPane.setLayer(this.sequenceCoverageOptionsJButton, JLayeredPane.POPUP_LAYER);
        this.sequenceCoverageLayeredPane.add(this.sequenceCoverageOptionsJButton);
        this.sequenceCoverageOptionsJButton.setBounds(895, 5, 10, 19);
        this.contextMenuSequenceCoverageBackgroundPanel.setOpaque(false);
        GroupLayout contextMenuSequenceCoverageBackgroundPanelLayout = new GroupLayout(this.contextMenuSequenceCoverageBackgroundPanel);
        this.contextMenuSequenceCoverageBackgroundPanel.setLayout(contextMenuSequenceCoverageBackgroundPanelLayout);
        contextMenuSequenceCoverageBackgroundPanelLayout.setHorizontalGroup(contextMenuSequenceCoverageBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        contextMenuSequenceCoverageBackgroundPanelLayout.setVerticalGroup(contextMenuSequenceCoverageBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.sequenceCoverageLayeredPane.setLayer(this.contextMenuSequenceCoverageBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.sequenceCoverageLayeredPane.add(this.contextMenuSequenceCoverageBackgroundPanel);
        this.contextMenuSequenceCoverageBackgroundPanel.setBounds(890, 0, 50, 19);
        GroupLayout sequenceCoverageJPanelLayout = new GroupLayout(this.sequenceCoverageJPanel);
        this.sequenceCoverageJPanel.setLayout(sequenceCoverageJPanelLayout);
        sequenceCoverageJPanelLayout.setHorizontalGroup(sequenceCoverageJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceCoverageLayeredPane, -1, 960, Short.MAX_VALUE));
        sequenceCoverageJPanelLayout.setVerticalGroup(sequenceCoverageJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sequenceCoverageLayeredPane, -1, 48, Short.MAX_VALUE));
        this.coverageJSplitPane.setRightComponent(this.sequenceCoverageJPanel);
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setBorder(null);
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerLocation(450);
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerSize(0);
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setResizeWeight(0.5);
        this.peptidesPsmJSplitPane.setBorder(null);
        this.peptidesPsmJSplitPane.setDividerLocation(175);
        this.peptidesPsmJSplitPane.setDividerSize(0);
        this.peptidesPsmJSplitPane.setOrientation(0);
        this.peptidesPsmJSplitPane.setResizeWeight(0.5);
        this.peptidesJPanel.setOpaque(false);
        this.peptidesPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptides", 0, 0, new Font("sansserif", 1, 14)));
        this.peptidesPanel.setOpaque(false);
        this.peptideTable.setModel((TableModel)((Object)new PeptideTableModel()));
        this.peptideTable.setSelectionMode(0);
        this.peptideTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OverviewPanel.this.peptideTableMouseMoved(evt);
            }
        });
        this.peptideTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OverviewPanel.this.peptideTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.peptideTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.peptideTableMouseReleased(evt);
            }
        });
        this.peptideTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.peptideTableKeyReleased(evt);
            }
        });
        this.peptideScrollPane.setViewportView(this.peptideTable);
        GroupLayout peptidesPanelLayout = new GroupLayout(this.peptidesPanel);
        this.peptidesPanel.setLayout(peptidesPanelLayout);
        peptidesPanelLayout.setHorizontalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 438, Short.MAX_VALUE).addGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane, -1, 418, Short.MAX_VALUE).addContainerGap())));
        peptidesPanelLayout.setVerticalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 125, Short.MAX_VALUE).addGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane, -1, 113, Short.MAX_VALUE).addContainerGap())));
        this.peptidesLayeredPane.add(this.peptidesPanel);
        this.peptidesPanel.setBounds(0, 0, 450, 170);
        this.peptidesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.peptidesHelpJButton.setToolTipText("Help");
        this.peptidesHelpJButton.setBorder(null);
        this.peptidesHelpJButton.setBorderPainted(false);
        this.peptidesHelpJButton.setContentAreaFilled(false);
        this.peptidesHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.peptidesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.peptidesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.peptidesHelpJButtonMouseExited(evt);
            }
        });
        this.peptidesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.peptidesHelpJButtonActionPerformed(evt);
            }
        });
        this.peptidesLayeredPane.setLayer(this.peptidesHelpJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.peptidesHelpJButton);
        this.peptidesHelpJButton.setBounds(430, 0, 10, 19);
        this.exportPeptidesJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setToolTipText("Copy to File");
        this.exportPeptidesJButton.setBorder(null);
        this.exportPeptidesJButton.setBorderPainted(false);
        this.exportPeptidesJButton.setContentAreaFilled(false);
        this.exportPeptidesJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setEnabled(false);
        this.exportPeptidesJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPeptidesJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportPeptidesJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportPeptidesJButtonMouseExited(evt);
            }
        });
        this.exportPeptidesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.exportPeptidesJButtonActionPerformed(evt);
            }
        });
        this.peptidesLayeredPane.setLayer(this.exportPeptidesJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.exportPeptidesJButton);
        this.exportPeptidesJButton.setBounds(420, 0, 10, 19);
        this.hidePeptideAndPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/hide_grey.png")));
        this.hidePeptideAndPsmsJButton.setToolTipText("Hide Peptides & PSMs (Shift+Ctrl+E)");
        this.hidePeptideAndPsmsJButton.setBorder(null);
        this.hidePeptideAndPsmsJButton.setBorderPainted(false);
        this.hidePeptideAndPsmsJButton.setContentAreaFilled(false);
        this.hidePeptideAndPsmsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/hide.png")));
        this.hidePeptideAndPsmsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButtonMouseExited(evt);
            }
        });
        this.hidePeptideAndPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButtonActionPerformed(evt);
            }
        });
        this.peptidesLayeredPane.setLayer(this.hidePeptideAndPsmsJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.hidePeptideAndPsmsJButton);
        this.hidePeptideAndPsmsJButton.setBounds(410, 0, 10, 19);
        this.contextMenuPeptidesBackgroundPanel.setOpaque(false);
        GroupLayout contextMenuPeptidesBackgroundPanelLayout = new GroupLayout(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setLayout(contextMenuPeptidesBackgroundPanelLayout);
        contextMenuPeptidesBackgroundPanelLayout.setHorizontalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        contextMenuPeptidesBackgroundPanelLayout.setVerticalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.peptidesLayeredPane.setLayer(this.contextMenuPeptidesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setBounds(400, 0, 40, 19);
        GroupLayout peptidesJPanelLayout = new GroupLayout(this.peptidesJPanel);
        this.peptidesJPanel.setLayout(peptidesJPanelLayout);
        peptidesJPanelLayout.setHorizontalGroup(peptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidesLayeredPane, -1, 450, Short.MAX_VALUE));
        peptidesJPanelLayout.setVerticalGroup(peptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidesLayeredPane, -1, 175, Short.MAX_VALUE));
        this.peptidesPsmJSplitPane.setTopComponent(this.peptidesJPanel);
        this.psmJPanel.setOpaque(false);
        this.psmsPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptide Spectrum Matches", 0, 0, new Font("sansserif", 1, 14)));
        this.psmsPanel.setOpaque(false);
        this.psmTable.setModel((TableModel)((Object)new PsmTableModel()));
        this.psmTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                OverviewPanel.this.psmTableMouseMoved(evt);
            }
        });
        this.psmTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                OverviewPanel.this.psmTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.psmTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.psmTableMouseReleased(evt);
            }
        });
        this.psmTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                OverviewPanel.this.psmTableKeyReleased(evt);
            }
        });
        this.spectraScrollPane.setViewportView(this.psmTable);
        GroupLayout psmsPanelLayout = new GroupLayout(this.psmsPanel);
        this.psmsPanel.setLayout(psmsPanelLayout);
        psmsPanelLayout.setHorizontalGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 438, Short.MAX_VALUE).addGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectraScrollPane, -1, 418, Short.MAX_VALUE).addContainerGap())));
        psmsPanelLayout.setVerticalGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 125, Short.MAX_VALUE).addGroup(psmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(psmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectraScrollPane, -1, 113, Short.MAX_VALUE).addContainerGap())));
        this.psmsLayeredPane.add(this.psmsPanel);
        this.psmsPanel.setBounds(0, 0, 450, 170);
        this.psmsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.psmsHelpJButton.setToolTipText("Help");
        this.psmsHelpJButton.setBorder(null);
        this.psmsHelpJButton.setBorderPainted(false);
        this.psmsHelpJButton.setContentAreaFilled(false);
        this.psmsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.psmsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.psmsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.psmsHelpJButtonMouseExited(evt);
            }
        });
        this.psmsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.psmsHelpJButtonActionPerformed(evt);
            }
        });
        this.psmsLayeredPane.setLayer(this.psmsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.psmsHelpJButton);
        this.psmsHelpJButton.setBounds(430, 0, 10, 19);
        this.exportPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmsJButton.setToolTipText("Copy to File");
        this.exportPsmsJButton.setBorder(null);
        this.exportPsmsJButton.setBorderPainted(false);
        this.exportPsmsJButton.setContentAreaFilled(false);
        this.exportPsmsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPsmsJButton.setEnabled(false);
        this.exportPsmsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPsmsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportPsmsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportPsmsJButtonMouseExited(evt);
            }
        });
        this.exportPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.exportPsmsJButtonActionPerformed(evt);
            }
        });
        this.psmsLayeredPane.setLayer(this.exportPsmsJButton, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.exportPsmsJButton);
        this.exportPsmsJButton.setBounds(420, 0, 10, 19);
        this.hidePeptideAndPsmsJButton2.setIcon(new ImageIcon(this.getClass().getResource("/icons/hide_grey.png")));
        this.hidePeptideAndPsmsJButton2.setToolTipText("Hide Peptides & PSMs (Shift+Ctrl+E)");
        this.hidePeptideAndPsmsJButton2.setBorder(null);
        this.hidePeptideAndPsmsJButton2.setBorderPainted(false);
        this.hidePeptideAndPsmsJButton2.setContentAreaFilled(false);
        this.hidePeptideAndPsmsJButton2.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/hide.png")));
        this.hidePeptideAndPsmsJButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButton2MouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButton2MouseExited(evt);
            }
        });
        this.hidePeptideAndPsmsJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.hidePeptideAndPsmsJButton2ActionPerformed(evt);
            }
        });
        this.psmsLayeredPane.setLayer(this.hidePeptideAndPsmsJButton2, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.hidePeptideAndPsmsJButton2);
        this.hidePeptideAndPsmsJButton2.setBounds(410, 0, 10, 19);
        this.contextMenuPsmsBackgroundPanel.setOpaque(false);
        GroupLayout contextMenuPsmsBackgroundPanelLayout = new GroupLayout(this.contextMenuPsmsBackgroundPanel);
        this.contextMenuPsmsBackgroundPanel.setLayout(contextMenuPsmsBackgroundPanelLayout);
        contextMenuPsmsBackgroundPanelLayout.setHorizontalGroup(contextMenuPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 40, Short.MAX_VALUE));
        contextMenuPsmsBackgroundPanelLayout.setVerticalGroup(contextMenuPsmsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.psmsLayeredPane.setLayer(this.contextMenuPsmsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.psmsLayeredPane.add(this.contextMenuPsmsBackgroundPanel);
        this.contextMenuPsmsBackgroundPanel.setBounds(400, 0, 40, 19);
        GroupLayout psmJPanelLayout = new GroupLayout(this.psmJPanel);
        this.psmJPanel.setLayout(psmJPanelLayout);
        psmJPanelLayout.setHorizontalGroup(psmJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsLayeredPane, -1, 450, Short.MAX_VALUE));
        psmJPanelLayout.setVerticalGroup(psmJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psmsLayeredPane, -1, 175, Short.MAX_VALUE));
        this.peptidesPsmJSplitPane.setRightComponent(this.psmJPanel);
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setLeftComponent(this.peptidesPsmJSplitPane);
        this.spectrumMainJPanel.setOpaque(false);
        this.spectrumMainPanel.setBorder(BorderFactory.createTitledBorder(null, "Spectrum & Fragment Ions", 0, 0, new Font("sansserif", 1, 14)));
        this.spectrumMainPanel.setOpaque(false);
        this.slidersSplitPane.setBackground(new Color(51, 51, 51));
        this.slidersSplitPane.setBorder(null);
        this.slidersSplitPane.setDividerLocation(430);
        this.slidersSplitPane.setDividerSize(0);
        this.spectrumJTabbedPane.setBackground(new Color(51, 51, 51));
        this.spectrumJTabbedPane.setTabPlacement(3);
        this.spectrumJTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OverviewPanel.this.spectrumJTabbedPaneStateChanged(evt);
            }
        });
        this.spectrumJTabbedPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OverviewPanel.this.spectrumJTabbedPaneMouseWheelMoved(evt);
            }
        });
        this.spectrumJTabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.spectrumJTabbedPaneMouseEntered(evt);
            }
        });
        this.fragmentIonJPanel.setOpaque(false);
        this.fragmentIonsJScrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OverviewPanel.this.fragmentIonsJScrollPaneMouseWheelMoved(evt);
            }
        });
        this.ionTableJToolBar.setBackground(new Color(255, 255, 255));
        this.ionTableJToolBar.setBorder(null);
        this.ionTableJToolBar.setFloatable(false);
        this.ionTableJToolBar.setRollover(true);
        this.ionTableJToolBar.setBorderPainted(false);
        this.ionTableJToolBar.setOpaque(false);
        this.ionTableAnnotationMenuPanel.setLayout(new BoxLayout(this.ionTableAnnotationMenuPanel, 2));
        this.ionTableJToolBar.add(this.ionTableAnnotationMenuPanel);
        GroupLayout fragmentIonJPanelLayout = new GroupLayout(this.fragmentIonJPanel);
        this.fragmentIonJPanel.setLayout(fragmentIonJPanelLayout);
        fragmentIonJPanelLayout.setHorizontalGroup(fragmentIonJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonJPanelLayout.createSequentialGroup().addContainerGap().addGroup(fragmentIonJPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fragmentIonsJScrollPane, GroupLayout.Alignment.LEADING, -1, 401, Short.MAX_VALUE).addComponent(this.ionTableJToolBar, GroupLayout.Alignment.LEADING, -1, 405, Short.MAX_VALUE)).addContainerGap()));
        fragmentIonJPanelLayout.setVerticalGroup(fragmentIonJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fragmentIonJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fragmentIonsJScrollPane, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ionTableJToolBar, -2, -1, -2)));
        this.spectrumJTabbedPane.addTab("Ion Table", this.fragmentIonJPanel);
        this.bubblePlotTabJPanel.setBackground(new Color(255, 255, 255));
        this.bubblePlotTabJPanel.setOpaque(false);
        this.bubbleJPanel.setOpaque(false);
        this.bubbleJPanel.setLayout(new BoxLayout(this.bubbleJPanel, 2));
        this.bubblePlotJToolBar.setBackground(new Color(255, 255, 255));
        this.bubblePlotJToolBar.setBorder(null);
        this.bubblePlotJToolBar.setFloatable(false);
        this.bubblePlotJToolBar.setRollover(true);
        this.bubblePlotJToolBar.setBorderPainted(false);
        this.bubblePlotJToolBar.setOpaque(false);
        this.bubbleAnnotationMenuPanel.setLayout(new BoxLayout(this.bubbleAnnotationMenuPanel, 2));
        this.bubblePlotJToolBar.add(this.bubbleAnnotationMenuPanel);
        GroupLayout bubblePlotTabJPanelLayout = new GroupLayout(this.bubblePlotTabJPanel);
        this.bubblePlotTabJPanel.setLayout(bubblePlotTabJPanelLayout);
        bubblePlotTabJPanelLayout.setHorizontalGroup(bubblePlotTabJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bubblePlotTabJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.bubblePlotJToolBar, -1, 405, Short.MAX_VALUE).addContainerGap()).addGroup(bubblePlotTabJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bubbleJPanel, -1, 425, Short.MAX_VALUE)));
        bubblePlotTabJPanelLayout.setVerticalGroup(bubblePlotTabJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bubblePlotTabJPanelLayout.createSequentialGroup().addContainerGap(269, Short.MAX_VALUE).addComponent(this.bubblePlotJToolBar, -2, -1, -2)).addGroup(bubblePlotTabJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bubblePlotTabJPanelLayout.createSequentialGroup().addComponent(this.bubbleJPanel, -1, 244, Short.MAX_VALUE).addGap(25, 25, 25))));
        this.spectrumJTabbedPane.addTab("Bubble Plot", this.bubblePlotTabJPanel);
        this.spectrumContainerJPanel.setOpaque(false);
        this.spectrumJToolBar.setBackground(new Color(255, 255, 255));
        this.spectrumJToolBar.setBorder(null);
        this.spectrumJToolBar.setFloatable(false);
        this.spectrumJToolBar.setRollover(true);
        this.spectrumJToolBar.setBorderPainted(false);
        this.spectrumJToolBar.setOpaque(false);
        this.spectrumAnnotationMenuPanel.setLayout(new BoxLayout(this.spectrumAnnotationMenuPanel, 2));
        this.spectrumJToolBar.add(this.spectrumAnnotationMenuPanel);
        this.spectrumSplitPane.setBorder(null);
        this.spectrumSplitPane.setDividerLocation(80);
        this.spectrumSplitPane.setDividerSize(0);
        this.spectrumSplitPane.setOrientation(0);
        this.secondarySpectrumPlotsJPanel.setMinimumSize(new Dimension(0, 80));
        this.secondarySpectrumPlotsJPanel.setOpaque(false);
        this.secondarySpectrumPlotsJPanel.setLayout(new BoxLayout(this.secondarySpectrumPlotsJPanel, 2));
        this.spectrumSplitPane.setTopComponent(this.secondarySpectrumPlotsJPanel);
        this.spectrumOuterJPanel.setOpaque(false);
        this.spectrumPaddingPanel.setOpaque(false);
        GroupLayout spectrumPaddingPanelLayout = new GroupLayout(this.spectrumPaddingPanel);
        this.spectrumPaddingPanel.setLayout(spectrumPaddingPanelLayout);
        spectrumPaddingPanelLayout.setHorizontalGroup(spectrumPaddingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        spectrumPaddingPanelLayout.setVerticalGroup(spectrumPaddingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE));
        this.spectrumJPanel.setOpaque(false);
        this.spectrumJPanel.setLayout(new BorderLayout());
        GroupLayout spectrumOuterJPanelLayout = new GroupLayout(this.spectrumOuterJPanel);
        this.spectrumOuterJPanel.setLayout(spectrumOuterJPanelLayout);
        spectrumOuterJPanelLayout.setHorizontalGroup(spectrumOuterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumPaddingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.spectrumJPanel, -1, 425, Short.MAX_VALUE));
        spectrumOuterJPanelLayout.setVerticalGroup(spectrumOuterJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumOuterJPanelLayout.createSequentialGroup().addComponent(this.spectrumPaddingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumJPanel, -1, 160, Short.MAX_VALUE)));
        this.spectrumSplitPane.setRightComponent(this.spectrumOuterJPanel);
        GroupLayout spectrumContainerJPanelLayout = new GroupLayout(this.spectrumContainerJPanel);
        this.spectrumContainerJPanel.setLayout(spectrumContainerJPanelLayout);
        spectrumContainerJPanelLayout.setHorizontalGroup(spectrumContainerJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumContainerJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumJToolBar, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.spectrumSplitPane, -2, 0, Short.MAX_VALUE));
        spectrumContainerJPanelLayout.setVerticalGroup(spectrumContainerJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, spectrumContainerJPanelLayout.createSequentialGroup().addComponent(this.spectrumSplitPane, -1, 263, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectrumJToolBar, -2, -1, -2)));
        this.spectrumJTabbedPane.addTab("Spectrum", this.spectrumContainerJPanel);
        this.spectrumJTabbedPane.setSelectedIndex(2);
        this.slidersSplitPane.setLeftComponent(this.spectrumJTabbedPane);
        this.slidersPanel.setOpaque(false);
        this.accuracySlider.setOrientation(1);
        this.accuracySlider.setPaintTicks(true);
        this.accuracySlider.setToolTipText("Annotation Accuracy");
        this.accuracySlider.setValue(100);
        this.accuracySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OverviewPanel.this.accuracySliderStateChanged(evt);
            }
        });
        this.accuracySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OverviewPanel.this.accuracySliderMouseWheelMoved(evt);
            }
        });
        this.intensitySlider.setOrientation(1);
        this.intensitySlider.setPaintTicks(true);
        this.intensitySlider.setToolTipText("Annotation Level");
        this.intensitySlider.setValue(75);
        this.intensitySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OverviewPanel.this.intensitySliderStateChanged(evt);
            }
        });
        this.intensitySlider.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                OverviewPanel.this.intensitySliderMouseWheelMoved(evt);
            }
        });
        GroupLayout slidersPanelLayout = new GroupLayout(this.slidersPanel);
        this.slidersPanel.setLayout(slidersPanelLayout);
        slidersPanelLayout.setHorizontalGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slidersPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.accuracySlider, -2, 26, -2).addComponent(this.intensitySlider, -2, 26, -2)).addGap(0, 0, 0)));
        slidersPanelLayout.setVerticalGroup(slidersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slidersPanelLayout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.accuracySlider, -1, 86, Short.MAX_VALUE).addGap(29, 29, 29).addComponent(this.intensitySlider, -1, 89, Short.MAX_VALUE).addGap(66, 66, 66)));
        this.slidersSplitPane.setRightComponent(this.slidersPanel);
        GroupLayout spectrumMainPanelLayout = new GroupLayout(this.spectrumMainPanel);
        this.spectrumMainPanel.setLayout(spectrumMainPanelLayout);
        spectrumMainPanelLayout.setHorizontalGroup(spectrumMainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumMainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.slidersSplitPane, -1, 458, Short.MAX_VALUE).addContainerGap()));
        spectrumMainPanelLayout.setVerticalGroup(spectrumMainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumMainPanelLayout.createSequentialGroup().addComponent(this.slidersSplitPane).addContainerGap()));
        this.spectrumLayeredPane.add(this.spectrumMainPanel);
        this.spectrumMainPanel.setBounds(0, 0, 490, 350);
        this.spectrumHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.spectrumHelpJButton.setToolTipText("Help");
        this.spectrumHelpJButton.setBorder(null);
        this.spectrumHelpJButton.setBorderPainted(false);
        this.spectrumHelpJButton.setContentAreaFilled(false);
        this.spectrumHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.spectrumHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.spectrumHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.spectrumHelpJButtonMouseExited(evt);
            }
        });
        this.spectrumHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.spectrumHelpJButtonActionPerformed(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.spectrumHelpJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.spectrumHelpJButton);
        this.spectrumHelpJButton.setBounds(460, 0, 10, 19);
        this.exportSpectrumJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setToolTipText("Export");
        this.exportSpectrumJButton.setBorder(null);
        this.exportSpectrumJButton.setBorderPainted(false);
        this.exportSpectrumJButton.setContentAreaFilled(false);
        this.exportSpectrumJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportSpectrumJButton.setEnabled(false);
        this.exportSpectrumJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportSpectrumJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.exportSpectrumJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.exportSpectrumJButtonMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                OverviewPanel.this.exportSpectrumJButtonMouseReleased(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.exportSpectrumJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.exportSpectrumJButton);
        this.exportSpectrumJButton.setBounds(450, 0, 10, 19);
        this.hideSpectrumPanelJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/hide_grey.png")));
        this.hideSpectrumPanelJButton.setToolTipText("Hide Spectrum (Shift+Ctrl+E)");
        this.hideSpectrumPanelJButton.setBorder(null);
        this.hideSpectrumPanelJButton.setBorderPainted(false);
        this.hideSpectrumPanelJButton.setContentAreaFilled(false);
        this.hideSpectrumPanelJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/hide.png")));
        this.hideSpectrumPanelJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.hideSpectrumPanelJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.hideSpectrumPanelJButtonMouseExited(evt);
            }
        });
        this.hideSpectrumPanelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.hideSpectrumPanelJButtonActionPerformed(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.hideSpectrumPanelJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.hideSpectrumPanelJButton);
        this.hideSpectrumPanelJButton.setBounds(440, 0, 10, 19);
        this.maximizeSpectrumPanelJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/maximize_grey.png")));
        this.maximizeSpectrumPanelJButton.setToolTipText("Maximize Spectrum");
        this.maximizeSpectrumPanelJButton.setBorder(null);
        this.maximizeSpectrumPanelJButton.setBorderPainted(false);
        this.maximizeSpectrumPanelJButton.setContentAreaFilled(false);
        this.maximizeSpectrumPanelJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/maximize.png")));
        this.maximizeSpectrumPanelJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                OverviewPanel.this.maximizeSpectrumPanelJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                OverviewPanel.this.maximizeSpectrumPanelJButtonMouseExited(evt);
            }
        });
        this.maximizeSpectrumPanelJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.maximizeSpectrumPanelJButtonActionPerformed(evt);
            }
        });
        this.spectrumLayeredPane.setLayer(this.maximizeSpectrumPanelJButton, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.maximizeSpectrumPanelJButton);
        this.maximizeSpectrumPanelJButton.setBounds(425, 5, 10, 19);
        this.contextMenuSpectrumBackgroundPanel.setOpaque(false);
        GroupLayout contextMenuSpectrumBackgroundPanelLayout = new GroupLayout(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setLayout(contextMenuSpectrumBackgroundPanelLayout);
        contextMenuSpectrumBackgroundPanelLayout.setHorizontalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 60, Short.MAX_VALUE));
        contextMenuSpectrumBackgroundPanelLayout.setVerticalGroup(contextMenuSpectrumBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.spectrumLayeredPane.setLayer(this.contextMenuSpectrumBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.spectrumLayeredPane.add(this.contextMenuSpectrumBackgroundPanel);
        this.contextMenuSpectrumBackgroundPanel.setBounds(420, 0, 60, 19);
        GroupLayout spectrumMainJPanelLayout = new GroupLayout(this.spectrumMainJPanel);
        this.spectrumMainJPanel.setLayout(spectrumMainJPanelLayout);
        spectrumMainJPanelLayout.setHorizontalGroup(spectrumMainJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumLayeredPane, GroupLayout.Alignment.TRAILING, -1, 510, Short.MAX_VALUE));
        spectrumMainJPanelLayout.setVerticalGroup(spectrumMainJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumLayeredPane, -1, 350, Short.MAX_VALUE));
        this.peptidesPsmSpectrumFragmentIonsJSplitPane.setRightComponent(this.spectrumMainJPanel);
        this.coverageJSplitPane.setLeftComponent(this.peptidesPsmSpectrumFragmentIonsJSplitPane);
        this.overviewJSplitPane.setRightComponent(this.coverageJSplitPane);
        GroupLayout overviewJPanelLayout = new GroupLayout(this.overviewJPanel);
        this.overviewJPanel.setLayout(overviewJPanelLayout);
        overviewJPanelLayout.setHorizontalGroup(overviewJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewJSplitPane).addContainerGap()));
        overviewJPanelLayout.setVerticalGroup(overviewJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.overviewJSplitPane).addContainerGap()));
        this.backgroundLayeredPane.add(this.overviewJPanel);
        this.overviewJPanel.setBounds(0, 0, 980, 720);
        this.toolBar.setBackground(new Color(255, 255, 255));
        this.toolBar.setBorder(null);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setOpaque(false);
        this.showProteinsBeforeSeparator.setOrientation(1);
        this.showProteinsBeforeSeparator.setOpaque(true);
        this.toolBar.add(this.showProteinsBeforeSeparator);
        this.showProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/list2.gif")));
        this.showProteinsJButton.setText("Proteins");
        this.showProteinsJButton.setToolTipText("Click to Show (Shift+Ctrl+P)");
        this.showProteinsJButton.setFocusable(false);
        this.showProteinsJButton.setVerticalTextPosition(3);
        this.showProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.showProteinsJButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showProteinsJButton);
        this.showProteinsAfterSeparator.setOrientation(1);
        this.showProteinsAfterSeparator.setOpaque(true);
        this.toolBar.add(this.showProteinsAfterSeparator);
        this.showPeptidesAndPsmsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/list2.gif")));
        this.showPeptidesAndPsmsJButton.setText("Peptides & PSMs");
        this.showPeptidesAndPsmsJButton.setToolTipText("Click to Show (Shift+Ctrl+E)");
        this.showPeptidesAndPsmsJButton.setFocusable(false);
        this.showPeptidesAndPsmsJButton.setVerticalTextPosition(3);
        this.showPeptidesAndPsmsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.showPeptidesAndPsmsJButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showPeptidesAndPsmsJButton);
        this.showPeptidesAfterSeparator.setOrientation(1);
        this.showPeptidesAfterSeparator.setOpaque(true);
        this.toolBar.add(this.showPeptidesAfterSeparator);
        this.showSpectrumJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/spectrum.GIF")));
        this.showSpectrumJButton.setText("Spectrum & Fragment Ions");
        this.showSpectrumJButton.setToolTipText("Click to Show (Shift+Ctrl+S)");
        this.showSpectrumJButton.setFocusable(false);
        this.showSpectrumJButton.setVerticalTextPosition(3);
        this.showSpectrumJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.showSpectrumJButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showSpectrumJButton);
        this.showSpectrumAfterSeparator.setOrientation(1);
        this.showSpectrumAfterSeparator.setOpaque(true);
        this.toolBar.add(this.showSpectrumAfterSeparator);
        this.showCoverageJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/coverage3.gif")));
        this.showCoverageJButton.setText("Protein Sequence Coverage");
        this.showCoverageJButton.setToolTipText("Click to Show (Shift+Ctrl+C)");
        this.showCoverageJButton.setFocusable(false);
        this.showCoverageJButton.setVerticalTextPosition(3);
        this.showCoverageJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OverviewPanel.this.showCoverageJButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.showCoverageJButton);
        this.showCoverageAfterSeparator.setOrientation(1);
        this.showCoverageAfterSeparator.setOpaque(true);
        this.toolBar.add(this.showCoverageAfterSeparator);
        this.backgroundLayeredPane.add(this.toolBar);
        this.toolBar.setBounds(0, 720, 980, 20);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 977, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, -1, 977, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 742, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundLayeredPane, -1, 742, Short.MAX_VALUE)));
    }

    private void proteinTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.proteinTableMouseReleased(null);
        }
    }

    private void peptideTableKeyReleased(KeyEvent evt) {
        int peptideRow;
        if ((evt == null || evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) && (peptideRow = this.peptideTable.getSelectedRow()) != -1) {
            this.peptideTableMouseReleased(null);
        }
    }

    private void psmTableKeyReleased(KeyEvent evt) {
        if (evt == null || evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            int row = this.psmTable.getSelectedRow();
            if (row != -1) {
                this.newItemSelection();
                this.updateSpectrum(row, false);
            }
            this.spectrumJTabbedPaneStateChanged(null);
        }
    }

    private void proteinTableMouseMoved(MouseEvent evt) {
        int row = this.proteinTable.rowAtPoint(evt.getPoint());
        int column = this.proteinTable.columnAtPoint(evt.getPoint());
        this.proteinTable.setToolTipText(null);
        if (row != -1 && column != -1 && column == this.proteinTable.getColumn("Accession").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinTable.getColumn("PI").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Chr").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Description").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell((JTable)this.proteinTable, (int)row, (int)column) > this.proteinTable.getColumn("Description").getWidth()) {
                this.proteinTable.setToolTipText("" + this.proteinTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void proteinTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psmTableMouseReleased(MouseEvent evt) {
        int row = this.psmTable.getSelectedRow();
        int column = this.psmTable.getSelectedColumn();
        if (row != -1) {
            long psmKey;
            int psmIndex;
            SelfUpdatingTableModel tableModel;
            this.setCursor(new Cursor(3));
            this.newItemSelection();
            this.updateSpectrum(row, false);
            Identification identification = this.peptideShakerGUI.getIdentification();
            if (column == this.psmTable.getColumn("  ").getModelIndex()) {
                tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
                psmKey = this.psmKeys[tableModel.getViewIndex(psmIndex = tableModel.getViewIndex(row))];
                SpectrumMatch spectrumMatch = identification.getSpectrumMatch(psmKey);
                PSParameter psParameter = (PSParameter)spectrumMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starPsm(psmKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarPsm(psmKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
            }
            if (column == 2 && evt != null && evt.getButton() == 1) {
                this.peptideShakerGUI.jumpToTab(1);
            }
            if (column == this.psmTable.getColumn("").getModelIndex() && evt != null && evt.getButton() == 1) {
                tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
                psmIndex = tableModel.getViewIndex(row);
                psmKey = this.psmKeys[tableModel.getViewIndex(psmIndex)];
                PSMaps pSMaps = new PSMaps();
                MatchValidationDialog matchValidationDialog = new MatchValidationDialog(this.peptideShakerGUI, identification, (pSMaps = (PSMaps)identification.getUrParam((UrParameter)pSMaps)).getPsmMap(), psmKey, this.peptideShakerGUI.getIdentificationParameters(), this.peptideShakerGUI.getProjectDetails().getFastaFile(), MatchValidationDialog.MatchType.PSM);
                if (matchValidationDialog.isValidationChanged()) {
                    this.updatePsmPanelTitle();
                    this.peptidesPanel.repaint();
                    this.proteinsLayeredPanel.repaint();
                }
            }
            this.setCursor(new Cursor(0));
        }
        this.spectrumJTabbedPaneStateChanged(null);
    }

    private void proteinTableMouseReleased(MouseEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        int column = this.proteinTable.getSelectedColumn();
        int proteinIndex = -1;
        if (row != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            proteinIndex = tableModel.getViewIndex(row);
        }
        if (evt == null || evt.getButton() == 1 && proteinIndex != -1 && column != -1) {
            if (proteinIndex != -1) {
                ProteinMatch proteinMatch;
                this.setCursor(new Cursor(3));
                long proteinKey = this.proteinKeys[proteinIndex];
                this.peptideShakerGUI.setSelectedItems(proteinKey, ExperimentObject.NO_KEY, null, null);
                this.updatePeptideSelection(proteinIndex);
                this.newItemSelection();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OverviewPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    }
                });
                this.setCursor(new Cursor(0));
                if (column == this.proteinTable.getColumn("  ").getModelIndex()) {
                    proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                    PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                    if (!psParameter.getStarred()) {
                        this.peptideShakerGUI.getStarHider().starProtein(proteinKey);
                    } else {
                        this.peptideShakerGUI.getStarHider().unStarProtein(proteinKey);
                    }
                    this.peptideShakerGUI.setDataSaved(false);
                }
                if (column == this.proteinTable.getColumn("Chr").getModelIndex() && evt != null && evt.getButton() == 1) {
                    proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                    new GeneDetailsDialog((Frame)this.peptideShakerGUI, proteinMatch, this.peptideShakerGUI.getGeneMaps(), this.peptideShakerGUI.getProteinDetailsProvider());
                }
                if (column == this.proteinTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.proteinTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                    String link = (String)this.proteinTable.getValueAt(row, column);
                    link = link.substring(link.indexOf("\"") + 1);
                    link = link.substring(0, link.indexOf("\""));
                    this.setCursor(new Cursor(3));
                    BareBonesBrowserLaunch.openURL((String)link);
                    this.setCursor(new Cursor(0));
                }
                if (column == this.proteinTable.getColumn("PI").getModelIndex() && evt != null && evt.getButton() == 1) {
                    new ProteinInferenceDialog(this.peptideShakerGUI, this.peptideShakerGUI.getGeneMaps(), proteinKey, this.peptideShakerGUI.getIdentification());
                }
                if (column == this.proteinTable.getColumn("").getModelIndex() && evt != null && evt.getButton() == 1) {
                    Identification identification = this.peptideShakerGUI.getIdentification();
                    PSMaps pSMaps = new PSMaps();
                    MatchValidationDialog matchValidationDialog = new MatchValidationDialog(this.peptideShakerGUI, identification, (pSMaps = (PSMaps)identification.getUrParam((UrParameter)pSMaps)).getProteinMap(), proteinKey, this.peptideShakerGUI.getIdentificationParameters(), this.peptideShakerGUI.getProjectDetails().getFastaFile(), MatchValidationDialog.MatchType.PROTEIN);
                    if (matchValidationDialog.isValidationChanged()) {
                        this.updateProteinPanelTitle();
                    }
                }
            }
        } else if (evt.getButton() == 3 && this.proteinTable.columnAtPoint(evt.getPoint()) == this.proteinTable.getColumn("  ").getModelIndex()) {
            this.selectJPopupMenu.show(this.proteinTable, evt.getX(), evt.getY());
        }
    }

    private void peptideTableMouseReleased(MouseEvent evt) {
        final int row = this.peptideTable.getSelectedRow();
        int column = this.peptideTable.getSelectedColumn();
        if (row != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
            int peptideIndex = tableModel.getViewIndex(row);
            long peptideKey = this.peptideKeys[peptideIndex];
            this.peptideShakerGUI.setSelectedItems(this.peptideShakerGUI.getSelectedProteinKey(), peptideKey, null, null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OverviewPanel.this.updatePsmSelection(row, false);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (OverviewPanel.this.psmTable.getSelectedRow() != -1) {
                        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)OverviewPanel.this.psmTable.getModel();
                        OverviewPanel.this.updateSpectrum(tableModel.getViewIndex(OverviewPanel.this.psmTable.getSelectedRow()), true);
                        OverviewPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")));
                    }
                }
            });
            if (column == this.peptideTable.getColumn("  ").getModelIndex()) {
                PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starPeptide(peptideKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarPeptide(peptideKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
            }
            if (column == this.peptideTable.getColumn("PI").getModelIndex() && evt != null && evt.getButton() == 1) {
                tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
                long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
                new ProteinInferencePeptideLevelDialog(this.peptideShakerGUI, true, peptideKey, proteinKey, this.peptideShakerGUI.getGeneMaps());
            }
            if (column == this.peptideTable.getColumn("").getModelIndex() && evt != null && evt.getButton() == 1) {
                Identification identification = this.peptideShakerGUI.getIdentification();
                PSMaps pSMaps = new PSMaps();
                MatchValidationDialog matchValidationDialog = new MatchValidationDialog(this.peptideShakerGUI, identification, (pSMaps = (PSMaps)identification.getUrParam((UrParameter)pSMaps)).getPeptideMap(), peptideKey, this.peptideShakerGUI.getIdentificationParameters(), this.peptideShakerGUI.getProjectDetails().getFastaFile(), MatchValidationDialog.MatchType.PEPTIDE);
                if (matchValidationDialog.isValidationChanged()) {
                    this.updateProteinPanelTitle();
                    this.updatePeptidePanelTitle();
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        OverviewPanel.this.updateSelection(true);
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
        }
    }

    private void peptideTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideTableMouseMoved(MouseEvent evt) {
        int row = this.peptideTable.rowAtPoint(evt.getPoint());
        int column = this.peptideTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.peptideTable.getValueAt(row, column) != null) {
            if (column == this.peptideTable.getColumn("PI").getModelIndex()) {
                this.setCursor(new Cursor(12));
                this.peptideTable.setToolTipText(null);
            } else if (column == this.peptideTable.getColumn("").getModelIndex()) {
                this.setCursor(new Cursor(12));
                this.peptideTable.setToolTipText(null);
            } else if (column == this.peptideTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                String sequence = (String)this.peptideTable.getValueAt(row, column);
                if (sequence.contains("<span")) {
                    SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
                    long peptideKey = this.peptideKeys[tableModel.getViewIndex(row)];
                    PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                    String tooltip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptideMatch);
                    this.peptideTable.setToolTipText(tooltip);
                } else {
                    this.peptideTable.setToolTipText(null);
                }
            } else {
                this.setCursor(new Cursor(0));
                this.peptideTable.setToolTipText(null);
            }
        } else {
            this.setCursor(new Cursor(0));
            this.peptideTable.setToolTipText(null);
        }
    }

    private void spectrumJTabbedPaneStateChanged(ChangeEvent evt) {
        if (this.peptideShakerGUI.getAnnotationMenuBar() != null) {
            int index = this.spectrumJTabbedPane.getSelectedIndex();
            switch (index) {
                case 0: {
                    this.ionTableAnnotationMenuPanel.removeAll();
                    this.ionTableAnnotationMenuPanel.add(this.peptideShakerGUI.getAnnotationMenuBar());
                    this.peptideShakerGUI.updateAnnotationMenuBarVisableOptions(false, false, true, false, false);
                    break;
                }
                case 1: {
                    this.bubbleAnnotationMenuPanel.removeAll();
                    this.bubbleAnnotationMenuPanel.add(this.peptideShakerGUI.getAnnotationMenuBar());
                    this.peptideShakerGUI.updateAnnotationMenuBarVisableOptions(false, true, false, false, false);
                    break;
                }
                case 2: {
                    this.spectrumAnnotationMenuPanel.removeAll();
                    this.spectrumAnnotationMenuPanel.add(this.peptideShakerGUI.getAnnotationMenuBar());
                    this.peptideShakerGUI.updateAnnotationMenuBarVisableOptions(true, false, false, false, this.psmTable.getSelectedRowCount() == 1);
                    break;
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OverviewPanel.this.psmTable.getSelectedRowCount() > 1) {
                    OverviewPanel.this.spectrumSplitPane.setDividerLocation(0);
                } else {
                    OverviewPanel.this.spectrumSplitPane.setDividerLocation(80);
                }
                OverviewPanel.this.spectrumMainJPanel.revalidate();
                OverviewPanel.this.spectrumMainJPanel.repaint();
            }
        });
    }

    private void spectrumJTabbedPaneMouseWheelMoved(MouseWheelEvent evt) {
        if (evt.isControlDown()) {
            if (evt.getWheelRotation() > 0) {
                this.accuracySlider.setValue(this.accuracySlider.getValue() - 1);
            } else {
                int oldValue = this.accuracySlider.getValue();
                int newValue = oldValue + 1;
                this.accuracySlider.setValue(newValue);
                while (oldValue == this.accuracySlider.getValue()) {
                    this.accuracySlider.setValue(newValue++);
                    if (this.accuracySlider.getValue() != this.accuracySlider.getMaximum()) continue;
                    break;
                }
            }
        } else if (evt.getWheelRotation() > 0) {
            this.intensitySlider.setValue(this.intensitySlider.getValue() - 1);
        } else {
            int oldValue = this.intensitySlider.getValue();
            int newValue = oldValue + 1;
            this.intensitySlider.setValue(newValue);
            while (oldValue == this.intensitySlider.getValue()) {
                this.intensitySlider.setValue(newValue++);
                if (this.intensitySlider.getValue() != this.intensitySlider.getMaximum()) continue;
            }
        }
        this.updateSpectrumSliderToolTip();
    }

    private void intensitySliderStateChanged(ChangeEvent evt) {
        AnnotationParameters annotationParameters = this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters();
        annotationParameters.setIntensityLimit((double)this.intensitySlider.getValue() / 100.0);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.intensitySlider.setToolTipText("Annotation Level: " + this.intensitySlider.getValue() + "%");
        this.updateSpectrumSliderToolTip();
    }

    private void intensitySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumJTabbedPaneMouseWheelMoved(evt);
    }

    private void psmTableMouseMoved(MouseEvent evt) {
        int row = this.psmTable.rowAtPoint(evt.getPoint());
        int column = this.psmTable.columnAtPoint(evt.getPoint());
        if (row != -1 && column != -1 && this.psmTable.getValueAt(row, column) != null) {
            if (column == this.psmTable.getColumn("Sequence").getModelIndex()) {
                String sequence = (String)this.psmTable.getValueAt(row, column);
                if (sequence.contains("<span")) {
                    Identification identification = this.peptideShakerGUI.getIdentification();
                    SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
                    long spectrumKey = this.psmKeys[tableModel.getViewIndex(row)];
                    SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumKey);
                    String tooltip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(spectrumMatch.getBestPeptideAssumption().getPeptide());
                    this.psmTable.setToolTipText(tooltip);
                } else {
                    this.psmTable.setToolTipText(null);
                }
            } else {
                this.psmTable.setToolTipText(null);
            }
            if (column == 2 || column == this.psmTable.getColumn("").getModelIndex()) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.psmTable.setToolTipText(null);
        }
    }

    private void accuracySliderStateChanged(ChangeEvent evt) {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        AnnotationParameters annotationParameters = this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters();
        annotationParameters.setFragmentIonAccuracy(accuracy);
        this.peptideShakerGUI.updateSpectrumAnnotations();
        this.peptideShakerGUI.setDataSaved(false);
        this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType());
        this.updateSpectrumSliderToolTip();
    }

    private void accuracySliderMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumJTabbedPaneMouseWheelMoved(evt);
    }

    private void formComponentResized(ComponentEvent evt) {
        boolean nonHidden = this.updateHiddenPanels();
        if (nonHidden) {
            this.backgroundLayeredPane.getComponent(0).setBounds(0, 0, this.backgroundLayeredPane.getWidth(), this.backgroundLayeredPane.getHeight());
            this.backgroundLayeredPane.revalidate();
            this.backgroundLayeredPane.repaint();
            this.backgroundLayeredPane.getComponent(1).setBounds(10, this.backgroundLayeredPane.getHeight() - 25, this.backgroundLayeredPane.getWidth(), 25);
            this.backgroundLayeredPane.revalidate();
            this.backgroundLayeredPane.repaint();
        } else {
            this.backgroundLayeredPane.getComponent(0).setBounds(0, 0, this.backgroundLayeredPane.getWidth(), this.backgroundLayeredPane.getHeight() - 15);
            this.backgroundLayeredPane.revalidate();
            this.backgroundLayeredPane.repaint();
            this.backgroundLayeredPane.getComponent(1).setBounds(10, this.backgroundLayeredPane.getHeight() - 25, this.backgroundLayeredPane.getWidth(), 25);
            this.backgroundLayeredPane.revalidate();
            this.backgroundLayeredPane.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverviewPanel.this.proteinsLayeredPane.getComponent(0).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(1).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(2).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(2).getWidth() - 32, -5, OverviewPanel.this.proteinsLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(3).setBounds(OverviewPanel.this.proteinsLayeredPane.getWidth() - OverviewPanel.this.proteinsLayeredPane.getComponent(3).getWidth() - 5, -3, OverviewPanel.this.proteinsLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.proteinsLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.proteinsLayeredPane.getComponent(4).setBounds(0, 0, OverviewPanel.this.proteinsLayeredPane.getWidth(), OverviewPanel.this.proteinsLayeredPane.getHeight());
                OverviewPanel.this.proteinsLayeredPane.revalidate();
                OverviewPanel.this.proteinsLayeredPane.repaint();
                OverviewPanel.this.peptidesLayeredPane.getComponent(0).setBounds(OverviewPanel.this.peptidesLayeredPane.getWidth() - OverviewPanel.this.peptidesLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.peptidesLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.peptidesLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.peptidesLayeredPane.getComponent(1).setBounds(OverviewPanel.this.peptidesLayeredPane.getWidth() - OverviewPanel.this.peptidesLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.peptidesLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.peptidesLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.peptidesLayeredPane.getComponent(2).setBounds(OverviewPanel.this.peptidesLayeredPane.getWidth() - OverviewPanel.this.peptidesLayeredPane.getComponent(2).getWidth() - 32, -5, OverviewPanel.this.peptidesLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.peptidesLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.peptidesLayeredPane.getComponent(3).setBounds(OverviewPanel.this.peptidesLayeredPane.getWidth() - OverviewPanel.this.peptidesLayeredPane.getComponent(3).getWidth() - 5, -3, OverviewPanel.this.peptidesLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.peptidesLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.peptidesLayeredPane.getComponent(4).setBounds(0, 0, OverviewPanel.this.peptidesLayeredPane.getWidth(), OverviewPanel.this.peptidesLayeredPane.getHeight());
                OverviewPanel.this.peptidesLayeredPane.revalidate();
                OverviewPanel.this.peptidesLayeredPane.repaint();
                OverviewPanel.this.psmsLayeredPane.getComponent(0).setBounds(OverviewPanel.this.psmsLayeredPane.getWidth() - OverviewPanel.this.psmsLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.psmsLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.psmsLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.psmsLayeredPane.getComponent(1).setBounds(OverviewPanel.this.psmsLayeredPane.getWidth() - OverviewPanel.this.psmsLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.psmsLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.psmsLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.psmsLayeredPane.getComponent(2).setBounds(OverviewPanel.this.psmsLayeredPane.getWidth() - OverviewPanel.this.psmsLayeredPane.getComponent(2).getWidth() - 32, -5, OverviewPanel.this.psmsLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.psmsLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.psmsLayeredPane.getComponent(3).setBounds(OverviewPanel.this.psmsLayeredPane.getWidth() - OverviewPanel.this.psmsLayeredPane.getComponent(3).getWidth() - 5, -3, OverviewPanel.this.psmsLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.psmsLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.psmsLayeredPane.getComponent(4).setBounds(0, 0, OverviewPanel.this.psmsLayeredPane.getWidth(), OverviewPanel.this.psmsLayeredPane.getHeight());
                OverviewPanel.this.psmsLayeredPane.revalidate();
                OverviewPanel.this.psmsLayeredPane.repaint();
                OverviewPanel.this.spectrumLayeredPane.getComponent(0).setBounds(OverviewPanel.this.spectrumLayeredPane.getWidth() - OverviewPanel.this.spectrumLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.spectrumLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.spectrumLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.spectrumLayeredPane.getComponent(1).setBounds(OverviewPanel.this.spectrumLayeredPane.getWidth() - OverviewPanel.this.spectrumLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.spectrumLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.spectrumLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.spectrumLayeredPane.getComponent(2).setBounds(OverviewPanel.this.spectrumLayeredPane.getWidth() - OverviewPanel.this.spectrumLayeredPane.getComponent(2).getWidth() - 32, -5, OverviewPanel.this.spectrumLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.spectrumLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.spectrumLayeredPane.getComponent(3).setBounds(OverviewPanel.this.spectrumLayeredPane.getWidth() - OverviewPanel.this.spectrumLayeredPane.getComponent(2).getWidth() - 44, -2, OverviewPanel.this.spectrumLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.spectrumLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.spectrumLayeredPane.getComponent(4).setBounds(OverviewPanel.this.spectrumLayeredPane.getWidth() - OverviewPanel.this.spectrumLayeredPane.getComponent(4).getWidth() - 5, -3, OverviewPanel.this.spectrumLayeredPane.getComponent(4).getWidth(), OverviewPanel.this.spectrumLayeredPane.getComponent(4).getHeight());
                OverviewPanel.this.spectrumLayeredPane.getComponent(5).setBounds(0, 0, OverviewPanel.this.spectrumLayeredPane.getWidth(), OverviewPanel.this.spectrumLayeredPane.getHeight());
                if (OverviewPanel.this.psmTable.getSelectedRowCount() > 1) {
                    OverviewPanel.this.spectrumSplitPane.setDividerLocation(0);
                } else {
                    OverviewPanel.this.spectrumSplitPane.setDividerLocation(80);
                }
                OverviewPanel.this.spectrumLayeredPane.revalidate();
                OverviewPanel.this.spectrumLayeredPane.repaint();
                if (OverviewPanel.this.peptideShakerGUI.getUserParameters().showSliders()) {
                    OverviewPanel.this.slidersSplitPane.setDividerLocation(OverviewPanel.this.slidersSplitPane.getWidth() - 30);
                } else {
                    OverviewPanel.this.slidersSplitPane.setDividerLocation(OverviewPanel.this.slidersSplitPane.getWidth());
                }
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(0).setBounds(OverviewPanel.this.sequenceCoverageLayeredPane.getWidth() - OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(0).getWidth() - 10, -3, OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(0).getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(0).getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(1).setBounds(OverviewPanel.this.sequenceCoverageLayeredPane.getWidth() - OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(1).getWidth() - 20, -3, OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(1).getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(1).getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(2).setBounds(OverviewPanel.this.sequenceCoverageLayeredPane.getWidth() - OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(2).getWidth() - 32, -5, OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(2).getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(2).getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(3).setBounds(OverviewPanel.this.sequenceCoverageLayeredPane.getWidth() - OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(3).getWidth() - 44, 0, OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(3).getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(3).getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(4).setBounds(OverviewPanel.this.sequenceCoverageLayeredPane.getWidth() - OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(4).getWidth() - 5, -3, OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(4).getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(4).getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.getComponent(5).setBounds(0, 0, OverviewPanel.this.sequenceCoverageLayeredPane.getWidth(), OverviewPanel.this.sequenceCoverageLayeredPane.getHeight());
                OverviewPanel.this.sequenceCoverageLayeredPane.revalidate();
                OverviewPanel.this.sequenceCoverageLayeredPane.repaint();
            }
        });
    }

    private void proteinsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/OverviewTab.html"), "#Proteins", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Overview - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportProteinsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.PROTEIN_TABLE);
    }

    private void peptidesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptidesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptidesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/OverviewTab.html"), "#Peptides", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Overview - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPeptidesJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.PEPTIDE_TABLE);
    }

    private void psmsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void psmsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void psmsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/OverviewTab.html"), "#PSMs", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Overview - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPsmsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPsmsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPsmsJButtonActionPerformed(ActionEvent evt) {
        this.copyTableContentToClipboardOrFile(TableIndex.PSM_TABLE);
    }

    private void spectrumHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void spectrumHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void spectrumHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/OverviewTab.html"), "#Spectrum", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Overview - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportSpectrumJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportSpectrumJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void sequenceCoveragetHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void sequenceCoveragetHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void sequenceCoveragetHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/OverviewTab.html"), "#SequenceCoverage", Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Overview - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportSequenceCoverageContextJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportSequenceCoverageContextJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void showProteinsJButtonActionPerformed(ActionEvent evt) {
        this.displayProteins = !this.displayProteins;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void showPeptidesAndPsmsJButtonActionPerformed(ActionEvent evt) {
        this.displayPeptidesAndPSMs = !this.displayPeptidesAndPSMs;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void showSpectrumJButtonActionPerformed(ActionEvent evt) {
        this.displaySpectrum = !this.displaySpectrum;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void showCoverageJButtonActionPerformed(ActionEvent evt) {
        this.displayCoverage = !this.displayCoverage;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void hideProteinsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void hideProteinsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void hideProteinsJButtonActionPerformed(ActionEvent evt) {
        this.displayProteins = false;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void hidePeptideAndPsmsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void hidePeptideAndPsmsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void hidePeptideAndPsmsJButtonActionPerformed(ActionEvent evt) {
        this.displayPeptidesAndPSMs = false;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void hidePeptideAndPsmsJButton2MouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void hidePeptideAndPsmsJButton2MouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void hidePeptideAndPsmsJButton2ActionPerformed(ActionEvent evt) {
        this.displayPeptidesAndPSMs = false;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void maximizeSpectrumPanelJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void maximizeSpectrumPanelJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void maximizeSpectrumPanelJButtonActionPerformed(ActionEvent evt) {
        if (this.panelsShownUponMaximze != null) {
            this.displayProteins = this.panelsShownUponMaximze.get(0);
            this.displayPeptidesAndPSMs = this.panelsShownUponMaximze.get(1);
            this.displayCoverage = this.panelsShownUponMaximze.get(2);
            this.displaySpectrum = true;
            this.panelsShownUponMaximze = null;
        } else {
            this.panelsShownUponMaximze = new ArrayList();
            this.panelsShownUponMaximze.add(this.displayProteins);
            this.panelsShownUponMaximze.add(this.displayPeptidesAndPSMs);
            this.panelsShownUponMaximze.add(this.displayCoverage);
            this.displayProteins = false;
            this.displayPeptidesAndPSMs = false;
            this.displayCoverage = false;
            this.displaySpectrum = true;
        }
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void hideCoverageJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void hideCoverageJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void hideCoverageJButtonActionPerformed(ActionEvent evt) {
        this.displayCoverage = false;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void selectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.proteinTable.getRowCount(); ++i) {
            this.proteinTable.setValueAt(true, i, this.proteinTable.getColumn("  ").getModelIndex());
            long key = this.proteinKeys[i];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(key);
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
            psParameter.setStarred(true);
        }
    }

    private void deselectAllMenuItemActionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.proteinTable.getRowCount(); ++i) {
            this.proteinTable.setValueAt(false, i, this.proteinTable.getColumn("  ").getModelIndex());
            this.proteinTable.setValueAt(true, i, this.proteinTable.getColumn("  ").getModelIndex());
            long key = this.proteinKeys[i];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(key);
            PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
            psParameter.setStarred(false);
        }
    }

    private void exportSpectrumJButtonMouseReleased(MouseEvent evt) {
        JPopupMenu popupMenu = new JPopupMenu();
        int index = this.spectrumJTabbedPane.getSelectedIndex();
        if (index == 0) {
            JMenuItem menuItem = new JMenuItem("Spectrum as MGF");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        OverviewPanel.this.peptideShakerGUI.exportSelectedSpectraAsMgf();
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Spectrum Annotation");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        OverviewPanel.this.peptideShakerGUI.exportAnnotatedSpectrum();
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            popupMenu.add(menuItem);
        } else if (index == 1) {
            JMenuItem menuItem = new JMenuItem("Bubble Plot");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OverviewPanel.this.peptideShakerGUI.exportBubblePlotAsFigure();
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Spectrum as MGF");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        OverviewPanel.this.peptideShakerGUI.exportSelectedSpectraAsMgf();
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            popupMenu.add(menuItem);
            menuItem = new JMenuItem("Spectrum Annotation");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        OverviewPanel.this.peptideShakerGUI.exportAnnotatedSpectrum();
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            popupMenu.add(menuItem);
        } else if (index == 2) {
            JMenuItem menuItem = new JMenuItem("Spectrum Plot");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OverviewPanel.this.peptideShakerGUI.exportSpectrumAsFigure();
                }
            });
            popupMenu.add(menuItem);
            if (this.psmTable.getSelectedRowCount() == 1) {
                popupMenu.add(new JSeparator());
                menuItem = new JMenuItem("Sequence Fragmentation");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        OverviewPanel.this.peptideShakerGUI.exportSequenceFragmentationAsFigure();
                    }
                });
                popupMenu.add(menuItem);
                menuItem = new JMenuItem("Intensity Histogram");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        OverviewPanel.this.peptideShakerGUI.exportIntensityHistogramAsFigure();
                    }
                });
                popupMenu.add(menuItem);
                menuItem = new JMenuItem("m/z Error Plot");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        OverviewPanel.this.peptideShakerGUI.exportMassErrorPlotAsFigure();
                    }
                });
                popupMenu.add(menuItem);
                popupMenu.add(new JSeparator());
                menuItem = new JMenuItem("Spectrum as MGF");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            OverviewPanel.this.peptideShakerGUI.exportSelectedSpectraAsMgf();
                        }
                        catch (Exception e) {
                            OverviewPanel.this.peptideShakerGUI.catchException(e);
                        }
                    }
                });
                popupMenu.add(menuItem);
                popupMenu.add(new JSeparator());
                menuItem = new JMenuItem("Spectrum Annotation");
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            OverviewPanel.this.peptideShakerGUI.exportAnnotatedSpectrum();
                        }
                        catch (Exception e) {
                            OverviewPanel.this.peptideShakerGUI.catchException(e);
                        }
                    }
                });
                popupMenu.add(menuItem);
            }
        }
        popupMenu.show(this.exportSpectrumJButton, evt.getX(), evt.getY());
    }

    private void spectrumJTabbedPaneMouseEntered(MouseEvent evt) {
        this.spectrumJTabbedPane.setToolTipText(null);
    }

    private void fragmentIonsJScrollPaneMouseWheelMoved(MouseWheelEvent evt) {
        this.spectrumJTabbedPaneMouseWheelMoved(evt);
    }

    private void hideSpectrumPanelJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void hideSpectrumPanelJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void hideSpectrumPanelJButtonActionPerformed(ActionEvent evt) {
        this.displaySpectrum = false;
        this.peptideShakerGUI.setDisplayOptions(this.displayProteins, this.displayPeptidesAndPSMs, this.displayCoverage, this.displaySpectrum);
    }

    private void sequenceCoverageOptionsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void sequenceCoverageOptionsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void sequenceCoverageOptionsJButtonMouseReleased(MouseEvent evt) {
        this.sequenceCoverageJPopupMenu.show(this.sequenceCoverageOptionsJButton, evt.getX(), evt.getY());
    }

    private void coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        if (this.proteinTable.getSelectedRow() != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
            this.updateSequenceCoverage(proteinKey, proteinMatch.getLeadingAccession(), true);
        }
    }

    private void coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(null);
    }

    private void coverageShowTruncatedPeptidesOnlyJRadioButtonMenuItemActionPerformed(ActionEvent evt) {
        this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(null);
    }

    private void coverageShowPossiblePeptidesJCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.coverageShowAllPeptidesJRadioButtonMenuItemActionPerformed(null);
    }

    private void proteinTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.proteinTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog((Frame)OverviewPanel.this.peptideShakerGUI, OverviewPanel.this.proteinTable, OverviewPanel.this.proteinTable.getColumnName(OverviewPanel.this.proteinTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, OverviewPanel.this.proteinTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.proteinTable, evt.getX(), evt.getY());
        }
    }

    private void peptideTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.peptideTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog((Frame)OverviewPanel.this.peptideShakerGUI, OverviewPanel.this.peptideTable, OverviewPanel.this.peptideTable.getColumnName(OverviewPanel.this.peptideTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, OverviewPanel.this.peptideTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.peptideTable, evt.getX(), evt.getY());
        }
    }

    private void psmTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.psmTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog((Frame)OverviewPanel.this.peptideShakerGUI, OverviewPanel.this.psmTable, OverviewPanel.this.psmTable.getColumnName(OverviewPanel.this.psmTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, OverviewPanel.this.psmTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.psmTable, evt.getX(), evt.getY());
        }
    }

    private void psmTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void sequenceCoveragePlotExportMenuItemActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, this.coverageChart, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void sequenceCoverageSequenceExportMenuItemActionPerformed(ActionEvent evt) {
        if (this.proteinTable.getSelectedRow() != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
            String accession = proteinMatch.getLeadingAccession();
            String sequence = this.peptideShakerGUI.getSequenceProvider().getSequence(accession);
            StringSelection stringSelection = new StringSelection(sequence);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this.peptideShakerGUI);
            JOptionPane.showMessageDialog(this.peptideShakerGUI, "Protein sequence copied to clipboard.", "Copied to Clipboard", 1);
        }
    }

    private void exportSequenceCoverageContextJButtonMouseReleased(MouseEvent evt) {
        this.sequenceCoverageExportPopupMenu.show(this.exportSequenceCoverageContextJButton, evt.getX(), evt.getY());
    }

    public void updateProteinPanelTitle() {
        String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins (";
        int nValidated = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNValidatedProteins();
        int nConfident = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNConfidentProteins();
        int nProteins = this.proteinTable.getRowCount();
        title = nConfident > 0 ? title + nValidated + "/" + nProteins + " - " + nConfident + " confident, " + (nValidated - nConfident) + " doubtful" : title + nValidated + "/" + nProteins;
        title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
        ((TitledBorder)this.proteinsLayeredPanel.getBorder()).setTitle(title);
        this.proteinsLayeredPanel.repaint();
    }

    public void updatePeptidePanelTitle() {
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
        IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
        long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
        ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
        int nValidatedPeptides = identificationFeaturesGenerator.getNValidatedPeptides(proteinKey);
        int nConfidentPeptides = identificationFeaturesGenerator.getNConfidentPeptides(proteinKey);
        int nPeptides = proteinMatch.getPeptideCount();
        String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptides (";
        title = nConfidentPeptides > 0 ? title + nValidatedPeptides + "/" + nPeptides + " - " + nConfidentPeptides + " confident, " + (nValidatedPeptides - nConfidentPeptides) + " doubtful" : title + nValidatedPeptides + "/" + nPeptides;
        title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
        ((TitledBorder)this.peptidesPanel.getBorder()).setTitle(title);
        this.peptidesPanel.repaint();
    }

    public void updatePsmPanelTitle() {
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
        IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
        int peptideIndex = tableModel.getViewIndex(this.peptideTable.getSelectedRow());
        long peptideKey = this.peptideKeys[peptideIndex];
        int nValidatedPsms = identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideKey);
        int nConfidentPsms = identificationFeaturesGenerator.getNConfidentSpectraForPeptide(peptideKey);
        int nPsms = this.psmTable.getRowCount();
        String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches (";
        title = nConfidentPsms > 0 ? title + nValidatedPsms + "/" + nPsms + " - " + nConfidentPsms + " confident, " + (nValidatedPsms - nConfidentPsms) + " doubtful" : title + nValidatedPsms + "/" + nPsms;
        title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
        ((TitledBorder)this.psmsPanel.getBorder()).setTitle(title);
        this.psmsPanel.repaint();
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("Coverage").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumnModel().getColumn(11).getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.peptideTable.getColumn("#Spectra").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.peptideTable.getColumnModel().getColumn(6).getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("m/z Error").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumn("Charge").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.psmTable.getColumnModel().getColumn(6).getCellRenderer()).showNumbers(!showSparkLines);
        this.proteinTable.revalidate();
        this.proteinTable.repaint();
        this.peptideTable.revalidate();
        this.peptideTable.repaint();
        this.psmTable.revalidate();
        this.psmTable.repaint();
    }

    public long[] getDisplayedProteins() {
        return this.proteinKeys;
    }

    public long[] getDisplayedPeptides() {
        return this.peptideKeys;
    }

    public long[] getDisplayedSpectrumMatches() {
        return this.psmKeys;
    }

    private void updateProteinTableSeparator() {
        if (this.displayProteins) {
            this.overviewJSplitPane.setDividerLocation(this.overviewJSplitPane.getHeight() / 100 * 30);
        } else {
            this.overviewJSplitPane.setDividerLocation(0);
        }
        if (!this.displayPeptidesAndPSMs && !this.displaySpectrum) {
            this.overviewJSplitPane.setDividerLocation(this.overviewJSplitPane.getHeight() / 100 * 70);
            this.coverageJSplitPane.setDividerLocation(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverviewPanel.this.updateSequenceCoverageSeparator();
                OverviewPanel.this.peptidesPsmJSplitPane.setDividerLocation(OverviewPanel.this.peptidesPsmJSplitPane.getHeight() / 2);
                OverviewPanel.this.formComponentResized(null);
            }
        });
    }

    private void updatePeptidesAndPsmsSeparator() {
        if (this.displayPeptidesAndPSMs && this.displaySpectrum) {
            this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerLocation(this.peptidesPsmSpectrumFragmentIonsJSplitPane.getWidth() / 2);
        } else if (this.displayPeptidesAndPSMs && !this.displaySpectrum) {
            this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerLocation(this.peptidesPsmSpectrumFragmentIonsJSplitPane.getWidth());
        } else if (!this.displayPeptidesAndPSMs && this.displaySpectrum) {
            this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerLocation(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverviewPanel.this.updateSequenceCoverageSeparator();
                OverviewPanel.this.peptidesPsmJSplitPane.setDividerLocation(OverviewPanel.this.peptidesPsmJSplitPane.getHeight() / 2);
                OverviewPanel.this.formComponentResized(null);
            }
        });
    }

    private void updateSequenceCoverageSeparator() {
        if (this.displayCoverage) {
            this.coverageJSplitPane.setDividerLocation(this.coverageJSplitPane.getHeight() - 82);
        } else {
            this.coverageJSplitPane.setDividerLocation(Integer.MAX_VALUE);
        }
        if (!this.displayPeptidesAndPSMs && !this.displaySpectrum) {
            if (!this.displayCoverage) {
                this.overviewJSplitPane.setDividerLocation(this.overviewJSplitPane.getHeight());
            } else {
                this.overviewJSplitPane.setDividerLocation(this.overviewJSplitPane.getHeight() - 82);
                this.coverageJSplitPane.setDividerLocation(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OverviewPanel.this.peptidesPsmJSplitPane.setDividerLocation(OverviewPanel.this.peptidesPsmJSplitPane.getHeight() / 2);
                OverviewPanel.this.formComponentResized(null);
            }
        });
    }

    public void updateSeparators() {
        if (this.isSelfUpdating) {
            this.formComponentResized(null);
            this.updateProteinTableSeparator();
            this.updatePeptidesAndPsmsSeparator();
            this.peptidesPsmJSplitPane.setDividerLocation(this.peptidesPsmJSplitPane.getHeight() / 2);
            this.formComponentResized(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OverviewPanel.this.updateSequenceCoverageSeparator();
                    OverviewPanel.this.updateProteinTableSeparator();
                    OverviewPanel.this.updatePeptidesAndPsmsSeparator();
                    OverviewPanel.this.overviewJPanel.revalidate();
                    OverviewPanel.this.overviewJPanel.repaint();
                    OverviewPanel.this.updateBubblePlot();
                    OverviewPanel.this.formComponentResized(null);
                }
            });
            this.formComponentResized(null);
        }
    }

    public void setDisplayOptions(boolean displayProteins, boolean displayPeptidesAndPSMs, boolean displayCoverage, boolean displaySpectrum) {
        this.displayProteins = displayProteins;
        this.displayPeptidesAndPSMs = displayPeptidesAndPSMs;
        this.displayCoverage = displayCoverage;
        this.displaySpectrum = displaySpectrum;
    }

    public void updateBubblePlot() {
        if (this.peptideTable.getSelectedRow() != -1 && this.displaySpectrum) {
            ArrayList<String> selectedIndexes = new ArrayList<String>();
            int[] selectedPsmRows = this.psmTable.getSelectedRows();
            SelfUpdatingTableModel psmTableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
            ArrayList<IonMatch[]> allAnnotations = new ArrayList<IonMatch[]>();
            ArrayList<Spectrum> allSpectra = new ArrayList<Spectrum>();
            SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
            IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
            ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
            SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
            AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
            DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
            ArrayList<Peptide> peptides = new ArrayList<Peptide>();
            SpectrumProvider spectrumProvider = this.peptideShakerGUI.getSpectrumProvider();
            PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
            SpecificAnnotationParameters specificAnnotationParameters = null;
            int maxCharge = 1;
            HashSet<String> allModifications = new HashSet<String>();
            for (int row : selectedPsmRows) {
                int psmIndex = psmTableModel.getViewIndex(row);
                long spectrumMatchKey = this.psmKeys[psmIndex];
                SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(spectrumMatchKey);
                selectedIndexes.add(psmIndex + 1 + " " + Charge.toString((int)spectrumMatch.getBestPeptideAssumption().getIdentificationCharge()));
                String spectrumFile = spectrumMatch.getSpectrumFile();
                String spectrumTitle = spectrumMatch.getSpectrumTitle();
                Spectrum currentSpectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle);
                if (currentSpectrum == null) continue;
                PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
                Peptide peptide = peptideAssumption.getPeptide();
                specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption);
                peptides.add(peptide);
                IonMatch[] annotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, currentSpectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                allAnnotations.add(annotations);
                allSpectra.add(currentSpectrum);
                int currentCharge = spectrumMatch.getBestPeptideAssumption().getIdentificationCharge();
                if (currentCharge > maxCharge) {
                    maxCharge = currentCharge;
                }
                allModifications.addAll(ModificationUtils.getAllModifications((Peptide)peptide, (ModificationParameters)modificationParameters, (SequenceProvider)sequenceProvider, (SequenceMatchingParameters)modificationSequenceMatchingParameters));
                this.currentSpectrumMatchKey = spectrumMatch.getKey();
            }
            double bubbleScale = annotationParameters.getFragmentIonAccuracy() * 10.0 * this.peptideShakerGUI.getBubbleScale();
            this.massErrorBubblePlot = new MassErrorBubblePlot(selectedIndexes, allAnnotations, allSpectra, annotationParameters.getFragmentIonAccuracy(), bubbleScale, selectedIndexes.size() == 1, displayParameters.showBars(), identificationParameters.getSearchParameters().getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM);
            if (selectedIndexes.size() > 20) {
                this.massErrorBubblePlot.getChartPanel().getChart().getLegend().setVisible(false);
            }
            this.massErrorBubblePlot.getChartPanel().getChart().getPlot().setOutlineVisible(false);
            this.bubbleJPanel.removeAll();
            this.bubbleJPanel.add((Component)this.massErrorBubblePlot);
            this.bubbleJPanel.revalidate();
            this.bubbleJPanel.repaint();
            if (allSpectra.size() == 2) {
                for (int i = 0; i < allSpectra.size(); ++i) {
                    Integer rewindIon;
                    Integer forwardIon;
                    Spectrum spectrum;
                    if (i == 0) {
                        spectrum = (Spectrum)allSpectra.get(i);
                        this.spectrumPanel = new SpectrumPanel(spectrum.mz, ArrayUtil.scaleToMax((double[])spectrum.intensity, (boolean)true), 500.0, "2", "", 40, false, false, false, 2, false);
                        this.spectrumPanel.setAnnotateHighestPeak(annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                        this.spectrumPanel.setAnnotations((List)SpectrumAnnotator.getSpectrumAnnotation((IonMatch[])((IonMatch[])allAnnotations.get(i))), annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                        SpectrumPanel.setKnownMassDeltas(this.peptideShakerGUI.getCurrentMassDeltas());
                        this.spectrumPanel.setDeltaMassWindow(this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().getFragmentIonAccuracy());
                        this.spectrumPanel.setBorder(null);
                        this.spectrumPanel.setDataPointAndLineColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor(), 0);
                        this.spectrumPanel.setPeakWaterMarkColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
                        this.spectrumPanel.setPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth());
                        this.spectrumPanel.setBackgroundPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth());
                        this.spectrumPanel.showAnnotatedPeaksOnly(!annotationParameters.showAllPeaks());
                        this.spectrumPanel.setYAxisZoomExcludesBackgroundPeaks(annotationParameters.yAxisZoomExcludesBackgroundPeaks());
                        forwardIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getForwardIons().get(0);
                        rewindIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getRewindIons().get(0);
                        this.spectrumPanel.addAutomaticDeNovoSequencing((Peptide)peptides.get(i), (IonMatch[])allAnnotations.get(i), forwardIon.intValue(), rewindIon.intValue(), annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), false, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                        continue;
                    }
                    spectrum = (Spectrum)allSpectra.get(i);
                    this.spectrumPanel.addMirroredSpectrum(spectrum.mz, ArrayUtil.scaleToMax((double[])spectrum.intensity, (boolean)true), 500.0, "2", "", false, this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor(), this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedMirroredPeakColor());
                    this.spectrumPanel.setAnnotateHighestPeak(annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                    this.spectrumPanel.setAnnotationsMirrored((List)SpectrumAnnotator.getSpectrumAnnotation((IonMatch[])((IonMatch[])allAnnotations.get(i))));
                    forwardIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getForwardIons().get(0);
                    rewindIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getRewindIons().get(0);
                    this.spectrumPanel.addAutomaticDeNovoSequencing((Peptide)peptides.get(i), (IonMatch[])allAnnotations.get(i), forwardIon.intValue(), rewindIon.intValue(), annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), true, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                }
                this.spectrumPanel.rescale(0.0, this.spectrumPanel.getMaxXAxisValue());
                this.spectrumSplitPane.setDividerLocation(0);
                this.spectrumContainerJPanel.revalidate();
                this.spectrumContainerJPanel.repaint();
                this.spectrumJPanel.removeAll();
                this.spectrumJPanel.add((Component)this.spectrumPanel);
                this.spectrumJPanel.revalidate();
                this.spectrumJPanel.repaint();
            } else {
                this.spectrumSplitPane.setDividerLocation(80);
                this.spectrumContainerJPanel.revalidate();
                this.spectrumContainerJPanel.repaint();
            }
            this.peptideShakerGUI.updateAnnotationMenus(specificAnnotationParameters, maxCharge, allModifications);
        }
    }

    private void updateSequenceCoverage(long proteinKey, String proteinAccession) {
        this.updateSequenceCoverage(proteinKey, proteinAccession, false);
    }

    private void updateSequenceCoverage(long proteinKey, String proteinAccession, boolean updateProtein) {
        try {
            HashMap<Object, Object> proteinTooltips;
            if (updateProtein || !proteinAccession.equalsIgnoreCase(this.currentProteinAccession) || this.coverage == null) {
                this.updateProteinSequenceCoveragePanelTitle(proteinAccession);
                this.updatePtmCoveragePlot(proteinAccession);
                this.updatePeptideVariationsCoveragePlot(proteinAccession);
            }
            this.currentProteinAccession = proteinAccession;
            SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
            ArrayList<Integer> selectedPeptideStart = new ArrayList<Integer>();
            int selectionLength = 0;
            if (this.peptideTable.getSelectedRow() != -1) {
                SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
                int peptideIndex = tableModel.getViewIndex(this.peptideTable.getSelectedRow());
                long peptideKey = this.peptideKeys[peptideIndex];
                PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                String peptideSequence = peptideMatch.getPeptide().getSequence();
                selectionLength = peptideSequence.length();
                try {
                    for (int startIndex : (int[])peptideMatch.getPeptide().getProteinMapping().get(this.currentProteinAccession)) {
                        selectedPeptideStart.add(startIndex);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
            int[] validationCoverage = this.coverageShowAllPeptidesJRadioButtonMenuItem.isSelected() ? identificationFeaturesGenerator.getAACoverage(proteinKey) : identificationFeaturesGenerator.estimateAACoverage(proteinKey, this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.isSelected());
            double minHeight = 0.2;
            double maxHeight = 1.0;
            NonSymmetricalNormalDistribution peptideLengthDistribution = this.peptideShakerGUI.getMetrics().getPeptideLengthDistribution();
            if (peptideLengthDistribution != null) {
                double medianLength = peptideLengthDistribution.getMean();
                maxHeight = (1.0 - minHeight) * peptideLengthDistribution.getProbabilityAt(medianLength);
            }
            double[] coverageLikelihood = identificationFeaturesGenerator.getCoverableAA(proteinKey);
            double[] coverageHeight = new double[coverageLikelihood.length];
            for (int i = 0; i < coverageLikelihood.length; ++i) {
                double p = coverageLikelihood[i];
                coverageHeight[i] = minHeight + p / maxHeight;
            }
            HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
            colors.put(MatchValidationLevel.confident.getIndex(), this.peptideShakerGUI.getSparklineColor());
            colors.put(MatchValidationLevel.doubtful.getIndex(), this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful());
            colors.put(MatchValidationLevel.not_validated.getIndex(), this.peptideShakerGUI.getSparklineColorNonValidated());
            colors.put(MatchValidationLevel.none.getIndex(), this.peptideShakerGUI.getSparklineColorNotFound());
            int userSelectionIndex = 0;
            while (colors.containsKey(userSelectionIndex)) {
                ++userSelectionIndex;
            }
            colors.put(userSelectionIndex, Color.blue);
            int[] coverageColor = (int[])validationCoverage.clone();
            Iterator iterator = selectedPeptideStart.iterator();
            while (iterator.hasNext()) {
                int aaStart;
                for (int aa = aaStart = ((Integer)iterator.next()).intValue(); aa < aaStart + selectionLength; ++aa) {
                    coverageColor[aa] = userSelectionIndex;
                }
            }
            int transparentIndex = userSelectionIndex + 1;
            colors.put(userSelectionIndex + 1, new Color(0, 0, 0, 0));
            for (int aa = 0; aa < coverageHeight.length; ++aa) {
                if (coverageColor[aa] != MatchValidationLevel.none.getIndex() || !(coverageLikelihood[aa] < 0.01) && this.coverageShowPossiblePeptidesJCheckBoxMenuItem.isSelected()) continue;
                coverageColor[aa] = transparentIndex;
            }
            ArrayList<JSparklinesDataSeries> sparkLineDataSeriesCoverage = ProteinSequencePanel.getSparkLineDataSeriesCoverage(coverageHeight, coverageColor, colors);
            try {
                proteinTooltips = this.peptideShakerGUI.getDisplayFeaturesGenerator().getResidueAnnotation(proteinKey, this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters(), identificationFeaturesGenerator, this.peptideShakerGUI.getMetrics(), this.peptideShakerGUI.getIdentification(), this.coverageShowAllPeptidesJRadioButtonMenuItem.isSelected(), searchParameters, this.coverageShowEnzymaticPeptidesOnlyJRadioButtonMenuItem.isSelected());
            }
            catch (Exception e) {
                this.peptideShakerGUI.catchException(e);
                proteinTooltips = new HashMap(0);
            }
            HashMap<Integer, ArrayList<ResidueAnnotation>> blocTooltips = new HashMap<Integer, ArrayList<ResidueAnnotation>>();
            int aaCpt = 0;
            int blocCpt = 0;
            for (JSparklinesDataSeries jSparklinesDataSeries : sparkLineDataSeriesCoverage) {
                double sparkLineLength = (Double)jSparklinesDataSeries.getData().get(0);
                ArrayList<ResidueAnnotation> blocAnnotation = new ArrayList<ResidueAnnotation>();
                int j = 0;
                while ((double)j < sparkLineLength) {
                    ArrayList aaAnnotation = (ArrayList)proteinTooltips.get(aaCpt);
                    if (aaAnnotation != null) {
                        for (ResidueAnnotation residueAnnotation : aaAnnotation) {
                            if (blocAnnotation.contains(residueAnnotation)) continue;
                            blocAnnotation.add(residueAnnotation);
                        }
                    }
                    ++j;
                    ++aaCpt;
                }
                blocTooltips.put(blocCpt, blocAnnotation);
                ++blocCpt;
            }
            this.proteinSequencePanel = new ProteinSequencePanel(Color.WHITE);
            this.coverageChart = this.proteinSequencePanel.getSequencePlot(this, new JSparklinesDataset(sparkLineDataSeriesCoverage), blocTooltips, true, true);
            this.coverageChart.getChart().addChangeListener(new ChartChangeListener(){

                public void chartChanged(ChartChangeEvent cce) {
                    Range range;
                    if (OverviewPanel.this.ptmChart != null) {
                        range = ((CategoryPlot)OverviewPanel.this.coverageChart.getChart().getPlot()).getRangeAxis().getRange();
                        ((CategoryPlot)OverviewPanel.this.ptmChart.getChart().getPlot()).getRangeAxis().setRange(range);
                        OverviewPanel.this.ptmChart.revalidate();
                        OverviewPanel.this.ptmChart.repaint();
                    }
                    if (OverviewPanel.this.peptideVariationsChart != null) {
                        range = ((CategoryPlot)OverviewPanel.this.coverageChart.getChart().getPlot()).getRangeAxis().getRange();
                        ((CategoryPlot)OverviewPanel.this.peptideVariationsChart.getChart().getPlot()).getRangeAxis().setRange(range);
                        OverviewPanel.this.peptideVariationsChart.revalidate();
                        OverviewPanel.this.peptideVariationsChart.repaint();
                    }
                }
            });
            this.sequenceCoverageInnerPanel.removeAll();
            this.sequenceCoverageInnerPanel.add((Component)this.coverageChart);
            this.sequenceCoverageInnerPanel.revalidate();
            this.sequenceCoverageInnerPanel.repaint();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void updateProteinSequenceCoveragePanelTitle(String proteinAccession) {
        this.currentProteinSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinAccession);
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
        if (this.proteinTable.getSelectedRow() != -1) {
            long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
            String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Protein Sequence Coverage (";
            HashMap sequenceCoverage = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getSequenceCoverage(proteinKey);
            double sequenceCoverageConfident = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.confident.getIndex());
            double sequenceCoverageDoubtful = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.doubtful.getIndex());
            double sequenceCoverageNotValidated = 100.0 * (Double)sequenceCoverage.get(MatchValidationLevel.not_validated.getIndex());
            double validatedCoverage = sequenceCoverageConfident + sequenceCoverageDoubtful;
            double totalCoverage = validatedCoverage + sequenceCoverageNotValidated;
            title = validatedCoverage > 0.0 ? title + Util.roundDouble((double)totalCoverage, (int)2) + "% - " + Util.roundDouble((double)sequenceCoverageConfident, (int)2) + "% confident, " + Util.roundDouble((double)sequenceCoverageDoubtful, (int)2) + "% doubtful, " + Util.roundDouble((double)sequenceCoverageNotValidated, (int)2) + "% not validated" : title + Util.roundDouble((double)sequenceCoverageNotValidated, (int)2) + "%";
            title = title + " - ";
            double possibleCoverarge = 100.0 * this.peptideShakerGUI.getIdentificationFeaturesGenerator().getObservableCoverage(proteinKey);
            title = title + Util.roundDouble((double)possibleCoverarge, (int)2) + "% possible";
            title = title + " - ";
            title = title + this.currentProteinSequence.length() + " AA)";
            title = title + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
            ((TitledBorder)this.sequenceCoverageTitledPanel.getBorder()).setTitle(title);
            this.sequenceCoverageTitledPanel.repaint();
        }
    }

    private void updatePtmCoveragePlot(String proteinAccession) {
        if (this.proteinTable.getSelectedRow() != -1) {
            try {
                SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
                long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
                ArrayList<JSparklinesDataSeries> sparkLineDataSeriesPtm = new ArrayList<JSparklinesDataSeries>();
                HashMap<Integer, ArrayList<ResidueAnnotation>> proteinTooltips = new HashMap<Integer, ArrayList<ResidueAnnotation>>();
                ArrayList<Double> data = new ArrayList<Double>();
                data.add(0.0);
                JSparklinesDataSeries sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                Identification identification = this.peptideShakerGUI.getIdentification();
                ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
                PSModificationScores psPtmScores = (PSModificationScores)proteinMatch.getUrParam((UrParameter)PSModificationScores.dummy);
                String sequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinAccession);
                int unmodifiedCounter = 0;
                HashMap<Integer, String> fixedPtms = new HashMap<Integer, String>();
                DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
                if (displayParameters.getDisplayedModifications().size() != this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getVariableModifications().size()) {
                    for (long peptideKey : this.peptideKeys) {
                        PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                        Peptide peptide = peptideMatch.getPeptide();
                        int[] indexesOnProtein = (int[])peptide.getProteinMapping().get(proteinAccession);
                        String[] fixedModifications = peptide.getFixedModifications(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters(), this.peptideShakerGUI.getSequenceProvider(), this.peptideShakerGUI.getIdentificationParameters().getModificationLocalizationParameters().getSequenceMatchingParameters());
                        for (int site = 0; site < fixedModifications.length; ++site) {
                            String modName = fixedModifications[site];
                            if (modName == null || !displayParameters.isDisplayedPTM(modName)) continue;
                            for (int index : indexesOnProtein) {
                                if (site == 0) {
                                    fixedPtms.put(site + index, modName);
                                    continue;
                                }
                                if (site == peptide.getSequence().length() + 1) {
                                    fixedPtms.put(site + index - 2, modName);
                                    continue;
                                }
                                fixedPtms.put(site + index - 1, modName);
                            }
                        }
                    }
                }
                for (int aa = 0; aa < sequence.length(); ++aa) {
                    String modName = (String)fixedPtms.get(aa);
                    for (ModificationMatch modificationMatch : proteinMatch.getVariableModifications()) {
                        if (modificationMatch.getSite() - 1 != aa || !displayParameters.isDisplayedPTM(modificationMatch.getModification())) continue;
                        modName = modificationMatch.getModification();
                        break;
                    }
                    if (modName != null) {
                        Color ptmColor;
                        if (unmodifiedCounter > 0) {
                            data = new ArrayList(1);
                            data.add(Double.valueOf(unmodifiedCounter));
                            sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                            sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                        }
                        if ((ptmColor = new Color(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getColor(modName))) == null) {
                            ptmColor = Color.lightGray;
                        }
                        ArrayList<ResidueAnnotation> annotations = new ArrayList<ResidueAnnotation>(1);
                        annotations.add(new ResidueAnnotation(modName + " (" + (aa + 1) + ")", 0L, false));
                        proteinTooltips.put(sparkLineDataSeriesPtm.size(), annotations);
                        data = new ArrayList(1);
                        data.add(1.0);
                        sparklineDataseriesPtm = new JSparklinesDataSeries(data, ptmColor, null);
                        sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                        unmodifiedCounter = 0;
                        continue;
                    }
                    ++unmodifiedCounter;
                }
                if (unmodifiedCounter > 0) {
                    data = new ArrayList();
                    data.add(Double.valueOf(unmodifiedCounter));
                    sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                    sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                }
                this.ptmSequencePanel = new ProteinSequencePanel(Color.WHITE);
                this.ptmChart = this.ptmSequencePanel.getSequencePlot(this, new JSparklinesDataset(sparkLineDataSeriesPtm), proteinTooltips, false, false);
                this.sequencePtmsPanel.removeAll();
                this.sequencePtmsPanel.add((Component)this.ptmChart);
                this.sequencePtmsPanel.revalidate();
                this.sequencePtmsPanel.repaint();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    private void updatePeptideVariationsCoveragePlot(String proteinAccession) {
        if (this.proteinTable.getSelectedRow() != -1) {
            try {
                ArrayList<JSparklinesDataSeries> sparkLineDataSeriesPtm = new ArrayList<JSparklinesDataSeries>();
                HashMap<Integer, ArrayList<ResidueAnnotation>> proteinTooltips = new HashMap<Integer, ArrayList<ResidueAnnotation>>();
                ArrayList<Double> data = new ArrayList<Double>();
                data.add(1.0);
                JSparklinesDataSeries sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                Identification identification = this.peptideShakerGUI.getIdentification();
                String sequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinAccession);
                int unmodifiedCounter = 0;
                HashMap<Integer, String> variantMapping = new HashMap<Integer, String>();
                DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
                if (displayParameters.getDisplayedModifications().size() != this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getVariableModifications().size()) {
                    for (long peptideKey : this.peptideKeys) {
                        PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
                        Peptide peptide = peptideMatch.getPeptide();
                        HashMap allVariants = peptide.getVariantMatches();
                        if (allVariants == null || !allVariants.containsKey(proteinAccession)) continue;
                        HashMap peptideVariants = (HashMap)allVariants.get(proteinAccession);
                        for (Integer peptideStart : peptideVariants.keySet()) {
                            PeptideVariantMatches peptideVariantMatches = (PeptideVariantMatches)peptideVariants.get(peptideStart);
                            HashMap variants = peptideVariantMatches.getVariantMatches();
                            for (Integer site : variants.keySet()) {
                                Variant variant = (Variant)variants.get(site);
                                variantMapping.put(site + peptideStart - 1, variant.getDescription());
                            }
                        }
                    }
                }
                for (int aa = 1; aa < sequence.length(); ++aa) {
                    String variantName = (String)variantMapping.get(aa + 1);
                    if (variantName != null) {
                        if (unmodifiedCounter > 0) {
                            data = new ArrayList(1);
                            data.add(Double.valueOf(unmodifiedCounter));
                            sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                            sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                        }
                        Color ptmColor = Color.ORANGE;
                        ArrayList<ResidueAnnotation> annotations = new ArrayList<ResidueAnnotation>(1);
                        annotations.add(new ResidueAnnotation(variantName + " (" + aa + ")", 0L, false));
                        proteinTooltips.put(sparkLineDataSeriesPtm.size(), annotations);
                        data = new ArrayList(1);
                        data.add(1.0);
                        sparklineDataseriesPtm = new JSparklinesDataSeries(data, ptmColor, null);
                        sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                        unmodifiedCounter = 0;
                        continue;
                    }
                    ++unmodifiedCounter;
                }
                if (unmodifiedCounter > 0) {
                    data = new ArrayList();
                    data.add(Double.valueOf(unmodifiedCounter));
                    sparklineDataseriesPtm = new JSparklinesDataSeries(data, new Color(0, 0, 0, 0), null);
                    sparkLineDataSeriesPtm.add(sparklineDataseriesPtm);
                }
                this.peptideVariationSequencePanel = new ProteinSequencePanel(Color.WHITE);
                this.peptideVariationsChart = this.peptideVariationSequencePanel.getSequencePlot(this, new JSparklinesDataset(sparkLineDataSeriesPtm), proteinTooltips, false, false);
                this.sequenceVariationsPanel.removeAll();
                this.sequenceVariationsPanel.add((Component)this.peptideVariationsChart);
                this.sequenceVariationsPanel.revalidate();
                this.sequenceVariationsPanel.repaint();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void updateSpectrum() {
        this.updateSpectrum(this.psmTable.getSelectedRow(), false);
    }

    private void updateSpectrum(int row, boolean resetMzRange) {
        if (row != -1) {
            String spectrumTitle;
            SpectrumMatch spectrumMatch;
            String spectrumFile;
            SpectrumProvider spectrumProvider;
            Spectrum currentSpectrum;
            this.setCursor(new Cursor(3));
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
            int psmIndex = tableModel.getViewIndex(row);
            long spectrumMatchKey = this.psmKeys[psmIndex];
            if (this.displaySpectrum && (currentSpectrum = (spectrumProvider = this.peptideShakerGUI.getSpectrumProvider()).getSpectrum(spectrumFile = (spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(spectrumMatchKey)).getSpectrumFile(), spectrumTitle = spectrumMatch.getSpectrumTitle())) != null && currentSpectrum.getNPeaks() > 0) {
                double newMaximum;
                boolean newMax = false;
                if (resetMzRange) {
                    this.lastMzMaximum = 0.0;
                }
                if (this.peptideShakerGUI.getSelectedPeptideKey() != ExperimentObject.NO_KEY && this.lastMzMaximum < (newMaximum = currentSpectrum.getMaxMz())) {
                    this.lastMzMaximum = newMaximum;
                    newMax = true;
                }
                double lowerMzZoomRange = 0.0;
                double upperMzZoomRange = this.lastMzMaximum;
                if (this.spectrumPanel != null && this.spectrumPanel.getXAxisZoomRangeLowerValue() != 0.0 && !newMax) {
                    lowerMzZoomRange = this.spectrumPanel.getXAxisZoomRangeLowerValue();
                    upperMzZoomRange = this.spectrumPanel.getXAxisZoomRangeUpperValue();
                }
                Precursor precursor = currentSpectrum.getPrecursor();
                this.spectrumPanel = new SpectrumPanel(currentSpectrum.mz, currentSpectrum.intensity, precursor.mz, Charge.toString((int)spectrumMatch.getBestPeptideAssumption().getIdentificationCharge()), "", 40, false, false, false, 2, false);
                SpectrumPanel.setKnownMassDeltas(this.peptideShakerGUI.getCurrentMassDeltas());
                this.spectrumPanel.setDeltaMassWindow(this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters().getFragmentIonAccuracy());
                this.spectrumPanel.setBorder(null);
                this.spectrumPanel.setDataPointAndLineColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakColor(), 0);
                this.spectrumPanel.setPeakWaterMarkColor(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakColor());
                this.spectrumPanel.setPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumAnnotatedPeakWidth());
                this.spectrumPanel.setBackgroundPeakWidth(this.peptideShakerGUI.getUtilitiesUserParameters().getSpectrumBackgroundPeakWidth());
                PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
                Peptide currentPeptide = peptideAssumption.getPeptide();
                PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
                AnnotationParameters annotationParameters = this.peptideShakerGUI.getIdentificationParameters().getAnnotationParameters();
                SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
                IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
                ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
                SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
                SpecificAnnotationParameters specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption);
                IonMatch[] annotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, currentSpectrum, currentPeptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                this.spectrumPanel.setAnnotations((List)SpectrumAnnotator.getSpectrumAnnotation((IonMatch[])annotations), annotationParameters.getTiesResolution() == SpectrumAnnotator.TiesResolution.mostIntense);
                this.spectrumPanel.rescale(lowerMzZoomRange, upperMzZoomRange);
                this.spectrumPanel.showAnnotatedPeaksOnly(!annotationParameters.showAllPeaks());
                this.spectrumPanel.setYAxisZoomExcludesBackgroundPeaks(annotationParameters.yAxisZoomExcludesBackgroundPeaks());
                Integer forwardIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getForwardIons().get(0);
                Integer rewindIon = (Integer)this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getRewindIons().get(0);
                this.spectrumPanel.addAutomaticDeNovoSequencing(currentPeptide, annotations, forwardIon.intValue(), rewindIon.intValue(), annotationParameters.getDeNovoCharge(), annotationParameters.showForwardIonDeNovoTags(), annotationParameters.showRewindIonDeNovoTags(), false, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
                this.spectrumJPanel.removeAll();
                this.spectrumJPanel.add((Component)this.spectrumPanel);
                this.spectrumJPanel.revalidate();
                this.spectrumJPanel.repaint();
                ArrayList<IonMatch[]> allAnnotations = this.getAnnotationsForAllSelectedSpectra();
                DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
                if (!displayParameters.useIntensityIonTable()) {
                    this.fragmentIonsJScrollPane.setViewportView((Component)new FragmentIonTable(currentPeptide, allAnnotations, specificAnnotationParameters.getFragmentIonTypes(), specificAnnotationParameters.getNeutralLossesMap(), specificAnnotationParameters.getSelectedCharges().contains(1), specificAnnotationParameters.getSelectedCharges().contains(2), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters));
                } else {
                    ArrayList spectra = Arrays.stream(this.getSelectedPsmKeys()).mapToObj(key -> this.peptideShakerGUI.getIdentification().getSpectrumMatch(key)).map(selectedMatch -> spectrumProvider.getSpectrum(selectedMatch.getSpectrumFile(), selectedMatch.getSpectrumTitle())).collect(Collectors.toCollection(ArrayList::new));
                    this.fragmentIonsJScrollPane.setViewportView((Component)new FragmentIonTable(currentPeptide, allAnnotations, spectra, specificAnnotationParameters.getFragmentIonTypes(), specificAnnotationParameters.getNeutralLossesMap(), specificAnnotationParameters.getSelectedCharges().contains(1), specificAnnotationParameters.getSelectedCharges().contains(2), modificationParameters, sequenceProvider, modificationSequenceMatchingParameters));
                }
                this.secondarySpectrumPlotsJPanel.removeAll();
                this.sequenceFragmentationPanel = new SequenceFragmentationPanel(this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(spectrumMatch, false, false, true), annotations, true, this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters(), forwardIon.intValue(), rewindIon.intValue());
                this.sequenceFragmentationPanel.setMinimumSize(new Dimension(this.sequenceFragmentationPanel.getPreferredSize().width, this.sequenceFragmentationPanel.getHeight()));
                this.sequenceFragmentationPanel.setOpaque(true);
                this.sequenceFragmentationPanel.setBackground(Color.WHITE);
                this.secondarySpectrumPlotsJPanel.add((Component)this.sequenceFragmentationPanel);
                this.intensityHistogram = new IntensityHistogram(annotations, currentSpectrum, annotationParameters.getAnnotationIntensityLimit(), false);
                this.secondarySpectrumPlotsJPanel.add((Component)this.intensityHistogram);
                this.massErrorPlot = new MassErrorPlot(annotations, currentSpectrum, specificAnnotationParameters.getFragmentIonAccuracy(), this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM, false);
                if (this.massErrorPlot.getNumberOfDataPointsInPlot() > 0) {
                    this.secondarySpectrumPlotsJPanel.add((Component)this.massErrorPlot);
                }
                this.secondarySpectrumPlotsJPanel.revalidate();
                this.secondarySpectrumPlotsJPanel.repaint();
                this.updateBubblePlot();
                this.spectrumJTabbedPane.setEnabledAt(2, this.psmTable.getSelectedRowCount() <= 2);
                this.peptideShakerGUI.enableSpectrumExport(this.psmTable.getSelectedRowCount() <= 2);
                if (this.psmTable.getSelectedRowCount() > 2 && this.spectrumJTabbedPane.getSelectedIndex() == 2) {
                    this.spectrumJTabbedPane.setSelectedIndex(1);
                }
                if (this.psmTable.getSelectedRowCount() > 2) {
                    this.spectrumJTabbedPane.setToolTipTextAt(2, "Available for single or double spectrum selection only");
                } else {
                    this.spectrumJTabbedPane.setToolTipTextAt(2, null);
                }
                this.updateSpectrumPanelBorderTitle(currentSpectrum);
                this.spectrumMainPanel.revalidate();
                this.spectrumMainPanel.repaint();
            }
            this.setCursor(new Cursor(0));
        } else {
            this.spectrumJPanel.removeAll();
            this.spectrumJPanel.revalidate();
            this.spectrumJPanel.repaint();
            this.secondarySpectrumPlotsJPanel.removeAll();
            this.secondarySpectrumPlotsJPanel.revalidate();
            this.secondarySpectrumPlotsJPanel.repaint();
            this.fragmentIonsJScrollPane.setViewportView(null);
            this.fragmentIonsJScrollPane.revalidate();
            this.fragmentIonsJScrollPane.repaint();
            this.bubbleJPanel.removeAll();
            this.bubbleJPanel.revalidate();
            this.bubbleJPanel.repaint();
            ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.spectrumMainPanel.repaint();
        }
    }

    private void updatePsmSelection(int row, boolean forcePsmOrderUpdate) {
        if (row != -1) {
            this.setCursor(new Cursor(3));
            Identification identification = this.peptideShakerGUI.getIdentification();
            IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
            int peptideIndex = tableModel.getViewIndex(row);
            long peptideKey = this.peptideKeys[peptideIndex];
            this.psmKeys = identificationFeaturesGenerator.getSortedPsmKeys(peptideKey, this.peptideShakerGUI.getUtilitiesUserParameters().getSortPsmsOnRt(), forcePsmOrderUpdate);
            this.psmTable.clearSelection();
            if (this.psmTable.getModel() instanceof PsmTableModel && ((PsmTableModel)((Object)this.psmTable.getModel())).isInstantiated()) {
                ((PsmTableModel)((Object)this.psmTable.getModel())).updateDataModel(identification, this.peptideShakerGUI.getDisplayFeaturesGenerator(), this.peptideShakerGUI.getIdentificationParameters(), this.psmKeys);
                ((PsmTableModel)((Object)this.psmTable.getModel())).setSelfUpdating(true);
                ((PsmTableModel)((Object)this.psmTable.getModel())).resetSorting(new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
            } else {
                PsmTableModel psmTableModel = new PsmTableModel(identification, this.peptideShakerGUI.getDisplayFeaturesGenerator(), this.peptideShakerGUI.getSpectrumProvider(), this.peptideShakerGUI.getIdentificationParameters(), this.psmKeys, this.peptideShakerGUI.getDisplayParameters().showScores(), (ExceptionHandler)this.peptideShakerGUI.getExceptionHandler());
                this.psmTable.setModel((TableModel)((Object)psmTableModel));
            }
            this.setPsmTableProperties();
            this.showSparkLines(this.peptideShakerGUI.showSparklines());
            int nValidatedPsms = identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideKey);
            int nConfidentPsms = identificationFeaturesGenerator.getNConfidentSpectraForPeptide(peptideKey);
            int nPsms = this.psmTable.getRowCount();
            String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches (";
            title = nConfidentPsms > 0 ? title + nValidatedPsms + "/" + nPsms + " - " + nConfidentPsms + " confident, " + (nValidatedPsms - nConfidentPsms) + " doubtful" : title + nValidatedPsms + "/" + nPsms;
            title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
            ((TitledBorder)this.psmsPanel.getBorder()).setTitle(title);
            this.psmsPanel.repaint();
            this.updateSelection(true);
            this.newItemSelection();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        int proteinIndex;
                        int selectedProteinRow = OverviewPanel.this.proteinTable.getSelectedRow();
                        if (selectedProteinRow != -1) {
                            SelfUpdatingTableModel proteinTableModel = (SelfUpdatingTableModel)OverviewPanel.this.proteinTable.getModel();
                            proteinIndex = proteinTableModel.getViewIndex(selectedProteinRow);
                        } else {
                            proteinIndex = 0;
                        }
                        long proteinKey = OverviewPanel.this.proteinKeys[proteinIndex];
                        ProteinMatch proteinMatch = OverviewPanel.this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                        OverviewPanel.this.updateSequenceCoverage(proteinKey, proteinMatch.getLeadingAccession());
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            this.setCursor(new Cursor(0));
        }
    }

    private void updatePeptideSelection(int proteinIndex) {
        if (proteinIndex != -1) {
            this.setCursor(new Cursor(3));
            Identification identification = this.peptideShakerGUI.getIdentification();
            IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
            long proteinMatchKey = this.proteinKeys[proteinIndex];
            ProteinMatch proteinMatch = identification.getProteinMatch(proteinMatchKey);
            String accession = proteinMatch.getLeadingAccession();
            this.peptideKeys = identificationFeaturesGenerator.getSortedPeptideKeys(proteinMatchKey);
            if (this.peptideTable.getModel() instanceof PeptideTableModel && ((PeptideTableModel)((Object)this.peptideTable.getModel())).isInstantiated()) {
                ((PeptideTableModel)((Object)this.peptideTable.getModel())).updateDataModel(identification, identificationFeaturesGenerator, this.peptideShakerGUI.getDisplayFeaturesGenerator(), accession, this.peptideKeys);
                ((PeptideTableModel)((Object)this.peptideTable.getModel())).setSelfUpdating(true);
                ((PeptideTableModel)((Object)this.peptideTable.getModel())).resetSorting(new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
            } else {
                PeptideTableModel peptideTableModel = new PeptideTableModel(identification, identificationFeaturesGenerator, this.peptideShakerGUI.getDisplayFeaturesGenerator(), accession, this.peptideKeys, this.peptideShakerGUI.getDisplayParameters().showScores(), (ExceptionHandler)this.peptideShakerGUI.getExceptionHandler());
                this.peptideTable.setModel((TableModel)((Object)peptideTableModel));
            }
            this.setPeptideTableProperties();
            this.showSparkLines(this.peptideShakerGUI.showSparklines());
            ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
            int maxPeptideSpectra = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getMaxNSpectra();
            ((JSparklinesArrayListBarChartTableCellRenderer)this.peptideTable.getColumn("#Spectra").getCellRenderer()).setMaxValue((double)maxPeptideSpectra);
            String tempSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinMatch.getLeadingAccession());
            this.peptideTable.getColumn("Start").setCellRenderer((TableCellRenderer)new JSparklinesMultiIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(tempSequence.length()), Double.valueOf((double)tempSequence.length() / 50.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 10);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        OverviewPanel.this.updateSelection(true);
                        OverviewPanel.this.updatePeptidePanelTitle();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            this.setCursor(new Cursor(0));
        }
    }

    public void displayResults() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Loading Overview. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OverviewPanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                try {
                    OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().setProteinKeys(OverviewPanel.this.peptideShakerGUI.getMetrics().getProteinKeys());
                    OverviewPanel.access$11302(OverviewPanel.this, OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys((WaitingHandler)OverviewPanel.this.progressDialog, OverviewPanel.this.peptideShakerGUI.getFilterParameters(), true));
                    OverviewPanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    OverviewPanel.this.progressDialog.setTitle("Preparing Overview. Please Wait...");
                    OverviewPanel.this.peptideShakerGUI.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")));
                    OverviewPanel.this.peptideShakerGUI.resetSelectedItems();
                    OverviewPanel.this.setTableProperties();
                    if (OverviewPanel.this.proteinTable.getModel() instanceof ProteinTableModel && ((ProteinTableModel)((Object)OverviewPanel.this.proteinTable.getModel())).isInstantiated()) {
                        ((ProteinTableModel)((Object)OverviewPanel.this.proteinTable.getModel())).updateDataModel(OverviewPanel.this.peptideShakerGUI.getIdentification(), OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), OverviewPanel.this.peptideShakerGUI.getProteinDetailsProvider(), OverviewPanel.this.peptideShakerGUI.getSequenceProvider(), OverviewPanel.this.peptideShakerGUI.getGeneMaps(), OverviewPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), OverviewPanel.this.proteinKeys);
                    } else {
                        ProteinTableModel proteinTableModel = new ProteinTableModel(OverviewPanel.this.peptideShakerGUI.getIdentification(), OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), OverviewPanel.this.peptideShakerGUI.getProteinDetailsProvider(), OverviewPanel.this.peptideShakerGUI.getSequenceProvider(), OverviewPanel.this.peptideShakerGUI.getGeneMaps(), OverviewPanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), (ExceptionHandler)OverviewPanel.this.peptideShakerGUI.getExceptionHandler(), OverviewPanel.this.proteinKeys);
                        OverviewPanel.this.proteinTable.setModel((TableModel)((Object)proteinTableModel));
                    }
                    OverviewPanel.this.setTableProperties();
                    OverviewPanel.this.showSparkLines(OverviewPanel.this.peptideShakerGUI.showSparklines());
                    ((DefaultTableModel)OverviewPanel.this.proteinTable.getModel()).fireTableDataChanged();
                    switch (OverviewPanel.this.peptideShakerGUI.getSpectrumCountingParameters().getSelectedMethod()) {
                        case NSAF: {
                            OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Protein MS2 Quantification - NSAF");
                            break;
                        }
                        case EMPAI: {
                            OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Protein MS2 Quantification - emPAI");
                            break;
                        }
                        case LFQ: {
                            OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Label-free MS1 Quantification - LFQ");
                            break;
                        }
                    }
                    if (OverviewPanel.this.peptideShakerGUI.getDisplayParameters().showScores()) {
                        OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumnCount() - 2, "Protein Score");
                    } else {
                        OverviewPanel.this.proteinTableToolTips.set(OverviewPanel.this.proteinTable.getColumnCount() - 2, "Protein Confidence");
                    }
                    OverviewPanel.this.updateProteinPanelTitle();
                    OverviewPanel.this.updateProteinTableCellRenderers();
                    SearchParameters searchParameters = OverviewPanel.this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
                    double accuracy = (double)OverviewPanel.this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
                    OverviewPanel.this.accuracySlider.setToolTipText("Annotation Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType());
                    OverviewPanel.this.intensitySlider.setToolTipText("Annotation Level: " + OverviewPanel.this.intensitySlider.getValue() + "%");
                    OverviewPanel.this.exportProteinsJButton.setEnabled(true);
                    OverviewPanel.this.exportPeptidesJButton.setEnabled(true);
                    OverviewPanel.this.exportPsmsJButton.setEnabled(true);
                    OverviewPanel.this.exportSpectrumJButton.setEnabled(true);
                    OverviewPanel.this.exportSequenceCoverageContextJButton.setEnabled(true);
                    OverviewPanel.this.peptideShakerGUI.setUpdated(0, true);
                    OverviewPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                    OverviewPanel.this.progressDialog.setRunFinished();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                OverviewPanel.this.peptideShakerGUI.checkNewsFeed();
                                OverviewPanel.this.peptideShakerGUI.showNotesNotification();
                                OverviewPanel.this.peptideShakerGUI.showTipsNotification();
                                OverviewPanel.this.proteinTable.requestFocus();
                                OverviewPanel.this.updateSelection(true);
                            }
                            catch (Exception e) {
                                OverviewPanel.this.peptideShakerGUI.catchException(e);
                            }
                        }
                    }, "UpdateSelectionThread").start();
                }
                catch (Exception e) {
                    OverviewPanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                    OverviewPanel.this.peptideShakerGUI.catchException(e);
                    OverviewPanel.this.progressDialog.setRunFinished();
                }
            }
        }.start();
    }

    public void updateProteinTable() {
        DefaultTableModel dm = (DefaultTableModel)this.proteinTable.getModel();
        dm.fireTableDataChanged();
        this.updateSelection(true);
    }

    public JTable getProteinTable() {
        return this.proteinTable;
    }

    private ArrayList<IonMatch[]> getAnnotationsForAllSelectedSpectra() {
        ArrayList<IonMatch[]> allAnnotations = new ArrayList<IonMatch[]>();
        int[] selectedRows = this.psmTable.getSelectedRows();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        AnnotationParameters annotationParameters = identificationParameters.getAnnotationParameters();
        SpectrumProvider spectrumProvider = this.peptideShakerGUI.getSpectrumProvider();
        PeptideSpectrumAnnotator spectrumAnnotator = new PeptideSpectrumAnnotator();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        for (int row : selectedRows) {
            String spectrumTitle;
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
            int psmIndex = tableModel.getViewIndex(row);
            long spectrumMatchKey = this.psmKeys[psmIndex];
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(spectrumMatchKey);
            String spectrumFile = spectrumMatch.getSpectrumFile();
            Spectrum currentSpectrum = spectrumProvider.getSpectrum(spectrumFile, spectrumTitle = spectrumMatch.getSpectrumTitle());
            if (currentSpectrum == null || this.peptideTable.getSelectedRow() == -1) continue;
            PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
            Peptide peptide = peptideAssumption.getPeptide();
            SpecificAnnotationParameters specificAnnotationParameters = this.peptideShakerGUI.getSpecificAnnotationParameters(spectrumFile, spectrumTitle, (SpectrumIdentificationAssumption)peptideAssumption);
            IonMatch[] annotations = spectrumAnnotator.getSpectrumAnnotation(annotationParameters, specificAnnotationParameters, spectrumFile, spectrumTitle, currentSpectrum, peptide, modificationParameters, sequenceProvider, modificationSequenceMatchingParameters);
            allAnnotations.add(annotations);
            this.currentSpectrumMatchKey = spectrumMatchKey;
        }
        return allAnnotations;
    }

    public long[] getSelectedPsmKeys() {
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
        return Arrays.stream(this.psmTable.getSelectedRows()).map(row -> tableModel.getViewIndex(row)).mapToLong(psmIndex -> this.psmKeys[psmIndex]).toArray();
    }

    public TreeMap<String, TreeSet<String>> getSelectedSpectrumTitles() {
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
        TreeMap<String, TreeSet<String>> result = new TreeMap<String, TreeSet<String>>();
        for (int row : this.psmTable.getSelectedRows()) {
            long psmKey = this.psmKeys[tableModel.getViewIndex(row)];
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
            String spectrumFile = spectrumMatch.getSpectrumFile();
            String spectrumTitle = spectrumMatch.getSpectrumTitle();
            TreeSet<String> spectrumTitles = result.get(spectrumFile);
            if (spectrumTitles == null) {
                spectrumTitles = new TreeSet();
                result.put(spectrumFile, spectrumTitles);
            }
            spectrumTitles.add(spectrumTitle);
        }
        return result;
    }

    public HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> getSelectedIdentificationAssumptions() {
        int[] selectedRows = this.psmTable.getSelectedRows();
        HashMap<Long, ArrayList<SpectrumIdentificationAssumption>> results = new HashMap<Long, ArrayList<SpectrumIdentificationAssumption>>(selectedRows.length);
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
        for (int row : selectedRows) {
            int psmIndex = tableModel.getViewIndex(row);
            long spectrumKey = this.psmKeys[psmIndex];
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(spectrumKey);
            ArrayList<PeptideAssumption> assumptions = new ArrayList<PeptideAssumption>(1);
            assumptions.add(spectrumMatch.getBestPeptideAssumption());
            results.put(spectrumKey, assumptions);
        }
        return results;
    }

    public Component getSpectrum() {
        if (this.spectrumJTabbedPane.isEnabledAt(2)) {
            this.spectrumJTabbedPane.setSelectedIndex(2);
            return this.spectrumJPanel.getComponent(0);
        }
        return null;
    }

    public Component getSpectrumAndPlots() {
        if (this.spectrumJTabbedPane.isEnabledAt(2)) {
            this.spectrumJTabbedPane.setSelectedIndex(2);
            return this.spectrumSplitPane;
        }
        return null;
    }

    public Component getSequenceFragmentationPlot() {
        if (this.spectrumJTabbedPane.isEnabledAt(2)) {
            this.spectrumJTabbedPane.setSelectedIndex(2);
            return this.secondarySpectrumPlotsJPanel.getComponent(0);
        }
        return null;
    }

    public IntensityHistogram getIntensityHistogramPlot() {
        if (this.spectrumJTabbedPane.isEnabledAt(2)) {
            this.spectrumJTabbedPane.setSelectedIndex(2);
            return (IntensityHistogram)this.secondarySpectrumPlotsJPanel.getComponent(1);
        }
        return null;
    }

    public MassErrorPlot getMassErrorPlot() {
        if (this.spectrumJTabbedPane.isEnabledAt(2)) {
            this.spectrumJTabbedPane.setSelectedIndex(2);
            if (this.secondarySpectrumPlotsJPanel.getComponentCount() == 3) {
                return (MassErrorPlot)this.secondarySpectrumPlotsJPanel.getComponent(2);
            }
        }
        return null;
    }

    public Component getBubblePlot() {
        if (this.spectrumJTabbedPane.isEnabledAt(1)) {
            this.spectrumJTabbedPane.setSelectedIndex(1);
            return ((MassErrorBubblePlot)this.bubbleJPanel.getComponent(0)).getChartPanel();
        }
        return null;
    }

    public boolean isSpectrumEnabled() {
        return this.spectrumJTabbedPane.isEnabledAt(2);
    }

    public void showSeparators(boolean showSeparators) {
        int dividerSize = 5;
        if (showSeparators) {
            this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerSize(dividerSize);
            this.formComponentResized(null);
        } else {
            this.peptidesPsmSpectrumFragmentIonsJSplitPane.setDividerSize(0);
            this.formComponentResized(null);
        }
    }

    public void updateScores() {
        ((ProteinTableModel)((Object)this.proteinTable.getModel())).showScores(this.peptideShakerGUI.getDisplayParameters().showScores());
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableStructureChanged();
        ((PeptideTableModel)((Object)this.peptideTable.getModel())).showScores(this.peptideShakerGUI.getDisplayParameters().showScores());
        ((DefaultTableModel)this.peptideTable.getModel()).fireTableStructureChanged();
        ((PsmTableModel)((Object)this.psmTable.getModel())).showScores(this.peptideShakerGUI.getDisplayParameters().showScores());
        ((DefaultTableModel)this.psmTable.getModel()).fireTableStructureChanged();
        this.setTableProperties();
        if (this.peptideShakerGUI.getSelectedTab() == 0) {
            this.updateSelection(false);
        }
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Score");
            this.peptideTableToolTips.set(this.peptideTable.getColumnCount() - 2, "Peptide Score");
            this.psmTableToolTips.set(this.psmTable.getColumnCount() - 2, "PSM Score");
        } else {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Confidence");
            this.peptideTableToolTips.set(this.peptideTable.getColumnCount() - 2, "Peptide Confidence");
            this.psmTableToolTips.set(this.psmTable.getColumnCount() - 2, "PSM Confidence");
        }
        this.updateProteinTableCellRenderers();
    }

    public void enableDarkTheme(boolean darkTheme) {
        if (darkTheme) {
            this.proteinTable.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinTable.setForeground(new Color(240, 240, 240));
            this.proteinTable.setSelectionBackground(Color.DARK_GRAY);
            this.proteinTable.setSelectionForeground(new Color(240, 240, 240));
            this.proteinTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), "FEFFFF"));
            ((ChromosomeTableCellRenderer)this.proteinTable.getColumn("Chr").getCellRenderer()).setFontColors(new Color(240, 240, 240), new Color(240, 240, 240));
            this.peptideTable.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.peptideTable.setForeground(new Color(240, 240, 240));
            this.peptideTable.setSelectionBackground(Color.DARK_GRAY);
            this.peptideTable.setSelectionForeground(new Color(240, 240, 240));
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showReferenceLine(true, 0.03, Color.WHITE);
            this.psmTable.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.psmTable.setForeground(new Color(240, 240, 240));
            this.psmTable.setSelectionBackground(Color.DARK_GRAY);
            this.psmTable.setSelectionForeground(new Color(240, 240, 240));
            this.spectrumPanel.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.spectrumPanel.getGraphics().setColor(Color.WHITE);
            this.ptmChart.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.ptmSequencePanel.getChartPanel().setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.ptmSequencePanel.getChartPanel().getChart().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.ptmSequencePanel.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().setRangeGridlinePaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setLabelPaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().setDomainGridlinePaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setLabelPaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.coverageChart.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinSequencePanel.getChartPanel().setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinSequencePanel.getChartPanel().getChart().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinSequencePanel.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().setRangeGridlinePaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setLabelPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().setDomainGridlinePaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setLabelPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.setReferenceLine(0.03, Color.WHITE);
            this.massErrorBubblePlot.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorBubblePlot.getChartPanel().setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorBubblePlot.getChartPanel().getChart().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorBubblePlot.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.massErrorPlot.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorPlot.getChartPanel().setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorPlot.getChartPanel().getChart().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorPlot.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.intensityHistogram.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.intensityHistogram.getChartPanel().setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.intensityHistogram.getChartPanel().getChart().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.intensityHistogram.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
            this.proteinSequencePanel.setReferenceLine(0.03, Color.WHITE);
            ((TitledBorder)this.proteinsLayeredPanel.getBorder()).setTitleColor(new Color(240, 240, 240));
            ((TitledBorder)this.peptidesPanel.getBorder()).setTitleColor(new Color(240, 240, 240));
            ((TitledBorder)this.psmsPanel.getBorder()).setTitleColor(new Color(240, 240, 240));
            ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitleColor(new Color(240, 240, 240));
            ((TitledBorder)this.sequenceCoverageTitledPanel.getBorder()).setTitleColor(new Color(240, 240, 240));
            this.sequenceFragmentationPanel.setFontColor(new Color(240, 240, 240));
            this.sequenceFragmentationPanel.setFont(new Font("Segoe UI", 1, 14));
            this.sequenceFragmentationPanel.setBackground(PeptideShakerGUI.DARK_THEME_BACKGROUND_COLOR);
        } else {
            this.proteinTable.setBackground(Color.WHITE);
            this.proteinTable.setForeground(Color.BLACK);
            this.proteinTable.setSelectionBackground(new Color(57, 105, 138));
            this.proteinTable.setSelectionForeground(Color.WHITE);
            this.proteinTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
            ((ChromosomeTableCellRenderer)this.proteinTable.getColumn("Chr").getCellRenderer()).setFontColors(Color.WHITE, Color.BLACK);
            this.peptideTable.setBackground(Color.WHITE);
            this.peptideTable.setForeground(Color.BLACK);
            this.peptideTable.setSelectionBackground(new Color(57, 105, 138));
            this.peptideTable.setSelectionForeground(Color.WHITE);
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
            this.psmTable.setBackground(Color.WHITE);
            this.psmTable.setForeground(Color.BLACK);
            this.psmTable.setSelectionBackground(new Color(57, 105, 138));
            this.psmTable.setSelectionForeground(Color.WHITE);
            this.spectrumPanel.setBackground(Color.WHITE);
            this.spectrumPanel.getGraphics().setColor(Color.BLACK);
            this.ptmChart.setBackground(Color.WHITE);
            this.ptmSequencePanel.getChartPanel().setBackground(Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setLabelPaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setLabelPaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.ptmSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.coverageChart.setBackground(Color.WHITE);
            this.proteinSequencePanel.getChartPanel().setBackground(Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setLabelPaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getRangeAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setLabelPaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.proteinSequencePanel.getChartPanel().getChart().getCategoryPlot().getDomainAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.proteinSequencePanel.setReferenceLine(0.03, Color.BLACK);
            this.proteinSequencePanel.setBackground(Color.WHITE);
            this.proteinSequencePanel.setReferenceLine(0.03, Color.BLACK);
            this.massErrorBubblePlot.setBackground(Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().setBackground(Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.massErrorBubblePlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.massErrorPlot.setBackground(Color.WHITE);
            this.massErrorPlot.getChartPanel().setBackground(Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.massErrorPlot.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.intensityHistogram.setBackground(Color.WHITE);
            this.intensityHistogram.getChartPanel().setBackground(Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().setBackgroundPaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getPlot().setBackgroundPaint((Paint)Color.WHITE);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setLabelPaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getRangeAxis().setTickLabelPaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setLabelPaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setAxisLinePaint((Paint)Color.BLACK);
            this.intensityHistogram.getChartPanel().getChart().getXYPlot().getDomainAxis().setTickLabelPaint((Paint)Color.BLACK);
            ((TitledBorder)this.proteinsLayeredPanel.getBorder()).setTitleColor(Color.BLACK);
            ((TitledBorder)this.peptidesPanel.getBorder()).setTitleColor(Color.BLACK);
            ((TitledBorder)this.psmsPanel.getBorder()).setTitleColor(Color.BLACK);
            ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitleColor(Color.BLACK);
            ((TitledBorder)this.sequenceCoverageTitledPanel.getBorder()).setTitleColor(Color.BLACK);
            this.sequenceFragmentationPanel.setFontColor(Color.BLACK);
            this.sequenceFragmentationPanel.setFont(new Font("Segoe UI", 1, 14));
            this.sequenceFragmentationPanel.setBackground(Color.WHITE);
        }
        this.proteinTable.repaint();
    }

    public int getSelectedSpectrumTabIndex() {
        return this.spectrumJTabbedPane.getSelectedIndex();
    }

    public void showSpectrumAnnotationMenu() {
        this.spectrumJTabbedPaneStateChanged(null);
    }

    public void setIntensitySliderValue(int value) {
        this.intensitySlider.setValue(value);
    }

    public void setAccuracySliderValue(int value) {
        this.accuracySlider.setValue(value);
    }

    public void updateModificationColors() {
        this.setCursor(new Cursor(3));
        ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
        ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
        if (this.proteinTable.getSelectedRow() != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            long proteinKey = this.proteinKeys[tableModel.getViewIndex(this.proteinTable.getSelectedRow())];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
            this.updateSequenceCoverage(proteinKey, proteinMatch.getLeadingAccession(), true);
        }
        this.updateSelection(false);
        this.setCursor(new Cursor(0));
    }

    public void updatePsmOrder() {
        this.setCursor(new Cursor(3));
        this.updatePsmSelection(this.peptideTable.getSelectedRow(), true);
        ((DefaultTableModel)this.psmTable.getModel()).fireTableDataChanged();
        this.setCursor(new Cursor(0));
    }

    private void updateSpectrumPanelBorderTitle(Spectrum currentSpectrum) {
        if (this.peptideTable.getSelectedRow() != -1 && this.proteinTable.getSelectedRow() != -1 && this.psmTable.getSelectedRow() != -1) {
            Identification identification = this.peptideShakerGUI.getIdentification();
            int nAA = this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides();
            SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
            SelfUpdatingTableModel psmTableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
            int psmIndex = psmTableModel.getViewIndex(this.psmTable.getSelectedRow());
            long spectrumMatchKey = this.psmKeys[psmIndex];
            SpectrumMatch spectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
            PeptideAssumption peptideAssumption = spectrumMatch.getBestPeptideAssumption();
            SelfUpdatingTableModel peptideTableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
            int peptideIndex = peptideTableModel.getViewIndex(this.peptideTable.getSelectedRow());
            long peptideKey = this.peptideKeys[peptideIndex];
            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideKey);
            Peptide peptide = peptideMatch.getPeptide();
            SelfUpdatingTableModel proteinTableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            long proteinKey = this.proteinKeys[proteinTableModel.getViewIndex(this.proteinTable.getSelectedRow())];
            ProteinMatch proteinMatch = identification.getProteinMatch(proteinKey);
            String leadingAccession = proteinMatch.getLeadingAccession();
            String aaBefore = Arrays.stream((int[])peptide.getProteinMapping().get(leadingAccession)).mapToObj(index -> PeptideUtils.getAaBefore((Peptide)peptide, (String)leadingAccession, (int)index, (int)nAA, (SequenceProvider)sequenceProvider)).collect(Collectors.joining("|"));
            String aaAfter = Arrays.stream((int[])peptide.getProteinMapping().get(leadingAccession)).mapToObj(index -> PeptideUtils.getAaAfter((Peptide)peptide, (String)leadingAccession, (int)index, (int)nAA, (SequenceProvider)sequenceProvider)).collect(Collectors.joining("|"));
            if (!aaBefore.equals("")) {
                aaBefore = aaBefore + " - ";
            }
            if (!aaAfter.equals("")) {
                aaAfter = " - " + aaAfter;
            }
            if (this.psmTable.getSelectedRowCount() == 1) {
                String modifiedSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(spectrumMatch, false, false, true);
                ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + aaBefore + modifiedSequence + aaAfter + "   " + Charge.toString((int)peptideAssumption.getIdentificationCharge()) + "   " + Util.roundDouble((double)currentSpectrum.getPrecursor().mz, (int)2) + " m/z)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            } else if (this.psmTable.getSelectedRowCount() == 2) {
                int[] selectedRows = this.psmTable.getSelectedRows();
                psmIndex = psmTableModel.getViewIndex(selectedRows[0]);
                spectrumMatchKey = this.psmKeys[psmIndex];
                SpectrumMatch firstSpectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
                String firstModifiedSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(firstSpectrumMatch, false, false, true);
                psmIndex = psmTableModel.getViewIndex(selectedRows[1]);
                spectrumMatchKey = this.psmKeys[psmIndex];
                SpectrumMatch secondSpectrumMatch = identification.getSpectrumMatch(spectrumMatchKey);
                String secondModifiedSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(secondSpectrumMatch, false, false, true);
                ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + firstModifiedSequence + " vs. " + secondModifiedSequence + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            } else {
                PeptideMatch currentPeptideMatch = (PeptideMatch)this.peptideShakerGUI.getIdentification().retrieveObject(peptideKey);
                String peptideSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(currentPeptideMatch, false, false, true);
                ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions (" + peptideSequence + " " + this.psmTable.getSelectedRowCount() + " PSMs)" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            }
            this.spectrumMainPanel.repaint();
        } else {
            ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.spectrumMainPanel.repaint();
        }
    }

    public void updatePeptideProteinInference(int proteinInferenceType) {
        this.peptideTable.setValueAt(proteinInferenceType, this.peptideTable.getSelectedRow(), this.peptideTable.getColumn("PI").getModelIndex());
    }

    private void copyTableContentToClipboardOrFile(TableIndex index) {
        final TableIndex tableIndex = index;
        final HashMap exportFeatures = new HashMap();
        final ArrayList sectionContent = new ArrayList();
        if (tableIndex == TableIndex.PROTEIN_TABLE || tableIndex == TableIndex.PEPTIDE_TABLE || tableIndex == TableIndex.PSM_TABLE) {
            String textFileFilterDescription = "Tab separated text file (.txt)";
            String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
            String excelFileFilterDescription = "Excel Workbook (.xls)";
            String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
            String exportName = "Export";
            switch (tableIndex.ordinal()) {
                case 0: {
                    exportName = "Protein table";
                    break;
                }
                case 1: {
                    exportName = "Peptide table";
                    break;
                }
                case 2: {
                    exportName = "PSM table";
                    break;
                }
            }
            FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".xls", ".txt", ".gz"}, (String[])new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)exportName, (boolean)false, (boolean)true, (boolean)false, (int)1);
            if (selectedFileAndFilter != null) {
                boolean gzip;
                ExportFormat exportFormat;
                final File selectedFile = selectedFileAndFilter.getFile();
                if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = false;
                } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = true;
                } else {
                    exportFormat = ExportFormat.excel;
                    gzip = false;
                }
                this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setTitle("Exporting Data. Please Wait...");
                final String filePath = selectedFile.getPath();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OverviewPanel.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        try {
                            switch (tableIndex.ordinal()) {
                                case 0: {
                                    sectionContent.add(PsProteinFeature.starred);
                                    sectionContent.add(PsProteinFeature.pi);
                                    sectionContent.add(PsProteinFeature.accession);
                                    sectionContent.add(PsProteinFeature.protein_description);
                                    sectionContent.add(PsProteinFeature.protein_group);
                                    sectionContent.add(PsProteinFeature.descriptions);
                                    sectionContent.add(PsProteinFeature.other_proteins);
                                    sectionContent.add(PsProteinFeature.chromosome);
                                    sectionContent.add(PsProteinFeature.coverage);
                                    sectionContent.add(PsProteinFeature.confident_coverage);
                                    sectionContent.add(PsProteinFeature.all_coverage);
                                    sectionContent.add(PsProteinFeature.possible_coverage);
                                    sectionContent.add(PsProteinFeature.validated_peptides);
                                    sectionContent.add(PsProteinFeature.peptides);
                                    sectionContent.add(PsProteinFeature.unique_peptides);
                                    sectionContent.add(PsProteinFeature.unique_validated_peptides);
                                    sectionContent.add(PsProteinFeature.validated_psms);
                                    sectionContent.add(PsProteinFeature.psms);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai);
                                    sectionContent.add(PsProteinFeature.label_free_quantification);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_percent);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_percent);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_percent);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_ppm);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_ppm);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_ppm);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_fmol);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_fmol);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_fmol);
                                    sectionContent.add(PsProteinFeature.mw);
                                    sectionContent.add(PsProteinFeature.confidence);
                                    sectionContent.add(PsProteinFeature.validated);
                                    exportFeatures.put("Protein Identification Summary", sectionContent);
                                    ExportScheme validatedProteinReport = new ExportScheme("Protein Table", false, exportFeatures, "\t", true, true, 0, false, false, false);
                                    PSExportFactory.writeExport(validatedProteinReport, selectedFile, exportFormat, gzip, OverviewPanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), OverviewPanel.this.peptideShakerGUI.getProjectDetails(), OverviewPanel.this.peptideShakerGUI.getIdentification(), OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), OverviewPanel.this.peptideShakerGUI.getGeneMaps(), OverviewPanel.this.getDisplayedProteins(), null, null, OverviewPanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), OverviewPanel.this.peptideShakerGUI.getIdentificationParameters(), OverviewPanel.this.peptideShakerGUI.getSequenceProvider(), OverviewPanel.this.peptideShakerGUI.getProteinDetailsProvider(), OverviewPanel.this.peptideShakerGUI.getSpectrumProvider(), OverviewPanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)OverviewPanel.this.progressDialog);
                                    break;
                                }
                                case 1: {
                                    sectionContent.add(PsPeptideFeature.starred);
                                    sectionContent.add(PsPeptideFeature.pi);
                                    sectionContent.add(PsPeptideFeature.accessions);
                                    sectionContent.add(PsPeptideFeature.protein_description);
                                    sectionContent.add(PsPeptideFeature.protein_groups);
                                    sectionContent.add(PsPeptideFeature.sequence);
                                    sectionContent.add(PsPeptideFeature.modified_sequence);
                                    sectionContent.add(PsPeptideFeature.position);
                                    sectionContent.add(PsPeptideFeature.aaBefore);
                                    sectionContent.add(PsPeptideFeature.aaAfter);
                                    sectionContent.add(PsPeptideFeature.missed_cleavages);
                                    sectionContent.add(PsPeptideFeature.variable_ptms);
                                    sectionContent.add(PsPeptideFeature.fixed_ptms);
                                    sectionContent.add(PsPeptideFeature.psms);
                                    sectionContent.add(PsPeptideFeature.validated_psms);
                                    sectionContent.add(PsPeptideFeature.confidence);
                                    sectionContent.add(PsPeptideFeature.validated);
                                    exportFeatures.put("Peptide Identification Summary", sectionContent);
                                    ExportScheme validatedProteinReport = new ExportScheme("Peptide Table", false, exportFeatures, "\t", true, true, 0, false, false, false);
                                    PSExportFactory.writeExport(validatedProteinReport, selectedFile, exportFormat, gzip, OverviewPanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), OverviewPanel.this.peptideShakerGUI.getProjectDetails(), OverviewPanel.this.peptideShakerGUI.getIdentification(), OverviewPanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), OverviewPanel.this.peptideShakerGUI.getGeneMaps(), null, OverviewPanel.this.getDisplayedPeptides(), null, OverviewPanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), OverviewPanel.this.peptideShakerGUI.getIdentificationParameters(), OverviewPanel.this.peptideShakerGUI.getSequenceProvider(), OverviewPanel.this.peptideShakerGUI.getProteinDetailsProvider(), OverviewPanel.this.peptideShakerGUI.getSpectrumProvider(), OverviewPanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)OverviewPanel.this.progressDialog);
                                    break;
                                }
                                case 2: {
                                    BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));
                                    Util.tableToFile((JTable)OverviewPanel.this.psmTable, (String)"\t", (ProgressDialogX)OverviewPanel.this.progressDialog, (boolean)true, (BufferedWriter)writer);
                                    writer.close();
                                    break;
                                }
                            }
                            boolean processCancelled = OverviewPanel.this.progressDialog.isRunCanceled();
                            OverviewPanel.this.progressDialog.setRunFinished();
                            if (!processCancelled) {
                                JOptionPane.showMessageDialog(OverviewPanel.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported", 1);
                            }
                        }
                        catch (FileNotFoundException e) {
                            OverviewPanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(OverviewPanel.this.peptideShakerGUI, "An error occurred while generating the output. Please make sure that the destination file is not opened by another application.", "Output Error", 0);
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getMessage().contains("Invalid row number (65536)")) {
                                OverviewPanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(OverviewPanel.this.peptideShakerGUI, "An error occurred while generating the output. This format can contain only 65,535 lines.\nPlease use a text export instead.", "Output Error", 0);
                                e.printStackTrace();
                            } else {
                                OverviewPanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(OverviewPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            OverviewPanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(OverviewPanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        }
    }

    private boolean updateHiddenPanels() {
        this.showProteinsJButton.setVisible(!this.displayProteins);
        this.showProteinsAfterSeparator.setVisible(!this.displayProteins);
        this.showPeptidesAndPsmsJButton.setVisible(!this.displayPeptidesAndPSMs);
        this.showPeptidesAfterSeparator.setVisible(!this.displayPeptidesAndPSMs);
        this.showCoverageJButton.setVisible(!this.displayCoverage);
        this.showCoverageAfterSeparator.setVisible(!this.displayCoverage);
        this.showSpectrumJButton.setVisible(!this.displaySpectrum);
        this.showSpectrumAfterSeparator.setVisible(!this.displaySpectrum);
        if (this.displayProteins && this.displayPeptidesAndPSMs && this.displayCoverage && this.displaySpectrum) {
            this.showProteinsBeforeSeparator.setVisible(false);
        } else {
            this.showProteinsBeforeSeparator.setVisible(true);
        }
        return this.displayProteins && this.displayPeptidesAndPSMs && this.displayCoverage && this.displaySpectrum;
    }

    private void reselect() {
        long psmKey;
        int psmRow;
        long proteinKey = this.peptideShakerGUI.getSelectedProteinKey();
        long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        if (proteinKey != ExperimentObject.NO_KEY) {
            int proteinRow = this.getProteinRow(proteinKey);
            this.proteinTable.setRowSelectionInterval(proteinRow, proteinRow);
        }
        if (peptideKey != ExperimentObject.NO_KEY) {
            int peptideRow = this.getPeptideRow(peptideKey);
            this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
        }
        if (spectrumFile != null && spectrumTitle != null && (psmRow = this.getPsmRow(psmKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle))) < this.psmTable.getRowCount()) {
            this.psmTable.setRowSelectionInterval(psmRow, psmRow);
        }
    }

    public void updateSelection(boolean scrollToVisible) {
        long psmKey;
        SpectrumMatch spectrumMatch;
        int proteinRow = 0;
        Identification identification = this.peptideShakerGUI.getIdentification();
        long proteinKey = this.peptideShakerGUI.getSelectedProteinKey();
        long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey == ExperimentObject.NO_KEY && spectrumFile != null && spectrumTitle != null && (spectrumMatch = identification.getSpectrumMatch(psmKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle))) != null && spectrumMatch.getBestPeptideAssumption() != null) {
            Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
            peptideKey = peptide.getMatchingKey(this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
        }
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey != ExperimentObject.NO_KEY) {
            long peptideKeyFinal = peptideKey;
            ProteinMatch tempProteinMatch = identification.getProteinIdentification().parallelStream().map(key -> identification.getProteinMatch(key.longValue())).filter(proteinMatch -> Arrays.stream(proteinMatch.getPeptideMatchesKeys()).anyMatch(key -> key == peptideKeyFinal)).findAny().orElse(null);
            if (tempProteinMatch != null) {
                proteinKey = tempProteinMatch.getKey();
                this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
            }
        }
        if (proteinKey != ExperimentObject.NO_KEY) {
            proteinRow = this.getProteinRow(proteinKey);
        }
        if (this.proteinKeys.length == 0) {
            this.clearData();
            return;
        }
        if (proteinRow == -1) {
            this.peptideShakerGUI.resetSelectedItems();
            this.proteinTableMouseReleased(null);
        } else if (this.proteinTable.getSelectedRow() != proteinRow) {
            this.proteinTable.setRowSelectionInterval(proteinRow, proteinRow);
            if (scrollToVisible) {
                this.proteinTable.scrollRectToVisible(this.proteinTable.getCellRect(proteinRow, 0, false));
            }
            this.proteinTableMouseReleased(null);
        }
        int peptideRow = 0;
        if (peptideKey != ExperimentObject.NO_KEY) {
            peptideRow = this.getPeptideRow(peptideKey);
        }
        if (this.peptideTable.getSelectedRow() != peptideRow && peptideRow != -1) {
            this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
            if (scrollToVisible) {
                this.peptideTable.scrollRectToVisible(this.peptideTable.getCellRect(peptideRow, 0, false));
            }
            this.peptideTableMouseReleased(null);
        }
        int psmRow = 0;
        if (spectrumFile != null && spectrumTitle != null) {
            long psmKey2 = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle);
            psmRow = this.getPsmRow(psmKey2);
        }
        if (this.psmTable.getSelectedRow() != psmRow && psmRow != -1 && psmRow < this.psmTable.getRowCount()) {
            this.psmTable.setRowSelectionInterval(psmRow, psmRow);
            if (scrollToVisible) {
                this.psmTable.scrollRectToVisible(this.psmTable.getCellRect(psmRow, 0, false));
            }
            this.psmTableMouseReleased(null);
        }
    }

    private void updateSpectrumSliderToolTip() {
        SearchParameters searchParameters = this.peptideShakerGUI.getIdentificationParameters().getSearchParameters();
        double accuracy = (double)this.accuracySlider.getValue() / 100.0 * searchParameters.getFragmentIonAccuracy();
        this.spectrumJTabbedPane.setToolTipText("<html>Accuracy: " + Util.roundDouble((double)accuracy, (int)2) + " " + searchParameters.getFragmentAccuracyType() + "<br>Level: " + this.intensitySlider.getValue() + "%</html>");
        ToolTipManager.sharedInstance().mouseMoved(new MouseEvent(this.spectrumJTabbedPane, 0, 0L, 0, this.spectrumJTabbedPane.getX() + this.spectrumJTabbedPane.getWidth() - 10, this.spectrumJTabbedPane.getY() + 90, 0, false));
    }

    public void newItemSelection() {
        int index;
        SelfUpdatingTableModel tableModel;
        long proteinKey = ExperimentObject.NO_KEY;
        long peptideKey = ExperimentObject.NO_KEY;
        String spectrumFile = null;
        String spectrumTitle = null;
        if (this.proteinTable.getSelectedRow() != -1) {
            tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            index = tableModel.getViewIndex(this.proteinTable.getSelectedRow());
            proteinKey = this.proteinKeys[index];
        }
        if (this.peptideTable.getSelectedRow() != -1) {
            tableModel = (SelfUpdatingTableModel)this.peptideTable.getModel();
            index = tableModel.getViewIndex(this.peptideTable.getSelectedRow());
            peptideKey = this.peptideKeys[index];
        }
        if (this.psmTable.getSelectedRow() != -1) {
            tableModel = (SelfUpdatingTableModel)this.psmTable.getModel();
            index = tableModel.getViewIndex(this.psmTable.getSelectedRow());
            long psmKey = this.psmKeys[index];
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
            spectrumFile = spectrumMatch.getSpectrumFile();
            spectrumTitle = spectrumMatch.getSpectrumTitle();
        }
        this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
    }

    private int getProteinRow(long proteinKey) {
        int modelIndex = IntStream.range(0, this.proteinKeys.length).filter(i -> this.proteinKeys[i] == proteinKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.proteinTable.getModel()).getRowNumber(modelIndex);
    }

    private int getPeptideRow(long peptideKey) {
        int modelIndex = IntStream.range(0, this.peptideKeys.length).filter(i -> this.peptideKeys[i] == peptideKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.peptideTable.getModel()).getRowNumber(modelIndex);
    }

    private int getPsmRow(long psmKey) {
        int modelIndex = IntStream.range(0, this.psmKeys.length).filter(i -> this.psmKeys[i] == psmKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.psmTable.getModel()).getRowNumber(modelIndex);
    }

    public void clearData() {
        this.displaySpectrum = true;
        this.displayCoverage = true;
        this.displayProteins = true;
        this.displayPeptidesAndPSMs = true;
        this.proteinKeys = new long[0];
        this.peptideKeys = new long[0];
        this.psmKeys = new long[0];
        PsmTableModel psmTableModel = (PsmTableModel)((Object)this.psmTable.getModel());
        psmTableModel.reset();
        PeptideTableModel peptideTableModel = (PeptideTableModel)((Object)this.peptideTable.getModel());
        peptideTableModel.reset();
        ProteinTableModel proteinTableModel = (ProteinTableModel)((Object)this.proteinTable.getModel());
        proteinTableModel.reset();
        psmTableModel.fireTableDataChanged();
        peptideTableModel.fireTableDataChanged();
        proteinTableModel.fireTableDataChanged();
        this.currentProteinSequence = "";
        this.spectrumPanel = null;
        this.sequenceCoverageInnerPanel.removeAll();
        this.sequencePtmsPanel.removeAll();
        this.sequenceVariationsPanel.removeAll();
        this.fragmentIonsJScrollPane.setViewportView(null);
        this.bubbleJPanel.removeAll();
        this.spectrumJPanel.removeAll();
        this.secondarySpectrumPlotsJPanel.removeAll();
        ((TitledBorder)this.proteinsLayeredPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.proteinsLayeredPanel.repaint();
        ((TitledBorder)this.peptidesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptides" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.peptidesPanel.repaint();
        ((TitledBorder)this.psmsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.psmsPanel.repaint();
        ((TitledBorder)this.spectrumMainPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.spectrumMainPanel.repaint();
        ((TitledBorder)this.sequenceCoverageTitledPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Protein Sequence Coverage" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        this.sequenceCoverageTitledPanel.repaint();
    }

    @Override
    public void annotationClicked(ArrayList<ResidueAnnotation> allAnnotation, ChartMouseEvent cme) {
        final Range oldRange = ((CategoryPlot)this.coverageChart.getChart().getPlot()).getRangeAxis().getRange();
        if (allAnnotation.size() == 1 && allAnnotation.get((int)0).clickable) {
            this.peptideShakerGUI.setSelectedItems(this.peptideShakerGUI.getSelectedProteinKey(), allAnnotation.get((int)0).identifier, null, null);
            this.updateSelection(true);
            this.peptideShakerGUI.setSelectedItems(this.peptideShakerGUI.getSelectedProteinKey(), allAnnotation.get((int)0).identifier, null, null);
            this.updatePsmSelection(this.peptideTable.getSelectedRow(), false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)OverviewPanel.this.psmTable.getModel();
                        OverviewPanel.this.updateSpectrum(tableModel.getViewIndex(OverviewPanel.this.psmTable.getSelectedRow()), true);
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((CategoryPlot)OverviewPanel.this.coverageChart.getChart().getPlot()).getRangeAxis().setRange(oldRange);
                        OverviewPanel.this.coverageChart.revalidate();
                        OverviewPanel.this.coverageChart.repaint();
                    }
                    catch (Exception e) {
                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                    }
                }
            });
        } else {
            JPopupMenu peptidesPopupMenu = new JPopupMenu();
            for (ResidueAnnotation currentAnnotation : allAnnotation) {
                if (!currentAnnotation.clickable) continue;
                String text = "<html>" + (peptidesPopupMenu.getComponentCount() + 1) + ": " + currentAnnotation.annotation + "</html>";
                final long peptideKey = currentAnnotation.identifier;
                JMenuItem menuItem = new JMenuItem(text);
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        try {
                            OverviewPanel.this.peptideShakerGUI.setSelectedItems(OverviewPanel.this.peptideShakerGUI.getSelectedProteinKey(), peptideKey, null, null);
                            OverviewPanel.this.updateSelection(true);
                            OverviewPanel.this.peptideShakerGUI.setSelectedItems(OverviewPanel.this.peptideShakerGUI.getSelectedProteinKey(), peptideKey, null, null);
                            OverviewPanel.this.updatePsmSelection(OverviewPanel.this.peptideTable.getSelectedRow(), false);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)OverviewPanel.this.psmTable.getModel();
                                        OverviewPanel.this.updateSpectrum(tableModel.getViewIndex(OverviewPanel.this.psmTable.getSelectedRow()), true);
                                    }
                                    catch (Exception e) {
                                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                                    }
                                }
                            });
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        ((CategoryPlot)OverviewPanel.this.coverageChart.getChart().getPlot()).getRangeAxis().setRange(oldRange);
                                        OverviewPanel.this.coverageChart.revalidate();
                                        OverviewPanel.this.coverageChart.repaint();
                                    }
                                    catch (Exception e) {
                                        OverviewPanel.this.peptideShakerGUI.catchException(e);
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            OverviewPanel.this.peptideShakerGUI.catchException(e);
                        }
                    }
                });
                peptidesPopupMenu.add(menuItem);
            }
            peptidesPopupMenu.show(cme.getTrigger().getComponent(), cme.getTrigger().getX(), cme.getTrigger().getY());
        }
    }

    public void updateSurroundingAminoAcids() {
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        if (spectrumFile != null && spectrumTitle != null) {
            Spectrum currentSpectrum = this.peptideShakerGUI.getSpectrumProvider().getSpectrum(spectrumFile, spectrumTitle);
            this.updateSpectrumPanelBorderTitle(currentSpectrum);
        }
    }

    private void updateProteinTableCellRenderers() {
        if (this.peptideShakerGUI.getIdentification() != null) {
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPeptides().intValue());
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPsms().intValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxSpectrumCounting().doubleValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxMW().doubleValue());
            String scoreColumnName = this.proteinTable.getColumnName(11);
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn(scoreColumnName).getCellRenderer()).setMaxValue(100.0);
        }
    }

    public void selfUpdating(boolean selfUpdating) {
        this.isSelfUpdating = selfUpdating;
        if (this.proteinTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.proteinTable.getModel()).setSelfUpdating(selfUpdating);
        }
        if (this.peptideTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.peptideTable.getModel()).setSelfUpdating(selfUpdating);
        }
        if (this.psmTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.psmTable.getModel()).setSelfUpdating(selfUpdating);
        }
    }

    static /* synthetic */ long[] access$11302(OverviewPanel x0, long[] x1) {
        x0.proteinKeys = x1;
        return x1;
    }

    private static enum TableIndex {
        PROTEIN_TABLE,
        PEPTIDE_TABLE,
        PSM_TABLE;

    }
}

