/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.gui.tabpanels;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.gui.XYPlottingDialog;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.export.graphics.ExportGraphicsDialog;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.genes.GeneDetailsDialog;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsProteinFeature;
import com.compomics.util.io.flat.SimpleFileWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.pdbfinder.FindPdbForUniprotAccessions;
import com.compomics.util.pdbfinder.pdb.PdbBlock;
import com.compomics.util.pdbfinder.pdb.PdbParameter;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.PSExportFactory;
import eu.isas.peptideshaker.gui.PeptideShakerGUI;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferenceDialog;
import eu.isas.peptideshaker.gui.protein_inference.ProteinInferencePeptideLevelDialog;
import eu.isas.peptideshaker.gui.tablemodels.ProteinTableModel;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import no.uib.jsparklines.data.StartIndexes;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.extra.HtmlLinksRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerColorTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntegerIconTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesIntervalChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesMultiIntervalChartTableCellRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolViewer;

public class ProteinStructurePanel
extends JPanel {
    private ArrayList<Long> peptidePdbArray;
    private boolean showModificationLabels = true;
    private boolean spinModel = true;
    private boolean ribbonModel = true;
    private boolean backboneModel = false;
    private String currentlyDisplayedPdbFile;
    private ProgressDialogX progressDialog;
    private FindPdbForUniprotAccessions uniProtPdb;
    private final PeptideShakerGUI peptideShakerGUI;
    private JmolPanel jmolPanel;
    private ArrayList<String> proteinTableToolTips;
    private ArrayList<String> peptideTableToolTips;
    private ArrayList<String> pdbTableToolTips;
    private ArrayList<String> pdbChainsTableToolTips;
    private HashMap<Integer, Long> peptideTableMap = new HashMap();
    private boolean jmolStructureShown = false;
    private PdbBlock[] chains;
    private String chainSequence;
    private long[] proteinKeys = new long[0];
    private JButton backboneJButton;
    private JPanel contextMenuPdbChainsBackgroundPanel;
    private JPanel contextMenuPdbMatchesBackgroundPanel;
    private JPanel contextMenuPdbStructureBackgroundPanel;
    private JPanel contextMenuPeptidesBackgroundPanel;
    private JPanel contextMenuProteinsBackgroundPanel;
    private JButton exportPdbChainsJButton;
    private JButton exportPdbMatchesJButton;
    private JButton exportPdbStructureJButton;
    private JButton exportPeptidesJButton;
    private JButton exportProteinsJButton;
    private JButton labelsJButton;
    private JButton pdbChainHelpJButton;
    private JPanel pdbChainsJPanel;
    private JScrollPane pdbChainsJScrollPane;
    private JTable pdbChainsJTable;
    private JLayeredPane pdbChainsLayeredPane;
    private JPanel pdbChainsPanel;
    private JScrollPane pdbJScrollPane;
    private JLayeredPane pdbLayeredPane;
    private JButton pdbMatchesHelpJButton;
    private JPanel pdbMatchesJPanel;
    private JTable pdbMatchesJTable;
    private JLayeredPane pdbMatchesLayeredPane;
    private JPanel pdbMatchesPanel;
    private JPanel pdbOuterPanel;
    private JPanel pdbPanel;
    private JButton pdbStructureHelpJButton;
    private JPanel pdbStructureJPanel;
    private JLayeredPane pdbStructureLayeredPane;
    private JScrollPane peptideScrollPane;
    private JTable peptideTable;
    private JButton peptidesHelpJButton;
    private JPanel peptidesJPanel;
    private JLayeredPane peptidesLayeredPane;
    private JPanel peptidesPanel;
    private JButton playJButton;
    private JScrollPane proteinScrollPane;
    private JTable proteinTable;
    private JButton proteinsHelpJButton;
    private JPanel proteinsJPanel;
    private JLayeredPane proteinsLayeredPane;
    private JPanel proteinsPanel;
    private JButton ribbonJButton;

    public ProteinStructurePanel(PeptideShakerGUI peptideShakerGUI) {
        this.initComponents();
        this.peptideShakerGUI = peptideShakerGUI;
        this.jmolPanel = new JmolPanel();
        this.pdbPanel.add(this.jmolPanel);
        this.setUpTableHeaderToolTips();
        this.setUpGUI();
    }

    private void setUpGUI() {
        this.proteinScrollPane.getViewport().setOpaque(false);
        this.peptideScrollPane.getViewport().setOpaque(false);
        this.pdbJScrollPane.getViewport().setOpaque(false);
        this.pdbChainsJScrollPane.getViewport().setOpaque(false);
        SelfUpdatingTableModel.addSortListener((JTable)this.proteinTable, (ProgressDialogX)new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true));
        this.proteinTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProteinStructurePanel.this.proteinTableMouseClicked(e);
            }
        });
        SelfUpdatingTableModel.addScrollListeners((JTable)this.proteinTable, (JScrollPane)this.proteinScrollPane, (JScrollBar)this.proteinScrollPane.getVerticalScrollBar());
        this.peptideTable.setAutoCreateRowSorter(true);
        this.setTableProperties();
    }

    private void setUpTableHeaderToolTips() {
        this.proteinTableToolTips = new ArrayList(13);
        this.proteinTableToolTips.add(null);
        this.proteinTableToolTips.add("Starred");
        this.proteinTableToolTips.add("Protein Inference Class");
        this.proteinTableToolTips.add("Protein Accession Number");
        this.proteinTableToolTips.add("Protein Description");
        this.proteinTableToolTips.add("Chromosome Number");
        this.proteinTableToolTips.add("Protein Sequence Coverage (%) (Confident / Doubtful / Not Validated / Possible)");
        this.proteinTableToolTips.add("Number of Peptides (Validated / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("Number of Spectra (Validated / Doubtful / Not Validated)");
        this.proteinTableToolTips.add("MS2 Quantification");
        this.proteinTableToolTips.add("Protein Molecular Weight (kDa)");
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.add("Protein Score");
        } else {
            this.proteinTableToolTips.add("Protein Confidence");
        }
        this.proteinTableToolTips.add("Validated");
        this.peptideTableToolTips = new ArrayList(7);
        this.peptideTableToolTips.add(null);
        this.peptideTableToolTips.add("Starred");
        this.peptideTableToolTips.add("Protein Inference");
        this.peptideTableToolTips.add("Peptide Sequence");
        this.peptideTableToolTips.add("Peptide Start Index");
        this.peptideTableToolTips.add("In PDB Sequence");
        this.peptideTableToolTips.add("Validated");
        this.pdbTableToolTips = new ArrayList(5);
        this.pdbTableToolTips.add(null);
        this.pdbTableToolTips.add("PDB Accession Number");
        this.pdbTableToolTips.add("PDB Title");
        this.pdbTableToolTips.add("Type of Structure");
        this.pdbTableToolTips.add("Number of Chains");
        this.pdbChainsTableToolTips = new ArrayList(4);
        this.pdbChainsTableToolTips.add(null);
        this.pdbChainsTableToolTips.add("Chain Label");
        this.pdbChainsTableToolTips.add("Protein-PDB Alignment");
        this.pdbChainsTableToolTips.add("Protein Coverage for PDB Sequence");
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.proteinTable.getTableHeader().getBackground());
        this.proteinScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        JPanel peptideCorner = new JPanel();
        peptideCorner.setBackground(this.peptideTable.getTableHeader().getBackground());
        this.peptideScrollPane.setCorner("UPPER_RIGHT_CORNER", peptideCorner);
        JPanel pdbMatchesCorner = new JPanel();
        pdbMatchesCorner.setBackground(this.pdbMatchesJTable.getTableHeader().getBackground());
        this.pdbJScrollPane.setCorner("UPPER_RIGHT_CORNER", pdbMatchesCorner);
        JPanel pdbChainsCorner = new JPanel();
        pdbChainsCorner.setBackground(this.pdbChainsJTable.getTableHeader().getBackground());
        this.pdbChainsJScrollPane.setCorner("UPPER_RIGHT_CORNER", pdbChainsCorner);
    }

    private void setTableProperties() {
        this.setProteinTableProperties();
        this.setPeptideTableProperties();
        this.setPdbTablesProperties();
    }

    private void setProteinTableProperties() {
        Integer maxProteinKeyLength = null;
        if (this.peptideShakerGUI.getMetrics() != null) {
            maxProteinKeyLength = this.peptideShakerGUI.getMetrics().getMaxProteinAccessionLength();
        }
        ProteinTableModel.setProteinTableProperties(this.proteinTable, this.peptideShakerGUI.getSparklineColor(), this.peptideShakerGUI.getSparklineColorNonValidated(), this.peptideShakerGUI.getSparklineColorNotFound(), this.peptideShakerGUI.getUtilitiesUserParameters().getSparklineColorDoubtful(), this.peptideShakerGUI.getScoreAndConfidenceDecimalFormat(), this.getClass(), maxProteinKeyLength);
        this.proteinTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProteinStructurePanel.this.reselect();
                    }
                });
            }
        });
    }

    private void setPeptideTableProperties() {
        this.peptideTable.getColumn(" ").setMaxWidth(50);
        this.peptideTable.getColumn(" ").setMinWidth(50);
        this.peptideTable.getColumn("PDB").setMinWidth(50);
        this.peptideTable.getColumn("PDB").setMaxWidth(50);
        this.peptideTable.getColumn("Start").setMinWidth(50);
        this.peptideTable.getColumn("").setMaxWidth(30);
        this.peptideTable.getColumn("").setMinWidth(30);
        this.peptideTable.getColumn("  ").setMaxWidth(30);
        this.peptideTable.getColumn("  ").setMinWidth(30);
        this.peptideTable.getColumn("PI").setMaxWidth(37);
        this.peptideTable.getColumn("PI").setMinWidth(37);
        this.peptideTable.getTableHeader().setReorderingAllowed(false);
        HashMap<Integer, Color> peptideInferenceColorMap = new HashMap<Integer, Color>();
        peptideInferenceColorMap.put(0, this.peptideShakerGUI.getSparklineColor());
        peptideInferenceColorMap.put(1, Color.YELLOW);
        peptideInferenceColorMap.put(2, Color.ORANGE);
        peptideInferenceColorMap.put(3, Color.RED);
        HashMap<Integer, String> peptideInferenceTooltipMap = new HashMap<Integer, String>();
        peptideInferenceTooltipMap.put(0, "Unique to a single protein");
        peptideInferenceTooltipMap.put(1, "Belongs to a group of related proteins");
        peptideInferenceTooltipMap.put(2, "Belongs to a group of related and unrelated proteins");
        peptideInferenceTooltipMap.put(3, "Belongs to unrelated proteins");
        this.peptideTable.getColumn("PI").setCellRenderer((TableCellRenderer)new JSparklinesIntegerColorTableCellRenderer(this.peptideShakerGUI.getSparklineColor(), peptideInferenceColorMap, peptideInferenceTooltipMap));
        this.peptideTable.getColumn("Start").setCellRenderer((TableCellRenderer)new JSparklinesMultiIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        this.peptideTable.getColumn("PDB").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/pdb.png")), null, "Mapped to PDB Structure", null));
        this.peptideTable.getColumn("").setCellRenderer((TableCellRenderer)new JSparklinesIntegerIconTableCellRenderer(MatchValidationLevel.getIconMap(this.getClass()), MatchValidationLevel.getTooltipMap()));
        this.peptideTable.getColumn("  ").setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/star_yellow.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), new ImageIcon(this.getClass().getResource("/icons/star_grey.png")), "Starred", null, null));
    }

    private void setPdbTablesProperties() {
        this.pdbMatchesJTable.getColumn(" ").setMaxWidth(50);
        this.pdbChainsJTable.getColumn(" ").setMaxWidth(50);
        this.pdbMatchesJTable.getColumn("PDB").setMaxWidth(50);
        this.pdbChainsJTable.getColumn("Chain").setMaxWidth(50);
        this.pdbMatchesJTable.getColumn(" ").setMinWidth(50);
        this.pdbChainsJTable.getColumn(" ").setMinWidth(50);
        this.pdbMatchesJTable.getColumn("PDB").setMinWidth(50);
        this.pdbChainsJTable.getColumn("Chain").setMinWidth(50);
        this.pdbMatchesJTable.getColumn("Chains").setMinWidth(100);
        this.pdbMatchesJTable.getColumn("Chains").setMaxWidth(100);
        this.pdbMatchesJTable.getTableHeader().setReorderingAllowed(false);
        this.pdbChainsJTable.getTableHeader().setReorderingAllowed(false);
        this.pdbChainsJTable.setAutoCreateRowSorter(true);
        this.pdbMatchesJTable.setAutoCreateRowSorter(true);
        this.pdbMatchesJTable.getColumn("PDB").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(TableProperties.getSelectedRowHtmlTagFontColor(), TableProperties.getNotSelectedRowHtmlTagFontColor()));
        this.pdbMatchesJTable.getColumn("Chains").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.pdbMatchesJTable.getColumn("Chains").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.pdbChainsJTable.getColumn("Coverage").setCellRenderer((TableCellRenderer)new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesBarChartTableCellRenderer)this.pdbChainsJTable.getColumn("Coverage").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth());
        this.pdbChainsJTable.getColumn("PDB-Protein").setCellRenderer((TableCellRenderer)new JSparklinesIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(100.0), Double.valueOf(10.0), this.peptideShakerGUI.getSparklineColor()));
        ((JSparklinesIntervalChartTableCellRenderer)this.pdbChainsJTable.getColumn("PDB-Protein").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
    }

    private void initComponents() {
        this.pdbStructureJPanel = new JPanel();
        this.pdbStructureLayeredPane = new JLayeredPane();
        this.pdbOuterPanel = new JPanel();
        this.pdbLayeredPane = new JLayeredPane();
        this.pdbPanel = new JPanel();
        this.labelsJButton = new JButton();
        this.ribbonJButton = new JButton();
        this.backboneJButton = new JButton();
        this.playJButton = new JButton();
        this.pdbStructureHelpJButton = new JButton();
        this.exportPdbStructureJButton = new JButton();
        this.contextMenuPdbStructureBackgroundPanel = new JPanel();
        this.proteinsJPanel = new JPanel();
        this.proteinsLayeredPane = new JLayeredPane();
        this.proteinsPanel = new JPanel();
        this.proteinScrollPane = new JScrollPane();
        this.proteinTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinStructurePanel.this.proteinTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.proteinsHelpJButton = new JButton();
        this.exportProteinsJButton = new JButton();
        this.contextMenuProteinsBackgroundPanel = new JPanel();
        this.peptidesJPanel = new JPanel();
        this.peptidesLayeredPane = new JLayeredPane();
        this.peptidesPanel = new JPanel();
        this.peptideScrollPane = new JScrollPane();
        this.peptideTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinStructurePanel.this.peptideTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.peptidesHelpJButton = new JButton();
        this.exportPeptidesJButton = new JButton();
        this.contextMenuPeptidesBackgroundPanel = new JPanel();
        this.pdbMatchesJPanel = new JPanel();
        this.pdbMatchesLayeredPane = new JLayeredPane();
        this.pdbMatchesPanel = new JPanel();
        this.pdbJScrollPane = new JScrollPane();
        this.pdbMatchesJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinStructurePanel.this.pdbTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.pdbMatchesHelpJButton = new JButton();
        this.exportPdbMatchesJButton = new JButton();
        this.contextMenuPdbMatchesBackgroundPanel = new JPanel();
        this.pdbChainsJPanel = new JPanel();
        this.pdbChainsLayeredPane = new JLayeredPane();
        this.pdbChainsPanel = new JPanel();
        this.pdbChainsJScrollPane = new JScrollPane();
        this.pdbChainsJTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ProteinStructurePanel.this.pdbChainsTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.pdbChainHelpJButton = new JButton();
        this.exportPdbChainsJButton = new JButton();
        this.contextMenuPdbChainsBackgroundPanel = new JPanel();
        this.setBackground(new Color(255, 255, 255));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ProteinStructurePanel.this.formComponentResized(evt);
            }
        });
        this.pdbStructureJPanel.setOpaque(false);
        this.pdbOuterPanel.setBorder(BorderFactory.createTitledBorder(null, "PDB Structure", 0, 0, new Font("sansserif", 1, 14)));
        this.pdbOuterPanel.setOpaque(false);
        this.pdbLayeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ProteinStructurePanel.this.pdbLayeredPaneComponentResized(evt);
            }
        });
        this.pdbPanel.setLayout(new BoxLayout(this.pdbPanel, 2));
        this.pdbLayeredPane.add(this.pdbPanel);
        this.pdbPanel.setBounds(0, 0, 435, 440);
        this.labelsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/labels_selected.png")));
        this.labelsJButton.setToolTipText("Hide Modification Labels");
        this.labelsJButton.setBorder(null);
        this.labelsJButton.setBorderPainted(false);
        this.labelsJButton.setContentAreaFilled(false);
        this.labelsJButton.setFocusable(false);
        this.labelsJButton.setHorizontalTextPosition(0);
        this.labelsJButton.setVerticalTextPosition(3);
        this.labelsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.labelsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.labelsJButtonMouseExited(evt);
            }
        });
        this.labelsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.labelsJButtonActionPerformed(evt);
            }
        });
        this.pdbLayeredPane.setLayer(this.labelsJButton, JLayeredPane.POPUP_LAYER);
        this.pdbLayeredPane.add(this.labelsJButton);
        this.labelsJButton.setBounds(0, 0, 24, 25);
        this.ribbonJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ribbon_selected.png")));
        this.ribbonJButton.setToolTipText("Ribbon Model");
        this.ribbonJButton.setBorder(null);
        this.ribbonJButton.setBorderPainted(false);
        this.ribbonJButton.setContentAreaFilled(false);
        this.ribbonJButton.setFocusable(false);
        this.ribbonJButton.setHorizontalTextPosition(0);
        this.ribbonJButton.setVerticalTextPosition(3);
        this.ribbonJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.ribbonJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.ribbonJButtonMouseExited(evt);
            }
        });
        this.ribbonJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.ribbonJButtonActionPerformed(evt);
            }
        });
        this.pdbLayeredPane.setLayer(this.ribbonJButton, JLayeredPane.POPUP_LAYER);
        this.pdbLayeredPane.add(this.ribbonJButton);
        this.ribbonJButton.setBounds(0, 0, 25, 25);
        this.backboneJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/backbone.png")));
        this.backboneJButton.setToolTipText("Backbone Model");
        this.backboneJButton.setBorder(null);
        this.backboneJButton.setBorderPainted(false);
        this.backboneJButton.setContentAreaFilled(false);
        this.backboneJButton.setFocusable(false);
        this.backboneJButton.setHorizontalTextPosition(0);
        this.backboneJButton.setVerticalTextPosition(3);
        this.backboneJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.backboneJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.backboneJButtonMouseExited(evt);
            }
        });
        this.backboneJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.backboneJButtonActionPerformed(evt);
            }
        });
        this.pdbLayeredPane.setLayer(this.backboneJButton, JLayeredPane.POPUP_LAYER);
        this.pdbLayeredPane.add(this.backboneJButton);
        this.backboneJButton.setBounds(0, 0, 25, 25);
        this.playJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/pause.png")));
        this.playJButton.setToolTipText("Stop Rotation");
        this.playJButton.setBorder(null);
        this.playJButton.setBorderPainted(false);
        this.playJButton.setContentAreaFilled(false);
        this.playJButton.setFocusable(false);
        this.playJButton.setHorizontalTextPosition(0);
        this.playJButton.setVerticalTextPosition(3);
        this.playJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.playJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.playJButtonMouseExited(evt);
            }
        });
        this.playJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.playJButtonActionPerformed(evt);
            }
        });
        this.pdbLayeredPane.setLayer(this.playJButton, JLayeredPane.POPUP_LAYER);
        this.pdbLayeredPane.add(this.playJButton);
        this.playJButton.setBounds(0, 0, 21, 21);
        GroupLayout pdbOuterPanelLayout = new GroupLayout(this.pdbOuterPanel);
        this.pdbOuterPanel.setLayout(pdbOuterPanelLayout);
        pdbOuterPanelLayout.setHorizontalGroup(pdbOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 448, Short.MAX_VALUE).addGroup(pdbOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbOuterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pdbLayeredPane, -1, 428, Short.MAX_VALUE).addContainerGap())));
        pdbOuterPanelLayout.setVerticalGroup(pdbOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 445, Short.MAX_VALUE).addGroup(pdbOuterPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pdbOuterPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pdbLayeredPane, -1, 433, Short.MAX_VALUE).addContainerGap())));
        this.pdbStructureLayeredPane.add(this.pdbOuterPanel);
        this.pdbOuterPanel.setBounds(0, 0, 460, 490);
        this.pdbStructureHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.pdbStructureHelpJButton.setToolTipText("Help");
        this.pdbStructureHelpJButton.setBorder(null);
        this.pdbStructureHelpJButton.setBorderPainted(false);
        this.pdbStructureHelpJButton.setContentAreaFilled(false);
        this.pdbStructureHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.pdbStructureHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.pdbStructureHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.pdbStructureHelpJButtonMouseExited(evt);
            }
        });
        this.pdbStructureHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.pdbStructureHelpJButtonActionPerformed(evt);
            }
        });
        this.pdbStructureLayeredPane.setLayer(this.pdbStructureHelpJButton, JLayeredPane.POPUP_LAYER);
        this.pdbStructureLayeredPane.add(this.pdbStructureHelpJButton);
        this.pdbStructureHelpJButton.setBounds(440, 0, 10, 19);
        this.exportPdbStructureJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbStructureJButton.setToolTipText("Export");
        this.exportPdbStructureJButton.setBorder(null);
        this.exportPdbStructureJButton.setBorderPainted(false);
        this.exportPdbStructureJButton.setContentAreaFilled(false);
        this.exportPdbStructureJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbStructureJButton.setEnabled(false);
        this.exportPdbStructureJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPdbStructureJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbStructureJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbStructureJButtonMouseExited(evt);
            }
        });
        this.exportPdbStructureJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.exportPdbStructureJButtonActionPerformed(evt);
            }
        });
        this.pdbStructureLayeredPane.setLayer(this.exportPdbStructureJButton, JLayeredPane.POPUP_LAYER);
        this.pdbStructureLayeredPane.add(this.exportPdbStructureJButton);
        this.exportPdbStructureJButton.setBounds(430, 0, 10, 19);
        this.contextMenuPdbStructureBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPdbStructureBackgroundPanelLayout = new GroupLayout(this.contextMenuPdbStructureBackgroundPanel);
        this.contextMenuPdbStructureBackgroundPanel.setLayout(contextMenuPdbStructureBackgroundPanelLayout);
        contextMenuPdbStructureBackgroundPanelLayout.setHorizontalGroup(contextMenuPdbStructureBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPdbStructureBackgroundPanelLayout.setVerticalGroup(contextMenuPdbStructureBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.pdbStructureLayeredPane.setLayer(this.contextMenuPdbStructureBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.pdbStructureLayeredPane.add(this.contextMenuPdbStructureBackgroundPanel);
        this.contextMenuPdbStructureBackgroundPanel.setBounds(420, 0, 30, 19);
        GroupLayout pdbStructureJPanelLayout = new GroupLayout(this.pdbStructureJPanel);
        this.pdbStructureJPanel.setLayout(pdbStructureJPanelLayout);
        pdbStructureJPanelLayout.setHorizontalGroup(pdbStructureJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbStructureLayeredPane, -1, 466, Short.MAX_VALUE));
        pdbStructureJPanelLayout.setVerticalGroup(pdbStructureJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbStructureLayeredPane, -1, 486, Short.MAX_VALUE));
        this.proteinsJPanel.setOpaque(false);
        this.proteinsPanel.setBorder(BorderFactory.createTitledBorder(null, "Proteins", 0, 0, new Font("sansserif", 1, 14)));
        this.proteinsPanel.setOpaque(false);
        this.proteinTable.setModel((TableModel)((Object)new ProteinTableModel()));
        this.proteinTable.setOpaque(false);
        this.proteinTable.setSelectionMode(0);
        this.proteinTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinStructurePanel.this.proteinTableMouseMoved(evt);
            }
        });
        this.proteinTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ProteinStructurePanel.this.proteinTableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.proteinTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinStructurePanel.this.proteinTableMouseReleased(evt);
            }
        });
        this.proteinTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProteinStructurePanel.this.proteinTableKeyReleased(evt);
            }
        });
        this.proteinScrollPane.setViewportView(this.proteinTable);
        GroupLayout proteinsPanelLayout = new GroupLayout(this.proteinsPanel);
        this.proteinsPanel.setLayout(proteinsPanelLayout);
        proteinsPanelLayout.setHorizontalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 938, Short.MAX_VALUE).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 918, Short.MAX_VALUE).addContainerGap())));
        proteinsPanelLayout.setVerticalGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 225, Short.MAX_VALUE).addGroup(proteinsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(proteinsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.proteinScrollPane, -1, 213, Short.MAX_VALUE).addContainerGap())));
        this.proteinsLayeredPane.add(this.proteinsPanel);
        this.proteinsPanel.setBounds(0, 0, 950, 270);
        this.proteinsHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.proteinsHelpJButton.setToolTipText("Help");
        this.proteinsHelpJButton.setBorder(null);
        this.proteinsHelpJButton.setBorderPainted(false);
        this.proteinsHelpJButton.setContentAreaFilled(false);
        this.proteinsHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.proteinsHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.proteinsHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.proteinsHelpJButtonMouseExited(evt);
            }
        });
        this.proteinsHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.proteinsHelpJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.proteinsHelpJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.proteinsHelpJButton);
        this.proteinsHelpJButton.setBounds(930, 0, 10, 19);
        this.exportProteinsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setToolTipText("Copy to File");
        this.exportProteinsJButton.setBorder(null);
        this.exportProteinsJButton.setBorderPainted(false);
        this.exportProteinsJButton.setContentAreaFilled(false);
        this.exportProteinsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportProteinsJButton.setEnabled(false);
        this.exportProteinsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportProteinsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.exportProteinsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.exportProteinsJButtonMouseExited(evt);
            }
        });
        this.exportProteinsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.exportProteinsJButtonActionPerformed(evt);
            }
        });
        this.proteinsLayeredPane.setLayer(this.exportProteinsJButton, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.exportProteinsJButton);
        this.exportProteinsJButton.setBounds(920, 0, 10, 19);
        this.contextMenuProteinsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuProteinsBackgroundPanelLayout = new GroupLayout(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setLayout(contextMenuProteinsBackgroundPanelLayout);
        contextMenuProteinsBackgroundPanelLayout.setHorizontalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuProteinsBackgroundPanelLayout.setVerticalGroup(contextMenuProteinsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.proteinsLayeredPane.setLayer(this.contextMenuProteinsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.proteinsLayeredPane.add(this.contextMenuProteinsBackgroundPanel);
        this.contextMenuProteinsBackgroundPanel.setBounds(920, 0, 30, 19);
        GroupLayout proteinsJPanelLayout = new GroupLayout(this.proteinsJPanel);
        this.proteinsJPanel.setLayout(proteinsJPanelLayout);
        proteinsJPanelLayout.setHorizontalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 957, Short.MAX_VALUE));
        proteinsJPanelLayout.setVerticalGroup(proteinsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.proteinsLayeredPane, -1, 273, Short.MAX_VALUE));
        this.peptidesJPanel.setOpaque(false);
        this.peptidesPanel.setBorder(BorderFactory.createTitledBorder(null, "Peptides", 0, 0, new Font("sansserif", 1, 14)));
        this.peptidesPanel.setOpaque(false);
        this.peptideTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "  ", "PI", "Sequence", "Start", "PDB", ""}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, Boolean.class, Integer.class, String.class, Integer.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[]{false, true, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.peptideTable.setOpaque(false);
        this.peptideTable.setSelectionMode(0);
        this.peptideTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinStructurePanel.this.peptideTableMouseMoved(evt);
            }
        });
        this.peptideTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.peptideTableMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinStructurePanel.this.peptideTableMouseReleased(evt);
            }
        });
        this.peptideTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProteinStructurePanel.this.peptideTableKeyReleased(evt);
            }
        });
        this.peptideScrollPane.setViewportView(this.peptideTable);
        GroupLayout peptidesPanelLayout = new GroupLayout(this.peptidesPanel);
        this.peptidesPanel.setLayout(peptidesPanelLayout);
        peptidesPanelLayout.setHorizontalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE).addGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane, -1, 448, Short.MAX_VALUE).addContainerGap())));
        peptidesPanelLayout.setVerticalGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 115, Short.MAX_VALUE).addGroup(peptidesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptidesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideScrollPane, -1, 103, Short.MAX_VALUE).addContainerGap())));
        this.peptidesLayeredPane.add(this.peptidesPanel);
        this.peptidesPanel.setBounds(0, 0, 480, 160);
        this.peptidesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.peptidesHelpJButton.setToolTipText("Help");
        this.peptidesHelpJButton.setBorder(null);
        this.peptidesHelpJButton.setBorderPainted(false);
        this.peptidesHelpJButton.setContentAreaFilled(false);
        this.peptidesHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.peptidesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.peptidesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.peptidesHelpJButtonMouseExited(evt);
            }
        });
        this.peptidesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.peptidesHelpJButtonActionPerformed(evt);
            }
        });
        this.peptidesLayeredPane.setLayer(this.peptidesHelpJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.peptidesHelpJButton);
        this.peptidesHelpJButton.setBounds(460, 0, 10, 19);
        this.exportPeptidesJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setToolTipText("Copy to File");
        this.exportPeptidesJButton.setBorder(null);
        this.exportPeptidesJButton.setBorderPainted(false);
        this.exportPeptidesJButton.setContentAreaFilled(false);
        this.exportPeptidesJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPeptidesJButton.setEnabled(false);
        this.exportPeptidesJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPeptidesJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.exportPeptidesJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.exportPeptidesJButtonMouseExited(evt);
            }
        });
        this.exportPeptidesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.exportPeptidesJButtonActionPerformed(evt);
            }
        });
        this.peptidesLayeredPane.setLayer(this.exportPeptidesJButton, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.exportPeptidesJButton);
        this.exportPeptidesJButton.setBounds(450, 0, 10, 19);
        this.contextMenuPeptidesBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPeptidesBackgroundPanelLayout = new GroupLayout(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setLayout(contextMenuPeptidesBackgroundPanelLayout);
        contextMenuPeptidesBackgroundPanelLayout.setHorizontalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPeptidesBackgroundPanelLayout.setVerticalGroup(contextMenuPeptidesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.peptidesLayeredPane.setLayer(this.contextMenuPeptidesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.peptidesLayeredPane.add(this.contextMenuPeptidesBackgroundPanel);
        this.contextMenuPeptidesBackgroundPanel.setBounds(440, 0, 30, 19);
        GroupLayout peptidesJPanelLayout = new GroupLayout(this.peptidesJPanel);
        this.peptidesJPanel.setLayout(peptidesJPanelLayout);
        peptidesJPanelLayout.setHorizontalGroup(peptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidesLayeredPane, -1, 485, Short.MAX_VALUE));
        peptidesJPanelLayout.setVerticalGroup(peptidesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptidesLayeredPane, -1, 158, Short.MAX_VALUE));
        this.pdbMatchesJPanel.setOpaque(false);
        this.pdbMatchesPanel.setBorder(BorderFactory.createTitledBorder(null, "PDB Matches", 0, 0, new Font("sansserif", 1, 14)));
        this.pdbMatchesPanel.setOpaque(false);
        this.pdbMatchesJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "PDB", "Title", "Type", "Chains"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.pdbMatchesJTable.setOpaque(false);
        this.pdbMatchesJTable.setSelectionMode(0);
        this.pdbMatchesJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinStructurePanel.this.pdbMatchesJTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.pdbMatchesJTableMouseExited(evt);
            }
        });
        this.pdbMatchesJTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ProteinStructurePanel.this.pdbMatchesJTableMouseMoved(evt);
            }
        });
        this.pdbMatchesJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProteinStructurePanel.this.pdbMatchesJTableKeyReleased(evt);
            }
        });
        this.pdbJScrollPane.setViewportView(this.pdbMatchesJTable);
        GroupLayout pdbMatchesPanelLayout = new GroupLayout(this.pdbMatchesPanel);
        this.pdbMatchesPanel.setLayout(pdbMatchesPanelLayout);
        pdbMatchesPanelLayout.setHorizontalGroup(pdbMatchesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE).addGroup(pdbMatchesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbMatchesPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.pdbJScrollPane).addGap(8, 8, 8))));
        pdbMatchesPanelLayout.setVerticalGroup(pdbMatchesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 105, Short.MAX_VALUE).addGroup(pdbMatchesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbMatchesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pdbJScrollPane, -1, 93, Short.MAX_VALUE).addContainerGap())));
        this.pdbMatchesLayeredPane.add(this.pdbMatchesPanel);
        this.pdbMatchesPanel.setBounds(0, 0, 480, 150);
        this.pdbMatchesHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.pdbMatchesHelpJButton.setToolTipText("Help");
        this.pdbMatchesHelpJButton.setBorder(null);
        this.pdbMatchesHelpJButton.setBorderPainted(false);
        this.pdbMatchesHelpJButton.setContentAreaFilled(false);
        this.pdbMatchesHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.pdbMatchesHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.pdbMatchesHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.pdbMatchesHelpJButtonMouseExited(evt);
            }
        });
        this.pdbMatchesHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.pdbMatchesHelpJButtonActionPerformed(evt);
            }
        });
        this.pdbMatchesLayeredPane.setLayer(this.pdbMatchesHelpJButton, JLayeredPane.POPUP_LAYER);
        this.pdbMatchesLayeredPane.add(this.pdbMatchesHelpJButton);
        this.pdbMatchesHelpJButton.setBounds(460, 0, 10, 19);
        this.exportPdbMatchesJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbMatchesJButton.setToolTipText("Copy to File");
        this.exportPdbMatchesJButton.setBorder(null);
        this.exportPdbMatchesJButton.setBorderPainted(false);
        this.exportPdbMatchesJButton.setContentAreaFilled(false);
        this.exportPdbMatchesJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbMatchesJButton.setEnabled(false);
        this.exportPdbMatchesJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPdbMatchesJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbMatchesJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbMatchesJButtonMouseExited(evt);
            }
        });
        this.exportPdbMatchesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.exportPdbMatchesJButtonActionPerformed(evt);
            }
        });
        this.pdbMatchesLayeredPane.setLayer(this.exportPdbMatchesJButton, JLayeredPane.POPUP_LAYER);
        this.pdbMatchesLayeredPane.add(this.exportPdbMatchesJButton);
        this.exportPdbMatchesJButton.setBounds(450, 0, 10, 19);
        this.contextMenuPdbMatchesBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPdbMatchesBackgroundPanelLayout = new GroupLayout(this.contextMenuPdbMatchesBackgroundPanel);
        this.contextMenuPdbMatchesBackgroundPanel.setLayout(contextMenuPdbMatchesBackgroundPanelLayout);
        contextMenuPdbMatchesBackgroundPanelLayout.setHorizontalGroup(contextMenuPdbMatchesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPdbMatchesBackgroundPanelLayout.setVerticalGroup(contextMenuPdbMatchesBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.pdbMatchesLayeredPane.setLayer(this.contextMenuPdbMatchesBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.pdbMatchesLayeredPane.add(this.contextMenuPdbMatchesBackgroundPanel);
        this.contextMenuPdbMatchesBackgroundPanel.setBounds(440, 0, 30, 19);
        GroupLayout pdbMatchesJPanelLayout = new GroupLayout(this.pdbMatchesJPanel);
        this.pdbMatchesJPanel.setLayout(pdbMatchesJPanelLayout);
        pdbMatchesJPanelLayout.setHorizontalGroup(pdbMatchesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbMatchesLayeredPane, -1, 485, Short.MAX_VALUE));
        pdbMatchesJPanelLayout.setVerticalGroup(pdbMatchesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbMatchesLayeredPane, -1, 158, Short.MAX_VALUE));
        this.pdbChainsJPanel.setOpaque(false);
        this.pdbChainsPanel.setBorder(BorderFactory.createTitledBorder(null, "PDB Chains", 0, 0, new Font("sansserif", 1, 14)));
        this.pdbChainsPanel.setOpaque(false);
        this.pdbChainsJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{" ", "Chain", "PDB-Protein", "Coverage"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Integer.class, String.class, Object.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.pdbChainsJTable.setOpaque(false);
        this.pdbChainsJTable.setSelectionMode(0);
        this.pdbChainsJTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ProteinStructurePanel.this.pdbChainsJTableMouseReleased(evt);
            }
        });
        this.pdbChainsJTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ProteinStructurePanel.this.pdbChainsJTableKeyReleased(evt);
            }
        });
        this.pdbChainsJScrollPane.setViewportView(this.pdbChainsJTable);
        GroupLayout pdbChainsPanelLayout = new GroupLayout(this.pdbChainsPanel);
        this.pdbChainsPanel.setLayout(pdbChainsPanelLayout);
        pdbChainsPanelLayout.setHorizontalGroup(pdbChainsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 468, Short.MAX_VALUE).addGroup(pdbChainsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbChainsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pdbChainsJScrollPane, -1, 448, Short.MAX_VALUE).addContainerGap())));
        pdbChainsPanelLayout.setVerticalGroup(pdbChainsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 115, Short.MAX_VALUE).addGroup(pdbChainsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pdbChainsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.pdbChainsJScrollPane, -1, 103, Short.MAX_VALUE).addContainerGap())));
        this.pdbChainsLayeredPane.add(this.pdbChainsPanel);
        this.pdbChainsPanel.setBounds(0, 0, 480, 160);
        this.pdbChainHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame_grey.png")));
        this.pdbChainHelpJButton.setToolTipText("Help");
        this.pdbChainHelpJButton.setBorder(null);
        this.pdbChainHelpJButton.setBorderPainted(false);
        this.pdbChainHelpJButton.setContentAreaFilled(false);
        this.pdbChainHelpJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/help_no_frame.png")));
        this.pdbChainHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.pdbChainHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.pdbChainHelpJButtonMouseExited(evt);
            }
        });
        this.pdbChainHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.pdbChainHelpJButtonActionPerformed(evt);
            }
        });
        this.pdbChainsLayeredPane.setLayer(this.pdbChainHelpJButton, JLayeredPane.POPUP_LAYER);
        this.pdbChainsLayeredPane.add(this.pdbChainHelpJButton);
        this.pdbChainHelpJButton.setBounds(460, 0, 10, 19);
        this.exportPdbChainsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbChainsJButton.setToolTipText("Copy to File");
        this.exportPdbChainsJButton.setBorder(null);
        this.exportPdbChainsJButton.setBorderPainted(false);
        this.exportPdbChainsJButton.setContentAreaFilled(false);
        this.exportPdbChainsJButton.setDisabledIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame_grey.png")));
        this.exportPdbChainsJButton.setEnabled(false);
        this.exportPdbChainsJButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/export_no_frame.png")));
        this.exportPdbChainsJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbChainsJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ProteinStructurePanel.this.exportPdbChainsJButtonMouseExited(evt);
            }
        });
        this.exportPdbChainsJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProteinStructurePanel.this.exportPdbChainsJButtonActionPerformed(evt);
            }
        });
        this.pdbChainsLayeredPane.setLayer(this.exportPdbChainsJButton, JLayeredPane.POPUP_LAYER);
        this.pdbChainsLayeredPane.add(this.exportPdbChainsJButton);
        this.exportPdbChainsJButton.setBounds(450, 0, 10, 19);
        this.contextMenuPdbChainsBackgroundPanel.setBackground(new Color(255, 255, 255));
        GroupLayout contextMenuPdbChainsBackgroundPanelLayout = new GroupLayout(this.contextMenuPdbChainsBackgroundPanel);
        this.contextMenuPdbChainsBackgroundPanel.setLayout(contextMenuPdbChainsBackgroundPanelLayout);
        contextMenuPdbChainsBackgroundPanelLayout.setHorizontalGroup(contextMenuPdbChainsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE));
        contextMenuPdbChainsBackgroundPanelLayout.setVerticalGroup(contextMenuPdbChainsBackgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 19, Short.MAX_VALUE));
        this.pdbChainsLayeredPane.setLayer(this.contextMenuPdbChainsBackgroundPanel, JLayeredPane.POPUP_LAYER);
        this.pdbChainsLayeredPane.add(this.contextMenuPdbChainsBackgroundPanel);
        this.contextMenuPdbChainsBackgroundPanel.setBounds(440, 0, 30, 19);
        GroupLayout pdbChainsJPanelLayout = new GroupLayout(this.pdbChainsJPanel);
        this.pdbChainsJPanel.setLayout(pdbChainsJPanelLayout);
        pdbChainsJPanelLayout.setHorizontalGroup(pdbChainsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbChainsLayeredPane, -1, 485, Short.MAX_VALUE));
        pdbChainsJPanelLayout.setVerticalGroup(pdbChainsJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbChainsLayeredPane, -1, 158, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pdbMatchesJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.pdbChainsJPanel, -1, -1, Short.MAX_VALUE).addComponent(this.peptidesJPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pdbStructureJPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.proteinsJPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.proteinsJPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pdbMatchesJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pdbChainsJPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptidesJPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.pdbStructureJPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pdbStructureJPanel.getAccessibleContext().setAccessibleName("Protein Details");
    }

    private void proteinTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinTableMouseMoved(MouseEvent evt) {
        int row = this.proteinTable.rowAtPoint(evt.getPoint());
        int column = this.proteinTable.columnAtPoint(evt.getPoint());
        this.proteinTable.setToolTipText(null);
        if (column == this.proteinTable.getColumn("Accession").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.proteinTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else if (column == this.proteinTable.getColumn("PI").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Chr").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            this.setCursor(new Cursor(12));
        } else if (column == this.proteinTable.getColumn("Description").getModelIndex() && this.proteinTable.getValueAt(row, column) != null) {
            if (GuiUtilities.getPreferredWidthOfCell((JTable)this.proteinTable, (int)row, (int)column) > this.proteinTable.getColumn("Description").getWidth()) {
                this.proteinTable.setToolTipText("" + this.proteinTable.getValueAt(row, column));
            }
            this.setCursor(new Cursor(0));
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void proteinTableKeyReleased(KeyEvent evt) {
        this.proteinTableMouseReleased(null);
    }

    private void peptideTableKeyReleased(KeyEvent evt) {
        if (evt == null || evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.peptideTableMouseReleased(null);
        }
    }

    private void pdbMatchesJTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.pdbMatchesJTableMouseReleased(null);
        }
    }

    private void proteinTableMouseReleased(MouseEvent evt) {
        int row = this.proteinTable.getSelectedRow();
        int column = this.proteinTable.getSelectedColumn();
        int proteinIndex = -1;
        if (row != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            proteinIndex = tableModel.getViewIndex(row);
        }
        if ((evt == null || evt.getButton() == 1 && proteinIndex != -1 && column != -1) && proteinIndex != -1) {
            ProteinMatch proteinMatch;
            this.setCursor(new Cursor(3));
            long proteinKey = this.proteinKeys[proteinIndex];
            this.peptideShakerGUI.setSelectedItems(proteinKey, ExperimentObject.NO_KEY, null, null);
            this.updatePdbTable(proteinKey);
            if (this.jmolStructureShown) {
                this.jmolPanel = new JmolPanel();
                this.pdbPanel.removeAll();
                this.pdbPanel.add(this.jmolPanel);
                this.pdbPanel.revalidate();
                this.pdbPanel.repaint();
                this.jmolStructureShown = false;
                this.currentlyDisplayedPdbFile = null;
                ((TitledBorder)this.pdbOuterPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Structure" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                this.pdbOuterPanel.repaint();
            }
            this.updatedPeptideSelection(proteinIndex);
            this.newItemSelection();
            this.setCursor(new Cursor(0));
            if (column == this.proteinTable.getColumn("Chr").getModelIndex() && evt != null && evt.getButton() == 1) {
                proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                new GeneDetailsDialog((Frame)this.peptideShakerGUI, proteinMatch, this.peptideShakerGUI.getGeneMaps(), this.peptideShakerGUI.getProteinDetailsProvider());
            }
            if (column == this.proteinTable.getColumn("Accession").getModelIndex() && evt != null && evt.getButton() == 1 && ((String)this.proteinTable.getValueAt(row, column)).lastIndexOf("<a href=\"") != -1) {
                String link = (String)this.proteinTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL((String)link);
                this.setCursor(new Cursor(0));
            }
            if (column == this.proteinTable.getColumn("PI").getModelIndex() && evt != null && evt.getButton() == 1) {
                new ProteinInferenceDialog(this.peptideShakerGUI, this.peptideShakerGUI.getGeneMaps(), proteinKey, this.peptideShakerGUI.getIdentification());
            }
            if (column == this.proteinTable.getColumn("  ").getModelIndex()) {
                proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                PSParameter psParameter = (PSParameter)proteinMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starProtein(proteinKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarProtein(proteinKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
            }
        }
    }

    private void peptideTableMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        if (evt != null) {
            this.peptideShakerGUI.setSelectedItems(this.peptideShakerGUI.getSelectedProteinKey(), ExperimentObject.NO_KEY, null, null);
        }
        int row = this.peptideTable.getSelectedRow();
        int column = this.peptideTable.getSelectedColumn();
        if (row != -1) {
            if (this.pdbMatchesJTable.getSelectedRow() != -1) {
                this.updatePeptideToPdbMapping();
            }
            this.newItemSelection();
            if (column == this.peptideTable.getColumn("  ").getModelIndex()) {
                long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(row));
                PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (!psParameter.getStarred()) {
                    this.peptideShakerGUI.getStarHider().starPeptide(peptideKey);
                } else {
                    this.peptideShakerGUI.getStarHider().unStarPeptide(peptideKey);
                }
                this.peptideShakerGUI.setDataSaved(false);
            }
            if (column == this.peptideTable.getColumn("PI").getModelIndex() && evt != null && evt.getButton() == 1) {
                SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
                int proteinIndex = tableModel.getViewIndex(this.proteinTable.getSelectedRow());
                long proteinKey = this.proteinKeys[proteinIndex];
                long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(row));
                new ProteinInferencePeptideLevelDialog(this.peptideShakerGUI, true, peptideKey, proteinKey, this.peptideShakerGUI.getGeneMaps());
            }
        }
        this.setCursor(new Cursor(0));
    }

    private void pdbMatchesJTableMouseReleased(MouseEvent evt) {
        String tempPdbFile;
        this.setCursor(new Cursor(3));
        boolean loadStructure = true;
        if (this.pdbMatchesJTable.getSelectedRow() != -1 && this.currentlyDisplayedPdbFile != null && this.currentlyDisplayedPdbFile.equalsIgnoreCase(tempPdbFile = (String)this.pdbMatchesJTable.getValueAt(this.pdbMatchesJTable.getSelectedRow(), this.pdbMatchesJTable.getColumn("PDB").getModelIndex()))) {
            loadStructure = false;
        }
        if (loadStructure) {
            this.setEnabled(false);
            DefaultTableModel dm = (DefaultTableModel)this.pdbChainsJTable.getModel();
            dm.getDataVector().removeAllElements();
            dm.fireTableDataChanged();
            for (int i = 0; i < this.peptideTable.getRowCount(); ++i) {
                this.peptideTable.setValueAt(false, i, this.peptideTable.getColumn("PDB").getModelIndex());
            }
            int peptideRow = 0;
            long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
            if (peptideKey != ExperimentObject.NO_KEY) {
                peptideRow = this.getPeptideRow(peptideKey);
            }
            if (this.peptideTable.getRowCount() > 0) {
                this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
                this.peptideTable.scrollRectToVisible(this.peptideTable.getCellRect(peptideRow, peptideRow, false));
            }
            if (this.jmolStructureShown) {
                this.jmolPanel = new JmolPanel();
                this.pdbPanel.removeAll();
                this.pdbPanel.add(this.jmolPanel);
                this.pdbPanel.revalidate();
                this.pdbPanel.repaint();
                this.jmolStructureShown = false;
                this.currentlyDisplayedPdbFile = null;
                ((TitledBorder)this.pdbOuterPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Structure" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                this.pdbOuterPanel.repaint();
            }
            if (this.pdbMatchesJTable.getSelectedRow() != -1) {
                this.currentlyDisplayedPdbFile = (String)this.pdbMatchesJTable.getValueAt(this.pdbMatchesJTable.getSelectedRow(), this.pdbMatchesJTable.getColumn("PDB").getModelIndex());
                if (this.pdbMatchesJTable.getSelectedColumn() == this.pdbMatchesJTable.getColumn("PDB").getModelIndex() && evt.getButton() == 1 && ((String)this.pdbMatchesJTable.getValueAt(this.pdbMatchesJTable.getSelectedRow(), this.pdbMatchesJTable.getSelectedColumn())).lastIndexOf("<a href=\"") != -1) {
                    String temp = this.currentlyDisplayedPdbFile.substring(this.currentlyDisplayedPdbFile.indexOf("\"") + 1);
                    this.currentlyDisplayedPdbFile = temp.substring(0, temp.indexOf("\""));
                    this.setCursor(new Cursor(3));
                    BareBonesBrowserLaunch.openURL((String)this.currentlyDisplayedPdbFile);
                    this.setCursor(new Cursor(0));
                }
                int selectedPdbTableIndex = (Integer)this.pdbMatchesJTable.getValueAt(this.pdbMatchesJTable.getSelectedRow(), 0);
                PdbParameter lParam = (PdbParameter)this.uniProtPdb.getPdbs().get(selectedPdbTableIndex - 1);
                this.chains = lParam.getBlocks();
                SelfUpdatingTableModel proteinTableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
                int proteinIndex = proteinTableModel.getViewIndex(this.proteinTable.getSelectedRow());
                long proteinKey = this.proteinKeys[proteinIndex];
                ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                String proteinSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinMatch.getLeadingAccession());
                for (int j = 0; j < this.chains.length; ++j) {
                    XYDataPoint temp = new XYDataPoint((double)this.chains[j].getStartProtein(), (double)this.chains[j].getEndProtein());
                    if (this.chains[j].getStartProtein() == this.chains[j].getEndProtein()) continue;
                    ((DefaultTableModel)this.pdbChainsJTable.getModel()).addRow(new Object[]{j + 1, this.chains[j].getBlock(), temp, ((double)this.chains[j].getEndProtein() - (double)this.chains[j].getStartProtein()) / (double)proteinSequence.length() * 100.0});
                }
                ((JSparklinesIntervalChartTableCellRenderer)this.pdbChainsJTable.getColumn("PDB-Protein").getCellRenderer()).setMaxValue((double)proteinSequence.length());
                if (this.pdbChainsJTable.getRowCount() > 0) {
                    ((TitledBorder)this.pdbChainsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Chains (" + this.pdbChainsJTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                } else {
                    ((TitledBorder)this.pdbChainsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Chains" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                }
                this.pdbChainsPanel.repaint();
                if (this.pdbChainsJTable.getRowCount() > 0) {
                    this.pdbChainsJTable.setRowSelectionInterval(0, 0);
                    this.pdbChainsJTable.scrollRectToVisible(this.pdbChainsJTable.getCellRect(0, 0, false));
                    this.pdbChainsJTableMouseReleased(null);
                }
            } else {
                ((TitledBorder)this.pdbChainsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Chains" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                this.pdbChainsPanel.repaint();
            }
            this.setEnabled(true);
        } else if (this.pdbMatchesJTable.getSelectedColumn() == this.pdbMatchesJTable.getColumn("PDB").getModelIndex() && evt.getButton() == 1 && ((String)this.pdbMatchesJTable.getValueAt(this.pdbMatchesJTable.getSelectedRow(), this.pdbMatchesJTable.getSelectedColumn())).lastIndexOf("<a href=\"") != -1) {
            String temp = this.currentlyDisplayedPdbFile.substring(this.currentlyDisplayedPdbFile.indexOf("\"") + 1);
            this.currentlyDisplayedPdbFile = temp.substring(0, temp.indexOf("\""));
            this.setCursor(new Cursor(3));
            BareBonesBrowserLaunch.openURL((String)this.currentlyDisplayedPdbFile);
            this.setCursor(new Cursor(0));
        }
        this.setCursor(new Cursor(0));
    }

    private void pdbChainsJTableMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        if (this.jmolStructureShown) {
            this.updatePeptideToPdbMapping();
        } else {
            this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading PDB Structure. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProteinStructurePanel.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "PdbChaingThread").start();
            new Thread("StructureThread"){

                @Override
                public void run() {
                    ProteinStructurePanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    int selectedPdbIndex = (Integer)ProteinStructurePanel.this.pdbMatchesJTable.getValueAt(ProteinStructurePanel.this.pdbMatchesJTable.getSelectedRow(), 0);
                    PdbParameter lParam = (PdbParameter)ProteinStructurePanel.this.uniProtPdb.getPdbs().get(selectedPdbIndex - 1);
                    String link = "https://files.rcsb.org/download/" + lParam.getPdbaccession() + ".pdb";
                    ProteinStructurePanel.this.jmolPanel.getViewer().openFile(link);
                    if (ProteinStructurePanel.this.ribbonModel) {
                        ProteinStructurePanel.this.jmolPanel.getViewer().evalString("select all; ribbon only;");
                    } else if (ProteinStructurePanel.this.backboneModel) {
                        ProteinStructurePanel.this.jmolPanel.getViewer().evalString("select all; backbone only; backbone 100;");
                    }
                    if (!ProteinStructurePanel.this.progressDialog.isRunCanceled()) {
                        ProteinStructurePanel.this.spinModel(ProteinStructurePanel.this.spinModel);
                        ProteinStructurePanel.this.jmolStructureShown = true;
                        ((TitledBorder)ProteinStructurePanel.this.pdbOuterPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Structure (" + lParam.getPdbaccession() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                        ProteinStructurePanel.this.pdbOuterPanel.repaint();
                    }
                    if (!ProteinStructurePanel.this.progressDialog.isRunCanceled()) {
                        ProteinStructurePanel.this.progressDialog.setTitle("Mapping Peptides. Please Wait...");
                        ProteinStructurePanel.access$7302(ProteinStructurePanel.this, lParam.getBlocks());
                        int selectedChainIndex = (Integer)ProteinStructurePanel.this.pdbChainsJTable.getValueAt(ProteinStructurePanel.this.pdbChainsJTable.getSelectedRow(), 0);
                        ProteinStructurePanel.this.chainSequence = ProteinStructurePanel.this.chains[selectedChainIndex - 1].getBlockSequence(lParam.getPdbaccession());
                        ProteinStructurePanel.this.updatePeptideToPdbMapping();
                    }
                    ProteinStructurePanel.this.progressDialog.setRunFinished();
                    ProteinStructurePanel.this.setCursor(new Cursor(0));
                }
            }.start();
        }
        this.setCursor(new Cursor(0));
    }

    private void pdbChainsJTableKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 38 || evt.getKeyCode() == 40 || evt.getKeyCode() == 33 || evt.getKeyCode() == 34) {
            this.updatePeptideToPdbMapping();
        }
    }

    private void pdbMatchesJTableMouseMoved(MouseEvent evt) {
        int row = this.pdbMatchesJTable.rowAtPoint(evt.getPoint());
        int column = this.pdbMatchesJTable.columnAtPoint(evt.getPoint());
        if (column == this.pdbMatchesJTable.getColumn("PDB").getModelIndex() && this.pdbMatchesJTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.pdbMatchesJTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<a href=\"") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void pdbMatchesJTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pdbLayeredPaneComponentResized(ComponentEvent evt) {
        int componentIndex = 0;
        this.pdbLayeredPane.getComponent(componentIndex++).setBounds(this.pdbLayeredPane.getWidth() - this.pdbLayeredPane.getComponent(0).getWidth() * componentIndex - 10, this.pdbLayeredPane.getComponent(0).getHeight() / 10 - 2, this.pdbLayeredPane.getComponent(0).getWidth(), this.pdbLayeredPane.getComponent(0).getHeight());
        this.pdbLayeredPane.getComponent(componentIndex++).setBounds(this.pdbLayeredPane.getWidth() - this.pdbLayeredPane.getComponent(0).getWidth() * componentIndex - 15, this.pdbLayeredPane.getComponent(0).getHeight() / 10 - 2, this.pdbLayeredPane.getComponent(0).getWidth(), this.pdbLayeredPane.getComponent(0).getHeight());
        this.pdbLayeredPane.getComponent(componentIndex++).setBounds(this.pdbLayeredPane.getWidth() - this.pdbLayeredPane.getComponent(0).getWidth() * componentIndex - 10, this.pdbLayeredPane.getComponent(0).getHeight() / 10 - 2, this.pdbLayeredPane.getComponent(0).getWidth(), this.pdbLayeredPane.getComponent(0).getHeight());
        this.pdbLayeredPane.getComponent(componentIndex++).setBounds(this.pdbLayeredPane.getWidth() - this.pdbLayeredPane.getComponent(0).getWidth() * componentIndex - 15, this.pdbLayeredPane.getComponent(0).getHeight() / 10, this.pdbLayeredPane.getComponent(0).getWidth(), this.pdbLayeredPane.getComponent(0).getHeight());
        this.pdbLayeredPane.getComponent(componentIndex++).setBounds(0, 0, this.pdbLayeredPane.getWidth(), this.pdbLayeredPane.getHeight());
        this.pdbLayeredPane.revalidate();
        this.pdbLayeredPane.repaint();
    }

    private void peptideTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideTableMouseMoved(MouseEvent evt) {
        int column;
        int row = this.peptideTable.rowAtPoint(evt.getPoint());
        if (this.peptideTable.getValueAt(row, column = this.peptideTable.columnAtPoint(evt.getPoint())) != null) {
            if (column == this.peptideTable.getColumn("PI").getModelIndex()) {
                this.setCursor(new Cursor(12));
                this.peptideTable.setToolTipText(null);
            } else if (column == this.peptideTable.getColumn("Sequence").getModelIndex()) {
                this.setCursor(new Cursor(0));
                String sequence = (String)this.peptideTable.getValueAt(row, column);
                if (sequence.contains("<span")) {
                    long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(row));
                    PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                    String tooltip = this.peptideShakerGUI.getDisplayFeaturesGenerator().getPeptideModificationTooltipAsHtml(peptideMatch);
                    this.peptideTable.setToolTipText(tooltip);
                } else {
                    this.peptideTable.setToolTipText(null);
                }
            } else {
                this.setCursor(new Cursor(0));
                this.peptideTable.setToolTipText(null);
            }
        } else {
            this.setCursor(new Cursor(0));
            this.peptideTable.setToolTipText(null);
        }
    }

    private void playJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void playJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void playJButtonActionPerformed(ActionEvent evt) {
        this.spinModel = !this.spinModel;
        this.spinModel(this.spinModel);
        if (this.spinModel) {
            this.playJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/pause.png")));
            this.playJButton.setToolTipText("Stop Rotation");
        } else {
            this.playJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/play.png")));
            this.playJButton.setToolTipText("Start Rotation");
        }
    }

    private void ribbonJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void ribbonJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void ribbonJButtonActionPerformed(ActionEvent evt) {
        this.ribbonModel = true;
        this.backboneModel = false;
        this.updateModelType();
        if (this.backboneModel) {
            this.backboneJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/backbone_selected.png")));
            this.ribbonJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ribbon.png")));
        } else {
            this.backboneJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/backbone.png")));
            this.ribbonJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ribbon_selected.png")));
        }
    }

    private void backboneJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void backboneJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void backboneJButtonActionPerformed(ActionEvent evt) {
        this.ribbonModel = false;
        this.backboneModel = true;
        this.updateModelType();
        if (this.backboneModel) {
            this.backboneJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/backbone_selected.png")));
            this.ribbonJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ribbon.png")));
        } else {
            this.backboneJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/backbone.png")));
            this.ribbonJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/ribbon_selected.png")));
        }
    }

    private void labelsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void labelsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void labelsJButtonActionPerformed(ActionEvent evt) {
        boolean bl = this.showModificationLabels = !this.showModificationLabels;
        if (this.showModificationLabels) {
            this.labelsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/labels_selected.png")));
            this.labelsJButton.setToolTipText("Hide Modification Labels");
        } else {
            this.labelsJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/labels.png")));
            this.labelsJButton.setToolTipText("Show Modification Labels");
        }
        if (this.pdbMatchesJTable.getSelectedRow() != -1 && this.peptideTable.getSelectedRow() != -1) {
            this.updatePeptideToPdbMapping();
        }
    }

    private void exportProteinsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportProteinsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportProteinsJButtonActionPerformed(ActionEvent evt) {
        try {
            this.copyTableContentToClipboardOrFile(TableIndex.PROTEIN_TABLE);
        }
        catch (IOException ioe) {
            this.peptideShakerGUI.catchException(ioe);
        }
    }

    private void proteinsHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void proteinsHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void proteinsHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PDB.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Structure - Help");
        this.setCursor(new Cursor(0));
    }

    private void formComponentResized(ComponentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProteinStructurePanel.this.proteinsLayeredPane.getComponent(0).setBounds(ProteinStructurePanel.this.proteinsLayeredPane.getWidth() - ProteinStructurePanel.this.proteinsLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinStructurePanel.this.proteinsLayeredPane.getComponent(0).getWidth(), ProteinStructurePanel.this.proteinsLayeredPane.getComponent(0).getHeight());
                ProteinStructurePanel.this.proteinsLayeredPane.getComponent(1).setBounds(ProteinStructurePanel.this.proteinsLayeredPane.getWidth() - ProteinStructurePanel.this.proteinsLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinStructurePanel.this.proteinsLayeredPane.getComponent(1).getWidth(), ProteinStructurePanel.this.proteinsLayeredPane.getComponent(1).getHeight());
                ProteinStructurePanel.this.proteinsLayeredPane.getComponent(2).setBounds(ProteinStructurePanel.this.proteinsLayeredPane.getWidth() - ProteinStructurePanel.this.proteinsLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinStructurePanel.this.proteinsLayeredPane.getComponent(2).getWidth(), ProteinStructurePanel.this.proteinsLayeredPane.getComponent(2).getHeight());
                ProteinStructurePanel.this.proteinsLayeredPane.getComponent(3).setBounds(0, 0, ProteinStructurePanel.this.proteinsLayeredPane.getWidth(), ProteinStructurePanel.this.proteinsLayeredPane.getHeight());
                ProteinStructurePanel.this.proteinsLayeredPane.revalidate();
                ProteinStructurePanel.this.proteinsLayeredPane.repaint();
                ProteinStructurePanel.this.peptidesLayeredPane.getComponent(0).setBounds(ProteinStructurePanel.this.peptidesLayeredPane.getWidth() - ProteinStructurePanel.this.peptidesLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinStructurePanel.this.peptidesLayeredPane.getComponent(0).getWidth(), ProteinStructurePanel.this.peptidesLayeredPane.getComponent(0).getHeight());
                ProteinStructurePanel.this.peptidesLayeredPane.getComponent(1).setBounds(ProteinStructurePanel.this.peptidesLayeredPane.getWidth() - ProteinStructurePanel.this.peptidesLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinStructurePanel.this.peptidesLayeredPane.getComponent(1).getWidth(), ProteinStructurePanel.this.peptidesLayeredPane.getComponent(1).getHeight());
                ProteinStructurePanel.this.peptidesLayeredPane.getComponent(2).setBounds(ProteinStructurePanel.this.peptidesLayeredPane.getWidth() - ProteinStructurePanel.this.peptidesLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinStructurePanel.this.peptidesLayeredPane.getComponent(2).getWidth(), ProteinStructurePanel.this.peptidesLayeredPane.getComponent(2).getHeight());
                ProteinStructurePanel.this.peptidesLayeredPane.getComponent(3).setBounds(0, 0, ProteinStructurePanel.this.peptidesLayeredPane.getWidth(), ProteinStructurePanel.this.peptidesLayeredPane.getHeight());
                ProteinStructurePanel.this.peptidesLayeredPane.revalidate();
                ProteinStructurePanel.this.peptidesLayeredPane.repaint();
                ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(0).setBounds(ProteinStructurePanel.this.pdbMatchesLayeredPane.getWidth() - ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(0).getWidth(), ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(0).getHeight());
                ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(1).setBounds(ProteinStructurePanel.this.pdbMatchesLayeredPane.getWidth() - ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(1).getWidth(), ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(1).getHeight());
                ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(2).setBounds(ProteinStructurePanel.this.pdbMatchesLayeredPane.getWidth() - ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(2).getWidth(), ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(2).getHeight());
                ProteinStructurePanel.this.pdbMatchesLayeredPane.getComponent(3).setBounds(0, 0, ProteinStructurePanel.this.pdbMatchesLayeredPane.getWidth(), ProteinStructurePanel.this.pdbMatchesLayeredPane.getHeight());
                ProteinStructurePanel.this.pdbMatchesLayeredPane.revalidate();
                ProteinStructurePanel.this.pdbMatchesLayeredPane.repaint();
                ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(0).setBounds(ProteinStructurePanel.this.pdbChainsLayeredPane.getWidth() - ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(0).getWidth(), ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(0).getHeight());
                ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(1).setBounds(ProteinStructurePanel.this.pdbChainsLayeredPane.getWidth() - ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(1).getWidth(), ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(1).getHeight());
                ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(2).setBounds(ProteinStructurePanel.this.pdbChainsLayeredPane.getWidth() - ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(2).getWidth(), ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(2).getHeight());
                ProteinStructurePanel.this.pdbChainsLayeredPane.getComponent(3).setBounds(0, 0, ProteinStructurePanel.this.pdbChainsLayeredPane.getWidth(), ProteinStructurePanel.this.pdbChainsLayeredPane.getHeight());
                ProteinStructurePanel.this.pdbChainsLayeredPane.revalidate();
                ProteinStructurePanel.this.pdbChainsLayeredPane.repaint();
                ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(0).setBounds(ProteinStructurePanel.this.pdbStructureLayeredPane.getWidth() - ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(0).getWidth() - 10, -3, ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(0).getWidth(), ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(0).getHeight());
                ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(1).setBounds(ProteinStructurePanel.this.pdbStructureLayeredPane.getWidth() - ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(1).getWidth() - 20, -3, ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(1).getWidth(), ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(1).getHeight());
                ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(2).setBounds(ProteinStructurePanel.this.pdbStructureLayeredPane.getWidth() - ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(2).getWidth() - 5, -3, ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(2).getWidth(), ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(2).getHeight());
                ProteinStructurePanel.this.pdbStructureLayeredPane.getComponent(3).setBounds(0, 0, ProteinStructurePanel.this.pdbStructureLayeredPane.getWidth(), ProteinStructurePanel.this.pdbStructureLayeredPane.getHeight());
                ProteinStructurePanel.this.pdbStructureLayeredPane.revalidate();
                ProteinStructurePanel.this.pdbStructureLayeredPane.repaint();
            }
        });
    }

    private void peptidesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptidesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptidesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PDB.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Structure - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPeptidesJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPeptidesJButtonActionPerformed(ActionEvent evt) {
        try {
            this.copyTableContentToClipboardOrFile(TableIndex.PEPTIDE_TABLE);
        }
        catch (IOException ioe) {
            this.peptideShakerGUI.catchException(ioe);
        }
    }

    private void pdbMatchesHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void pdbMatchesHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pdbMatchesHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PDB.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Structure - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPdbMatchesJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPdbMatchesJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPdbMatchesJButtonActionPerformed(ActionEvent evt) {
        try {
            this.copyTableContentToClipboardOrFile(TableIndex.PDB_MATCHES);
        }
        catch (IOException ioe) {
            this.peptideShakerGUI.catchException(ioe);
        }
    }

    private void pdbChainHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void pdbChainHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pdbChainHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PDB.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Structure - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPdbChainsJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPdbChainsJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPdbChainsJButtonActionPerformed(ActionEvent evt) {
        try {
            this.copyTableContentToClipboardOrFile(TableIndex.PDB_CHAINS);
        }
        catch (IOException ioe) {
            this.peptideShakerGUI.catchException(ioe);
        }
    }

    private void pdbStructureHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void pdbStructureHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void pdbStructureHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((Frame)this.peptideShakerGUI, this.getClass().getResource("/helpFiles/PDB.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), "Protein Structure - Help");
        this.setCursor(new Cursor(0));
    }

    private void exportPdbStructureJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void exportPdbStructureJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void exportPdbStructureJButtonActionPerformed(ActionEvent evt) {
        new ExportGraphicsDialog((JFrame)this.peptideShakerGUI, this.peptideShakerGUI.getNormalIcon(), this.peptideShakerGUI.getWaitingIcon(), true, (Component)this.pdbPanel, this.peptideShakerGUI.getLastSelectedFolder());
    }

    private void proteinTableMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 3 && this.proteinTable.getRowCount() > 0) {
            final MouseEvent event = evt;
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Statistics (beta)");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    new XYPlottingDialog((Frame)ProteinStructurePanel.this.peptideShakerGUI, ProteinStructurePanel.this.proteinTable, ProteinStructurePanel.this.proteinTable.getColumnName(ProteinStructurePanel.this.proteinTable.columnAtPoint(event.getPoint())), XYPlottingDialog.PlottingDialogPlotType.densityPlot, ProteinStructurePanel.this.proteinTableToolTips, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                }
            });
            popupMenu.add(menuItem);
            popupMenu.show(this.proteinTable, evt.getX(), evt.getY());
        }
    }

    public long[] getDisplayedProteins() {
        return this.proteinKeys;
    }

    public long[] getDisplayedPeptides() {
        return this.peptideTableMap.values().stream().mapToLong(a -> a).toArray();
    }

    private void updatedPeptideSelection(int proteinIndex) {
        if (proteinIndex != -1) {
            long[] peptideKeys;
            this.setCursor(new Cursor(3));
            DefaultTableModel dm = (DefaultTableModel)this.peptideTable.getModel();
            dm.getDataVector().removeAllElements();
            dm.fireTableDataChanged();
            long proteinMatchKey = this.proteinKeys[proteinIndex];
            ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinMatchKey);
            String proteinAccession = proteinMatch.getLeadingAccession();
            this.peptideTableMap = new HashMap();
            int index = 0;
            for (long peptideKey : peptideKeys = this.peptideShakerGUI.getIdentificationFeaturesGenerator().getSortedPeptideKeys(proteinMatchKey)) {
                PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
                PSParameter psParameter = (PSParameter)peptideMatch.getUrParam((UrParameter)PSParameter.dummy);
                if (psParameter.getHidden()) continue;
                StartIndexes startIndexes = new StartIndexes(Arrays.stream((int[])peptideMatch.getPeptide().getProteinMapping().get(proteinAccession)).map(site -> site + 1).boxed().collect(Collectors.toCollection(ArrayList::new)));
                int proteinInferenceType = psParameter.getProteinInferenceGroupClass();
                ((DefaultTableModel)this.peptideTable.getModel()).addRow(new Object[]{index + 1, psParameter.getStarred(), proteinInferenceType, this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true), startIndexes, false, psParameter.getMatchValidationLevel().getIndex()});
                this.peptideTableMap.put(index + 1, peptideKey);
                ++index;
            }
            ((DefaultTableModel)this.peptideTable.getModel()).fireTableDataChanged();
            String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptides (";
            IdentificationFeaturesGenerator identificationFeaturesGenerator = this.peptideShakerGUI.getIdentificationFeaturesGenerator();
            int nValidatedPeptides = identificationFeaturesGenerator.getNValidatedPeptides(proteinMatchKey);
            int nConfidentPeptides = identificationFeaturesGenerator.getNConfidentPeptides(proteinMatchKey);
            int nPeptides = proteinMatch.getPeptideCount();
            title = nConfidentPeptides > 0 ? title + nValidatedPeptides + "/" + nPeptides + " - " + nConfidentPeptides + " confident, " + (nValidatedPeptides - nConfidentPeptides) + " doubtful" : title + nValidatedPeptides + "/" + nPeptides;
            title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
            ((TitledBorder)this.peptidesPanel.getBorder()).setTitle(title);
            this.peptidesPanel.repaint();
            String proteinSequence = this.peptideShakerGUI.getSequenceProvider().getSequence(proteinAccession);
            this.peptideTable.getColumn("Start").setCellRenderer((TableCellRenderer)new JSparklinesMultiIntervalChartTableCellRenderer(PlotOrientation.HORIZONTAL, Double.valueOf(proteinSequence.length()), Double.valueOf((double)proteinSequence.length() / 50.0), this.peptideShakerGUI.getSparklineColor()));
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showReferenceLine(true, 0.02, Color.BLACK);
            ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showNumberAndChart(true, TableProperties.getLabelWidth() - 10);
            if (this.peptideTable.getRowCount() > 0) {
                int peptideRow = 0;
                long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
                if (peptideKey != ExperimentObject.NO_KEY) {
                    peptideRow = this.getPeptideRow(peptideKey);
                }
                if (peptideRow != -1) {
                    this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
                    this.peptideTable.scrollRectToVisible(this.peptideTable.getCellRect(peptideRow, 0, false));
                    this.peptideTableKeyReleased(null);
                }
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void displayResults() {
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Updating Data. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ProteinStructurePanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("DisplayThread"){

            @Override
            public void run() {
                try {
                    ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().setProteinKeys(ProteinStructurePanel.this.peptideShakerGUI.getMetrics().getProteinKeys());
                    ProteinStructurePanel.access$8402(ProteinStructurePanel.this, ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getProcessedProteinKeys((WaitingHandler)ProteinStructurePanel.this.progressDialog, ProteinStructurePanel.this.peptideShakerGUI.getFilterParameters(), true));
                    ProteinStructurePanel.this.setTableProperties();
                    if (ProteinStructurePanel.this.proteinTable.getModel() instanceof ProteinTableModel && ((ProteinTableModel)((Object)ProteinStructurePanel.this.proteinTable.getModel())).isInstantiated()) {
                        ((ProteinTableModel)((Object)ProteinStructurePanel.this.proteinTable.getModel())).updateDataModel(ProteinStructurePanel.this.peptideShakerGUI.getIdentification(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinStructurePanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSequenceProvider(), ProteinStructurePanel.this.peptideShakerGUI.getGeneMaps(), ProteinStructurePanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), ProteinStructurePanel.this.proteinKeys);
                    } else {
                        ProteinTableModel proteinTableModel = new ProteinTableModel(ProteinStructurePanel.this.peptideShakerGUI.getIdentification(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinStructurePanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSequenceProvider(), ProteinStructurePanel.this.peptideShakerGUI.getGeneMaps(), ProteinStructurePanel.this.peptideShakerGUI.getDisplayFeaturesGenerator(), (ExceptionHandler)ProteinStructurePanel.this.peptideShakerGUI.getExceptionHandler(), ProteinStructurePanel.this.proteinKeys);
                        ProteinStructurePanel.this.proteinTable.setModel((TableModel)((Object)proteinTableModel));
                    }
                    ProteinStructurePanel.this.setTableProperties();
                    ProteinStructurePanel.this.showSparkLines(ProteinStructurePanel.this.peptideShakerGUI.showSparklines());
                    ((DefaultTableModel)ProteinStructurePanel.this.proteinTable.getModel()).fireTableDataChanged();
                    switch (ProteinStructurePanel.this.peptideShakerGUI.getSpectrumCountingParameters().getSelectedMethod()) {
                        case EMPAI: {
                            ProteinStructurePanel.this.proteinTableToolTips.set(ProteinStructurePanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Protein MS2 Quantification - emPAI");
                            break;
                        }
                        case NSAF: {
                            ProteinStructurePanel.this.proteinTableToolTips.set(ProteinStructurePanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Protein MS2 Quantification - NSAF");
                            break;
                        }
                        case LFQ: {
                            ProteinStructurePanel.this.proteinTableToolTips.set(ProteinStructurePanel.this.proteinTable.getColumn("Quant").getModelIndex(), "Protein LFQ Quantification - LFQ");
                            break;
                        }
                    }
                    if (ProteinStructurePanel.this.peptideShakerGUI.getDisplayParameters().showScores()) {
                        ProteinStructurePanel.this.proteinTableToolTips.set(ProteinStructurePanel.this.proteinTable.getColumnCount() - 2, "Protein Score");
                    } else {
                        ProteinStructurePanel.this.proteinTableToolTips.set(ProteinStructurePanel.this.proteinTable.getColumnCount() - 2, "Protein Confidence");
                    }
                    String title = PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins (";
                    int nValidated = ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNValidatedProteins();
                    int nConfident = ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator().getNConfidentProteins();
                    int nProteins = ProteinStructurePanel.this.proteinTable.getRowCount();
                    title = nConfident > 0 ? title + nValidated + "/" + nProteins + " - " + nConfident + " confident, " + (nValidated - nConfident) + " doubtful" : title + nValidated + "/" + nProteins;
                    title = title + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING;
                    ((TitledBorder)ProteinStructurePanel.this.proteinsPanel.getBorder()).setTitle(title);
                    ProteinStructurePanel.this.proteinsPanel.repaint();
                    ProteinStructurePanel.this.updateProteinTableCellRenderers();
                    ProteinStructurePanel.this.exportProteinsJButton.setEnabled(true);
                    ProteinStructurePanel.this.exportPdbMatchesJButton.setEnabled(true);
                    ProteinStructurePanel.this.exportPdbChainsJButton.setEnabled(true);
                    ProteinStructurePanel.this.exportPeptidesJButton.setEnabled(true);
                    ProteinStructurePanel.this.exportPdbStructureJButton.setEnabled(true);
                    ProteinStructurePanel.this.peptideShakerGUI.setUpdated(4, true);
                    ProteinStructurePanel.this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
                    ProteinStructurePanel.this.progressDialog.setTitle("Preparing 3D Structure Tab. Please Wait...");
                    ProteinStructurePanel.this.peptideShakerGUI.setCursor(new Cursor(0));
                    ProteinStructurePanel.this.progressDialog.setRunFinished();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            long proteinKey = ProteinStructurePanel.this.peptideShakerGUI.getSelectedProteinKey();
                            long peptideKey = ProteinStructurePanel.this.peptideShakerGUI.getSelectedPeptideKey();
                            String spectrumFile = ProteinStructurePanel.this.peptideShakerGUI.getSelectedSpectrumFile();
                            String spectrumTitle = ProteinStructurePanel.this.peptideShakerGUI.getSelectedSpectrumTitle();
                            ProteinStructurePanel.this.proteinTableMouseReleased(null);
                            ProteinStructurePanel.this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
                            ProteinStructurePanel.this.updateSelection(true);
                            ProteinStructurePanel.this.proteinTable.requestFocus();
                        }
                    }, "UpdateSelectionThread").start();
                }
                catch (Exception e) {
                    ProteinStructurePanel.this.progressDialog.setRunFinished();
                    ProteinStructurePanel.this.peptideShakerGUI.catchException(e);
                }
            }
        }.start();
    }

    private Integer getPeptideIndex(int row) {
        if (row != -1) {
            return (Integer)this.peptideTable.getValueAt(row, 0);
        }
        return -1;
    }

    private void updatePdbTable(long aProteinKey) {
        final long proteinKey = aProteinKey;
        this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ProteinStructurePanel.this.progressDialog.setTitle("Getting PDB Data. Please Wait...");
                try {
                    ProteinStructurePanel.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ExtractThread"){

            @Override
            public void run() {
                try {
                    ProteinMatch proteinMatch = ProteinStructurePanel.this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
                    String tempAccession = proteinMatch.getLeadingAccession();
                    ProteinStructurePanel.this.uniProtPdb = new FindPdbForUniprotAccessions(tempAccession, (WaitingHandler)ProteinStructurePanel.this.progressDialog);
                    DefaultTableModel dm = (DefaultTableModel)ProteinStructurePanel.this.pdbMatchesJTable.getModel();
                    dm.getDataVector().removeAllElements();
                    dm.fireTableDataChanged();
                    dm = (DefaultTableModel)ProteinStructurePanel.this.pdbChainsJTable.getModel();
                    dm.getDataVector().removeAllElements();
                    dm.fireTableDataChanged();
                    for (int i = 0; i < ProteinStructurePanel.this.peptideTable.getRowCount() && !ProteinStructurePanel.this.progressDialog.isRunCanceled(); ++i) {
                        ProteinStructurePanel.this.peptideTable.setValueAt(false, i, ProteinStructurePanel.this.peptideTable.getColumn("PDB").getModelIndex());
                    }
                    int maxNumberOfChains = 1;
                    for (int i = 0; i < ProteinStructurePanel.this.uniProtPdb.getPdbs().size() && !ProteinStructurePanel.this.progressDialog.isRunCanceled(); ++i) {
                        PdbParameter lParam = (PdbParameter)ProteinStructurePanel.this.uniProtPdb.getPdbs().get(i);
                        ((DefaultTableModel)ProteinStructurePanel.this.pdbMatchesJTable.getModel()).addRow(new Object[]{i + 1, ProteinStructurePanel.this.addPdbDatabaseLink(lParam.getPdbaccession()), lParam.getTitle(), lParam.getExperiment_type(), lParam.getBlocks().length});
                        if (lParam.getBlocks().length <= maxNumberOfChains) continue;
                        maxNumberOfChains = lParam.getBlocks().length;
                    }
                    if (!ProteinStructurePanel.this.progressDialog.isRunCanceled()) {
                        ((JSparklinesBarChartTableCellRenderer)ProteinStructurePanel.this.pdbMatchesJTable.getColumn("Chains").getCellRenderer()).setMaxValue((double)maxNumberOfChains);
                        if (!ProteinStructurePanel.this.uniProtPdb.urlWasRead()) {
                            ((TitledBorder)ProteinStructurePanel.this.pdbMatchesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Matches - Not Available Without Internet Connection!" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                        } else {
                            ((TitledBorder)ProteinStructurePanel.this.pdbMatchesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Matches (" + ProteinStructurePanel.this.pdbMatchesJTable.getRowCount() + ")" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                        }
                        ProteinStructurePanel.this.pdbMatchesPanel.repaint();
                        ((TitledBorder)ProteinStructurePanel.this.pdbChainsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Chains" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
                        ProteinStructurePanel.this.pdbChainsPanel.repaint();
                    }
                    ProteinStructurePanel.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    ProteinStructurePanel.this.progressDialog.setRunFinished();
                    ProteinStructurePanel.this.peptideShakerGUI.catchException(e);
                }
            }
        }.start();
    }

    public void updateModelType() {
        if (this.jmolStructureShown) {
            if (this.ribbonModel) {
                this.jmolPanel.getViewer().evalString("select all; ribbon; backbone off");
            } else if (this.backboneModel) {
                this.jmolPanel.getViewer().evalString("select all; backbone 100; ribbon off");
            }
        }
    }

    public void showSparkLines(boolean showSparkLines) {
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("Coverage").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).showNumbers(!showSparkLines);
        String scoreColumnName = this.proteinTable.getColumnName(11);
        ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn(scoreColumnName).getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.pdbMatchesJTable.getColumn("Chains").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesBarChartTableCellRenderer)this.pdbChainsJTable.getColumn("Coverage").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesIntervalChartTableCellRenderer)this.pdbChainsJTable.getColumn("PDB-Protein").getCellRenderer()).showNumbers(!showSparkLines);
        ((JSparklinesMultiIntervalChartTableCellRenderer)this.peptideTable.getColumn("Start").getCellRenderer()).showNumbers(!showSparkLines);
        this.proteinTable.revalidate();
        this.proteinTable.repaint();
        this.peptideTable.revalidate();
        this.peptideTable.repaint();
        this.pdbMatchesJTable.revalidate();
        this.pdbMatchesJTable.repaint();
    }

    private String addPdbDatabaseLink(String pdbAccession) {
        return "<html><a href=\"" + this.getPDBAccesionLink(pdbAccession) + "\"><font color=\"" + TableProperties.getNotSelectedRowHtmlTagFontColor() + "\">" + pdbAccession + "</font></a></html>";
    }

    public String getPDBAccesionLink(String pdbAccession) {
        return "https://www.rcsb.org/pdb/explore/explore.do?structureId=" + pdbAccession;
    }

    private void updatePeptideToPdbMapping() {
        this.setCursor(new Cursor(3));
        for (int i = 0; i < this.peptideTable.getRowCount() && !this.progressDialog.isRunCanceled(); ++i) {
            this.peptideTable.setValueAt(false, i, this.peptideTable.getColumn("PDB").getModelIndex());
        }
        this.jmolPanel.getViewer().evalString("select all; color grey");
        int selectedChainIndex = (Integer)this.pdbChainsJTable.getValueAt(this.pdbChainsJTable.getSelectedRow(), 0);
        String currentChain = this.chains[selectedChainIndex - 1].getBlock();
        SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
        int proteinIndex = tableModel.getViewIndex(this.proteinTable.getSelectedRow());
        long proteinKey = this.proteinKeys[proteinIndex];
        ProteinMatch proteinMatch = this.peptideShakerGUI.getIdentification().getProteinMatch(proteinKey);
        this.peptidePdbArray = new ArrayList();
        block1: for (int i = 0; i < this.peptideTable.getRowCount() && !this.progressDialog.isRunCanceled(); ++i) {
            long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(i));
            PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
            String peptideSequence = peptideMatch.getPeptide().getSequence();
            int[] nArray = (int[])peptideMatch.getPeptide().getProteinMapping().get(proteinMatch.getLeadingAccession());
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int n2 = nArray[j];
                int peptideEnd = n2 + peptideSequence.length();
                this.jmolPanel.getViewer().evalString("select resno >=" + (n2 + 1 - this.chains[selectedChainIndex - 1].getDifference()) + " and resno <=" + (peptideEnd - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + "; color green");
                if (n2 >= this.chains[selectedChainIndex - 1].getStartProtein() && peptideEnd <= this.chains[selectedChainIndex - 1].getEndProtein()) {
                    this.peptideTable.setValueAt(true, i, this.peptideTable.getColumn("PDB").getModelIndex());
                    this.peptidePdbArray.add(peptideKey);
                }
                if (this.progressDialog.isRunCanceled()) continue block1;
            }
        }
        long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(this.peptideTable.getSelectedRow()));
        PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
        String peptideSequence = peptideMatch.getPeptide().getSequence();
        for (Object peptideStart : (String)((int[])peptideMatch.getPeptide().getProteinMapping().get(proteinMatch.getLeadingAccession()))) {
            if (this.progressDialog.isRunCanceled()) break;
            reference var16_20 = peptideStart + peptideSequence.length();
            this.jmolPanel.getViewer().evalString("select resno >=" + (int)(peptideStart + true - this.chains[selectedChainIndex - 1].getDifference()) + " and resno <=" + (int)(var16_20 - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + "; color blue");
        }
        this.jmolPanel.getViewer().evalString("select all; label off");
        DisplayParameters displayParameters = this.peptideShakerGUI.getDisplayParameters();
        IdentificationParameters identificationParameters = this.peptideShakerGUI.getIdentificationParameters();
        SequenceProvider sequenceProvider = this.peptideShakerGUI.getSequenceProvider();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters sequenceMatchingParameters = identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        block4: for (int i = 0; i < this.peptideTable.getRowCount() && !this.progressDialog.isRunCanceled(); ++i) {
            peptideKey = this.peptideTableMap.get(this.getPeptideIndex(i));
            peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
            Peptide peptide = peptideMatch.getPeptide();
            peptideSequence = peptide.getSequence();
            String[] variableModifications = peptide.getIndexedVariableModifications();
            String[] fixedModifications = peptide.getFixedModifications(modificationParameters, sequenceProvider, sequenceMatchingParameters);
            for (int peptideStart : (int[])peptide.getProteinMapping().get(proteinMatch.getLeadingAccession())) {
                if (this.progressDialog.isRunCanceled()) continue block4;
                int peptideEnd = peptideStart + peptideSequence.length() - 1;
                for (int j = peptideStart; j < peptideEnd && !this.progressDialog.isRunCanceled(); ++j) {
                    Color ptmColor;
                    String modName = variableModifications[j - peptideStart];
                    if (modName != null && displayParameters.isDisplayedPTM(modName)) {
                        ptmColor = new Color(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getColor(modName));
                        this.jmolPanel.getViewer().evalString("select resno =" + (j - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + "; color [" + ptmColor.getRed() + "," + ptmColor.getGreen() + "," + ptmColor.getBlue() + "]");
                        if (this.showModificationLabels) {
                            this.jmolPanel.getViewer().evalString("select resno =" + (j - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + " and *.ca; color [" + ptmColor.getRed() + "," + ptmColor.getGreen() + "," + ptmColor.getBlue() + "];label " + modName);
                        }
                    }
                    if ((modName = fixedModifications[j - peptideStart]) == null || !displayParameters.isDisplayedPTM(modName)) continue;
                    ptmColor = new Color(this.peptideShakerGUI.getIdentificationParameters().getSearchParameters().getModificationParameters().getColor(modName));
                    this.jmolPanel.getViewer().evalString("select resno =" + (j - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + "; color [" + ptmColor.getRed() + "," + ptmColor.getGreen() + "," + ptmColor.getBlue() + "]");
                    if (!this.showModificationLabels) continue;
                    this.jmolPanel.getViewer().evalString("select resno =" + (j - this.chains[selectedChainIndex - 1].getDifference()) + " and chain = " + currentChain + " and *.ca; color [" + ptmColor.getRed() + "," + ptmColor.getGreen() + "," + ptmColor.getBlue() + "];label " + modName);
                }
            }
        }
        this.peptideTable.getRowSorter().allRowsChanged();
        this.setCursor(new Cursor(0));
    }

    public void updateMainMatch(String mainMatch, int proteinInferenceType) {
        if (this.proteinTable.getRowCount() > 0) {
            DefaultTableModel dm = (DefaultTableModel)this.proteinTable.getModel();
            dm.fireTableDataChanged();
            this.reselect();
        }
    }

    public void spinModel(boolean spin) {
        if (spin) {
            this.jmolPanel.getViewer().evalString("set spin y 20; spin");
        } else {
            this.jmolPanel.getViewer().evalString("spin off");
        }
    }

    public JTable getProteinTable() {
        return this.proteinTable;
    }

    public JTable getPeptideTable() {
        return this.peptideTable;
    }

    public void updateScores() {
        ((ProteinTableModel)((Object)this.proteinTable.getModel())).showScores(this.peptideShakerGUI.getDisplayParameters().showScores());
        ((DefaultTableModel)this.proteinTable.getModel()).fireTableStructureChanged();
        this.setTableProperties();
        if (this.peptideShakerGUI.getSelectedTab() == 4) {
            this.reselect();
        }
        if (this.peptideShakerGUI.getDisplayParameters().showScores()) {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Score");
        } else {
            this.proteinTableToolTips.set(this.proteinTable.getColumnCount() - 2, "Protein Confidence");
        }
        this.updateProteinTableCellRenderers();
    }

    public void updateModificationColors() {
        this.setCursor(new Cursor(3));
        for (int i = 0; i < this.peptideTable.getRowCount(); ++i) {
            long peptideKey = this.peptideTableMap.get(this.getPeptideIndex(i));
            PeptideMatch peptideMatch = this.peptideShakerGUI.getIdentification().getPeptideMatch(peptideKey);
            String modifiedSequence = this.peptideShakerGUI.getDisplayFeaturesGenerator().getTaggedPeptideSequence(peptideMatch, true, true, true);
            this.peptideTable.setValueAt(modifiedSequence, i, this.peptideTable.getColumn("Sequence").getModelIndex());
        }
        if (this.peptideTable.getRowCount() > 0) {
            this.peptideTableMouseReleased(null);
        }
        this.setCursor(new Cursor(0));
    }

    public void updatePeptideProteinInference(int proteinInferenceType) {
        this.peptideTable.setValueAt(proteinInferenceType, this.peptideTable.getSelectedRow(), this.peptideTable.getColumn("PI").getModelIndex());
    }

    private void copyTableContentToClipboardOrFile(TableIndex index) throws IOException {
        File selectedFile;
        final TableIndex tableIndex = index;
        if (tableIndex == TableIndex.PROTEIN_TABLE || tableIndex == TableIndex.PEPTIDE_TABLE) {
            final HashMap exportFeatures = new HashMap();
            final ArrayList sectionContent = new ArrayList();
            String textFileFilterDescription = "Tab separated text file (.txt)";
            String gzipFileFilterDescription = "Gzipped tab separated text file (.gz)";
            String excelFileFilterDescription = "Excel Workbook (.xls)";
            String lastSelectedFolderPath = this.peptideShakerGUI.getLastSelectedFolder().getLastSelectedFolder();
            String exportName = "Export";
            switch (tableIndex.ordinal()) {
                case 0: {
                    exportName = "Protein table";
                    break;
                }
                case 1: {
                    exportName = "Peptide table";
                    break;
                }
            }
            FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile((Component)this, (String[])new String[]{".xls", ".txt", ".gz"}, (String[])new String[]{excelFileFilterDescription, textFileFilterDescription, gzipFileFilterDescription}, (String)"Export Report", (String)lastSelectedFolderPath, (String)exportName, (boolean)false, (boolean)true, (boolean)false, (int)1);
            if (selectedFileAndFilter != null) {
                boolean gzip;
                ExportFormat exportFormat;
                final File selectedFile2 = selectedFileAndFilter.getFile();
                if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = false;
                } else if (selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(gzipFileFilterDescription)) {
                    exportFormat = ExportFormat.text;
                    gzip = true;
                } else {
                    exportFormat = ExportFormat.excel;
                    gzip = false;
                }
                this.progressDialog = new ProgressDialogX((Frame)this.peptideShakerGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
                this.progressDialog.setTitle("Exporting Data. Please Wait...");
                final String filePath = selectedFile2.getPath();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProteinStructurePanel.this.progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        try {
                            switch (tableIndex.ordinal()) {
                                case 0: {
                                    sectionContent.add(PsProteinFeature.starred);
                                    sectionContent.add(PsProteinFeature.pi);
                                    sectionContent.add(PsProteinFeature.accession);
                                    sectionContent.add(PsProteinFeature.protein_description);
                                    sectionContent.add(PsProteinFeature.protein_group);
                                    sectionContent.add(PsProteinFeature.descriptions);
                                    sectionContent.add(PsProteinFeature.other_proteins);
                                    sectionContent.add(PsProteinFeature.chromosome);
                                    sectionContent.add(PsProteinFeature.coverage);
                                    sectionContent.add(PsProteinFeature.confident_coverage);
                                    sectionContent.add(PsProteinFeature.all_coverage);
                                    sectionContent.add(PsProteinFeature.possible_coverage);
                                    sectionContent.add(PsProteinFeature.validated_peptides);
                                    sectionContent.add(PsProteinFeature.peptides);
                                    sectionContent.add(PsProteinFeature.unique_peptides);
                                    sectionContent.add(PsProteinFeature.unique_validated_peptides);
                                    sectionContent.add(PsProteinFeature.validated_psms);
                                    sectionContent.add(PsProteinFeature.psms);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai);
                                    sectionContent.add(PsProteinFeature.label_free_quantification);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_percent);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_percent);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_percent);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_ppm);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_ppm);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_ppm);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_nsaf_fmol);
                                    sectionContent.add(PsProteinFeature.spectrum_counting_empai_fmol);
                                    sectionContent.add(PsProteinFeature.label_free_quantification_fmol);
                                    sectionContent.add(PsProteinFeature.mw);
                                    sectionContent.add(PsProteinFeature.confidence);
                                    sectionContent.add(PsProteinFeature.validated);
                                    exportFeatures.put("Protein Identification Summary", sectionContent);
                                    ExportScheme validatedProteinReport = new ExportScheme("Protein Table", false, exportFeatures, "\t", true, true, 0, false, false, false);
                                    PSExportFactory.writeExport(validatedProteinReport, selectedFile2, exportFormat, gzip, ProteinStructurePanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), ProteinStructurePanel.this.peptideShakerGUI.getProjectDetails(), ProteinStructurePanel.this.peptideShakerGUI.getIdentification(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinStructurePanel.this.peptideShakerGUI.getGeneMaps(), ProteinStructurePanel.this.getDisplayedProteins(), null, null, ProteinStructurePanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationParameters(), ProteinStructurePanel.this.peptideShakerGUI.getSequenceProvider(), ProteinStructurePanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSpectrumProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)ProteinStructurePanel.this.progressDialog);
                                    break;
                                }
                                case 1: {
                                    sectionContent.add(PsPeptideFeature.starred);
                                    sectionContent.add(PsPeptideFeature.pi);
                                    sectionContent.add(PsPeptideFeature.accessions);
                                    sectionContent.add(PsPeptideFeature.protein_description);
                                    sectionContent.add(PsPeptideFeature.protein_groups);
                                    sectionContent.add(PsPeptideFeature.sequence);
                                    sectionContent.add(PsPeptideFeature.modified_sequence);
                                    sectionContent.add(PsPeptideFeature.position);
                                    sectionContent.add(PsPeptideFeature.aaBefore);
                                    sectionContent.add(PsPeptideFeature.aaAfter);
                                    sectionContent.add(PsPeptideFeature.missed_cleavages);
                                    sectionContent.add(PsPeptideFeature.variable_ptms);
                                    sectionContent.add(PsPeptideFeature.fixed_ptms);
                                    sectionContent.add(PsPeptideFeature.psms);
                                    sectionContent.add(PsPeptideFeature.validated_psms);
                                    sectionContent.add(PsPeptideFeature.confidence);
                                    sectionContent.add(PsPeptideFeature.validated);
                                    exportFeatures.put("Peptide Identification Summary", sectionContent);
                                    ExportScheme validatedProteinReport = new ExportScheme("Peptide Table", false, exportFeatures, "\t", true, true, 0, false, false, false);
                                    PSExportFactory.writeExport(validatedProteinReport, selectedFile2, exportFormat, gzip, ProteinStructurePanel.this.peptideShakerGUI.getProjectParameters().getProjectUniqueName(), ProteinStructurePanel.this.peptideShakerGUI.getProjectDetails(), ProteinStructurePanel.this.peptideShakerGUI.getIdentification(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationFeaturesGenerator(), ProteinStructurePanel.this.peptideShakerGUI.getGeneMaps(), null, ProteinStructurePanel.this.getDisplayedPeptides(), null, ProteinStructurePanel.this.peptideShakerGUI.getDisplayParameters().getnAASurroundingPeptides(), ProteinStructurePanel.this.peptideShakerGUI.getIdentificationParameters(), ProteinStructurePanel.this.peptideShakerGUI.getSequenceProvider(), ProteinStructurePanel.this.peptideShakerGUI.getProteinDetailsProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSpectrumProvider(), ProteinStructurePanel.this.peptideShakerGUI.getSpectrumCountingParameters(), (WaitingHandler)ProteinStructurePanel.this.progressDialog);
                                    break;
                                }
                            }
                            boolean processCancelled = ProteinStructurePanel.this.progressDialog.isRunCanceled();
                            ProteinStructurePanel.this.progressDialog.setRunFinished();
                            if (!processCancelled) {
                                JOptionPane.showMessageDialog(ProteinStructurePanel.this.peptideShakerGUI, "Data copied to file:\n" + filePath, "Data Exported", 1);
                            }
                        }
                        catch (FileNotFoundException e) {
                            ProteinStructurePanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(ProteinStructurePanel.this.peptideShakerGUI, "An error occurred while generating the output. Please make sure that the destination file is not opened by another application.", "Output Error", 0);
                            e.printStackTrace();
                        }
                        catch (IllegalArgumentException e) {
                            if (e.getMessage().contains("Invalid row number (65536)")) {
                                ProteinStructurePanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(ProteinStructurePanel.this.peptideShakerGUI, "An error occurred while generating the output. This format can contain only 65,535 lines.\nPlease use a text export instead.", "Output Error", 0);
                                e.printStackTrace();
                            } else {
                                ProteinStructurePanel.this.progressDialog.setRunFinished();
                                JOptionPane.showMessageDialog(ProteinStructurePanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            ProteinStructurePanel.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(ProteinStructurePanel.this.peptideShakerGUI, "An error occurred while generating the output.", "Output Error", 0);
                            e.printStackTrace();
                        }
                    }
                }.start();
            }
        } else if ((tableIndex == TableIndex.PDB_MATCHES || tableIndex == TableIndex.PDB_CHAINS) && (selectedFile = this.peptideShakerGUI.getUserSelectedFile("pdb_details.txt", ".txt", "Tab separated text file (.txt)", "Export...", false)) != null) {
            if (tableIndex == TableIndex.PDB_CHAINS) {
                try (SimpleFileWriter writer = new SimpleFileWriter(selectedFile, false);){
                    writer.writeLine(new String[]{"", "Chain", "PDB-Start", "PDB-End", "Coverage"});
                    for (int i = 0; i < this.pdbChainsJTable.getRowCount(); ++i) {
                        XYDataPoint pdbCoverage = (XYDataPoint)this.pdbChainsJTable.getValueAt(i, 2);
                        writer.writeLine(new String[]{this.pdbChainsJTable.getValueAt(i, 0).toString(), this.pdbChainsJTable.getValueAt(i, 1).toString(), Double.toString(pdbCoverage.getX()), Double.toString(pdbCoverage.getY()), this.pdbChainsJTable.getValueAt(i, 3).toString()});
                    }
                    JOptionPane.showMessageDialog(this.peptideShakerGUI, "Data copied to file:\n" + selectedFile.getPath(), "Data Exported", 1);
                }
            }
            if (tableIndex == TableIndex.PDB_MATCHES) {
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));){
                    Util.tableToFile((JTable)this.pdbMatchesJTable, (String)"\t", null, (boolean)true, (BufferedWriter)writer);
                    JOptionPane.showMessageDialog(this.peptideShakerGUI, "Data copied to file:\n" + selectedFile.getPath(), "Data Exported", 1);
                }
            }
        }
    }

    private void reselect() {
        int peptideRow;
        int proteinRow;
        long proteinKey = this.peptideShakerGUI.getSelectedProteinKey();
        long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
        if (proteinKey != ExperimentObject.NO_KEY && (proteinRow = this.getProteinRow(proteinKey)) != -1 && proteinRow < this.proteinTable.getRowCount()) {
            this.proteinTable.setRowSelectionInterval(proteinRow, proteinRow);
        }
        if (peptideKey != ExperimentObject.NO_KEY && (peptideRow = this.getPeptideRow(peptideKey)) != -1) {
            this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
        }
    }

    public void updateSelection(boolean scrollToVisible) {
        long psmKey;
        SpectrumMatch spectrumMatch;
        int proteinRow = 0;
        long proteinKey = this.peptideShakerGUI.getSelectedProteinKey();
        long peptideKey = this.peptideShakerGUI.getSelectedPeptideKey();
        String spectrumFile = this.peptideShakerGUI.getSelectedSpectrumFile();
        String spectrumTitle = this.peptideShakerGUI.getSelectedSpectrumTitle();
        Identification identification = this.peptideShakerGUI.getIdentification();
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey == ExperimentObject.NO_KEY && spectrumFile != null && spectrumTitle != null && (spectrumMatch = identification.getSpectrumMatch(psmKey = SpectrumMatch.getKey((String)spectrumFile, (String)spectrumTitle))) != null && spectrumMatch.getBestPeptideAssumption() != null) {
            Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
            peptideKey = peptide.getMatchingKey(this.peptideShakerGUI.getIdentificationParameters().getSequenceMatchingParameters());
        }
        if (proteinKey == ExperimentObject.NO_KEY && peptideKey != ExperimentObject.NO_KEY) {
            long peptideKeyFinal = peptideKey;
            ProteinMatch tempProteinMatch = identification.getProteinIdentification().parallelStream().map(key -> identification.getProteinMatch(key.longValue())).filter(proteinMatch -> Arrays.stream(proteinMatch.getPeptideMatchesKeys()).anyMatch(key -> key == peptideKeyFinal)).findAny().orElse(null);
            if (tempProteinMatch != null) {
                proteinKey = tempProteinMatch.getKey();
                this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
            }
            if (proteinKey != ExperimentObject.NO_KEY) {
                proteinRow = this.getProteinRow(proteinKey);
            }
            if (this.proteinKeys.length == 0) {
                this.clearData();
                return;
            }
            if (proteinRow == -1) {
                this.peptideShakerGUI.resetSelectedItems();
                this.proteinTableMouseReleased(null);
            } else if (this.proteinTable.getSelectedRow() != proteinRow) {
                this.proteinTable.setRowSelectionInterval(proteinRow, proteinRow);
                if (scrollToVisible) {
                    this.proteinTable.scrollRectToVisible(this.proteinTable.getCellRect(proteinRow, 0, false));
                }
                this.proteinTableMouseReleased(null);
            }
            int peptideRow = 0;
            if (peptideKey != ExperimentObject.NO_KEY) {
                peptideRow = this.getPeptideRow(peptideKey);
            }
            if (this.peptideTable.getSelectedRow() != peptideRow && peptideRow != -1) {
                this.peptideTable.setRowSelectionInterval(peptideRow, peptideRow);
                if (scrollToVisible) {
                    this.peptideTable.scrollRectToVisible(this.peptideTable.getCellRect(peptideRow, 0, false));
                }
                this.peptideTableMouseReleased(null);
            }
            if (spectrumFile != null && spectrumTitle != null) {
                this.peptideShakerGUI.setSelectedItems(this.peptideShakerGUI.getSelectedProteinKey(), this.peptideShakerGUI.getSelectedPeptideKey(), spectrumFile, spectrumTitle);
            }
        }
    }

    public void newItemSelection() {
        long proteinKey = ExperimentObject.NO_KEY;
        long peptideKey = ExperimentObject.NO_KEY;
        String spectrumFile = null;
        String spectrumTitle = null;
        if (this.proteinTable.getSelectedRow() != -1) {
            SelfUpdatingTableModel tableModel = (SelfUpdatingTableModel)this.proteinTable.getModel();
            int proteinIndex = tableModel.getViewIndex(this.proteinTable.getSelectedRow());
            proteinKey = this.proteinKeys[proteinIndex];
        }
        if (this.peptideTable.getSelectedRow() != -1) {
            peptideKey = this.peptideTableMap.get(this.getPeptideIndex(this.peptideTable.getSelectedRow()));
        }
        if (proteinKey != this.peptideShakerGUI.getSelectedProteinKey() || peptideKey != this.peptideShakerGUI.getSelectedPeptideKey()) {
            long psmKey = this.peptideShakerGUI.getDefaultPsmSelection(peptideKey);
            SpectrumMatch spectrumMatch = this.peptideShakerGUI.getIdentification().getSpectrumMatch(psmKey);
            spectrumFile = spectrumMatch.getSpectrumFile();
            spectrumTitle = spectrumMatch.getSpectrumTitle();
        }
        this.peptideShakerGUI.setSelectedItems(proteinKey, peptideKey, spectrumFile, spectrumTitle);
    }

    private int getProteinRow(long proteinKey) {
        int modelIndex = IntStream.range(0, this.proteinKeys.length).filter(i -> this.proteinKeys[i] == proteinKey).findAny().orElse(-1);
        return modelIndex == -1 ? -1 : ((SelfUpdatingTableModel)this.proteinTable.getModel()).getRowNumber(modelIndex);
    }

    private int getPeptideRow(long peptideKey) {
        int index = -1;
        for (int key : this.peptideTableMap.keySet()) {
            if (!this.peptideTableMap.get(key).equals(peptideKey)) continue;
            index = key;
            break;
        }
        for (int row = 0; row < this.peptideTable.getRowCount(); ++row) {
            if ((Integer)this.peptideTable.getValueAt(row, 0) != index) continue;
            return row;
        }
        return -1;
    }

    public void clearData() {
        DefaultTableModel dm = (DefaultTableModel)this.proteinTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.peptideTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.pdbMatchesJTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        dm = (DefaultTableModel)this.pdbChainsJTable.getModel();
        dm.getDataVector().removeAllElements();
        dm.fireTableDataChanged();
        this.peptideTableMap = new HashMap();
        this.peptidePdbArray = new ArrayList();
        this.currentlyDisplayedPdbFile = null;
        if (this.jmolStructureShown) {
            this.jmolPanel = new JmolPanel();
            this.pdbPanel.removeAll();
            this.pdbPanel.add(this.jmolPanel);
            this.pdbPanel.revalidate();
            this.pdbPanel.repaint();
            this.jmolStructureShown = false;
            this.currentlyDisplayedPdbFile = null;
            ((TitledBorder)this.pdbOuterPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "PDB Structure" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
            this.pdbOuterPanel.repaint();
        }
        ((TitledBorder)this.proteinsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Proteins" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.peptidesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptides" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.pdbMatchesPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Peptide Spectrum Matches" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
        ((TitledBorder)this.pdbChainsPanel.getBorder()).setTitle(PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING + "Spectrum & Fragment Ions" + PeptideShakerGUI.TITLED_BORDER_HORIZONTAL_PADDING);
    }

    private void updateProteinTableCellRenderers() {
        if (this.peptideShakerGUI.getIdentification() != null) {
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Peptides").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPeptides().intValue());
            ((JSparklinesArrayListBarChartTableCellRenderer)this.proteinTable.getColumn("#Spectra").getCellRenderer()).setMaxValue((double)this.peptideShakerGUI.getMetrics().getMaxNPsms().intValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("Quant").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxSpectrumCounting().doubleValue());
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn("MW").getCellRenderer()).setMaxValue(this.peptideShakerGUI.getMetrics().getMaxMW().doubleValue());
            String scoreColumnName = this.proteinTable.getColumnName(11);
            ((JSparklinesBarChartTableCellRenderer)this.proteinTable.getColumn(scoreColumnName).getCellRenderer()).setMaxValue(100.0);
            this.showSparkLines(this.peptideShakerGUI.showSparklines());
        }
    }

    public void selfUpdating(boolean selfUpdating) {
        if (this.proteinTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.proteinTable.getModel()).setSelfUpdating(selfUpdating);
        }
        if (this.peptideTable.getModel() instanceof SelfUpdatingTableModel) {
            ((SelfUpdatingTableModel)this.peptideTable.getModel()).setSelfUpdating(selfUpdating);
        }
    }

    static /* synthetic */ PdbBlock[] access$7302(ProteinStructurePanel x0, PdbBlock[] x1) {
        x0.chains = x1;
        return x1;
    }

    static /* synthetic */ long[] access$8402(ProteinStructurePanel x0, long[] x1) {
        x0.proteinKeys = x1;
        return x1;
    }

    public class JmolPanel
    extends JPanel {
        private final JmolViewer viewer;
        private final Dimension currentSize = new Dimension();
        private final Rectangle rectClip = new Rectangle();

        JmolPanel() {
            SmarterJmolAdapter adapter = new SmarterJmolAdapter();
            this.viewer = JmolViewer.allocateViewer((Component)this, (JmolAdapter)adapter);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        public void executeCmd(String rasmolScript) {
            this.viewer.evalString(rasmolScript);
        }

        @Override
        public void paint(Graphics g) {
            this.getSize(this.currentSize);
            g.getClipBounds(this.rectClip);
            this.viewer.renderScreenImage(g, this.currentSize, this.rectClip);
        }
    }

    private static enum TableIndex {
        PROTEIN_TABLE,
        PEPTIDE_TABLE,
        PDB_MATCHES,
        PDB_CHAINS;

    }
}

