/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.processing;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.modifications.ModificationProvider;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.protein_inference.PeptideChecker;
import eu.isas.peptideshaker.ptm.ModificationLocalizationScorer;
import eu.isas.peptideshaker.scoring.maps.InputMap;
import eu.isas.peptideshaker.scoring.psm_scoring.BestMatchSelection;
import eu.isas.peptideshaker.validation.MatchesValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PsmProcessorRunnable
implements Runnable {
    private final ConcurrentLinkedQueue<Long> spectrumMatchKeysQueue;
    private final Identification identification;
    private final IdentificationParameters identificationParameters;
    private final InputMap inputMap;
    private final BestMatchSelection bestMatchSelection;
    private final MatchesValidator matchesValidator;
    private final ModificationLocalizationScorer modificationLocalizationScorer;
    private final SequenceProvider sequenceProvider;
    private final SpectrumProvider spectrumProvider;
    private final ModificationProvider modificationProvider;
    private final PeptideSpectrumAnnotator peptideSpectrumAnnotator = new PeptideSpectrumAnnotator();
    private final WaitingHandler waitingHandler;
    private final ExceptionHandler exceptionHandler;

    public PsmProcessorRunnable(ConcurrentLinkedQueue<Long> spectrumMatchKeysIterator, Identification identification, IdentificationParameters identificationParameters, InputMap inputMap, MatchesValidator matchesValidator, ModificationLocalizationScorer modificationLocalizationScorer, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ModificationProvider modificationProvider, HashMap<String, Integer> proteinCount, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.spectrumMatchKeysQueue = spectrumMatchKeysIterator;
        this.identification = identification;
        this.identificationParameters = identificationParameters;
        this.inputMap = inputMap;
        this.matchesValidator = matchesValidator;
        this.modificationLocalizationScorer = modificationLocalizationScorer;
        this.sequenceProvider = sequenceProvider;
        this.spectrumProvider = spectrumProvider;
        this.modificationProvider = modificationProvider;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.bestMatchSelection = new BestMatchSelection(proteinCount, sequenceProvider, spectrumProvider, identificationParameters, this.peptideSpectrumAnnotator);
    }

    @Override
    public void run() {
        try {
            Long spectrumMatchKey;
            while ((spectrumMatchKey = this.spectrumMatchKeysQueue.poll()) != null) {
                this.processPsm(spectrumMatchKey);
                if (this.waitingHandler.isRunCanceled()) {
                    return;
                }
                this.waitingHandler.increaseSecondaryProgressCounter();
            }
        }
        catch (Exception e) {
            this.waitingHandler.setRunCanceled();
            this.exceptionHandler.catchException(e);
        }
    }

    private void processPsm(long spectrumMatchKey) {
        if (this.waitingHandler.isRunCanceled()) {
            return;
        }
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getModificationLocalizationParameters().getSequenceMatchingParameters();
        SpectrumMatch spectrumMatch = this.identification.getSpectrumMatch(spectrumMatchKey);
        this.attachAssumptionsProbabilities(spectrumMatch);
        this.bestMatchSelection.selectBestHit(spectrumMatch, this.inputMap, this.matchesValidator.getPsmMap(), this.identification);
        if (spectrumMatch.getBestPeptideAssumption() != null) {
            this.modificationLocalizationScorer.scorePTMs(this.identification, spectrumMatch, this.sequenceProvider, this.spectrumProvider, this.modificationProvider, this.identificationParameters, this.waitingHandler, this.peptideSpectrumAnnotator);
            this.modificationLocalizationScorer.modificationSiteInference(spectrumMatch, this.sequenceProvider, this.modificationProvider, this.identificationParameters);
            spectrumMatch.getBestPeptideAssumption().getPeptide().getIndexedVariableModifications();
            spectrumMatch.getAllPeptideAssumptions().forEach(peptideAssumption -> peptideAssumption.getPeptide().getIndexedVariableModifications());
            if (this.identificationParameters.getProteinInferenceParameters().isModificationRefinement()) {
                spectrumMatch.getAllPeptideAssumptions().forEach(peptideAssumption -> PeptideChecker.checkPeptide(peptideAssumption.getPeptide(), this.sequenceProvider, modificationSequenceMatchingParameters));
            }
        }
    }

    private void attachAssumptionsProbabilities(SpectrumMatch spectrumMatch) {
        FastaParameters fastaParameters = this.identificationParameters.getFastaParameters();
        SequenceMatchingParameters sequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        HashMap peptideAssumptionsMap = spectrumMatch.getPeptideAssumptionsMap();
        TreeMap<Double, ArrayList<PSParameter>> pepToParameterMap = new TreeMap<Double, ArrayList<PSParameter>>();
        for (Map.Entry entry : peptideAssumptionsMap.entrySet()) {
            int searchEngine = (Integer)entry.getKey();
            Iterator seMapping = (TreeMap)entry.getValue();
            double d = 0.0;
            ArrayList<PSParameter> previousAssumptionsParameters = new ArrayList<PSParameter>(2);
            PeptideAssumption previousAssumption = null;
            for (Map.Entry entry2 : ((TreeMap)((Object)seMapping)).entrySet()) {
                double eValue = (Double)entry2.getKey();
                ArrayList peptideAssumptions = (ArrayList)entry2.getValue();
                for (PeptideAssumption assumption : peptideAssumptions) {
                    PSParameter psParameter = (PSParameter)assumption.getUrParam((UrParameter)PSParameter.dummy);
                    if (psParameter == null) {
                        psParameter = new PSParameter();
                    }
                    if (fastaParameters.isTargetDecoy()) {
                        Peptide previousPeptide;
                        Peptide newPeptide;
                        double newP = this.inputMap.getProbability(searchEngine, eValue);
                        double pep = d;
                        if (newP > d) {
                            pep = newP;
                            d = newP;
                        }
                        psParameter.setProbability(pep);
                        ArrayList<PSParameter> pSParameters = (ArrayList<PSParameter>)pepToParameterMap.get(pep);
                        if (pSParameters == null) {
                            pSParameters = new ArrayList<PSParameter>(1);
                            pepToParameterMap.put(pep, pSParameters);
                        }
                        pSParameters.add(psParameter);
                        if (previousAssumption != null && !(newPeptide = assumption.getPeptide()).isSameSequenceAndModificationStatus(previousPeptide = previousAssumption.getPeptide(), sequenceMatchingParameters)) {
                            for (PSParameter previousParameter : previousAssumptionsParameters) {
                                double deltaPEP = pep - previousParameter.getProbability();
                                previousParameter.setAlgorithmDeltaPEP(deltaPEP);
                            }
                            previousAssumptionsParameters.clear();
                        }
                        previousAssumption = assumption;
                        previousAssumptionsParameters.add(psParameter);
                    } else {
                        psParameter.setProbability(1.0);
                    }
                    assumption.addUrParam((UrParameter)psParameter);
                }
            }
            for (PSParameter previousParameter : previousAssumptionsParameters) {
                double deltaPEP = 1.0 - previousParameter.getProbability();
                previousParameter.setAlgorithmDeltaPEP(deltaPEP);
            }
        }
        double previousPEP = Double.NaN;
        ArrayList previousParameters = new ArrayList();
        for (Map.Entry entry : pepToParameterMap.entrySet()) {
            double pep = (Double)entry.getKey();
            if (!Double.isNaN(previousPEP)) {
                for (PSParameter previousParameter : previousParameters) {
                    double delta = pep - previousPEP;
                    previousParameter.setDeltaPEP(delta);
                }
            }
            previousParameters = (ArrayList)entry.getValue();
            previousPEP = pep;
        }
        for (PSParameter pSParameter : previousParameters) {
            double delta = 1.0 - pSParameter.getProbability();
            pSParameter.setDeltaPEP(delta);
        }
        if (this.waitingHandler.isRunCanceled()) {
            return;
        }
        HashMap tagAssumptionsMap = spectrumMatch.getTagAssumptionsMap();
        for (Map.Entry entry : tagAssumptionsMap.entrySet()) {
            int algorithm = (Integer)entry.getKey();
            TreeMap seMapping = (TreeMap)entry.getValue();
            double previousP = 0.0;
            ArrayList<PSParameter> previousAssumptionsParameters = new ArrayList<PSParameter>();
            TagAssumption previousAssumption = null;
            for (Map.Entry entry2 : seMapping.entrySet()) {
                double score = (Double)entry2.getKey();
                for (TagAssumption assumption : (ArrayList)entry2.getValue()) {
                    PSParameter psParameter = (PSParameter)assumption.getUrParam((UrParameter)PSParameter.dummy);
                    if (psParameter == null) {
                        psParameter = new PSParameter();
                    }
                    if (fastaParameters.isTargetDecoy()) {
                        double newP = this.inputMap.getProbability(algorithm, score);
                        double pep = previousP;
                        if (newP > previousP) {
                            pep = newP;
                            previousP = newP;
                        }
                        psParameter.setProbability(pep);
                        ArrayList<PSParameter> pSParameters = (ArrayList<PSParameter>)pepToParameterMap.get(pep);
                        if (pSParameters == null) {
                            pSParameters = new ArrayList<PSParameter>(1);
                            pepToParameterMap.put(pep, pSParameters);
                        }
                        pSParameters.add(psParameter);
                        if (previousAssumption != null) {
                            Tag previousTag;
                            boolean same = false;
                            Tag newTag = assumption.getTag();
                            if (newTag.isSameSequenceAndModificationStatusAs(previousTag = previousAssumption.getTag(), sequenceMatchingParameters)) {
                                same = true;
                            }
                            if (!same) {
                                for (PSParameter previousParameter : previousAssumptionsParameters) {
                                    double deltaPEP = pep - previousParameter.getProbability();
                                    previousParameter.setAlgorithmDeltaPEP(deltaPEP);
                                }
                                previousAssumptionsParameters.clear();
                            }
                        }
                        previousAssumption = assumption;
                        previousAssumptionsParameters.add(psParameter);
                    } else {
                        psParameter.setProbability(1.0);
                    }
                    assumption.addUrParam((UrParameter)psParameter);
                }
            }
            for (PSParameter previousParameter : previousAssumptionsParameters) {
                double deltaPEP = 1.0 - previousParameter.getProbability();
                previousParameter.setAlgorithmDeltaPEP(deltaPEP);
            }
        }
    }
}

