/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.protein_inference;

import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.modifications.ModificationType;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class PeptideChecker {
    public static void checkPeptide(Peptide peptide, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationMatchingParameters) {
        ModificationFactory modificationFactory = ModificationFactory.getInstance();
        ModificationMatch[] variableModifications = peptide.getVariableModifications();
        TreeMap<String, int[]> proteinMapping = peptide.getProteinMapping();
        for (ModificationMatch modificationMatch : variableModifications) {
            if (!modificationMatch.getConfident() && !modificationMatch.getInferred()) continue;
            Modification modification = modificationFactory.getModification(modificationMatch.getModification());
            ModificationType modificationType = modification.getModificationType();
            if (modificationType == ModificationType.modn_protein || modificationType == ModificationType.modnaa_protein) {
                proteinMapping = PeptideChecker.getNTermMapping(proteinMapping);
            } else if (modificationType == ModificationType.modc_protein || modificationType == ModificationType.modcaa_protein) {
                proteinMapping = PeptideChecker.getCTermMapping(proteinMapping, peptide.getSequence().length(), sequenceProvider);
            }
            if (modification.getPattern().length() <= 0) continue;
            proteinMapping = PeptideChecker.getPatternMapping(proteinMapping, modificationMatch, modification, peptide.getSequence().length(), sequenceProvider, modificationMatchingParameters);
        }
        peptide.setProteinMapping((TreeMap)proteinMapping);
    }

    private static TreeMap<String, int[]> getNTermMapping(TreeMap<String, int[]> proteinMapping) {
        TreeMap<String, int[]> cleanedProteinMapping = new TreeMap<String, int[]>();
        for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
            if (!Arrays.stream(entry.getValue()).anyMatch(site -> site == 0)) continue;
            cleanedProteinMapping.put(entry.getKey(), new int[]{0});
        }
        return cleanedProteinMapping;
    }

    private static TreeMap<String, int[]> getCTermMapping(TreeMap<String, int[]> proteinMapping, int peptideLength, SequenceProvider sequenceProvider) {
        TreeMap<String, int[]> cleanedProteinMapping = new TreeMap<String, int[]>();
        for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
            String proteinAccession = entry.getKey();
            int peptideStart = sequenceProvider.getSequence(proteinAccession).length() - peptideLength;
            if (!Arrays.stream(entry.getValue()).anyMatch(site -> site == peptideStart)) continue;
            cleanedProteinMapping.put(proteinAccession, new int[]{peptideStart});
        }
        return cleanedProteinMapping;
    }

    private static TreeMap<String, int[]> getPatternMapping(TreeMap<String, int[]> proteinMapping, ModificationMatch modificationMatch, Modification modification, int peptideLength, SequenceProvider sequenceProvider, SequenceMatchingParameters modificationMatchingParameters) {
        TreeMap<String, int[]> cleanedProteinMapping = new TreeMap<String, int[]>();
        for (Map.Entry<String, int[]> entry : proteinMapping.entrySet()) {
            String proteinAccession = entry.getKey();
            String proteinSequence = sequenceProvider.getSequence(proteinAccession);
            int[] sequenceStart = entry.getValue();
            int[] peptideStart = Arrays.stream(sequenceStart).filter(aa -> PeptideChecker.validSite(proteinSequence, aa, modificationMatch.getSite(), peptideLength, modification.getPattern(), modificationMatchingParameters)).toArray();
            if (peptideStart.length <= 0) continue;
            cleanedProteinMapping.put(proteinAccession, peptideStart);
        }
        return cleanedProteinMapping;
    }

    private static boolean validSite(String proteinSequence, int peptideStart, int modificationSite, int peptideLength, AminoAcidPattern aminoAcidPattern, SequenceMatchingParameters modificationMatchingParameters) {
        if (modificationSite == 0) {
            modificationSite = 1;
        } else if (modificationSite == peptideLength + 1) {
            modificationSite = peptideLength;
        }
        int siteOnProtein = peptideStart + modificationSite - 1;
        return aminoAcidPattern.matchesAt(proteinSequence, modificationMatchingParameters, siteOnProtein);
    }
}

