/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.recalibration;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.RecalibrationUtils;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.recalibration.RunMzDeviation;
import java.util.HashMap;

public class SpectrumRecalibrator {
    private final HashMap<String, RunMzDeviation> runMzDeviationMap = new HashMap();

    public void clearErrors(String spectrumFileName) {
        this.runMzDeviationMap.remove(spectrumFileName);
    }

    public RunMzDeviation getRunMzDeviations(String spectrumFileName) {
        return this.runMzDeviationMap.get(spectrumFileName);
    }

    public void estimateErrors(String spectrumFileNameWithoutExtension, Identification identification, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, IdentificationParameters identificationParameters, WaitingHandler waitingHandler) {
        RunMzDeviation fileErrors = new RunMzDeviation(spectrumFileNameWithoutExtension, identification, sequenceProvider, spectrumProvider, identificationParameters, waitingHandler);
        this.runMzDeviationMap.put(spectrumFileNameWithoutExtension, fileErrors);
    }

    public Spectrum recalibrateSpectrum(String fileName, String spectrumTitle, SpectrumProvider spectrumProvider, boolean recalibratePrecursor, boolean recalibrateFragmentIons) {
        RunMzDeviation runError = this.runMzDeviationMap.get(fileName);
        if (runError == null) {
            throw new IllegalArgumentException("No m/z deviation statistics found for spectrum file " + fileName + ".");
        }
        Spectrum originalSpectrum = spectrumProvider.getSpectrum(fileName, spectrumTitle);
        double mzCorrection = recalibratePrecursor ? runError.getPrecursorMzCorrection(originalSpectrum.precursor.mz, originalSpectrum.precursor.rt) : 0.0;
        Precursor newPrecursor = RecalibrationUtils.getRecalibratedPrecursor((Precursor)originalSpectrum.precursor, (double)mzCorrection, (double)0.0);
        double[] newFragmentMz = recalibrateFragmentIons ? runError.recalibrateFragmentMz(originalSpectrum.precursor.rt, originalSpectrum.mz) : originalSpectrum.mz;
        return new Spectrum(newPrecursor, newFragmentMz, originalSpectrum.intensity, originalSpectrum.getSpectrumLevel());
    }
}

