/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.peptideshaker.utils;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidPattern;
import com.compomics.util.experiment.biology.aminoacids.sequence.AminoAcidSequence;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.amino_acid_tags.Tag;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSModificationScores;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.identification.utils.ProteinUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDatabase;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.personalization.UrParameter;
import com.compomics.util.gui.TableProperties;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import eu.isas.peptideshaker.gui.protein_sequence.ResidueAnnotation;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;

public class DisplayFeaturesGenerator {
    private final DisplayParameters displayParameters;
    private final IdentificationParameters identificationParameters;
    private final String notSelectedRowHtmlTagFontColor = TableProperties.getNotSelectedRowHtmlTagFontColor();
    private final SequenceProvider sequenceProvider;
    private final ProteinDetailsProvider proteinDetailsProvider;

    public DisplayFeaturesGenerator(IdentificationParameters identificationParameters, DisplayParameters displayParameters, SequenceProvider sequenceProvider, ProteinDetailsProvider proteinDetailsProvider) {
        this.identificationParameters = identificationParameters;
        this.displayParameters = displayParameters;
        this.sequenceProvider = sequenceProvider;
        this.proteinDetailsProvider = proteinDetailsProvider;
    }

    public String getDatabaseLink(String proteinAccession) {
        return this.getDatabaseLink(proteinAccession, true, false);
    }

    public String getDatabaseLink(String proteinAccession, boolean includeHtmlTags, boolean underlineLink) {
        String result;
        if (ProteinUtils.isDecoy((String)proteinAccession, (SequenceProvider)this.sequenceProvider)) {
            return proteinAccession;
        }
        ProteinDatabase proteinDatabase = this.proteinDetailsProvider.getProteinDatabase(proteinAccession);
        String underLineTag = "";
        if (!underlineLink) {
            underLineTag = " style=\"text-decoration: none\"";
        }
        switch (proteinDatabase) {
            case IPI: 
            case UniProt: {
                result = String.join((CharSequence)"", "<a href=\"", this.getUniProtAccessionLink(proteinAccession), "\"", underLineTag, "><font color=\"", this.notSelectedRowHtmlTagFontColor, "\">", proteinAccession, "</font></a>");
                break;
            }
            case NextProt: {
                result = String.join((CharSequence)"", "<a href=\"", this.getNextProtAccessionLink(proteinAccession), "\"", underLineTag, "><font color=\"", this.notSelectedRowHtmlTagFontColor, "\">", proteinAccession, "</font></a>");
                break;
            }
            case NCBI_old: 
            case NCBI_new: {
                result = String.join((CharSequence)"", "<a href=\"", this.getNcbiAccessionLink(proteinAccession), "\"", underLineTag, "><font color=\"", this.notSelectedRowHtmlTagFontColor, "\">", proteinAccession, "</font></a>");
                break;
            }
            case UniRef: {
                String uniProtProteinAccession = proteinAccession.substring(proteinAccession.indexOf("_") + 1);
                result = String.join((CharSequence)"", "<a href=\"" + this.getUniProtAccessionLink(uniProtProteinAccession), "\"", underLineTag, "><font color=\"" + this.notSelectedRowHtmlTagFontColor + "\">", proteinAccession, "</font></a>");
                break;
            }
            default: {
                result = proteinAccession;
            }
        }
        if (includeHtmlTags) {
            result = "<html>" + result + "</html>";
        }
        return result;
    }

    public String getDatabaseLinks(String[] proteinAccessions) {
        return this.getDatabaseLinks(proteinAccessions, false);
    }

    public String getDatabaseLinks(String[] proteinAccessions, boolean underlineLink) {
        String result = proteinAccessions.length == 0 ? "" : Arrays.stream(proteinAccessions).sorted().map(accession -> this.getDatabaseLink((String)accession, false, underlineLink)).collect(Collectors.joining(", "));
        result = "<html>" + result + "</html>";
        return result;
    }

    public String getSrsAccessionLink(String proteinAccession, String database) {
        return String.join((CharSequence)"", "https://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-e+%5b", database, "-AccNumber:", proteinAccession, "%5d");
    }

    public String getUniProtAccessionLink(String proteinAccession) {
        return "https://www.uniprot.org/uniprot/" + proteinAccession;
    }

    public String getNextProtAccessionLink(String proteinAccession) {
        proteinAccession = proteinAccession.substring(0, proteinAccession.lastIndexOf("-"));
        return "https://www.nextprot.org/db/entry/" + proteinAccession;
    }

    public String getNcbiAccessionLink(String proteinAccession) {
        return "https://www.ncbi.nlm.nih.gov/protein/" + proteinAccession;
    }

    public static String getPrideAccessionLink(String projectAccession) {
        return "https://www.ebi.ac.uk/pride/directLink.do?experimentAccessionNumber=" + projectAccession;
    }

    public static String getPrideProjectArchiveLink(String projectAccession) {
        return "https://www.ebi.ac.uk/pride/archive/projects/" + projectAccession;
    }

    public static String getPrideAssayArchiveLink(String projectAccession, String assayAccession) {
        return String.join((CharSequence)"", "https://www.ebi.ac.uk/pride/archive/projects/", projectAccession, "/assays/", assayAccession);
    }

    public String getPeptideModificationTooltipAsHtml(SpectrumMatch spectrumMatch) {
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        return this.getPeptideModificationTooltipAsHtml(peptide, modificationScores);
    }

    public String getPeptideModificationTooltipAsHtml(PeptideMatch peptideMatch) {
        Peptide peptide = peptideMatch.getPeptide();
        PSModificationScores modificationScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        return this.getPeptideModificationTooltipAsHtml(peptide, modificationScores);
    }

    public String getPeptideModificationTooltipAsHtml(Peptide peptide, PSModificationScores modificationScores) {
        String peptideSequence = peptide.getSequence();
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        HashSet<String> displayedModifications = this.displayParameters.getDisplayedModifications();
        String[] fixedModifications = DisplayFeaturesGenerator.getDisplayedModifications(peptide.getFixedModifications(modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters), displayedModifications);
        String[] confidentVariableModifications = DisplayFeaturesGenerator.getFilteredConfidentModificationsSites(peptide, displayedModifications);
        String[] ambiguousVariableModifications = DisplayFeaturesGenerator.getFilteredAmbiguousModifications(peptide, displayedModifications);
        return this.getModificationToolTip(peptideSequence, fixedModifications, confidentVariableModifications, ambiguousVariableModifications);
    }

    public static String[] getDisplayedModifications(String[] modificationArray, HashSet<String> displayedModifications) {
        String[] result = new String[modificationArray.length];
        for (int i = 0; i < modificationArray.length; ++i) {
            String modName = modificationArray[i];
            if (modName == null || !displayedModifications.contains(modName)) continue;
            result[i] = modName;
        }
        return result;
    }

    public String getPeptideModificationTooltipAsHtml(Peptide peptide) {
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        HashSet<String> displayedModifications = this.displayParameters.getDisplayedModifications();
        String[] fixedModifications = DisplayFeaturesGenerator.getDisplayedModifications(peptide.getFixedModifications(modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters), displayedModifications);
        String[] confidentVariableModifications = DisplayFeaturesGenerator.getFilteredConfidentModificationsSites(peptide, displayedModifications);
        String[] ambiguousVariableModifications = DisplayFeaturesGenerator.getFilteredAmbiguousModifications(peptide, displayedModifications);
        return this.getModificationToolTip(peptide.getSequence(), fixedModifications, confidentVariableModifications, ambiguousVariableModifications);
    }

    private String getModificationToolTip(String peptideSequence, String[] fixedModifications, String[] confidentLocations, String[] representativeAmbiguousLocations) {
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>");
        for (int aa = 1; aa <= peptideSequence.length(); ++aa) {
            int aaIndex = aa - 1;
            char aminoAcid = peptideSequence.charAt(aaIndex);
            String fixedMod = fixedModifications[aa];
            String confidentMod = confidentLocations[aa];
            String ambiguousMod = representativeAmbiguousLocations[aa];
            if (fixedMod == null && confidentMod == null && ambiguousMod == null) continue;
            ModificationUtils.appendTaggedResidue((StringBuilder)tooltip, (char)aminoAcid, (String)confidentMod, (String)ambiguousMod, null, (String)fixedMod, (ModificationParameters)modificationParameters, (boolean)true, (boolean)true);
            tooltip.append(": ");
            if (fixedMod != null) {
                tooltip.append(fixedMod).append(" (fixed)<br>");
            }
            if (confidentMod != null) {
                tooltip.append(confidentMod).append(" (confident)<br>");
            }
            if (ambiguousMod == null) continue;
            tooltip.append(ambiguousMod).append(" (not confident)<br>");
        }
        tooltip.append("</html>");
        return tooltip.length() == 13 ? null : tooltip.toString();
    }

    public String getTagModificationTooltipAsHtml(Tag tag) {
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        StringBuilder tooltip = new StringBuilder();
        tooltip.append("<html>");
        ArrayList<String> alreadyAnnotated = new ArrayList<String>();
        ArrayList tagComponents = tag.getContent();
        boolean modified = false;
        for (int i = 0; i < tagComponents.size(); ++i) {
            TagComponent tagComponent = (TagComponent)tagComponents.get(i);
            if (!(tagComponent instanceof AminoAcidSequence)) continue;
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
            String[] fixedMods = aminoAcidSequence.getFixedModifications(i == 0, i == tagComponents.size() - 1, modificationParameters, modificationSequenceMatchingParameters);
            String[] variableMods = aminoAcidSequence.getIndexedVariableModifications();
            for (int aa = 1; aa <= aminoAcidSequence.length(); ++aa) {
                int aaIndex = aa - 1;
                char aminoAcid = aminoAcidSequence.charAt(aaIndex);
                String fixedMod = fixedMods[aa];
                String confidentMod = variableMods[aa];
                if (fixedMod == null && confidentMod == null) continue;
                modified = true;
                StringBuilder tempTooltip = new StringBuilder();
                ModificationUtils.appendTaggedResidue((StringBuilder)tooltip, (char)aminoAcid, (String)confidentMod, null, null, (String)fixedMod, (ModificationParameters)modificationParameters, (boolean)true, (boolean)true);
                String currentResidueAnnotation = tempTooltip.toString();
                if (alreadyAnnotated.contains(currentResidueAnnotation)) continue;
                tooltip.append(currentResidueAnnotation).append(": ");
                if (fixedMod != null) {
                    tooltip.append(fixedMod).append(" (fixed)<br>");
                }
                if (confidentMod != null) {
                    tooltip.append(confidentMod).append(" (confident)<br>");
                }
                alreadyAnnotated.add(tempTooltip.toString());
            }
        }
        tooltip.append("</html>");
        if (!modified) {
            return null;
        }
        return tooltip.toString();
    }

    public String getTaggedPeptideSequence(PeptideMatch peptideMatch, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        Peptide peptide = peptideMatch.getPeptide();
        PSModificationScores modificationScores = (PSModificationScores)peptideMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        return this.getTaggedPeptideSequence(peptide, modificationScores, useHtmlColorCoding, includeHtmlStartEndTags, useShortName);
    }

    public String getTaggedPeptideSequence(SpectrumMatch spectrumMatch, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        Peptide peptide = spectrumMatch.getBestPeptideAssumption().getPeptide();
        PSModificationScores modificationScores = (PSModificationScores)spectrumMatch.getUrParam((UrParameter)PSModificationScores.dummy);
        return this.getTaggedPeptideSequence(peptide, modificationScores, useHtmlColorCoding, includeHtmlStartEndTags, useShortName);
    }

    public String getTaggedPeptideSequence(Peptide peptide, PSModificationScores modificationScores, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName) {
        ModificationParameters modificationParameters = this.identificationParameters.getSearchParameters().getModificationParameters();
        SequenceMatchingParameters modificationSequenceMatchingParameters = this.identificationParameters.getSequenceMatchingParameters();
        HashSet<String> dislpayedModifications = this.displayParameters.getDisplayedModifications();
        String[] allFixedModifications = peptide.getFixedModifications(modificationParameters, this.sequenceProvider, modificationSequenceMatchingParameters);
        String[] allVariableModifications = peptide.getIndexedVariableModifications();
        String[] fixedModifications = DisplayFeaturesGenerator.getDisplayedModifications(allFixedModifications, dislpayedModifications);
        String[] confidentVariableModifications = DisplayFeaturesGenerator.getFilteredConfidentModificationsSites(peptide, dislpayedModifications);
        String[] ambiguousVariableModificationsRepresentative = DisplayFeaturesGenerator.getFilteredAmbiguousModifications(peptide, dislpayedModifications);
        return PeptideUtils.getTaggedModifiedSequence((Peptide)peptide, (ModificationParameters)modificationParameters, (String[])allFixedModifications, (String[])allVariableModifications, (String[])confidentVariableModifications, (String[])ambiguousVariableModificationsRepresentative, null, (String[])fixedModifications, (boolean)useHtmlColorCoding, (boolean)includeHtmlStartEndTags, (boolean)useShortName);
    }

    public static String[] getFilteredConfidentModificationsSites(Peptide peptide, HashSet<String> displayedModifications) {
        String[] result = new String[peptide.getSequence().length() + 2];
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            if (!modificationMatch.getConfident() || !displayedModifications.contains(modName)) continue;
            result[modificationMatch.getSite()] = modName;
        }
        return result;
    }

    public static String[] getFilteredAmbiguousModifications(Peptide peptide, HashSet<String> displayedModifications) {
        String[] result = new String[peptide.getSequence().length() + 2];
        for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
            String modName = modificationMatch.getModification();
            if (modificationMatch.getConfident() || !displayedModifications.contains(modName)) continue;
            result[modificationMatch.getSite()] = modName;
        }
        return result;
    }

    public String addGoLink(String goAccession) {
        return String.join((CharSequence)"", "<html><a href=\"", this.getGoAccessionLink(goAccession), "\"><font color=\"", this.notSelectedRowHtmlTagFontColor, "\">", goAccession, "</font></a></html>");
    }

    public String getGoAccessionLink(String goAccession) {
        return String.join((CharSequence)"", "https://www.ebi.ac.uk/QuickGO/GTerm?id=", goAccession);
    }

    public HashMap<Integer, ArrayList<ResidueAnnotation>> getResidueAnnotation(long proteinMatchKey, SequenceMatchingParameters sequenceMatchingPreferences, IdentificationFeaturesGenerator identificationFeaturesGenerator, Metrics metrics, Identification identification, boolean allPeptides, SearchParameters searchParameters, boolean enzymatic) {
        int i;
        ProteinMatch proteinMatch = identification.getProteinMatch(proteinMatchKey);
        String sequence = this.sequenceProvider.getSequence(proteinMatch.getLeadingAccession());
        HashMap<Integer, ArrayList<ResidueAnnotation>> residueAnnotation = new HashMap<Integer, ArrayList<ResidueAnnotation>>(sequence.length());
        double[] coverage = identificationFeaturesGenerator.getCoverableAA(proteinMatchKey);
        double lastP = coverage[0];
        int lastIndex = 0;
        for (i = 0; i < coverage.length; ++i) {
            double p = coverage[i];
            if (p == lastP) continue;
            StringBuilder annotation = new StringBuilder();
            annotation.append(lastIndex + 1).append('-').append(i + 1);
            if (metrics.getPeptideLengthDistribution() != null) {
                annotation.append(", ").append(Util.roundDouble((double)(100.0 * lastP), (int)1)).append("% chance of coverage");
            } else if (lastP > 0.01) {
                annotation.append(", possible to cover");
            }
            ArrayList<ResidueAnnotation> annotations = new ArrayList<ResidueAnnotation>(1);
            annotations.add(new ResidueAnnotation(annotation.toString(), 0L, false));
            for (int j = lastIndex; j < i; ++j) {
                residueAnnotation.put(j, new ArrayList(annotations));
            }
            lastP = p;
            lastIndex = i;
        }
        i = coverage.length;
        StringBuilder annotation = new StringBuilder();
        annotation.append(lastIndex + 1).append("-").append(i);
        if (metrics.getPeptideLengthDistribution() != null) {
            annotation.append(", ").append(Util.roundDouble((double)(100.0 * lastP), (int)1)).append("% chance of coverage");
        } else if (lastP > 0.01) {
            annotation.append(", possible to cover");
        }
        ArrayList<Object> annotations = new ArrayList<ResidueAnnotation>(1);
        annotations.add(new ResidueAnnotation(annotation.toString(), 0L, false));
        for (int j = lastIndex; j < i; ++j) {
            residueAnnotation.put(j, new ArrayList(annotations));
        }
        for (long peptideMatchKey : proteinMatch.getPeptideMatchesKeys()) {
            int[] startIndexes;
            DigestionParameters digestionPreferences;
            PeptideMatch peptideMatch = identification.getPeptideMatch(peptideMatchKey);
            String peptideSequence = peptideMatch.getPeptide().getSequence();
            boolean enzymaticPeptide = true;
            if (!allPeptides && (digestionPreferences = searchParameters.getDigestionParameters()).getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
                PeptideUtils.isEnzymatic((Peptide)peptideMatch.getPeptide(), (SequenceProvider)this.sequenceProvider, (ArrayList)digestionPreferences.getEnzymes());
            }
            if (!allPeptides && (!enzymatic || !enzymaticPeptide) && (enzymatic || enzymaticPeptide)) continue;
            String modifiedSequence = this.getTaggedPeptideSequence(peptideMatch, true, false, true);
            AminoAcidPattern aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString((String)peptideSequence);
            for (int startIndex : startIndexes = aminoAcidPattern.getIndexes(sequence, sequenceMatchingPreferences)) {
                int endIndex = startIndex + peptideSequence.length() - 1;
                String peptideTempStart = Integer.toString(startIndex);
                String peptideTempEnd = Integer.toString(endIndex);
                ResidueAnnotation newAnnotation = new ResidueAnnotation(String.join((CharSequence)" - ", peptideTempStart, modifiedSequence, peptideTempEnd), peptideMatchKey, true);
                for (int j = startIndex - 1; j < endIndex; ++j) {
                    annotations = residueAnnotation.get(j);
                    if (annotations == null) {
                        annotations = new ArrayList(1);
                        residueAnnotation.put(j, annotations);
                    } else if (annotations.size() == 1 && !((ResidueAnnotation)annotations.get((int)0)).clickable) {
                        annotations.clear();
                    }
                    annotations.add(newAnnotation);
                }
            }
        }
        return residueAnnotation;
    }
}

