/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.complete.benchmark;

import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.ujmp.colt.benchmark.ColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.commonsmath.benchmark.CommonsMathBlockDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.Matrix2D;
import org.ujmp.core.benchmark.AbstractMatrix2DBenchmark;
import org.ujmp.core.benchmark.ArrayDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.benchmark.BenchmarkConfig;
import org.ujmp.core.benchmark.BenchmarkUtil;
import org.ujmp.core.benchmark.BlockDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.benchmark.DefaultDenseDoubleMatrix2DBenchmark;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.listmatrix.DefaultListMatrix;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.CommandLineUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.matrices.MatrixLibraries;
import org.ujmp.core.util.matrices.SystemEnvironmentMatrix;
import org.ujmp.core.util.matrices.SystemPropertiesMatrix;
import org.ujmp.ejml.benchmark.EJMLDenseDoubleMatrix2DBenchmark;
import org.ujmp.jama.JamaDenseDoubleMatrix2D;
import org.ujmp.jama.benchmark.JamaDenseDoubleMatrix2DBenchmark;
import org.ujmp.jblas.benchmark.JBlasDenseDoubleMatrix2DBenchmark;
import org.ujmp.jsci.benchmark.JSciDenseDoubleMatrix2DBenchmark;
import org.ujmp.jscience.benchmark.JScienceDenseDoubleMatrix2DBenchmark;
import org.ujmp.mtj.benchmark.MTJDenseDoubleMatrix2DBenchmark;
import org.ujmp.ojalgo.benchmark.OjalgoDenseDoubleMatrix2DBenchmark;
import org.ujmp.parallelcolt.benchmark.ParallelColtDenseDoubleMatrix2DBenchmark;
import org.ujmp.vecmath.benchmark.VecMathDenseDoubleMatrix2DBenchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteMatrixBenchmark
extends AbstractMatrix2DBenchmark {
    public List<AbstractMatrix2DBenchmark> getDenseBenchmarks() {
        ArrayList<AbstractMatrix2DBenchmark> list = new ArrayList<AbstractMatrix2DBenchmark>();
        if (this.getConfig().isRunVecMathDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new VecMathDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunDefaultDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new DefaultDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunArrayDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new ArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunBlockDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new BlockDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunOjalgoDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new OjalgoDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunMTJDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new MTJDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJScienceDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new JScienceDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJSciDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new JSciDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJBlasDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new JBlasDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunJamaDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new JamaDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunEJMLDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new EJMLDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathBlockDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new CommonsMathBlockDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunCommonsMathArrayDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new CommonsMathArrayDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunColtDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new ColtDenseDoubleMatrix2DBenchmark());
        }
        if (this.getConfig().isRunParallelColtDenseDoubleMatrix2D()) {
            list.add((AbstractMatrix2DBenchmark)new ParallelColtDenseDoubleMatrix2DBenchmark());
        }
        return list;
    }

    public void runAll() throws Exception {
        List<AbstractMatrix2DBenchmark> benchmarks = this.getDenseBenchmarks();
        UJMPSettings.getInstance().setNumberOfThreads(this.getConfig().getNumberOfThreads());
        ConcurrencyUtils.setNumberOfThreads((int)this.getConfig().getNumberOfThreads());
        System.setProperty("ATLAS_NUM_THREADS", "" + this.getConfig().getNumberOfThreads());
        if (this.getConfig().isShuffle()) {
            Collections.shuffle(benchmarks);
        }
        if (this.getConfig().isReverse()) {
            Collections.reverse(benchmarks);
        }
        long t0 = System.currentTimeMillis();
        for (int j = 0; j < benchmarks.size(); ++j) {
            AbstractMatrix2DBenchmark benchmark = benchmarks.get(j);
            benchmark.run();
        }
        long t1 = System.currentTimeMillis();
        System.out.println();
        System.out.println("Finished.");
        System.out.println("Total Time: " + StringUtil.duration((long)(t1 - t0)));
        System.out.println();
        System.out.println();
    }

    public static void main(String[] args) throws Exception {
        CompleteMatrixBenchmark mb = new CompleteMatrixBenchmark();
        CommandLineUtil.parse((MapMatrix)mb.getConfig(), (String[])args);
        mb.saveSettings();
        mb.runAll();
        mb.evaluate();
    }

    public void setShuffle(boolean shuffle) {
        this.getConfig().setShuffle(shuffle);
    }

    public void setReverse(boolean reverse) {
        this.getConfig().setReverse(reverse);
    }

    public void saveSettings() throws Exception {
        String resultDir = BenchmarkUtil.getResultDir((BenchmarkConfig)this.getConfig());
        File envFile = new File(resultDir + File.separator + "env.csv");
        File propFile = new File(resultDir + File.separator + "props.csv");
        File confFile = new File(resultDir + File.separator + "conf.csv");
        File versionFile = new File(resultDir + File.separator + "versions.csv");
        new SystemEnvironmentMatrix().exportTo().file(envFile).asDenseCSV();
        Matrix props = new SystemPropertiesMatrix().replaceRegex(Calculation.Ret.NEW, "\r\n", " ");
        props = props.replaceRegex(Calculation.Ret.NEW, "\n", " ");
        props.exportTo().file(propFile).asDenseCSV();
        this.getConfig().exportTo().file(confFile).asDenseCSV();
        MatrixLibraries libraries = new MatrixLibraries();
        System.out.println(libraries);
        Matrix versions = libraries.selectRows(Calculation.Ret.NEW, new long[]{0L, 1L}).transpose();
        versions.exportTo().file(versionFile).asDenseCSV();
    }

    public void evaluate() throws Exception {
        System.out.println("Evaluation");
        System.out.println("==========");
        System.out.println();
        File dir = new File(BenchmarkUtil.getResultDir((BenchmarkConfig)this.getConfig()));
        if (!dir.exists()) {
            throw new RuntimeException("no results found");
        }
        HashMap<String, ArrayList<Matrix>> statistics = new HashMap<String, ArrayList<Matrix>>();
        List<File> dirs = Arrays.asList(dir.listFiles());
        Collections.sort(dirs);
        for (File f : dirs) {
            if (!f.isDirectory()) continue;
            String matrixName = f.getName();
            List<File> results = Arrays.asList(f.listFiles());
            Collections.sort(results);
            for (File r : results) {
                String benchmarkName = r.getName().replaceAll(".csv", "");
                Matrix data = Matrix.Factory.importFrom().file(r).asDenseCSV();
                data.setLabel((Object)matrixName);
                ArrayList<Matrix> list = (ArrayList<Matrix>)statistics.get(benchmarkName);
                if (list == null) {
                    list = new ArrayList<Matrix>();
                    statistics.put(benchmarkName, list);
                }
                list.add(data);
            }
        }
        for (String benchmarkName : statistics.keySet()) {
            List list = (List)statistics.get(benchmarkName);
            ArrayList<Matrix> means = new ArrayList<Matrix>();
            ArrayList<Matrix> stds = new ArrayList<Matrix>();
            ArrayList<Matrix> mins = new ArrayList<Matrix>();
            ArrayList<Matrix> maxs = new ArrayList<Matrix>();
            for (Matrix m : list) {
                Matrix data = m.deleteRows(Calculation.Ret.NEW, new long[]{0L});
                Matrix columnLabels = m.selectRows(Calculation.Ret.NEW, new long[]{0L});
                Matrix mean = data.mean(Calculation.Ret.NEW, 0, true);
                mean.setLabel((Object)(m.getLabel() + "-" + benchmarkName + "-mean"));
                mean.setMetaDataDimensionMatrix(0, columnLabels);
                means.add(mean);
                Matrix std = data.std(Calculation.Ret.NEW, 0, true, true);
                std.setLabel((Object)(m.getLabel() + "-" + benchmarkName + "-std"));
                std.setMetaDataDimensionMatrix(0, columnLabels);
                stds.add(std);
                Matrix min = data.min(Calculation.Ret.NEW, 0);
                min.setLabel((Object)(m.getLabel() + "-" + benchmarkName + "-min"));
                min.setMetaDataDimensionMatrix(0, columnLabels);
                mins.add(min);
                Matrix max = data.max(Calculation.Ret.NEW, 0);
                max.setLabel((Object)(m.getLabel() + "-" + benchmarkName + "-max"));
                max.setMetaDataDimensionMatrix(0, columnLabels);
                maxs.add(max);
            }
            Matrix allmeans = null;
            try {
                allmeans = Matrix.Factory.vertCat(means);
                allmeans.setLabel((Object)(benchmarkName + "-mean"));
                DefaultListMatrix matrixLabels = new DefaultListMatrix();
                for (Matrix m : means) {
                    matrixLabels.add((Object)m.getLabel().split("-")[0]);
                }
                allmeans.setMetaDataDimensionMatrix(1, (Matrix)matrixLabels);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!allmeans.getLabel().contains("diff")) {
                try {
                    long jamaRow = allmeans.getRowForLabel((Object)JamaDenseDoubleMatrix2D.class.getSimpleName());
                    if (jamaRow < 0L) {
                        jamaRow = allmeans.getRowForLabel((Object)DefaultDenseDoubleMatrix2D.class.getSimpleName());
                    }
                    Matrix2D valueCount = DenseDoubleMatrix2D.Factory.zeros(1L, allmeans.getColumnCount());
                    int c = 0;
                    while ((long)c < valueCount.getColumnCount()) {
                        int s = this.extractSize(allmeans.getColumnLabel((long)c));
                        if (allmeans.getLabel().contains("tall")) {
                            valueCount.setAsInt(s * s / 2, new long[]{0L, c});
                        } else {
                            valueCount.setAsInt(s * s, new long[]{0L, c});
                        }
                        ++c;
                    }
                    valueCount = Matrix.Factory.vertCat((Matrix)valueCount, allmeans.getRowCount());
                    Matrix perCell = allmeans.divide(Calculation.Ret.NEW, false, (Matrix)valueCount).transpose(Calculation.Ret.NEW);
                    perCell.setLabel((Object)(allmeans.getLabel() + "-percell"));
                    int r = 0;
                    while ((long)r < perCell.getRowCount()) {
                        perCell.setRowLabel((long)r, (Object)perCell.getRowLabel((long)r).split("x")[0]);
                        ++r;
                    }
                    this.export(perCell);
                    Matrix row = allmeans.selectRows(Calculation.Ret.NEW, new long[]{jamaRow});
                    Matrix m = Matrix.Factory.vertCat(row, allmeans.getRowCount());
                    Matrix scaled = allmeans.divide(Calculation.Ret.NEW, false, m).power(Calculation.Ret.NEW, -1.0).transpose(Calculation.Ret.NEW);
                    scaled.setLabel((Object)(allmeans.getLabel() + "-scaled"));
                    int r2 = 0;
                    while ((long)r2 < scaled.getRowCount()) {
                        scaled.setRowLabel((long)r2, (Object)scaled.getRowLabel((long)r2).split("x")[0]);
                        ++r2;
                    }
                    this.export(scaled);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.export(allmeans.transpose(Calculation.Ret.NEW));
            Matrix allstds = null;
            Matrix stdPercent = null;
            try {
                allstds = Matrix.Factory.vertCat(stds);
                stdPercent = allstds.divide(Calculation.Ret.NEW, false, allmeans).times(Calculation.Ret.NEW, false, 100.0);
                allstds.setLabel((Object)(benchmarkName + "-std"));
                stdPercent.setLabel((Object)(benchmarkName + "-stdpercent"));
                DefaultListMatrix stdLabels = new DefaultListMatrix();
                for (Matrix m : stds) {
                    stdLabels.add((Object)m.getLabel().split("-")[0]);
                }
                allstds.setMetaDataDimensionMatrix(1, (Matrix)stdLabels);
                stdPercent.setMetaDataDimensionMatrix(1, (Matrix)stdLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate std results for " + benchmarkName + ": " + e);
            }
            this.export(allstds.transpose(Calculation.Ret.NEW));
            this.export(stdPercent.transpose(Calculation.Ret.NEW));
            Matrix allmins = null;
            try {
                allmins = Matrix.Factory.vertCat(mins);
                allmins.setLabel((Object)(benchmarkName + "-min"));
                DefaultListMatrix minLabels = new DefaultListMatrix();
                for (Matrix m : mins) {
                    minLabels.add((Object)m.getLabel().split("-")[0]);
                }
                allmins.setMetaDataDimensionMatrix(1, (Matrix)minLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate min results for " + benchmarkName + ": " + e);
            }
            this.export(allmins.transpose(Calculation.Ret.NEW));
            Matrix allmaxs = null;
            try {
                allmaxs = Matrix.Factory.vertCat(maxs);
                allmaxs.setLabel((Object)(benchmarkName + "-max"));
                DefaultListMatrix maxLabels = new DefaultListMatrix();
                for (Matrix m : maxs) {
                    maxLabels.add((Object)m.getLabel().split("-")[0]);
                }
                allmaxs.setMetaDataDimensionMatrix(1, (Matrix)maxLabels);
            }
            catch (Exception e) {
                System.err.println("could not evaluate max results for " + benchmarkName + ": " + e);
            }
            this.export(allmaxs.transpose(Calculation.Ret.NEW));
            System.out.println(allmeans);
            System.out.println();
        }
    }

    private void export(Matrix matrix) {
        String name = matrix.getLabel();
        int r = 0;
        while ((long)r < matrix.getRowCount()) {
            matrix.setRowLabel((long)r, (Object)String.valueOf(this.extractSize(matrix.getRowLabel((long)r))));
            ++r;
        }
        Matrix firstPart = Matrix.Factory.horCat(new Matrix[]{Matrix.Factory.linkToValue(matrix.getLabel()), matrix.getMetaDataDimensionMatrix(0)});
        Matrix lastPart = Matrix.Factory.horCat(new Matrix[]{matrix.getMetaDataDimensionMatrix(1), matrix});
        Matrix complete = Matrix.Factory.vertCat(new Matrix[]{firstPart, lastPart});
        try {
            complete.exportTo().file(new File(BenchmarkUtil.getResultDir((BenchmarkConfig)this.getConfig()) + name + ".csv")).asDenseCSV();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            complete.exportTo().file(new File(BenchmarkUtil.getResultDir((BenchmarkConfig)this.getConfig()) + name + ".xls")).asXLS();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Matrix plt = complete.deleteRows(Calculation.Ret.NEW, new long[]{0L});
            plt.setColumnLabel(0L, (Object)"matrix size");
            int c = 1;
            while ((long)c < plt.getColumnCount()) {
                plt.setColumnLabel((long)c, (Object)matrix.getColumnLabel((long)(c - 1)));
                ++c;
            }
            plt.setLabel((Object)matrix.getLabel());
            Object[] params = null;
            params = matrix.getLabel().contains("stdpercent") ? new Object[]{"xy", "logx"} : new Object[]{"xy", "logx", "logy"};
            plt.exportTo().file(new File(BenchmarkUtil.getResultDir((BenchmarkConfig)this.getConfig()) + name + ".plt")).asPLT(params);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public DoubleMatrix2D createMatrix(long ... size) {
        return null;
    }

    public DoubleMatrix2D createMatrix(Matrix source) {
        return null;
    }

    private int extractSize(String s) {
        if (s != null && !"null".equals(s)) {
            if (s.contains("x")) {
                return (int)Coordinates.parseString((String)s)[0];
            }
            return Integer.parseInt(s);
        }
        return 0;
    }
}

