/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter;

import com.compomics.software.CompomicsWrapper;
import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.spectrum_annotation.SpectrumAnnotator;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.mass_spectrometry.spectra.Precursor;
import com.compomics.util.experiment.mass_spectrometry.spectra.Spectrum;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.calculation.Deisotoper;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.calculation.QuantificationFilter;
import eu.isas.reporter.calculation.RatioEstimator;
import eu.isas.reporter.preferences.ReporterPathPreferences;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinPtmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.SpectrumQuantificationDetails;
import eu.isas.reporter.settings.RatioEstimationSettings;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class Reporter {
    private static String matchesFolder = "matches";
    private static String enzymeFile = "resources/conf/searchGUI_enzymes.xml";
    private static String methodsFile = "resources/conf/defaultMethods.xml";
    private static String tempFolderPath = null;
    private static File configFolder = null;

    public static ProteinQuantificationDetails estimateProteinMatchQuantificationDetails(Identification identification, SpectrumProvider spectrumProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, QuantificationFeaturesGenerator quantificationFeaturesGenerator, RatioEstimationSettings ratioEstimationSettings, ReporterIonQuantification reporterIonQuantification, SearchParameters searchParameters, ProteinMatch proteinMatch, WaitingHandler waitingHandler) {
        ArrayList<Double> channelRatios;
        PeptideMatch peptideMatch;
        ProteinQuantificationDetails result = new ProteinQuantificationDetails();
        HashMap ratios = new HashMap();
        HashMap uniqueRatios = new HashMap();
        HashMap<String, ArrayList<Double>> sharedRatios = new HashMap<String, ArrayList<Double>>();
        Set<String> indexes = reporterIonQuantification.getSampleIndexes();
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(proteinMatch.getPeptideMatchesKeys(), waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            if (!QuantificationFilter.isPeptideValid(ratioEstimationSettings, identification, searchParameters, peptideMatch)) continue;
            for (String index : indexes) {
                PeptideQuantificationDetails peptideQuantification = quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(spectrumProvider, peptideMatch, waitingHandler);
                double ratio = peptideQuantification.getRatio(index, reporterIonQuantification.getNormalizationFactors());
                channelRatios = (ArrayList<Double>)ratios.get(index);
                ArrayList<Double> channelUniqueRatios = (ArrayList<Double>)uniqueRatios.get(index);
                ArrayList<Double> channelSharedRatios = (ArrayList<Double>)sharedRatios.get(index);
                if (channelRatios == null) {
                    channelRatios = new ArrayList<Double>(proteinMatch.getPeptideCount());
                    ratios.put(index, channelRatios);
                    channelUniqueRatios = new ArrayList<Double>(proteinMatch.getPeptideCount());
                    uniqueRatios.put(index, channelUniqueRatios);
                    channelSharedRatios = new ArrayList<Double>(proteinMatch.getPeptideCount());
                    sharedRatios.put(index, channelSharedRatios);
                }
                if (!QuantificationFilter.isRatioValid(ratioEstimationSettings, ratio)) continue;
                channelRatios.add(ratio);
                if (identificationFeaturesGenerator.getNValidatedProteinGroups(peptideMatch.getKey()) == 1) {
                    channelUniqueRatios.add(ratio);
                    continue;
                }
                channelSharedRatios.add(ratio);
            }
        }
        for (String index : indexes) {
            ArrayList channelUniqueRatios = (ArrayList)uniqueRatios.get(index);
            Double uniqueRatio = RatioEstimator.estimateRatios(ratioEstimationSettings, channelUniqueRatios);
            result.setUniqueRawRatio(index, uniqueRatio);
            ArrayList channelSharedRatios = (ArrayList)sharedRatios.get(index);
            result.setSharedRawRatio(index, RatioEstimator.estimateRatios(ratioEstimationSettings, channelSharedRatios));
            if (ratioEstimationSettings.getMinUnique() >= 0 && channelUniqueRatios != null && channelUniqueRatios.size() >= ratioEstimationSettings.getMinUnique()) {
                result.setRawRatio(index, uniqueRatio);
                continue;
            }
            channelRatios = (ArrayList)ratios.get(index);
            result.setRawRatio(index, RatioEstimator.estimateRatios(ratioEstimationSettings, channelRatios));
        }
        return result;
    }

    public static ProteinPtmQuantificationDetails estimatePTMQuantificationDetails(Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, RatioEstimationSettings ratioEstimationSettings, ReporterIonQuantification reporterIonQuantification, SearchParameters searchParameters, SequenceMatchingParameters sequenceMatchingParameters, String ptmName, long matchKey, int site, WaitingHandler waitingHandler) throws IllegalArgumentException, SQLException, IOException, ClassNotFoundException, InterruptedException {
        PeptideMatch peptideMatch;
        ProteinPtmQuantificationDetails result = new ProteinPtmQuantificationDetails();
        HashMap ratios = new HashMap();
        ProteinMatch proteinMatch = identification.getProteinMatch(matchKey);
        Set<String> indexes = reporterIonQuantification.getSampleIndexes();
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(proteinMatch.getPeptideMatchesKeys(), waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            Peptide peptide = peptideMatch.getPeptide();
            if (peptide.getNVariableModifications() > 0) {
                boolean modified = false;
                for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                    if (modificationMatch.getModification().equals(ptmName) && modificationMatch.getConfident()) {
                        int[] startIndexes;
                        String leadingAccession = proteinMatch.getLeadingAccession();
                        for (int index : startIndexes = peptideMatch.getPeptide().getProteinMapping().get(leadingAccession)) {
                            if (index + modificationMatch.getSite() != site) continue;
                            modified = true;
                            break;
                        }
                    }
                    if (modified) break;
                }
            }
            if (!QuantificationFilter.isPeptideValid(ratioEstimationSettings, identification, searchParameters, peptideMatch)) continue;
            for (String index : indexes) {
                PeptideQuantificationDetails peptideQuantification = quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(spectrumProvider, peptideMatch, waitingHandler);
                double ratio = peptideQuantification.getRatio(index, reporterIonQuantification.getNormalizationFactors());
                ArrayList<Double> channelRatios = (ArrayList<Double>)ratios.get(index);
                if (channelRatios == null) {
                    channelRatios = new ArrayList<Double>(proteinMatch.getPeptideCount());
                    ratios.put(index, channelRatios);
                }
                if (!QuantificationFilter.isRatioValid(ratioEstimationSettings, ratio)) continue;
                channelRatios.add(ratio);
            }
        }
        for (String index : indexes) {
            ArrayList channelRatios = (ArrayList)ratios.get(index);
            result.setRatio(index, RatioEstimator.estimateRatios(ratioEstimationSettings, channelRatios));
        }
        return result;
    }

    public static PeptideQuantificationDetails estimatePeptideMatchQuantificationDetails(Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, RatioEstimationSettings ratioEstimationSettings, ReporterIonQuantification reporterIonQuantification, PeptideMatch peptideMatch, WaitingHandler waitingHandler) {
        SpectrumMatch spectrumMatch;
        PeptideQuantificationDetails result = new PeptideQuantificationDetails();
        HashMap ratios = new HashMap();
        Set<String> indexes = reporterIonQuantification.getSampleIndexes();
        SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(peptideMatch.getSpectrumMatchesKeys(), waitingHandler);
        while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
            if (!QuantificationFilter.isPsmValid(ratioEstimationSettings, identification, spectrumMatch.getKey())) continue;
            for (String index : indexes) {
                PsmQuantificationDetails spectrumQuantification = quantificationFeaturesGenerator.getPSMQuantificationDetails(spectrumProvider, spectrumMatch.getKey());
                double ratio = spectrumQuantification.getRatio(index, reporterIonQuantification.getNormalizationFactors());
                ArrayList<Double> channelRatios = (ArrayList<Double>)ratios.get(index);
                if (channelRatios == null) {
                    channelRatios = new ArrayList<Double>(peptideMatch.getSpectrumCount());
                    ratios.put(index, channelRatios);
                }
                if (!QuantificationFilter.isRatioValid(ratioEstimationSettings, ratio)) continue;
                channelRatios.add(ratio);
            }
        }
        for (String index : indexes) {
            ArrayList channelRatios = (ArrayList)ratios.get(index);
            result.setRawRatio(index, RatioEstimator.estimateRatios(ratioEstimationSettings, channelRatios));
        }
        return result;
    }

    public static PsmQuantificationDetails estimatePSMQuantificationDetails(Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonSelectionSettings reporterIonSelectionSettings, RatioEstimationSettings ratioEstimationSettings, ReporterIonQuantification reporterIonQuantification, Long matchKey) {
        PsmQuantificationDetails result = new PsmQuantificationDetails();
        ArrayList<SpectrumMatch> spectrumMatches = new ArrayList<SpectrumMatch>(1);
        SpectrumMatch spectrumMatch = identification.getSpectrumMatch(matchKey);
        switch (reporterIonSelectionSettings.getReporterIonsLocation()) {
            case ms2Spectra: {
                spectrumMatches.add(spectrumMatch);
                break;
            }
            case ms3Spectra: {
                ArrayList<String> postprecursorTitles = spectrumProvider.getPostcursorSpectrumTitles(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
                if (postprecursorTitles == null) break;
                for (String tempPostcursorSpectrumTitle : postprecursorTitles) {
                    int postcursorSpectrumLevel = spectrumProvider.getSpectrumLevel(spectrumMatch.getSpectrumFile(), tempPostcursorSpectrumTitle);
                    if (postcursorSpectrumLevel != 3) continue;
                    spectrumMatches.add(new SpectrumMatch(spectrumMatch.getSpectrumFile(), tempPostcursorSpectrumTitle));
                }
                break;
            }
            case precursorMatching: {
                String refFile = spectrumMatch.getSpectrumFile();
                Precursor refPrecursor = spectrumProvider.getPrecursor(spectrumMatch.getSpectrumFile(), spectrumMatch.getSpectrumTitle());
                for (String spectrumTitle : spectrumProvider.getSpectrumTitles(refFile)) {
                    Precursor precursor = spectrumProvider.getPrecursor(refFile, spectrumTitle);
                    if (!(Math.abs(precursor.rt - refPrecursor.rt) <= reporterIonSelectionSettings.getPrecursorRTTolerance())) continue;
                    if (reporterIonSelectionSettings.isPrecursorMzPpm()) {
                        double error = (precursor.mz - refPrecursor.mz) / refPrecursor.mz * 1000000.0;
                        if (!(Math.abs(error) <= reporterIonSelectionSettings.getPrecursorMzTolerance())) continue;
                        spectrumMatches.add(new SpectrumMatch(refFile, spectrumTitle));
                        continue;
                    }
                    if (!(Math.abs(precursor.mz - refPrecursor.mz) <= reporterIonSelectionSettings.getPrecursorMzTolerance())) continue;
                    spectrumMatches.add(new SpectrumMatch(refFile, spectrumTitle));
                }
                break;
            }
        }
        Set<String> indexes = reporterIonQuantification.getSampleIndexes();
        HashMap ratios = new HashMap();
        for (SpectrumMatch tempSpectrumMatch : spectrumMatches) {
            double intensity;
            SpectrumQuantificationDetails spectrumQuantification = quantificationFeaturesGenerator.getSpectrumQuantificationDetails(spectrumProvider, reporterIonQuantification, reporterIonSelectionSettings, tempSpectrumMatch);
            ArrayList<String> controlIndexes = reporterIonQuantification.getControlSamples();
            if (controlIndexes == null || controlIndexes.isEmpty()) {
                controlIndexes = new ArrayList<String>(indexes);
            }
            ArrayList<Double> controlIntensities = new ArrayList<Double>(controlIndexes.size());
            for (String index : controlIndexes) {
                intensity = spectrumQuantification.getDeisotopedIntensity(index);
                if (!(intensity > 0.0)) continue;
                controlIntensities.add(intensity);
            }
            if (controlIntensities.isEmpty()) {
                for (String index : indexes) {
                    intensity = spectrumQuantification.getDeisotopedIntensity(index);
                    if (!(intensity > 0.0)) continue;
                    controlIntensities.add(intensity);
                }
            }
            double normalization = 0.0;
            if (!controlIntensities.isEmpty()) {
                normalization = BasicMathFunctions.median(controlIntensities);
            }
            for (String index : indexes) {
                ArrayList<Double> channelRatios;
                double ratio = 0.0;
                if (normalization > 0.0) {
                    double intensity2 = spectrumQuantification.getDeisotopedIntensity(index);
                    ratio = intensity2 / normalization;
                }
                if ((channelRatios = (ArrayList<Double>)ratios.get(index)) == null) {
                    channelRatios = new ArrayList<Double>(spectrumMatches.size());
                    ratios.put(index, channelRatios);
                }
                if (!QuantificationFilter.isRatioValid(ratioEstimationSettings, ratio)) continue;
                channelRatios.add(ratio);
            }
        }
        for (String index : indexes) {
            ArrayList channelRatios = (ArrayList)ratios.get(index);
            result.setRawRatio(index, RatioEstimator.estimateRatios(ratioEstimationSettings, channelRatios));
        }
        return result;
    }

    public static SpectrumQuantificationDetails estimateSpectrumQuantificationDetails(Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterIonSelectionSettings reporterIonSelectionSettings, SpectrumMatch aSpectrumMatch) {
        ReporterMethod reporterMethod = reporterIonQuantification.getReporterMethod();
        Spectrum spectrum = spectrumProvider.getSpectrum(aSpectrumMatch.getSpectrumFile(), aSpectrumMatch.getSpectrumTitle());
        SpectrumQuantificationDetails result = new SpectrumQuantificationDetails();
        Set<String> labels = reporterIonQuantification.getSampleIndexes();
        HashMap<String, IonMatch> matchesMap = new HashMap<String, IonMatch>(labels.size());
        for (String ionName : labels) {
            ReporterIon reporterIon = reporterMethod.getReporterIon(ionName);
            IonMatch bestMatch = Reporter.getBestReporterIonMatch(reporterIon, 1, spectrum, reporterIonSelectionSettings.getReporterIonsMzTolerance(), reporterIonSelectionSettings.isMostAccurate());
            if (bestMatch == null) continue;
            result.setReporterMatch(ionName, bestMatch);
            matchesMap.put(ionName, bestMatch);
        }
        Deisotoper deisotoper = quantificationFeaturesGenerator.getDeisotoper(reporterMethod, reporterIonSelectionSettings.getReporterIonsMzTolerance());
        HashMap<String, Double> deisotoped = deisotoper.deisotope(matchesMap, spectrum, reporterIonSelectionSettings.getReporterIonsMzTolerance(), reporterIonSelectionSettings.isMostAccurate());
        for (String index : reporterIonQuantification.getSampleIndexes()) {
            Double intensity = deisotoped.get(index);
            if (intensity == null || intensity < 0.0) {
                intensity = 0.0;
            }
            result.setDeisotopedIntensity(index, intensity);
        }
        return result;
    }

    public static IonMatch getBestReporterIonMatch(ReporterIon reporterIon, int charge, Spectrum spectrum, double mzTolerance, boolean mostAccurate) {
        ArrayList<IonMatch> ionMatches = SpectrumAnnotator.matchReporterIon(reporterIon, 1, spectrum, mzTolerance);
        IonMatch bestMatch = null;
        double bestError = mzTolerance;
        double bestIntensity = 0.0;
        for (IonMatch ionMatch : ionMatches) {
            boolean bestIon = false;
            if (bestMatch == null) {
                bestIon = true;
            } else if (mostAccurate) {
                double intensity;
                double ionError = Math.abs(ionMatch.getAbsoluteError());
                if (ionError < bestError) {
                    bestIon = true;
                    bestError = ionError;
                } else if (ionError == bestError && (intensity = ionMatch.peakIntensity) > bestIntensity) {
                    bestIon = true;
                    bestIntensity = intensity;
                }
            } else {
                double intensity = ionMatch.peakIntensity;
                if (intensity > bestIntensity) {
                    bestIon = true;
                    bestIntensity = intensity;
                }
            }
            if (!bestIon) continue;
            bestMatch = ionMatch;
        }
        return bestMatch;
    }

    public static String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(new Reporter().getClass().getResource("Reporter.class").getPath(), "Reporter");
    }

    public static File getConfigFolder() {
        if (configFolder != null) {
            return configFolder;
        }
        return new File(Reporter.getJarFilePath());
    }

    public static void setTempFolderPath(String tempFolderPath) {
        Reporter.tempFolderPath = tempFolderPath;
    }

    public static String getTempFolderPath(File configFolder) {
        File tempFolder;
        if (tempFolderPath == null && !(tempFolder = new File(tempFolderPath = configFolder.toString().equals(".") ? "resources" + File.separator + "temp" : configFolder + File.separator + "resources" + File.separator + "temp")).exists()) {
            tempFolder.mkdirs();
        }
        return tempFolderPath;
    }

    public static File getMatchesFolder() {
        return new File(Reporter.getTempFolderPath(Reporter.getConfigFolder()), matchesFolder);
    }

    public static void setPathConfiguration() throws IOException {
        File pathConfigurationFile = new File(Reporter.getJarFilePath(), "resources/conf/paths.txt");
        if (pathConfigurationFile.exists()) {
            ReporterPathPreferences.loadPathParametersFromFile(pathConfigurationFile);
        }
    }

    public static File getEnzymesFile() {
        String jarFilePath = Reporter.getJarFilePath();
        File result = new File(jarFilePath, enzymeFile);
        if (!result.exists()) {
            System.out.println(result.getAbsolutePath() + " not found!");
            FileNotFoundException ex = new FileNotFoundException(result.getAbsolutePath() + " not found!");
            ex.printStackTrace();
        }
        return result;
    }

    public static File getMethodsFile() {
        String jarFilePath = Reporter.getJarFilePath();
        File result = new File(jarFilePath, methodsFile);
        if (!result.exists()) {
            System.out.println(result.getAbsolutePath() + " not found!");
            FileNotFoundException ex = new FileNotFoundException(result.getAbsolutePath() + " not found!");
            ex.printStackTrace();
        }
        return result;
    }
}

