/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.preferences.ReporterPathPreferences;
import eu.isas.reporter.utils.Properties;
import java.io.File;
import java.util.ArrayList;

public class ReporterWrapper
extends CompomicsWrapper {
    public ReporterWrapper(String[] args) {
        String jarFileName = "Reporter-" + new Properties().getVersion() + ".jar";
        String jarFilePath = Reporter.getJarFilePath();
        File jarFile = new File(jarFilePath, jarFileName);
        String splash = "reporter-splash.png";
        String mainClass = "eu.isas.reporter.gui.ReporterGUI";
        try {
            Reporter.setPathConfiguration();
        }
        catch (Exception e) {
            System.out.println("Impossible to load path configuration, default will be used.");
        }
        try {
            ArrayList<PathKey> errorKeys = ReporterPathPreferences.getErrorKeys(jarFilePath);
            if (!errorKeys.isEmpty()) {
                System.out.println("Unable to write in the following configuration folders. Please edit the configuration paths.");
                for (PathKey pathKey : errorKeys) {
                    System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default paths will be used.");
        }
        this.launchTool("Reporter", jarFile, splash, mainClass, args);
    }

    public static void main(String[] args) {
        new ReporterWrapper(args);
    }
}

