/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation;

import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinPtmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.quantificationdetails.SpectrumQuantificationDetails;
import java.util.Collections;
import java.util.HashMap;

public class QuantificationFeaturesCache {
    private double memoryShare = 0.99;
    private HashMap<Integer, HashMap<Long, ProteinQuantificationDetails>> proteinRatios = new HashMap();
    private HashMap<String, HashMap<Long, HashMap<String, ProteinPtmQuantificationDetails>>> proteinPtmRatios = new HashMap();
    private HashMap<Integer, HashMap<Long, PeptideQuantificationDetails>> peptideRatios = new HashMap();
    private HashMap<String, HashMap<String, PsmQuantificationDetails>> psmRatios = new HashMap();
    private HashMap<String, HashMap<String, SpectrumQuantificationDetails>> spectrumRatios = new HashMap();
    private boolean editing = false;

    private void adaptCacheSize() {
        if (!(this.editing || this.memoryCheck() || this.isEmpty())) {
            this.adaptCacheSizeSynchronized();
        }
    }

    public boolean isEmpty() {
        return this.peptideRatios.isEmpty() && this.proteinRatios.isEmpty() && this.spectrumRatios.isEmpty() && this.proteinPtmRatios.isEmpty();
    }

    private synchronized void adaptCacheSizeSynchronized() {
        int i;
        int i2;
        if (this.editing || this.memoryCheck() || this.isEmpty()) {
            return;
        }
        this.editing = true;
        for (i2 = 1; i2 < 10; ++i2) {
            this.peptideRatios.remove(i2);
            if (!this.memoryCheck()) continue;
            this.editing = false;
            return;
        }
        for (i2 = 1; i2 < 10; ++i2) {
            this.proteinRatios.remove(i2);
            if (!this.memoryCheck()) continue;
            this.editing = false;
            return;
        }
        this.spectrumRatios.clear();
        if (this.memoryCheck()) {
            this.editing = false;
            return;
        }
        this.psmRatios.clear();
        if (this.memoryCheck()) {
            this.editing = false;
            return;
        }
        int keyMax = Collections.max(this.peptideRatios.keySet());
        for (i = 10; i <= keyMax; ++i) {
            this.peptideRatios.remove(i);
            if (!this.memoryCheck()) continue;
            this.editing = false;
            return;
        }
        keyMax = Collections.max(this.proteinRatios.keySet());
        for (i = 10; i <= keyMax; ++i) {
            this.proteinRatios.remove(i);
            if (!this.memoryCheck()) continue;
            this.editing = false;
            return;
        }
        for (String ptm : this.proteinPtmRatios.keySet()) {
            this.proteinPtmRatios.remove(ptm);
            if (!this.memoryCheck()) continue;
            this.editing = false;
            return;
        }
    }

    public boolean memoryCheck() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() < (long)(this.memoryShare * (double)Runtime.getRuntime().maxMemory());
    }

    public synchronized void addProteinMatchQuantificationDetails(int nPeptides, long matchKey, ProteinQuantificationDetails matchQuantificationDetails) {
        this.editing = true;
        HashMap<Long, ProteinQuantificationDetails> submap = this.proteinRatios.get(nPeptides);
        if (submap == null) {
            submap = new HashMap();
            this.proteinRatios.put(nPeptides, submap);
        }
        submap.put(matchKey, matchQuantificationDetails);
        this.editing = false;
        this.adaptCacheSize();
    }

    public ProteinQuantificationDetails getProteinMatchQuantificationDetails(int nPeptides, long matchKey) {
        ProteinQuantificationDetails result = null;
        HashMap<Long, ProteinQuantificationDetails> submap = this.proteinRatios.get(nPeptides);
        if (submap != null) {
            result = submap.get(matchKey);
        }
        this.adaptCacheSize();
        return result;
    }

    public synchronized void addPtmQuantificationDetails(String ptmName, long matchKey, int site, ProteinPtmQuantificationDetails matchQuantificationDetails) {
        HashMap<String, ProteinPtmQuantificationDetails> subsubmap;
        this.editing = true;
        HashMap<Long, HashMap<String, ProteinPtmQuantificationDetails>> submap = this.proteinPtmRatios.get(ptmName);
        if (submap == null) {
            submap = new HashMap();
            this.proteinPtmRatios.put(ptmName, submap);
        }
        if ((subsubmap = submap.get(matchKey)) == null) {
            subsubmap = new HashMap();
            submap.put(matchKey, subsubmap);
        }
        subsubmap.put(site + "", matchQuantificationDetails);
        this.editing = false;
        this.adaptCacheSize();
    }

    public ProteinPtmQuantificationDetails getPtmQuantificationDetails(String ptmName, long matchKey, int site) {
        HashMap<String, ProteinPtmQuantificationDetails> subsubmap;
        ProteinPtmQuantificationDetails result = null;
        HashMap<Long, HashMap<String, ProteinPtmQuantificationDetails>> submap = this.proteinPtmRatios.get(ptmName);
        if (submap != null && (subsubmap = submap.get(matchKey)) != null) {
            result = subsubmap.get(site + "");
        }
        this.adaptCacheSize();
        return result;
    }

    public synchronized void addPeptideMatchQuantificationDetails(int nPeptides, Long matchKey, PeptideQuantificationDetails matchQuantificationDetails) {
        this.editing = true;
        HashMap<Long, PeptideQuantificationDetails> submap = this.peptideRatios.get(nPeptides);
        if (submap == null) {
            submap = new HashMap();
            this.peptideRatios.put(nPeptides, submap);
        }
        submap.put(matchKey, matchQuantificationDetails);
        this.editing = false;
        this.adaptCacheSize();
    }

    public PeptideQuantificationDetails getPeptideMatchQuantificationDetails(int nPsms, Long matchKey) {
        PeptideQuantificationDetails result = null;
        HashMap<Long, PeptideQuantificationDetails> submap = this.peptideRatios.get(nPsms);
        if (submap != null) {
            result = submap.get(matchKey);
        }
        this.adaptCacheSize();
        return result;
    }

    public synchronized void addPSMQuantificationDetails(String spectrumFile, String spectrumTitle, PsmQuantificationDetails matchQuantificationDetails) {
        this.editing = true;
        HashMap<String, PsmQuantificationDetails> submap = this.psmRatios.get(spectrumFile);
        if (submap == null) {
            submap = new HashMap();
            this.psmRatios.put(spectrumFile, submap);
        }
        submap.put(spectrumTitle, matchQuantificationDetails);
        this.editing = false;
        this.adaptCacheSize();
    }

    public PsmQuantificationDetails getPSMQuantificationDetails(String spectrumFile, String spectrumTitle) {
        PsmQuantificationDetails result = null;
        HashMap<String, PsmQuantificationDetails> submap = this.psmRatios.get(spectrumFile);
        if (submap != null) {
            result = submap.get(spectrumTitle);
        }
        this.adaptCacheSize();
        return result;
    }

    public synchronized void addSpectrumQuantificationDetails(String spectrumFile, String spectrumTitle, SpectrumQuantificationDetails matchQuantificationDetails) {
        this.editing = true;
        HashMap<String, SpectrumQuantificationDetails> submap = this.spectrumRatios.get(spectrumFile);
        if (submap == null) {
            submap = new HashMap();
            this.spectrumRatios.put(spectrumFile, submap);
        }
        submap.put(spectrumTitle, matchQuantificationDetails);
        this.editing = false;
        this.adaptCacheSize();
    }

    public SpectrumQuantificationDetails getSpectrumQuantificationDetails(String spectrumFile, String spectrumTitle) {
        SpectrumQuantificationDetails result = null;
        HashMap<String, SpectrumQuantificationDetails> submap = this.spectrumRatios.get(spectrumFile);
        if (submap != null) {
            result = submap.get(spectrumTitle);
        }
        this.adaptCacheSize();
        return result;
    }
}

