/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation;

import com.compomics.util.experiment.biology.enzymes.Enzyme;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.parameters.identification.search.DigestionParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import eu.isas.reporter.settings.RatioEstimationSettings;
import java.io.IOException;
import java.sql.SQLException;

public class QuantificationFilter {
    public static boolean isRatioValid(RatioEstimationSettings ratioEstimationSettings, Double ratio) {
        return !ratio.isNaN() && (!ratioEstimationSettings.isIgnoreNullIntensities() || ratio > 0.0);
    }

    public static boolean isPsmValid(RatioEstimationSettings ratioEstimationSettings, Identification identification, long matchKey) {
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)identification.getSpectrumMatch(matchKey).getUrParam(psParameter);
        return psParameter.getMatchValidationLevel().getIndex() >= ratioEstimationSettings.getPsmValidationLevel().getIndex();
    }

    public static boolean isPeptideValid(RatioEstimationSettings ratioEstimationSettings, Identification identification, SearchParameters searchParameters, PeptideMatch peptideMatch) {
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)identification.getPeptideMatch(peptideMatch.getKey()).getUrParam(psParameter);
        if (psParameter.getMatchValidationLevel().getIndex() < ratioEstimationSettings.getPeptideValidationLevel().getIndex()) {
            return false;
        }
        Peptide peptide = peptideMatch.getPeptide();
        DigestionParameters digestionParameters = searchParameters.getDigestionParameters();
        if (digestionParameters.getCleavageParameter() == DigestionParameters.CleavageParameter.enzyme) {
            Integer minMissedCleavages = null;
            for (Enzyme enzyme : digestionParameters.getEnzymes()) {
                int nMissedCleavages = peptide.getNMissedCleavages(enzyme);
                if (minMissedCleavages != null && nMissedCleavages >= minMissedCleavages) continue;
                minMissedCleavages = nMissedCleavages;
            }
            if (minMissedCleavages != null && minMissedCleavages > 0 && ratioEstimationSettings.isIgnoreMissedCleavages()) {
                return false;
            }
        }
        if (peptide.getNVariableModifications() > 0) {
            for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                if (!ratioEstimationSettings.getExcludingPtms().contains(modificationMatch.getModification())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isProteinValid(RatioEstimationSettings ratioEstimationSettings, Identification identification, long matchKey) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        PSParameter psParameter = new PSParameter();
        psParameter = (PSParameter)identification.getProteinMatch(matchKey).getUrParam(psParameter);
        return psParameter.getMatchValidationLevel().getIndex() >= ratioEstimationSettings.getProteinValidationLevel().getIndex();
    }
}

