/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation.clustering;

import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.math.clustering.KMeansClustering;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.calculation.clustering.keys.PeptideClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.ProteinClusterClassKey;
import eu.isas.reporter.calculation.clustering.keys.PsmClusterClassKey;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinRatioType;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.settings.ClusteringSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class ClusterBuilder {
    private HashMap<String, ArrayList<Long>> filteredProteinKeys;
    private HashMap<Long, ArrayList<String>> proteinClusters;
    private HashMap<Long, Integer> proteinKeysIndexes;
    private HashMap<String, ArrayList<Long>> filteredPeptideKeys;
    private HashMap<Long, ArrayList<String>> peptideClusters;
    private HashMap<Long, Integer> peptideKeysIndexes;
    private HashMap<String, ArrayList<Long>> filteredPsmKeys;
    private HashMap<Long, ArrayList<String>> psmClusters;
    private HashMap<Long, Integer> psmKeysIndexes;
    private ArrayList<String> clusterKeys;
    private double[][] ratios;
    private Double minRatio = null;
    private Double maxRatio = null;

    public KMeansClustering clusterProfiles(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, Metrics metrics, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, DisplayPreferences displayPreferences, boolean loadData, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        if (loadData) {
            waitingHandler.setWaitingText("Loading data (1/2). Please Wait...");
            this.loadData(identification, identificationParameters, sequenceProvider, spectrumProvider, metrics, displayPreferences, reporterIonQuantification, quantificationFeaturesGenerator, waitingHandler);
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            waitingHandler.setWaitingText("Clustering Data (2/2). Please Wait...");
        } else {
            waitingHandler.setWaitingText("Clustering Data. Please Wait...");
        }
        KMeansClustering kMeansClutering = null;
        if (this.ratios.length > 0) {
            String[] keysArray = this.clusterKeys.toArray(new String[this.clusterKeys.size()]);
            int numClusters = displayPreferences.getClusteringSettings().getKMeansClusteringSettings().getnClusters();
            if (this.ratios.length < numClusters) {
                displayPreferences.getClusteringSettings().getKMeansClusteringSettings().setnClusters(this.ratios.length);
            }
            kMeansClutering = new KMeansClustering(this.ratios, keysArray, displayPreferences.getClusteringSettings().getKMeansClusteringSettings().getnClusters());
            kMeansClutering.kMeanCluster(waitingHandler);
        }
        return kMeansClutering;
    }

    public void loadData(Identification identification, IdentificationParameters identificationParameters, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, Metrics metrics, DisplayPreferences displayPreferences, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        ClusteringSettings clusteringSettings = displayPreferences.getClusteringSettings();
        HashSet<Long> proteinKeys = identification.getProteinIdentification();
        HashSet<Long> peptideKeys = identification.getPeptideIdentification();
        int nProteinClusters = clusteringSettings.getSelectedProteinClasses().size();
        int nPeptideClusters = clusteringSettings.getSelectedPeptideClasses().size();
        int nPsmClusters = clusteringSettings.getSelectedPsmClasses().size();
        int progressTotal = 1;
        if (nProteinClusters > 0) {
            progressTotal += proteinKeys.size();
        }
        if (nPeptideClusters > 0) {
            progressTotal += peptideKeys.size();
        }
        if (nPsmClusters > 0) {
            progressTotal += identification.getSpectrumIdentificationSize();
        }
        waitingHandler.resetPrimaryProgressCounter();
        waitingHandler.setPrimaryProgressCounterIndeterminate(false);
        waitingHandler.setMaxPrimaryProgressCounter(progressTotal);
        waitingHandler.increasePrimaryProgressCounter();
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        ArrayList<String> sampleIndexes = new ArrayList<String>(reporterIonQuantification.getSampleIndexes());
        Collections.sort(sampleIndexes);
        Integer clusteringIndex = 0;
        this.clusterKeys = new ArrayList(metrics.getnValidatedProteins());
        ArrayList<double[]> ratiosList = new ArrayList<double[]>(metrics.getnValidatedProteins());
        this.proteinClusters = new HashMap(nProteinClusters);
        this.proteinKeysIndexes = new HashMap(metrics.getnValidatedProteins());
        this.filteredProteinKeys = new HashMap(metrics.getnValidatedProteins());
        if (nProteinClusters > 0) {
            ProteinMatch proteinMatch;
            int selectedRatioType = displayPreferences.getProteinRatioType();
            ProteinRatioType proteinRatioType = ProteinRatioType.getProteinRatioType(selectedRatioType);
            if (proteinRatioType == null) {
                throw new IllegalArgumentException("Ratio type of index " + selectedRatioType + " not recognized.");
            }
            ProteinMatchesIterator proteinMatchesIterator = quantificationFeaturesGenerator.getQuantificationFeaturesCache().memoryCheck() ? identification.getProteinMatchesIterator(metrics.getProteinKeys(), waitingHandler) : identification.getProteinMatchesIterator(metrics.getProteinKeys(), waitingHandler);
            while ((proteinMatch = proteinMatchesIterator.next()) != null) {
                long proteinKey = proteinMatch.getKey();
                String proteinKeyAsString = Long.toString(proteinKey);
                psParameter = (PSParameter)identification.getProteinMatch(proteinKey).getUrParam(psParameter);
                if (psParameter.getMatchValidationLevel().isValidated()) {
                    boolean found = false;
                    for (String keyName : clusteringSettings.getSelectedProteinClasses()) {
                        boolean inCluster = true;
                        ProteinClusterClassKey proteinClusterClassKey = clusteringSettings.getProteinClassKey(keyName);
                        if (proteinClusterClassKey.isStarred().booleanValue() && !psParameter.getStarred()) {
                            inCluster = false;
                        }
                        if (!inCluster) continue;
                        ArrayList<Long> tempClusterKeys = this.filteredProteinKeys.get(keyName);
                        if (tempClusterKeys == null) {
                            tempClusterKeys = new ArrayList();
                            this.filteredProteinKeys.put(keyName, tempClusterKeys);
                        }
                        tempClusterKeys.add(proteinKey);
                        ArrayList<String> clusters = this.proteinClusters.get(proteinKey);
                        if (clusters == null) {
                            clusters = new ArrayList(nProteinClusters);
                            this.proteinClusters.put(proteinKey, clusters);
                        }
                        clusters.add(keyName);
                        found = true;
                    }
                    if (found) {
                        ProteinQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(spectrumProvider, proteinKey, waitingHandler);
                        double[] proteinRatios = new double[sampleIndexes.size()];
                        for (int sampleIndex = 0; sampleIndex < sampleIndexes.size(); ++sampleIndex) {
                            double logRatio;
                            Double ratio;
                            switch (proteinRatioType) {
                                case all: {
                                    ratio = quantificationDetails.getRatio(sampleIndexes.get(sampleIndex), reporterIonQuantification.getNormalizationFactors());
                                    break;
                                }
                                case shared: {
                                    ratio = quantificationDetails.getSharedRatio(sampleIndexes.get(sampleIndex), reporterIonQuantification.getNormalizationFactors());
                                    break;
                                }
                                case unique: {
                                    ratio = quantificationDetails.getUniqueRatio(sampleIndexes.get(sampleIndex), reporterIonQuantification.getNormalizationFactors());
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Ratio type " + (Object)((Object)proteinRatioType) + " not supported.");
                                }
                            }
                            if (ratio == null || ratio == 0.0) continue;
                            proteinRatios[sampleIndex] = logRatio = BasicMathFunctions.log(ratio, 2.0);
                            if (this.maxRatio == null || logRatio > this.maxRatio) {
                                this.maxRatio = logRatio;
                            }
                            if (this.minRatio != null && !(logRatio < this.minRatio)) continue;
                            this.minRatio = logRatio;
                        }
                        this.clusterKeys.add(proteinKeyAsString);
                        this.proteinKeysIndexes.put(proteinKey, clusteringIndex);
                        ratiosList.add(proteinRatios);
                        Integer sampleIndex = clusteringIndex;
                        clusteringIndex = clusteringIndex + 1;
                    }
                }
                waitingHandler.increasePrimaryProgressCounter();
            }
        }
        this.filteredPeptideKeys = new HashMap(metrics.getnValidatedProteins());
        this.peptideKeysIndexes = new HashMap(metrics.getnValidatedProteins());
        this.peptideClusters = new HashMap(nPeptideClusters);
        if (nPeptideClusters > 0) {
            PeptideMatch peptideMatch;
            PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
            while ((peptideMatch = peptideMatchesIterator.next()) != null) {
                Peptide peptide = peptideMatch.getPeptide();
                long peptideKey = peptideMatch.getKey();
                String peptideKeyAsString = Long.toString(peptideKey);
                psParameter = (PSParameter)identification.getPeptideMatch(peptideKey).getUrParam(psParameter);
                if (psParameter.getMatchValidationLevel().isValidated()) {
                    boolean found = false;
                    for (String keyName : clusteringSettings.getSelectedPeptideClasses()) {
                        boolean inCluster = true;
                        PeptideClusterClassKey peptideClusterClassKey = clusteringSettings.getPeptideClassKey(keyName);
                        if (peptideClusterClassKey.isStarred().booleanValue() && !psParameter.getStarred()) {
                            inCluster = false;
                        }
                        if (inCluster && peptideClusterClassKey.isNotModified() && peptide.getNVariableModifications() > 0) {
                            inCluster = false;
                            break;
                        }
                        if (inCluster && peptideClusterClassKey.getPossiblePtms() != null) {
                            boolean possiblePtms = false;
                            if (peptide.getNVariableModifications() > 0) {
                                for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                                    if (!peptideClusterClassKey.getPossiblePtmsAsSet().contains(modificationMatch.getModification())) continue;
                                    possiblePtms = true;
                                    break;
                                }
                            }
                            if (!possiblePtms) {
                                inCluster = false;
                            }
                        }
                        if (inCluster && peptideClusterClassKey.getForbiddenPtms() != null) {
                            boolean forbiddenPtms = false;
                            if (peptide.getNVariableModifications() > 0) {
                                for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                                    if (!peptideClusterClassKey.getForbiddenPtmsAsSet().contains(modificationMatch.getModification())) continue;
                                    forbiddenPtms = true;
                                    break;
                                }
                            }
                            if (forbiddenPtms) {
                                inCluster = false;
                            }
                        }
                        if (inCluster && peptideClusterClassKey.isNTerm().booleanValue() && PeptideUtils.isNterm(peptide, sequenceProvider)) {
                            inCluster = false;
                        }
                        if (inCluster && peptideClusterClassKey.isCTerm().booleanValue() && PeptideUtils.isCterm(peptide, sequenceProvider)) {
                            inCluster = false;
                        }
                        if (!inCluster) continue;
                        ArrayList<Long> tempClusterKeys = this.filteredPeptideKeys.get(keyName);
                        if (tempClusterKeys == null) {
                            tempClusterKeys = new ArrayList();
                            this.filteredPeptideKeys.put(keyName, tempClusterKeys);
                        }
                        tempClusterKeys.add(peptideKey);
                        ArrayList<String> clusters = this.peptideClusters.get(peptideKey);
                        if (clusters == null) {
                            clusters = new ArrayList(nPeptideClusters);
                            this.peptideClusters.put(peptideKey, clusters);
                        }
                        clusters.add(keyName);
                        found = true;
                    }
                    if (found) {
                        PeptideQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(spectrumProvider, peptideMatch, waitingHandler);
                        double[] peptideRatios = new double[sampleIndexes.size()];
                        for (int sampleIndex = 0; sampleIndex < sampleIndexes.size(); ++sampleIndex) {
                            double logRatio;
                            Double ratio = quantificationDetails.getRatio(sampleIndexes.get(sampleIndex), reporterIonQuantification.getNormalizationFactors());
                            if (ratio == null || ratio == 0.0) continue;
                            peptideRatios[sampleIndex] = logRatio = BasicMathFunctions.log(ratio, 2.0);
                            if (this.maxRatio == null || logRatio > this.maxRatio) {
                                this.maxRatio = logRatio;
                            }
                            if (this.minRatio != null && !(logRatio < this.minRatio)) continue;
                            this.minRatio = logRatio;
                        }
                        this.clusterKeys.add(peptideKeyAsString);
                        this.peptideKeysIndexes.put(peptideKey, clusteringIndex);
                        ratiosList.add(peptideRatios);
                        Integer sampleIndex = clusteringIndex;
                        clusteringIndex = clusteringIndex + 1;
                    }
                }
                waitingHandler.increasePrimaryProgressCounter();
            }
        }
        this.filteredPsmKeys = new HashMap(metrics.getnValidatedProteins());
        this.psmKeysIndexes = new HashMap(metrics.getnValidatedProteins());
        this.psmClusters = new HashMap(nPsmClusters);
        if (nPsmClusters > 0) {
            TreeSet<String> allMsFiles = new TreeSet<String>(identification.getSpectrumIdentification().keySet());
            HashSet<String> neededFiles = new HashSet<String>();
            for (String keyName : clusteringSettings.getSelectedPsmClasses()) {
                PsmClusterClassKey psmClusterClassKey = clusteringSettings.getPsmClassKey(keyName);
                if (psmClusterClassKey.getFile() == null) {
                    neededFiles.addAll(allMsFiles);
                    break;
                }
                neededFiles.add(psmClusterClassKey.getFile());
            }
            for (String spectrumFile : neededFiles) {
                SpectrumMatch spectrumMatch;
                SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
                while ((spectrumMatch = spectrumMatchesIterator.next()) != null) {
                    long spectrumKey = spectrumMatch.getKey();
                    String spectrumKeyAsString = Long.toString(spectrumKey);
                    psParameter = (PSParameter)identification.getSpectrumMatch(spectrumMatch.getKey()).getUrParam(psParameter);
                    if (psParameter.getMatchValidationLevel().isValidated()) {
                        boolean found = false;
                        for (String keyName : clusteringSettings.getSelectedPsmClasses()) {
                            boolean inCluster = true;
                            PsmClusterClassKey psmClusterClassKey = clusteringSettings.getPsmClassKey(keyName);
                            if (psmClusterClassKey.getFile() != null && !spectrumFile.equals(psmClusterClassKey.getFile())) {
                                inCluster = false;
                            }
                            if (inCluster && psmClusterClassKey.isStarred().booleanValue() && !psParameter.getStarred()) {
                                inCluster = false;
                            }
                            if (!inCluster) continue;
                            ArrayList<Long> tempClusterKeys = this.filteredPsmKeys.get(keyName);
                            if (tempClusterKeys == null) {
                                tempClusterKeys = new ArrayList();
                                this.filteredPsmKeys.put(keyName, tempClusterKeys);
                            }
                            tempClusterKeys.add(spectrumKey);
                            ArrayList<String> clusters = this.psmClusters.get(spectrumKey);
                            if (clusters == null) {
                                clusters = new ArrayList(nPsmClusters);
                                this.psmClusters.put(spectrumKey, clusters);
                            }
                            clusters.add(keyName);
                            found = true;
                        }
                        if (found) {
                            PsmQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getPSMQuantificationDetails(spectrumProvider, spectrumKey);
                            double[] psmRatios = new double[sampleIndexes.size()];
                            for (int sampleIndex = 0; sampleIndex < sampleIndexes.size(); ++sampleIndex) {
                                double logRatio;
                                Double ratio = quantificationDetails.getRatio(sampleIndexes.get(sampleIndex), reporterIonQuantification.getNormalizationFactors());
                                if (ratio == null || ratio == 0.0) continue;
                                psmRatios[sampleIndex] = logRatio = BasicMathFunctions.log(ratio, 2.0);
                                if (this.maxRatio == null || logRatio > this.maxRatio) {
                                    this.maxRatio = logRatio;
                                }
                                if (this.minRatio != null && !(logRatio < this.minRatio)) continue;
                                this.minRatio = logRatio;
                            }
                            this.clusterKeys.add(spectrumKeyAsString);
                            this.psmKeysIndexes.put(spectrumKey, clusteringIndex);
                            ratiosList.add(psmRatios);
                            Integer n = clusteringIndex;
                            clusteringIndex = clusteringIndex + 1;
                        }
                    }
                    waitingHandler.increasePrimaryProgressCounter();
                }
            }
        }
        this.ratios = (double[][])ratiosList.toArray((T[])new double[ratiosList.size()][sampleIndexes.size()]);
    }

    public Set<Long> getFilteredProteins() {
        HashSet<Long> proteinKeys = new HashSet<Long>(this.proteinClusters.keySet().size());
        for (Long proteinKey : this.proteinClusters.keySet()) {
            proteinKeys.add(proteinKey);
        }
        return proteinKeys;
    }

    public Set<Long> getFilteredPeptides() {
        HashSet<Long> peptideKeys = new HashSet<Long>(this.peptideClusters.keySet().size());
        for (Long peptideKey : this.peptideClusters.keySet()) {
            peptideKeys.add(peptideKey);
        }
        return peptideKeys;
    }

    public Set<Long> getFilteredPsms() {
        HashSet<Long> psmKeys = new HashSet<Long>(this.psmClusters.keySet().size());
        for (Long psmKey : this.psmClusters.keySet()) {
            psmKeys.add(psmKey);
        }
        return psmKeys;
    }

    public Double getMinRatio() {
        return this.minRatio;
    }

    public Double getMaxRatio() {
        return this.maxRatio;
    }

    public Double getRatioAmplitude() {
        return Math.max(Math.abs(this.minRatio), Math.abs(this.maxRatio));
    }

    public Integer getPsmIndex(Long key) {
        return this.psmKeysIndexes.get(key);
    }

    public Integer getPeptideIndex(Long key) {
        return this.peptideKeysIndexes.get(key);
    }

    public Integer getProteinIndex(Long key) {
        return this.proteinKeysIndexes.get(key);
    }

    public ArrayList<String> getProteinClasses(Long key) {
        return this.proteinClusters.get(key);
    }

    public ArrayList<String> getPeptideClasses(Long key) {
        return this.peptideClusters.get(key);
    }

    public ArrayList<String> getPsmClasses(Long key) {
        return this.psmClusters.get(key);
    }
}

