/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation.normalization;

public enum NormalizationType {
    none(0, "No normalization"),
    median(1, "Median"),
    mean(2, "Mean"),
    sum(3, "Sum"),
    mode(4, "Mode");

    public final int index;
    public final String name;

    private NormalizationType(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public static NormalizationType getNormalizationType(int index) {
        for (NormalizationType normalizationType : NormalizationType.values()) {
            if (normalizationType.index != index) continue;
            return normalizationType;
        }
        throw new IllegalArgumentException("No normalization type found for index " + index + ".");
    }

    public static NormalizationType getNormalizationType(String name) {
        for (NormalizationType normalizationType : NormalizationType.values()) {
            if (!normalizationType.name.equals(name)) continue;
            return normalizationType;
        }
        throw new IllegalArgumentException("No normalization type found for name " + name + ".");
    }

    public static String getCommandLineDescription() {
        StringBuilder sb = new StringBuilder();
        for (NormalizationType normalizationType : NormalizationType.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(normalizationType.index).append(": ").append(normalizationType.name);
        }
        return sb.toString();
    }
}

