/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.calculation.normalization;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import com.compomics.util.experiment.identification.matches.SpectrumMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.ProteinMatchesIterator;
import com.compomics.util.experiment.identification.matches_iterators.SpectrumMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.normalization.NormalizationFactors;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.calculation.QuantificationFilter;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.quantificationdetails.ProteinQuantificationDetails;
import eu.isas.reporter.quantificationdetails.PsmQuantificationDetails;
import eu.isas.reporter.settings.NormalizationSettings;
import eu.isas.reporter.settings.RatioEstimationSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Normalizer {
    public void setPsmNormalizationFactors(ReporterIonQuantification reporterIonQuantification, RatioEstimationSettings ratioEstimationSettings, NormalizationSettings normalizationSettings, SequenceMatchingParameters sequenceMatchingParameters, Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ProcessingParameters processingParameters, SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsPreferences, ExceptionHandler exceptionHandler, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        HashMap allRawRatios = new HashMap();
        HashMap seedRawRatios = new HashMap();
        for (String sampleIndex : reporterIonQuantification.getSampleIndexes()) {
            allRawRatios.put(sampleIndex, new ArrayList());
            seedRawRatios.put(sampleIndex, new ArrayList());
        }
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        if (normalizationSettings.getPsmNormalization() != NormalizationType.none) {
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("PSM Ratio Normalization. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(identification.getSpectrumIdentificationSize() + 1);
                waitingHandler.increaseSecondaryProgressCounter();
            }
            Collection<String> seeds = normalizationSettings.getStableProteins(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            Collection<String> exclusion = normalizationSettings.getContaminants(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            int nThreads = processingParameters.getnThreads();
            SpectrumMatchesIterator spectrumMatchesIterator = identification.getSpectrumMatchesIterator(waitingHandler);
            ExecutorService pool = Executors.newFixedThreadPool(nThreads);
            ArrayList<PsmNormalizerRunnable> runnables = new ArrayList<PsmNormalizerRunnable>(nThreads);
            for (int i = 1; i <= nThreads && waitingHandler != null && !waitingHandler.isRunCanceled(); ++i) {
                PsmNormalizerRunnable runnable = new PsmNormalizerRunnable(reporterIonQuantification, quantificationFeaturesGenerator, identification, spectrumProvider, spectrumMatchesIterator, seeds, exclusion, ratioEstimationSettings, sequenceMatchingParameters, waitingHandler, exceptionHandler);
                pool.submit(runnable);
                runnables.add(runnable);
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                pool.shutdownNow();
                return;
            }
            pool.shutdown();
            if (!pool.awaitTermination(7L, TimeUnit.DAYS)) {
                throw new InterruptedException("PSM validation timed out. Please contact the developers.");
            }
            for (PsmNormalizerRunnable runnable : runnables) {
                ArrayList ratios;
                for (String reagent : runnable.getAllRawRatios().keySet()) {
                    ratios = (ArrayList)allRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        allRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getAllRawRatios().get(reagent));
                }
                for (String reagent : runnable.getSeedRawRatios().keySet()) {
                    ratios = (ArrayList)seedRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        seedRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getSeedRawRatios().get(reagent));
                }
            }
        }
        NormalizationFactors normalizationFactors = reporterIonQuantification.getNormalizationFactors();
        for (String sampleIndex : reporterIonQuantification.getSampleIndexes()) {
            double normalisationFactor;
            ArrayList rawRatios = (ArrayList)allRawRatios.get(sampleIndex);
            ArrayList seedRatios = (ArrayList)seedRawRatios.get(sampleIndex);
            if (allRawRatios.get(sampleIndex) != null && !rawRatios.isEmpty()) {
                NormalizationType normalizationType = normalizationSettings.getPsmNormalization();
                if (null == normalizationType) {
                    throw new UnsupportedOperationException("Normalization method not implemented.");
                }
                switch (normalizationType) {
                    case none: {
                        normalisationFactor = 1.0;
                        break;
                    }
                    case mean: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.mean(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.mean(rawRatios);
                        break;
                    }
                    case median: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.median(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.median(rawRatios);
                        break;
                    }
                    case mode: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    case sum: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                }
            } else {
                normalisationFactor = 1.0;
            }
            normalizationFactors.addPsmNormalisationFactor(sampleIndex, normalisationFactor);
        }
    }

    public void setPeptideNormalizationFactors(ReporterIonQuantification reporterIonQuantification, RatioEstimationSettings ratioEstimationSettings, NormalizationSettings normalizationSettings, SequenceMatchingParameters sequenceMatchingParameters, Identification identification, SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ProcessingParameters processingParameters, SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsPreferences, ExceptionHandler exceptionHandler, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        HashMap allRawRatios = new HashMap();
        HashMap seedRawRatios = new HashMap();
        for (String sampleIndex : reporterIonQuantification.getSampleIndexes()) {
            allRawRatios.put(sampleIndex, new ArrayList());
            seedRawRatios.put(sampleIndex, new ArrayList());
        }
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        if (normalizationSettings.getPeptideNormalization() != NormalizationType.none) {
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Getting Stable Proteins and Contaminats. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            Collection<String> seeds = normalizationSettings.getStableProteins(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            Collection<String> exclusion = normalizationSettings.getContaminants(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Peptide Ratio Normalization. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(identification.getPeptideIdentification().size() + 1);
                waitingHandler.increaseSecondaryProgressCounter();
            }
            PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(waitingHandler);
            int nThreads = processingParameters.getnThreads();
            ExecutorService pool = Executors.newFixedThreadPool(nThreads);
            ArrayList<PeptideNormalizerRunnable> runnables = new ArrayList<PeptideNormalizerRunnable>(nThreads);
            for (int i = 1; i <= nThreads && waitingHandler != null && !waitingHandler.isRunCanceled(); ++i) {
                PeptideNormalizerRunnable runnable = new PeptideNormalizerRunnable(reporterIonQuantification, quantificationFeaturesGenerator, identification, spectrumProvider, peptideMatchesIterator, seeds, exclusion, ratioEstimationSettings, sequenceMatchingParameters, waitingHandler, exceptionHandler);
                pool.submit(runnable);
                runnables.add(runnable);
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                pool.shutdownNow();
                return;
            }
            pool.shutdown();
            if (!pool.awaitTermination(7L, TimeUnit.DAYS)) {
                throw new InterruptedException("Peptide validation timed out. Please contact the developers.");
            }
            for (PeptideNormalizerRunnable runnable : runnables) {
                ArrayList ratios;
                for (String reagent : runnable.getAllRawRatios().keySet()) {
                    ratios = (ArrayList)allRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        allRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getAllRawRatios().get(reagent));
                }
                for (String reagent : runnable.getSeedRawRatios().keySet()) {
                    ratios = (ArrayList)seedRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        seedRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getSeedRawRatios().get(reagent));
                }
            }
        }
        NormalizationFactors normalizationFactors = reporterIonQuantification.getNormalizationFactors();
        for (String sampleIndex : reporterIonQuantification.getSampleIndexes()) {
            double normalisationFactor;
            ArrayList rawRatios = (ArrayList)allRawRatios.get(sampleIndex);
            ArrayList seedRatios = (ArrayList)seedRawRatios.get(sampleIndex);
            if (allRawRatios.get(sampleIndex) != null && !rawRatios.isEmpty()) {
                NormalizationType normalizationType = normalizationSettings.getPeptideNormalization();
                if (null == normalizationType) {
                    throw new UnsupportedOperationException("Normalization method not implemented.");
                }
                switch (normalizationType) {
                    case none: {
                        normalisationFactor = 1.0;
                        break;
                    }
                    case mean: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.mean(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.mean(rawRatios);
                        break;
                    }
                    case median: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.median(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.median(rawRatios);
                        break;
                    }
                    case mode: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    case sum: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                }
            } else {
                normalisationFactor = 1.0;
            }
            normalizationFactors.addPeptideNormalisationFactor(sampleIndex, normalisationFactor);
        }
    }

    public void setProteinNormalizationFactors(ReporterIonQuantification reporterIonQuantification, RatioEstimationSettings ratioEstimationSettings, NormalizationSettings normalizationSettings, Identification identification, SpectrumProvider spectrumProvider, Metrics metrics, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ProcessingParameters processingParameters, SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsPreferences, ExceptionHandler exceptionHandler, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        Set<String> sampleIndexes = reporterIonQuantification.getSampleIndexes();
        HashMap allRawRatios = new HashMap(sampleIndexes.size());
        HashMap seedRawRatios = new HashMap(sampleIndexes.size());
        for (String sampleIndex : sampleIndexes) {
            allRawRatios.put(sampleIndex, new ArrayList(metrics.getnValidatedProteins()));
            seedRawRatios.put(sampleIndex, new ArrayList(metrics.getnValidatedProteins()));
        }
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        if (normalizationSettings.getProteinNormalization() != NormalizationType.none) {
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Getting Stable Proteins and Contaminats. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(true);
            }
            Collection<String> seeds = normalizationSettings.getStableProteins(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            Collection<String> exclusion = normalizationSettings.getContaminants(searchParameters, fastaParameters, peptideVariantsPreferences, waitingHandler);
            if (waitingHandler != null) {
                waitingHandler.setWaitingText("Protein Ratio Normalization. Please Wait...");
                waitingHandler.resetSecondaryProgressCounter();
                waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressCounter(identification.getProteinIdentification().size() + 1);
                waitingHandler.increaseSecondaryProgressCounter();
            }
            ProteinMatchesIterator proteinMatchesIterator = identification.getProteinMatchesIterator(waitingHandler);
            int nThreads = processingParameters.getnThreads();
            ExecutorService pool = Executors.newFixedThreadPool(nThreads);
            ArrayList<ProteinNormalizerRunnable> runnables = new ArrayList<ProteinNormalizerRunnable>(nThreads);
            for (int i = 1; i <= nThreads && waitingHandler != null && !waitingHandler.isRunCanceled(); ++i) {
                ProteinNormalizerRunnable runnable = new ProteinNormalizerRunnable(reporterIonQuantification, quantificationFeaturesGenerator, identification, spectrumProvider, proteinMatchesIterator, seeds, exclusion, ratioEstimationSettings, waitingHandler, exceptionHandler);
                pool.submit(runnable);
                runnables.add(runnable);
            }
            if (waitingHandler != null && waitingHandler.isRunCanceled()) {
                pool.shutdownNow();
                return;
            }
            pool.shutdown();
            if (!pool.awaitTermination(7L, TimeUnit.DAYS)) {
                throw new InterruptedException("Protein validation timed out. Please contact the developers.");
            }
            for (ProteinNormalizerRunnable runnable : runnables) {
                ArrayList ratios;
                for (String reagent : runnable.getAllRawRatios().keySet()) {
                    ratios = (ArrayList)allRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        allRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getAllRawRatios().get(reagent));
                }
                for (String reagent : runnable.getSeedRawRatios().keySet()) {
                    ratios = (ArrayList)seedRawRatios.get(reagent);
                    if (ratios == null) {
                        ratios = new ArrayList();
                        seedRawRatios.put(reagent, ratios);
                    }
                    ratios.addAll(runnable.getSeedRawRatios().get(reagent));
                }
            }
        }
        NormalizationFactors normalizationFactors = reporterIonQuantification.getNormalizationFactors();
        for (String sampleIndex : reporterIonQuantification.getSampleIndexes()) {
            double normalisationFactor;
            ArrayList rawRatios = (ArrayList)allRawRatios.get(sampleIndex);
            ArrayList seedRatios = (ArrayList)seedRawRatios.get(sampleIndex);
            if (rawRatios != null && !rawRatios.isEmpty()) {
                NormalizationType normalizationType = normalizationSettings.getProteinNormalization();
                if (null == normalizationType) {
                    throw new UnsupportedOperationException("Normalization method not implemented.");
                }
                switch (normalizationType) {
                    case none: {
                        normalisationFactor = 1.0;
                        break;
                    }
                    case mean: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.mean(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.mean(rawRatios);
                        break;
                    }
                    case median: {
                        if (seedRatios != null && !seedRatios.isEmpty()) {
                            normalisationFactor = BasicMathFunctions.median(seedRatios);
                            break;
                        }
                        normalisationFactor = BasicMathFunctions.median(rawRatios);
                        break;
                    }
                    case mode: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    case sum: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                    default: {
                        throw new UnsupportedOperationException("Normalization method not implemented.");
                    }
                }
            } else {
                normalisationFactor = 1.0;
            }
            normalizationFactors.addProteinNormalisationFactor(sampleIndex, normalisationFactor);
        }
    }

    private static boolean isSeed(Collection<String> seeds, String[] accessions) {
        for (String accession : accessions) {
            if (seeds.contains(accession)) continue;
            return false;
        }
        return true;
    }

    private static boolean isContaminant(Collection<String> contaminants, String[] accessions) {
        for (String accession : accessions) {
            if (!contaminants.contains(accession)) continue;
            return true;
        }
        return false;
    }

    private class PsmNormalizerRunnable
    implements Runnable {
        private ReporterIonQuantification reporterIonQuantification;
        private SpectrumMatchesIterator spectrumMatchesIterator;
        private Identification identification;
        private SpectrumProvider spectrumProvider;
        private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
        private Collection<String> seeds;
        private Collection<String> exclusion;
        private SequenceMatchingParameters sequenceMatchingParameters;
        private RatioEstimationSettings ratioEstimationSettings;
        private HashMap<String, ArrayList<Double>> allRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> seedRawRatios = new HashMap();
        private WaitingHandler waitingHandler;
        private ExceptionHandler exceptionHandler;

        public PsmNormalizerRunnable(ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, Identification identification, SpectrumProvider spectrumProvider, SpectrumMatchesIterator spectrumMatchesIterator, Collection<String> seeds, Collection<String> exclusion, RatioEstimationSettings ratioEstimationSettings, SequenceMatchingParameters sequenceMatchingParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.reporterIonQuantification = reporterIonQuantification;
            this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
            this.spectrumMatchesIterator = spectrumMatchesIterator;
            this.identification = identification;
            this.spectrumProvider = spectrumProvider;
            this.seeds = seeds;
            this.exclusion = exclusion;
            this.sequenceMatchingParameters = sequenceMatchingParameters;
            this.ratioEstimationSettings = ratioEstimationSettings;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                SpectrumMatch spectrumMatch;
                PSParameter psParameter = new PSParameter();
                while ((spectrumMatch = this.spectrumMatchesIterator.next()) != null) {
                    PeptideAssumption peptideAssumption;
                    if (spectrumMatch != null && (peptideAssumption = spectrumMatch.getBestPeptideAssumption()) != null) {
                        Peptide peptide = peptideAssumption.getPeptide();
                        String[] parentProteins = (String[])peptide.getProteinMapping().keySet().stream().toArray(String[]::new);
                        if (!(this.exclusion != null && Normalizer.isContaminant(this.exclusion, parentProteins) || (psParameter = (PSParameter)this.identification.getSpectrumMatch(spectrumMatch.getKey()).getUrParam(psParameter)).getMatchValidationLevel().getIndex() < this.ratioEstimationSettings.getPsmValidationLevel().getIndex())) {
                            PsmQuantificationDetails matchQuantificationDetails = this.quantificationFeaturesGenerator.getPSMQuantificationDetails(this.spectrumProvider, spectrumMatch.getKey());
                            for (String sampleIndex : this.reporterIonQuantification.getSampleIndexes()) {
                                Double ratio = matchQuantificationDetails.getRawRatio(sampleIndex);
                                if (!QuantificationFilter.isRatioValid(this.ratioEstimationSettings, ratio) || !(ratio > 0.0)) continue;
                                ArrayList<Double> ratios = this.allRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.allRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                                if (this.seeds == null || !Normalizer.isSeed(this.seeds, parentProteins)) continue;
                                ratios = this.seedRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.seedRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                            }
                        }
                    }
                    if (this.waitingHandler == null) continue;
                    if (this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.waitingHandler.setRunCanceled();
                this.exceptionHandler.catchException(e);
            }
        }

        public HashMap<String, ArrayList<Double>> getAllRawRatios() {
            return this.allRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getSeedRawRatios() {
            return this.seedRawRatios;
        }
    }

    private class PeptideNormalizerRunnable
    implements Runnable {
        private ReporterIonQuantification reporterIonQuantification;
        private PeptideMatchesIterator peptideMatchesIterator;
        private Identification identification;
        private SpectrumProvider spectrumProvider;
        private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
        private Collection<String> seeds;
        private Collection<String> exclusion;
        private SequenceMatchingParameters sequenceMatchingParameters;
        private RatioEstimationSettings ratioEstimationSettings;
        private HashMap<String, ArrayList<Double>> allRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> seedRawRatios = new HashMap();
        private WaitingHandler waitingHandler;
        private ExceptionHandler exceptionHandler;

        public PeptideNormalizerRunnable(ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, Identification identification, SpectrumProvider spectrumProvider, PeptideMatchesIterator peptideMatchesIterator, Collection<String> seeds, Collection<String> exclusion, RatioEstimationSettings ratioEstimationSettings, SequenceMatchingParameters sequenceMatchingParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.reporterIonQuantification = reporterIonQuantification;
            this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
            this.peptideMatchesIterator = peptideMatchesIterator;
            this.identification = identification;
            this.spectrumProvider = spectrumProvider;
            this.seeds = seeds;
            this.exclusion = exclusion;
            this.sequenceMatchingParameters = sequenceMatchingParameters;
            this.ratioEstimationSettings = ratioEstimationSettings;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                PeptideMatch peptideMatch;
                PSParameter psParameter = new PSParameter();
                while ((peptideMatch = this.peptideMatchesIterator.next()) != null) {
                    if (peptideMatch != null) {
                        long peptideKey;
                        Peptide peptide = peptideMatch.getPeptide();
                        String[] parentProteins = (String[])peptide.getProteinMapping().keySet().stream().toArray(String[]::new);
                        if (!(this.exclusion != null && Normalizer.isContaminant(this.exclusion, parentProteins) || (psParameter = (PSParameter)this.identification.getPeptideMatch(peptideKey = peptideMatch.getKey()).getUrParam(psParameter)).getMatchValidationLevel().getIndex() < this.ratioEstimationSettings.getPeptideValidationLevel().getIndex())) {
                            PeptideQuantificationDetails matchQuantificationDetails = this.quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(this.spectrumProvider, peptideMatch, this.waitingHandler);
                            for (String sampleIndex : this.reporterIonQuantification.getSampleIndexes()) {
                                Double ratio = matchQuantificationDetails.getRawRatio(sampleIndex);
                                if (!QuantificationFilter.isRatioValid(this.ratioEstimationSettings, ratio) || !(ratio > 0.0)) continue;
                                ArrayList<Double> ratios = this.allRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.allRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                                if (this.seeds == null || !Normalizer.isSeed(this.seeds, parentProteins)) continue;
                                ratios = this.seedRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.seedRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                            }
                        }
                    }
                    if (this.waitingHandler == null) continue;
                    if (this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.waitingHandler.setRunCanceled();
                this.exceptionHandler.catchException(e);
            }
        }

        public HashMap<String, ArrayList<Double>> getAllRawRatios() {
            return this.allRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getSeedRawRatios() {
            return this.seedRawRatios;
        }
    }

    private class ProteinNormalizerRunnable
    implements Runnable {
        private ReporterIonQuantification reporterIonQuantification;
        private ProteinMatchesIterator proteinMatchesIterator;
        private Identification identification;
        private SpectrumProvider spectrumProvider;
        private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
        private Collection<String> seeds;
        private Collection<String> exclusion;
        private RatioEstimationSettings ratioEstimationSettings;
        private HashMap<String, ArrayList<Double>> allRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> seedRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> allUniqueRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> seedUniqueRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> allSharedRawRatios = new HashMap();
        private HashMap<String, ArrayList<Double>> seedSharedRawRatios = new HashMap();
        private WaitingHandler waitingHandler;
        private ExceptionHandler exceptionHandler;

        public ProteinNormalizerRunnable(ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, Identification identification, SpectrumProvider spectrumProvider, ProteinMatchesIterator proteinMatchesIterator, Collection<String> seeds, Collection<String> exclusion, RatioEstimationSettings ratioEstimationSettings, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
            this.reporterIonQuantification = reporterIonQuantification;
            this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
            this.proteinMatchesIterator = proteinMatchesIterator;
            this.identification = identification;
            this.spectrumProvider = spectrumProvider;
            this.seeds = seeds;
            this.exclusion = exclusion;
            this.ratioEstimationSettings = ratioEstimationSettings;
            this.waitingHandler = waitingHandler;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                ProteinMatch proteinMatch;
                PSParameter psParameter = new PSParameter();
                while ((proteinMatch = this.proteinMatchesIterator.next()) != null) {
                    long proteinMatchKey;
                    if (!(proteinMatch == null || this.exclusion != null && Normalizer.isContaminant(this.exclusion, proteinMatch.getAccessions()) || (psParameter = (PSParameter)this.identification.getProteinMatch(proteinMatchKey = proteinMatch.getKey()).getUrParam(psParameter)).getMatchValidationLevel().getIndex() < this.ratioEstimationSettings.getProteinValidationLevel().getIndex())) {
                        ProteinQuantificationDetails matchQuantificationDetails = this.quantificationFeaturesGenerator.getProteinMatchQuantificationDetails(this.spectrumProvider, proteinMatchKey, this.waitingHandler);
                        for (String sampleIndex : this.reporterIonQuantification.getSampleIndexes()) {
                            ArrayList<Double> ratios;
                            Double ratio = matchQuantificationDetails.getRawRatio(sampleIndex);
                            if (QuantificationFilter.isRatioValid(this.ratioEstimationSettings, ratio) && ratio > 0.0) {
                                ratios = this.allRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.allRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                                if (this.seeds != null && Normalizer.isSeed(this.seeds, proteinMatch.getAccessions())) {
                                    ratios = this.seedRawRatios.get(sampleIndex);
                                    if (ratios == null) {
                                        ratios = new ArrayList();
                                        this.seedRawRatios.put(sampleIndex, ratios);
                                    }
                                    ratios.add(ratio);
                                }
                            }
                            if (QuantificationFilter.isRatioValid(this.ratioEstimationSettings, ratio = matchQuantificationDetails.getUniqueRawRatio(sampleIndex)) && ratio > 0.0) {
                                ratios = this.allUniqueRawRatios.get(sampleIndex);
                                if (ratios == null) {
                                    ratios = new ArrayList();
                                    this.allUniqueRawRatios.put(sampleIndex, ratios);
                                }
                                ratios.add(ratio);
                                if (this.seeds != null && Normalizer.isSeed(this.seeds, proteinMatch.getAccessions())) {
                                    ratios = this.seedUniqueRawRatios.get(sampleIndex);
                                    if (ratios == null) {
                                        ratios = new ArrayList();
                                        this.seedUniqueRawRatios.put(sampleIndex, ratios);
                                    }
                                    ratios.add(ratio);
                                }
                            }
                            if (!QuantificationFilter.isRatioValid(this.ratioEstimationSettings, ratio = matchQuantificationDetails.getSharedRawRatio(sampleIndex)) || !(ratio > 0.0)) continue;
                            ratios = this.allSharedRawRatios.get(sampleIndex);
                            if (ratios == null) {
                                ratios = new ArrayList();
                                this.allSharedRawRatios.put(sampleIndex, ratios);
                            }
                            ratios.add(ratio);
                            if (this.seeds == null || !Normalizer.isSeed(this.seeds, proteinMatch.getAccessions())) continue;
                            ratios = this.seedSharedRawRatios.get(sampleIndex);
                            if (ratios == null) {
                                ratios = new ArrayList();
                                this.seedSharedRawRatios.put(sampleIndex, ratios);
                            }
                            ratios.add(ratio);
                        }
                    }
                    if (this.waitingHandler == null) continue;
                    if (this.waitingHandler.isRunCanceled()) {
                        return;
                    }
                    this.waitingHandler.increaseSecondaryProgressCounter();
                }
            }
            catch (Exception e) {
                this.waitingHandler.setRunCanceled();
                this.exceptionHandler.catchException(e);
            }
        }

        public HashMap<String, ArrayList<Double>> getAllRawRatios() {
            return this.allRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getSeedRawRatios() {
            return this.seedRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getAllUniqueRawRatios() {
            return this.allUniqueRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getSeedUniqueRawRatios() {
            return this.seedUniqueRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getAllSharedRawRatios() {
            return this.allSharedRawRatios;
        }

        public HashMap<String, ArrayList<Double>> getSeedSharedRawRatios() {
            return this.seedSharedRawRatios;
        }
    }
}

