/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.cli.ReportCLIInputBean;
import eu.isas.reporter.export.report.ReporterExportFactory;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.math.MathException;

public class CLIExportMethods {
    public static void exportReport(ReportCLIInputBean reportCLIInputBean, String reportType, String experiment, ProjectDetails projectDetails, Identification identification, GeneMaps geneMaps, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, IdentificationParameters identificationParameters, int nSurroundingAA, SpectrumCountingParameters spectrumCountingParameters, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, MathException {
        ReporterExportFactory exportFactory = ReporterExportFactory.getInstance();
        ExportScheme exportScheme = exportFactory.getExportScheme(reportType);
        String reportName = reportType.replaceAll(" ", "_");
        reportName = ReporterExportFactory.getDefaultReportName(experiment, reportName);
        if (reportCLIInputBean.getReportNamePrefix() != null) {
            reportName = reportCLIInputBean.getReportNamePrefix() + reportName;
        }
        File reportFile = new File(reportCLIInputBean.getReportOutputFolder(), reportName);
        ReporterExportFactory.writeExport(exportScheme, reportFile, ExportFormat.text, experiment, projectDetails, identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, geneMaps, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, null, null, null, null, nSurroundingAA, spectrumCountingParameters, waitingHandler);
    }

    public static void exportDocumentation(ReportCLIInputBean reportCLIInputBean, String reportType, WaitingHandler waitingHandler) throws IOException {
        ReporterExportFactory exportFactory = ReporterExportFactory.getInstance();
        ExportScheme exportScheme = exportFactory.getExportScheme(reportType);
        File reportFile = new File(reportCLIInputBean.getReportOutputFolder(), ReporterExportFactory.getDefaultDocumentation(reportType));
        ReporterExportFactory.writeDocumentation(exportScheme, ExportFormat.text, reportFile);
    }
}

