/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathParameters;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.cli.PathSettingsCLIInputBean;
import eu.isas.reporter.cli.PathSettingsCLIParams;
import eu.isas.reporter.cli.ReporterCLI;
import eu.isas.reporter.preferences.ReporterPathPreferences;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PathSettingsCLI {
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private WaitingHandler waitingHandler;

    public PathSettingsCLI(PathSettingsCLIInputBean pathSettingsCLIInputBean) {
        this.pathSettingsCLIInputBean = pathSettingsCLIInputBean;
    }

    public Object call() {
        this.waitingHandler = new WaitingHandlerCLIImpl();
        this.setPathSettings();
        if (!this.waitingHandler.isRunCanceled()) {
            System.exit(0);
            return 0;
        }
        System.exit(1);
        return 1;
    }

    public void setPathSettings() {
        if (this.waitingHandler == null) {
            this.waitingHandler = new WaitingHandlerCLIImpl();
        }
        if (this.pathSettingsCLIInputBean.useLogFile()) {
            if (this.pathSettingsCLIInputBean.getLogFolder() != null) {
                ReporterCLI.redirectErrorStream(this.pathSettingsCLIInputBean.getLogFolder());
            } else {
                ReporterCLI.redirectErrorStream(new File(this.getJarFilePath() + File.separator + "resources"));
            }
        } else {
            System.setErr(new PrintStream(System.out));
        }
        if (this.pathSettingsCLIInputBean.hasInput()) {
            String path = this.pathSettingsCLIInputBean.getTempFolder();
            if (!path.equals("")) {
                try {
                    Reporter.setTempFolderPath(path);
                    ReporterPathPreferences.setAllPathsIn(path);
                }
                catch (Exception e) {
                    System.out.println("An error occurred when setting the temporary folder path.");
                    e.printStackTrace();
                }
            }
            HashMap<String, String> pathInput = this.pathSettingsCLIInputBean.getPaths();
            for (String id : pathInput.keySet()) {
                try {
                    ReporterPathPreferences.ReporterPathKey reporterPathKey = ReporterPathPreferences.ReporterPathKey.getKeyFromId(id);
                    if (reporterPathKey == null) {
                        UtilitiesPathParameters.UtilitiesPathKey utilitiesPathKey = UtilitiesPathParameters.UtilitiesPathKey.getKeyFromId(id);
                        if (utilitiesPathKey == null) {
                            System.out.println("Path id " + id + " not recognized.");
                            continue;
                        }
                        UtilitiesPathParameters.setPathParameter(utilitiesPathKey, pathInput.get(id));
                        continue;
                    }
                    ReporterPathPreferences.setPathPreference(reporterPathKey, pathInput.get(id));
                }
                catch (Exception e) {
                    System.out.println("An error occurred when setting the path " + id + ".");
                    e.printStackTrace();
                }
            }
            File destinationFile = new File(Reporter.getConfigFolder(), "resources/conf/paths.txt");
            try {
                ReporterPathPreferences.writeConfigurationToFile(destinationFile);
            }
            catch (Exception e) {
                System.out.println("An error occurred when saving the path preference to " + destinationFile.getAbsolutePath() + ".");
                e.printStackTrace();
            }
            if (!this.waitingHandler.isRunCanceled()) {
                System.out.println("Path configuration completed.");
            }
        } else {
            try {
                File pathConfigurationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
                if (pathConfigurationFile.exists()) {
                    ReporterPathPreferences.loadPathParametersFromFile(pathConfigurationFile);
                }
            }
            catch (Exception e) {
                System.out.println("An error occurred when setting path configuration. Default paths will be used.");
                e.printStackTrace();
            }
        }
        try {
            ArrayList<PathKey> errorKeys = ReporterPathPreferences.getErrorKeys(this.getJarFilePath());
            if (!errorKeys.isEmpty()) {
                System.out.println("Unable to write in the following configuration folders. Please use a temporary folder, the path configuration command line, or edit the configuration paths from the graphical interface.");
                for (PathKey pathKey : errorKeys) {
                    System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default paths will be used.");
        }
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "The Reporter path settings command line allows setting the path of every configuration file created by Reporter or set a temporary folder where all files will be stored." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see https://compomics.github.io/projects/reporter.html and https://compomics.github.io/projects/reporter/wiki/reportercli.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/reporter." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + System.getProperty("line.separator");
    }

    public static void main(String[] args) {
        try {
            Options lOptions = new Options();
            PathSettingsCLIParams.createOptionsCLI(lOptions);
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(lOptions, args);
            if (args.length == 0) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "========================================" + System.getProperty("line.separator"));
                lPrintWriter.print("Reporter Path Settings - Command Line" + System.getProperty("line.separator"));
                lPrintWriter.print("========================================" + System.getProperty("line.separator"));
                lPrintWriter.print(PathSettingsCLI.getHeader());
                lPrintWriter.print(PathSettingsCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                PathSettingsCLIInputBean cliInputBean = new PathSettingsCLIInputBean(line);
                PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(cliInputBean);
                pathSettingsCLI.call();
            }
        }
        catch (OutOfMemoryError e) {
            System.out.println("Reporter used up all the memory and had to be stopped. See the Reporter log for details.");
            System.err.println("Ran out of memory!");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Memory used by the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory in the Java virtual machine: " + Runtime.getRuntime().freeMemory() + ".");
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Reporter processing failed. See the Reporter log for details.");
            e.printStackTrace();
        }
    }

    public String toString() {
        return "PathSettingsCLI{, cliInputBean=" + this.pathSettingsCLIInputBean + '}';
    }

    public static String[] extractAndUpdatePathOptions(String[] args) throws ParseException {
        ArrayList<String> allPathOptions = PathSettingsCLIParams.getOptionIDs();
        ArrayList<String> pathSettingArgs = new ArrayList<String>();
        ArrayList<String> nonPathSettingArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String nextArg;
            String currentArg = args[i];
            boolean pathOption = allPathOptions.contains(currentArg);
            if (pathOption) {
                pathSettingArgs.add(currentArg);
            } else {
                nonPathSettingArgs.add(currentArg);
            }
            if (i + 1 >= args.length || (nextArg = args[i + 1]).startsWith("-")) continue;
            if (pathOption) {
                pathSettingArgs.add(args[++i]);
                continue;
            }
            nonPathSettingArgs.add(args[++i]);
        }
        String[] pathSettingArgsAsList = pathSettingArgs.toArray(new String[pathSettingArgs.size()]);
        String[] nonPathSettingArgsAsList = nonPathSettingArgs.toArray(new String[nonPathSettingArgs.size()]);
        Options pathOptions = new Options();
        PathSettingsCLIParams.createOptionsCLI(pathOptions);
        DefaultParser parser = new DefaultParser();
        CommandLine line = parser.parse(pathOptions, pathSettingArgsAsList);
        PathSettingsCLIInputBean pathSettingsCLIInputBean = new PathSettingsCLIInputBean(line);
        PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(pathSettingsCLIInputBean);
        pathSettingsCLI.setPathSettings();
        return nonPathSettingArgsAsList;
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("ReporterCLI.class").getPath(), "Reporter");
    }
}

