/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.software.settings.UtilitiesPathParameters;
import eu.isas.reporter.preferences.ReporterPathPreferences;
import java.util.ArrayList;
import org.apache.commons.cli.Options;

public enum PathSettingsCLIParams {
    ALL("temp_folder", "A folder for temporary file storage. Use only if you encounter problems with the default configuration."),
    LOG_FOLDER("log", "Folder where the log files are written."),
    USE_LOG_FOLDER("use_log_folder", "Use the log folder. 0: write to standard output, 1: use the log folder. Default: 1.");

    public String id;
    public String description;

    private PathSettingsCLIParams(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (PathSettingsCLIParams pathSettingsCLIParams : PathSettingsCLIParams.values()) {
            aOptions.addOption(pathSettingsCLIParams.id, true, pathSettingsCLIParams.description);
        }
        for (Enum enum_ : ReporterPathPreferences.ReporterPathKey.values()) {
            aOptions.addOption(((ReporterPathPreferences.ReporterPathKey)enum_).getId(), true, ((ReporterPathPreferences.ReporterPathKey)enum_).getDescription());
        }
        for (Enum enum_ : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            aOptions.addOption(((UtilitiesPathParameters.UtilitiesPathKey)enum_).getId(), true, ((UtilitiesPathParameters.UtilitiesPathKey)enum_).getDescription());
        }
    }

    public static ArrayList<String> getOptionIDs() {
        ArrayList<String> options = new ArrayList<String>();
        for (PathSettingsCLIParams pathSettingsCLIParams : PathSettingsCLIParams.values()) {
            options.add("-" + pathSettingsCLIParams.id);
        }
        for (Enum enum_ : ReporterPathPreferences.ReporterPathKey.values()) {
            options.add("-" + ((ReporterPathPreferences.ReporterPathKey)enum_).getId());
        }
        for (Enum enum_ : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            options.add("-" + ((UtilitiesPathParameters.UtilitiesPathKey)enum_).getId());
        }
        return options;
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Log Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.LOG_FOLDER.id) + " " + PathSettingsCLIParams.LOG_FOLDER.description + "\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.USE_LOG_FOLDER.id) + " " + PathSettingsCLIParams.USE_LOG_FOLDER.description + "\n";
        output = output + "Generic Temporary Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        output = output + "\n\nSpecific Path Setting:\n\n";
        for (ReporterPathPreferences.ReporterPathKey reporterPathKey : ReporterPathPreferences.ReporterPathKey.values()) {
            output = output + "-" + String.format(formatter, reporterPathKey.getId()) + " " + reporterPathKey.getDescription() + System.getProperty("line.separator");
        }
        for (Enum enum_ : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            output = output + "-" + String.format(formatter, ((UtilitiesPathParameters.UtilitiesPathKey)enum_).getId()) + " " + ((UtilitiesPathParameters.UtilitiesPathKey)enum_).getDescription() + System.getProperty("line.separator");
        }
        return output;
    }
}

