/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.software.cli.CommandLineUtils;
import eu.isas.reporter.cli.PathSettingsCLIInputBean;
import eu.isas.reporter.cli.ReportCLIParams;
import eu.isas.reporter.export.report.ReporterExportFactory;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;

public class ReportCLIInputBean {
    private File psdbFile = null;
    private File reportOutputFolder = null;
    private String reportNamePrefix = null;
    private ArrayList<String> reportTypes = new ArrayList();
    private ArrayList<String> documentationTypes = new ArrayList();
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;

    public ReportCLIInputBean(CommandLine aLine) {
        ReporterExportFactory exportFactory;
        ArrayList<Integer> options;
        if (aLine.hasOption(ReportCLIParams.PSDB_FILE.id)) {
            String file = aLine.getOptionValue(ReportCLIParams.PSDB_FILE.id);
            if (file.toLowerCase().endsWith(".psdb") || file.toLowerCase().endsWith(".zip")) {
                this.psdbFile = new File(file);
            } else {
                throw new IllegalArgumentException("Unknown file format '" + file + "' for PeptideShaker project input.");
            }
        }
        if (aLine.hasOption(ReportCLIParams.EXPORT_FOLDER.id)) {
            this.reportOutputFolder = new File(aLine.getOptionValue(ReportCLIParams.EXPORT_FOLDER.id));
        }
        if (aLine.hasOption(ReportCLIParams.EXPORT_PREFIX.id)) {
            this.reportNamePrefix = aLine.getOptionValue(ReportCLIParams.EXPORT_PREFIX.id);
        }
        if (aLine.hasOption(ReportCLIParams.REPORT_TYPE.id)) {
            options = CommandLineUtils.getIntegerListFromString(aLine.getOptionValue(ReportCLIParams.REPORT_TYPE.id), ",");
            exportFactory = ReporterExportFactory.getInstance();
            for (int option : options) {
                this.reportTypes.add(exportFactory.getExportTypeFromCommandLineOption(option));
            }
        }
        if (aLine.hasOption(ReportCLIParams.DOCUMENTATION_TYPE.id)) {
            options = CommandLineUtils.getIntegerListFromString(aLine.getOptionValue(ReportCLIParams.DOCUMENTATION_TYPE.id), ",");
            exportFactory = ReporterExportFactory.getInstance();
            for (int option : options) {
                this.documentationTypes.add(exportFactory.getExportTypeFromCommandLineOption(option));
            }
        }
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    public File getPsdbFile() {
        return this.psdbFile;
    }

    public File getReportOutputFolder() {
        return this.reportOutputFolder;
    }

    public void setReportOutputFolder(File outputFolder) {
        this.reportOutputFolder = outputFolder;
    }

    public String getReportNamePrefix() {
        return this.reportNamePrefix;
    }

    public void setReportNamePrefix(String reportNamePrefix) {
        this.reportNamePrefix = reportNamePrefix;
    }

    public ArrayList<String> getReportTypes() {
        return this.reportTypes;
    }

    public ArrayList<String> getDocumentationTypes() {
        return this.documentationTypes;
    }

    public boolean exportNeeded() {
        return this.reportExportNeeded() || this.documentationExportNeeded();
    }

    public boolean reportExportNeeded() {
        return this.reportOutputFolder != null && !this.reportTypes.isEmpty();
    }

    public boolean documentationExportNeeded() {
        return this.reportOutputFolder != null && !this.documentationTypes.isEmpty();
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }
}

