/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import eu.isas.reporter.cli.PathSettingsCLIParams;
import eu.isas.reporter.export.report.ReporterExportFactory;
import org.apache.commons.cli.Options;

public enum ReportCLIParams {
    PSDB_FILE("in", "Reporter project (.psdb or .zip file)", true, true),
    EXPORT_FOLDER("out_reports", "Output folder for report files. (Existing files will be overwritten.)", true, true),
    EXPORT_PREFIX("report_prefix", "Prefix added to the report file name.", false, true),
    REPORT_TYPE("reports", "Comma separated list of types of report to export. " + ReporterExportFactory.getInstance().getCommandLineOptions(), false, true),
    DOCUMENTATION_TYPE("documentation", "Comma separated list of types of report documentation to export. " + ReporterExportFactory.getInstance().getCommandLineOptions(), false, true);

    public final String id;
    public final String description;
    public final boolean mandatory;
    public final boolean hasArg;

    private ReportCLIParams(String id, String description, boolean mandatory, boolean hasArg) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
        this.hasArg = hasArg;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (ReportCLIParams reportCLIParams : ReportCLIParams.values()) {
            aOptions.addOption(reportCLIParams.id, reportCLIParams.hasArg, reportCLIParams.description);
        }
        aOptions.addOption(PathSettingsCLIParams.ALL.id, true, PathSettingsCLIParams.ALL.description);
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Mandatory parameters:\n\n";
        output = output + "-" + String.format(formatter, ReportCLIParams.PSDB_FILE.id) + ReportCLIParams.PSDB_FILE.description + "\n";
        output = output + "-" + String.format(formatter, ReportCLIParams.EXPORT_FOLDER.id) + ReportCLIParams.EXPORT_FOLDER.description + "\n";
        output = output + "\n\nOptional output parameters:\n";
        output = output + ReportCLIParams.getOutputOptionsAsString();
        output = output + "\n\nOptional temporary folder and name prefix:\n\n";
        output = output + "-" + String.format(formatter, ReportCLIParams.EXPORT_PREFIX.id) + ReportCLIParams.EXPORT_PREFIX.description + "\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + PathSettingsCLIParams.ALL.description + "\n";
        return output;
    }

    public static String getOutputOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "\nReport export:\n\n";
        output = output + "-" + String.format(formatter, ReportCLIParams.REPORT_TYPE.id) + ReportCLIParams.REPORT_TYPE.description + "\n";
        output = output + "\nReport Documentation export:\n\n";
        output = output + "-" + String.format(formatter, ReportCLIParams.DOCUMENTATION_TYPE.id) + ReportCLIParams.DOCUMENTATION_TYPE.description + "\n";
        return output;
    }
}

