/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.cli.identification_parameters.IdentificationParametersInputBean;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.parameters.identification.IdentificationParameters;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import eu.isas.reporter.cli.PathSettingsCLIInputBean;
import eu.isas.reporter.cli.ReportCLIInputBean;
import eu.isas.reporter.cli.ReporterCLIParameters;
import eu.isas.reporter.settings.ReporterIonsLocationType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;

public class ReporterCLIInputBean {
    private File peptideShakerFile;
    private File outputFile = null;
    private File configFolder = null;
    private File isotopesFile = null;
    private int nThreads = Runtime.getRuntime().availableProcessors();
    private IdentificationParametersInputBean identificationParametersInputBean;
    private PathSettingsCLIInputBean pathSettingsCLIInputBean;
    private ReportCLIInputBean reportCLIInputBean;
    private String reporterMethod = null;
    private ArrayList<Integer> referenceSamples = null;
    private Double reporterIonTolerance = null;
    private Boolean mostAccurate = null;
    private ReporterIonsLocationType reporterIonsLocation = ReporterIonsLocationType.ms2Spectra;
    private Double precMzTolerance = null;
    private Boolean precMzTolerancePpm = null;
    private Double precRtTolerance = null;
    private Boolean ignoreNull = null;
    private Boolean ignoreMc = null;
    private Double percentile = null;
    private Double resolution = null;
    private Integer minUnique = null;
    private ArrayList<String> ignoredPtms = null;
    private Integer validationPsm = null;
    private Integer validationPeptide = null;
    private Integer validationProtein = null;
    private NormalizationType psmNormalizationType = null;
    private NormalizationType peptideNormalizationType = null;
    private NormalizationType proteinNormalizationType = null;
    private File stableProteins = null;
    private File contaminants = null;
    private File zipExport = null;

    public ReporterCLIInputBean(CommandLine aLine) throws IOException, ClassNotFoundException {
        Integer index;
        Number input;
        String arg = aLine.getOptionValue(ReporterCLIParameters.ID.id);
        this.peptideShakerFile = new File(arg);
        if (aLine.hasOption(ReporterCLIParameters.OUT.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.OUT.id);
            this.outputFile = new File(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.CONFIG_FOLDER.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.CONFIG_FOLDER.id);
            this.configFolder = new File(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.ISOTOPES.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.ISOTOPES.id);
            this.isotopesFile = new File(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.THREADS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.THREADS.id);
            this.nThreads = Integer.parseInt(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.METHOD.id)) {
            this.reporterMethod = arg = aLine.getOptionValue(ReporterCLIParameters.METHOD.id);
        }
        if (aLine.hasOption(ReporterCLIParameters.REFERENCE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.REFERENCE.id);
            this.referenceSamples = CommandLineUtils.getIntegerListFromString(arg, ",");
            Collections.sort(this.referenceSamples);
        }
        if (aLine.hasOption(ReporterCLIParameters.ION_TOL.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.ION_TOL.id);
            input = Double.valueOf(arg);
            this.reporterIonTolerance = input;
        }
        if (aLine.hasOption(ReporterCLIParameters.MOST_ACCURATE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.MOST_ACCURATE.id);
            input = Integer.valueOf(arg);
            this.mostAccurate = ((Integer)input).equals(1);
        }
        if (aLine.hasOption(ReporterCLIParameters.REPORTER_IONS_LOCATION.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.REPORTER_IONS_LOCATION.id);
            index = Integer.valueOf(arg);
            this.reporterIonsLocation = ReporterIonsLocationType.getReporterIonsLocationType(index);
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_MZ_TOL.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_MZ_TOL.id);
            input = Double.valueOf(arg);
            this.precMzTolerance = input;
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_MZ_TOL_PPM.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_MZ_TOL_PPM.id);
            input = Integer.valueOf(arg);
            this.precMzTolerancePpm = ((Integer)input).equals(1);
        }
        if (aLine.hasOption(ReporterCLIParameters.PREC_WINDOW_RT_TOL.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.PREC_WINDOW_RT_TOL.id);
            input = Double.valueOf(arg);
            this.precRtTolerance = input;
        }
        if (aLine.hasOption(ReporterCLIParameters.IGNORE_NULL.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.IGNORE_NULL.id);
            input = Integer.valueOf(arg);
            this.ignoreNull = ((Integer)input).equals(1);
        }
        if (aLine.hasOption(ReporterCLIParameters.IGNORE_MC.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.IGNORE_MC.id);
            input = Integer.valueOf(arg);
            this.ignoreMc = ((Integer)input).equals(1);
        }
        if (aLine.hasOption(ReporterCLIParameters.PERCENTILE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.PERCENTILE.id);
            input = Double.valueOf(arg);
            this.percentile = input;
        }
        if (aLine.hasOption(ReporterCLIParameters.RESOLUTION.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.RESOLUTION.id);
            input = Double.valueOf(arg);
            this.resolution = input;
        }
        if (aLine.hasOption(ReporterCLIParameters.MIN_UNIQUE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.MIN_UNIQUE.id);
            this.minUnique = Integer.valueOf(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.IGNORE_PTMS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.IGNORE_PTMS.id);
            this.ignoredPtms = CommandLineUtils.splitInput(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PSM.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PSM.id);
            this.validationPsm = Integer.valueOf(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PEPTIDE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PEPTIDE.id);
            this.validationPeptide = Integer.valueOf(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.VALIDATION_PROTEIN.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.VALIDATION_PROTEIN.id);
            this.validationProtein = Integer.valueOf(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PSM.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PSM.id);
            index = Integer.valueOf(arg);
            this.psmNormalizationType = NormalizationType.getNormalizationType(index);
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PEPTIDE.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PEPTIDE.id);
            index = Integer.valueOf(arg);
            this.peptideNormalizationType = NormalizationType.getNormalizationType(index);
        }
        if (aLine.hasOption(ReporterCLIParameters.NORMALIZATION_PROTEIN.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.NORMALIZATION_PROTEIN.id);
            index = Integer.valueOf(arg);
            this.proteinNormalizationType = NormalizationType.getNormalizationType(index);
        }
        if (aLine.hasOption(ReporterCLIParameters.STABLE_PROTEINS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.STABLE_PROTEINS.id);
            this.stableProteins = new File(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.CONTAMINANTS.id)) {
            arg = aLine.getOptionValue(ReporterCLIParameters.CONTAMINANTS.id);
            this.contaminants = new File(arg);
        }
        if (aLine.hasOption(ReporterCLIParameters.ZIP.id)) {
            this.zipExport = new File(aLine.getOptionValue(ReporterCLIParameters.ZIP.id));
        }
        this.reportCLIInputBean = new ReportCLIInputBean(aLine);
        this.identificationParametersInputBean = new IdentificationParametersInputBean(aLine);
        this.pathSettingsCLIInputBean = new PathSettingsCLIInputBean(aLine);
    }

    public File getPeptideShakerFile() {
        return this.peptideShakerFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public File getIsotopesFile() {
        return this.isotopesFile;
    }

    public ArrayList<Integer> getReferenceSamples() {
        return this.referenceSamples;
    }

    public int getnThreads() {
        return this.nThreads;
    }

    public String getReporterMethod() {
        return this.reporterMethod;
    }

    public Double getReporterIonTolerance() {
        return this.reporterIonTolerance;
    }

    public Boolean getMostAccurate() {
        return this.mostAccurate;
    }

    public ReporterIonsLocationType getReporterIonsLocation() {
        return this.reporterIonsLocation;
    }

    public Double getPrecMzTolerance() {
        return this.precMzTolerance;
    }

    public Boolean getPrecMzTolerancePpm() {
        return this.precMzTolerancePpm;
    }

    public Double getPrecRtTolerance() {
        return this.precRtTolerance;
    }

    public File getIdentificationParametersFile() {
        if (this.identificationParametersInputBean.getDestinationFile() != null) {
            return this.identificationParametersInputBean.getDestinationFile();
        }
        return this.identificationParametersInputBean.getInputFile();
    }

    public Boolean getIgnoreNull() {
        return this.ignoreNull;
    }

    public Boolean getIgnoreMc() {
        return this.ignoreMc;
    }

    public Double getPercentile() {
        return this.percentile;
    }

    public Double getResolution() {
        return this.resolution;
    }

    public Integer getMinUnique() {
        return this.minUnique;
    }

    public ArrayList<String> getIgnoredPtms() {
        return this.ignoredPtms;
    }

    public Integer getValidationPsm() {
        return this.validationPsm;
    }

    public Integer getValidationPeptide() {
        return this.validationPeptide;
    }

    public Integer getValidationProtein() {
        return this.validationProtein;
    }

    public NormalizationType getPsmNormalizationType() {
        return this.psmNormalizationType;
    }

    public NormalizationType getPeptideNormalizationType() {
        return this.peptideNormalizationType;
    }

    public NormalizationType getProteinNormalizationType() {
        return this.proteinNormalizationType;
    }

    public File getStableProteins() {
        return this.stableProteins;
    }

    public File getContaminants() {
        return this.contaminants;
    }

    public File getZipExport() {
        return this.zipExport;
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParametersInputBean.getIdentificationParameters();
    }

    public PathSettingsCLIInputBean getPathSettingsCLIInputBean() {
        return this.pathSettingsCLIInputBean;
    }

    public ReportCLIInputBean getReportCLIInputBean() {
        return this.reportCLIInputBean;
    }
}

