/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.cli;

import com.compomics.cli.identification_parameters.IdentificationParametersCLIParams;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import eu.isas.reporter.cli.PathSettingsCLIParams;
import eu.isas.reporter.cli.ReportCLIParams;
import eu.isas.reporter.settings.ReporterIonsLocationType;
import org.apache.commons.cli.Options;

public enum ReporterCLIParameters {
    ID("id", "The PeptideShaker project (.psdb or .zip).", true),
    OUT("out", "Output file to save the project.", false),
    ISOTOPES("isotopes", "The isotope correction factors file (.xml file). Default values used if not provided. It is strongly advised to provide the values corresponding to the labelling kit used during the experiment.", false),
    METHOD("method", "The reporter ion quantification method to use from the isotopic methods file in case multiple methods are listed in the file. Inferred from the identification parameters if not provided.", false),
    REFERENCE("ref_samples", "The reference sample(s) as a comma separated list of integers where each sample is represented by its reagent ordered by mass starting from 1. Ex: 1,3 represent reagents 144 and 116 with iTRAQ 4-plex. Default: no reference.", false),
    ION_TOL("ion_tol", "The reporter ion m/z tolerance. Default value inferred from the identification parameters and reporter method.", false),
    MOST_ACCURATE("most_accurate", "Indicates whether the ion within the m/z tolerance with the most accurate m/z should be selected (1: yes, 0: no). If no, the most intense ion will be selected. Default value inferred from the identification parameters.", false),
    REPORTER_IONS_LOCATION("reporter_ions_location", "The location of the reporter ions (" + ReporterIonsLocationType.getCommandLineDescription() + "). Default is 0.", false),
    PREC_WINDOW_MZ_TOL("prec_window_mz_tol", "If " + REPORTER_IONS_LOCATION.name() + " is set to " + (Object)((Object)ReporterIonsLocationType.precursorMatching) + ", the m/z tolerance to use. Default is 1.", false),
    PREC_WINDOW_MZ_TOL_PPM("prec_window_mz_tol_ppm", "If " + REPORTER_IONS_LOCATION.name() + " is set to " + (Object)((Object)ReporterIonsLocationType.precursorMatching) + ", indicates whether the m/z tolerance to use is in ppm (1: yes, 0: no). Default is 1.", false),
    PREC_WINDOW_RT_TOL("prec_window_rt_tol", "If " + REPORTER_IONS_LOCATION.name() + " is set to " + (Object)((Object)ReporterIonsLocationType.precursorMatching) + ", the rt tolerance in seconds to use. Default is 10. Will be used only if available in the spectrum file.", false),
    IGNORE_NULL("ignore_null", "Ignore spectra where null intensities are found for at least one of the reporter ions (1: yes, 0: no). Default is 0.", false),
    IGNORE_MC("ignore_mc", "Ignore peptides with missed cleavages (1: yes, 0: no). Default is 0.", false),
    PERCENTILE("percentile", "Share of ratios to consider for the likelihood estimator window setting in percent. Default is 68%.", false),
    RESOLUTION("resolution", "Resolution to use for ratios calculation. Default is 0.01.", false),
    MIN_UNIQUE("min_unique", "Minimum number of unique peptides required to consider only those for a protein group ratio estimation, ignored if negative. Default is 3.", false),
    IGNORE_PTMS("ignore_ptms", "Ignore peptides carrying PTMs from this comma separated list. The lists of implemented and searched PTMs are available in the identification parameters.", false),
    VALIDATION_PSM("validation_psm", "Validation level for a PSM to be considered for quantification (0: all, 1: validated, 2: confident). Default is 1.", false),
    VALIDATION_PEPTIDE("validation_peptide", "Validation level for a peptide to be considered for quantification (0: all, 1: validated, 2: confident). Default is 1.", false),
    VALIDATION_PROTEIN("validation_protein", "Validation level for a protein to be considered for quantification (0: all, 1: validated, 2: confident). Default is 1.", false),
    NORMALIZATION_PSM("normalization_psm", "Normalization at the PSM level (" + NormalizationType.getCommandLineDescription() + "). Default is 0.", false),
    NORMALIZATION_PEPTIDE("normalization_peptide", "Normalization at the peptide level (" + NormalizationType.getCommandLineDescription() + "). Default is 1.", false),
    NORMALIZATION_PROTEIN("normalization_protein", "Normalization at the protein level (" + NormalizationType.getCommandLineDescription() + "). Default is 1.", false),
    STABLE_PROTEINS("stable_proteins", "Path to a FASTA file containing proteins to consider most stable between samples.", false),
    CONTAMINANTS("contaminants", "Path to a FASTA file containing proteins to consider as contaminants. Default is resources/crap.fasta.", false),
    ZIP("zip", "Exports the entire project as a zip file in the file specified.", false),
    THREADS("threads", "Number of threads to use for the processing, default: the number of cores on the machine.", false),
    CONFIG_FOLDER("config_folder", "The complete path to the config folder. Default resources\\conf.", false);

    public String id;
    public String description;
    public boolean mandatory;

    private ReporterCLIParameters(String id, String description, boolean mandatory) {
        this.id = id;
        this.description = description;
        this.mandatory = mandatory;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (ReporterCLIParameters reporterCLIParameters : ReporterCLIParameters.values()) {
            aOptions.addOption(reporterCLIParameters.id, true, reporterCLIParameters.description);
        }
        ReportCLIParams.createOptionsCLI(aOptions);
        aOptions.addOption(PathSettingsCLIParams.ALL.id, true, PathSettingsCLIParams.ALL.description);
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-25s";
        output = output + "Mandatory Parameters:\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.ID.id) + " " + ReporterCLIParameters.ID.description + "\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.ISOTOPES.id) + " " + ReporterCLIParameters.ISOTOPES.description + "\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.METHOD.id) + " " + ReporterCLIParameters.METHOD.description + "\n";
        output = output + "\n\nOutput:\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.OUT.id) + " " + ReporterCLIParameters.OUT.description + "\n";
        output = output + "\n\nOptional Export Parameters:\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.ZIP.id) + " " + ReporterCLIParameters.ZIP.description + "\n";
        output = output + "\n\nProcessing Options:\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.THREADS.id) + " " + ReporterCLIParameters.THREADS.description + "\n";
        output = output + "\n\nAdvanced Options:\n";
        output = output + "\n\nOptional Temporary Folder:\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        output = output + "\n\nOptional Input Parameters:\n";
        output = output + "-" + String.format(formatter, IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.id) + " " + IdentificationParametersCLIParams.IDENTIFICATION_PARAMETERS.description + "\n";
        output = output + "-" + String.format(formatter, ReporterCLIParameters.CONFIG_FOLDER.id) + " " + ReporterCLIParameters.CONFIG_FOLDER.description + "\n";
        output = output + "\n\n\nFor identification parameters options:\nReplace eu.isas.reporter.cmd.ReporterCLI with eu.isas.reportergui.cmd.IdentificationParametersCLI\n\n";
        output = output + "\nFor report export options:\nReplace eu.isas.reporter.cli.ReporterCLI with eu.isas.reporter.cli.ReportCLI\n";
        return output;
    }
}

