/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.export.report.sections;

import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.PeptideUtils;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.io.export.ExportFeature;
import com.compomics.util.io.export.ExportWriter;
import com.compomics.util.io.export.features.ReporterExportFeature;
import com.compomics.util.io.export.features.peptideshaker.PsFragmentFeature;
import com.compomics.util.io.export.features.peptideshaker.PsIdentificationAlgorithmMatchesFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPeptideFeature;
import com.compomics.util.io.export.features.peptideshaker.PsPsmFeature;
import com.compomics.util.io.export.features.reporter.ReporterPeptideFeature;
import com.compomics.util.io.export.features.reporter.ReporterPsmFeatures;
import com.compomics.util.io.export.writers.ExcelWriter;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.export.sections.PsPeptideSection;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.export.report.ReporterReportStyle;
import eu.isas.reporter.export.report.sections.ReporterPsmSection;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import eu.isas.reporter.settings.ReporterSettings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.math.MathException;

public class ReporterPeptideSection {
    private ArrayList<ExportFeature> identificationFeatures = new ArrayList();
    private ArrayList<ReporterExportFeature> quantificationFeatures = new ArrayList();
    private ReporterPsmSection psmSection = null;
    private boolean indexes;
    private boolean header;
    private ExportWriter writer;
    private ReporterReportStyle reporterStyle;

    public ReporterPeptideSection(ArrayList<ExportFeature> exportFeatures, boolean indexes, boolean header, ExportWriter writer) {
        ArrayList<ExportFeature> psmFeatures = new ArrayList<ExportFeature>();
        for (ExportFeature exportFeature : exportFeatures) {
            if (exportFeature instanceof PsPeptideFeature) {
                this.identificationFeatures.add(exportFeature);
                continue;
            }
            if (exportFeature instanceof ReporterPeptideFeature) {
                this.quantificationFeatures.add((ReporterExportFeature)exportFeature);
                continue;
            }
            if (exportFeature instanceof ReporterPsmFeatures || exportFeature instanceof PsPsmFeature || exportFeature instanceof PsIdentificationAlgorithmMatchesFeature || exportFeature instanceof PsFragmentFeature) {
                psmFeatures.add(exportFeature);
                continue;
            }
            throw new IllegalArgumentException("Export feature of type " + exportFeature.getClass() + " not recognized.");
        }
        if (!psmFeatures.isEmpty()) {
            this.psmSection = new ReporterPsmSection(psmFeatures, indexes, header, writer);
        }
        this.indexes = indexes;
        this.header = header;
        this.writer = writer;
        if (writer instanceof ExcelWriter) {
            this.reporterStyle = ReporterReportStyle.getReportStyle((ExcelWriter)writer);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeSection(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, SequenceProvider sequenceProvider, SpectrumProvider spectrumProvider, ProteinDetailsProvider proteinDetailsProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, ReporterSettings reporterSettings, IdentificationParameters identificationParameters, long[] keys, int nSurroundingAA, String linePrefix, boolean validatedOnly, boolean decoys, WaitingHandler waitingHandler) throws IOException, IllegalArgumentException, SQLException, ClassNotFoundException, InterruptedException, MathException {
        PeptideMatch peptideMatch;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressCounterIndeterminate(true);
        }
        if (this.header) {
            this.writeHeader(reporterIonQuantification);
        }
        if (keys == null) {
            keys = identification.getPeptideIdentification().stream().mapToLong(Long::longValue).toArray();
        }
        int line = 1;
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        if (waitingHandler != null) {
            waitingHandler.setWaitingText("Exporting. Please Wait...");
            waitingHandler.resetSecondaryProgressCounter();
            waitingHandler.setMaxSecondaryProgressCounter(keys.length);
        }
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(keys, waitingHandler);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            if (waitingHandler != null) {
                if (waitingHandler.isRunCanceled()) {
                    return;
                }
                waitingHandler.increaseSecondaryProgressCounter();
            }
            long peptideKey = peptideMatch.getKey();
            psParameter = (PSParameter)identification.getPeptideMatch(peptideKey).getUrParam(psParameter);
            if (validatedOnly && !psParameter.getMatchValidationLevel().isValidated()) continue;
            peptideMatch = identification.getPeptideMatch(peptideKey);
            if (!decoys && PeptideUtils.isDecoy(peptideMatch.getPeptide(), sequenceProvider)) continue;
            boolean first = true;
            if (this.indexes) {
                if (linePrefix != null) {
                    this.writer.write(linePrefix);
                }
                this.writer.write(line + "");
                first = false;
            }
            for (ExportFeature exportFeature : this.identificationFeatures) {
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                PsPeptideFeature peptideFeature = (PsPeptideFeature)exportFeature;
                this.writer.write(PsPeptideSection.getfeature((Identification)identification, (IdentificationFeaturesGenerator)identificationFeaturesGenerator, (SequenceProvider)sequenceProvider, (ProteinDetailsProvider)proteinDetailsProvider, (IdentificationParameters)identificationParameters, (int)nSurroundingAA, (String)linePrefix, (PeptideMatch)peptideMatch, (PsPeptideFeature)peptideFeature, (boolean)validatedOnly, (boolean)decoys, (WaitingHandler)waitingHandler));
            }
            ArrayList<String> sampleIndexes = new ArrayList<String>(reporterIonQuantification.getSampleIndexes());
            Collections.sort(sampleIndexes);
            for (ExportFeature exportFeature3 : this.quantificationFeatures) {
                ReporterPeptideFeature peptideFeature = (ReporterPeptideFeature)exportFeature3;
                if (peptideFeature.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (!first) {
                            this.writer.addSeparator();
                        } else {
                            first = false;
                        }
                        this.writer.write(ReporterPeptideSection.getFeature(spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, peptideMatch, peptideFeature, sampleIndex, waitingHandler), this.reporterStyle);
                    }
                    continue;
                }
                if (!first) {
                    this.writer.addSeparator();
                } else {
                    first = false;
                }
                this.writer.write(ReporterPeptideSection.getFeature(spectrumProvider, quantificationFeaturesGenerator, reporterIonQuantification, peptideMatch, peptideFeature, "", waitingHandler), this.reporterStyle);
            }
            if (this.psmSection != null) {
                void var25_30;
                this.writer.newLine();
                String string = "";
                if (linePrefix != null) {
                    String string2 = string + linePrefix;
                }
                String string3 = (String)var25_30 + line + ".";
                this.writer.increaseDepth();
                this.psmSection.writeSection(identification, identificationFeaturesGenerator, sequenceProvider, spectrumProvider, proteinDetailsProvider, quantificationFeaturesGenerator, reporterIonQuantification, reporterSettings, identificationParameters, peptideMatch.getSpectrumMatchesKeys(), string3, nSurroundingAA, validatedOnly, decoys, null);
                this.writer.decreaseDepth();
            }
            ++line;
            this.writer.newLine();
        }
    }

    public static String getFeature(SpectrumProvider spectrumProvider, QuantificationFeaturesGenerator quantificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, PeptideMatch peptideMatch, ReporterPeptideFeature peptideFeatures, String sampleIndex, WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        switch (peptideFeatures) {
            case raw_ratio: {
                PeptideQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(spectrumProvider, peptideMatch, waitingHandler);
                return quantificationDetails.getRawRatio(sampleIndex).toString();
            }
            case normalized_ratio: {
                PeptideQuantificationDetails quantificationDetails = quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(spectrumProvider, peptideMatch, waitingHandler);
                return quantificationDetails.getRatio(sampleIndex, reporterIonQuantification.getNormalizationFactors()).toString();
            }
        }
        return "Not implemented";
    }

    public void writeHeader(ReporterIonQuantification reporterIonQuantification) throws IOException {
        boolean needSecondLine = false;
        ArrayList<String> sampleIndexes = new ArrayList<String>(reporterIonQuantification.getSampleIndexes());
        Collections.sort(sampleIndexes);
        boolean firstColumn = true;
        if (this.indexes) {
            this.writer.writeHeaderText("");
            this.writer.addSeparator();
        }
        for (ExportFeature exportFeature : this.identificationFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(exportFeature.getTitle());
        }
        for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
            if (firstColumn) {
                firstColumn = false;
            } else {
                this.writer.addSeparator();
            }
            this.writer.writeHeaderText(reporterExportFeature.getTitle(), this.reporterStyle);
            if (!reporterExportFeature.hasChannels()) continue;
            for (int i = 1; i < sampleIndexes.size(); ++i) {
                if (firstColumn) {
                    firstColumn = false;
                } else {
                    this.writer.addSeparator();
                }
                this.writer.writeHeaderText(" ", this.reporterStyle);
            }
            needSecondLine = true;
        }
        if (needSecondLine) {
            this.writer.newLine();
            firstColumn = true;
            if (this.indexes) {
                this.writer.addSeparator();
            }
            for (ExportFeature exportFeature : this.identificationFeatures) {
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("");
                this.writer.addSeparator();
            }
            for (ReporterExportFeature reporterExportFeature : this.quantificationFeatures) {
                if (reporterExportFeature.hasChannels()) {
                    for (String sampleIndex : sampleIndexes) {
                        if (firstColumn) {
                            firstColumn = false;
                        } else {
                            this.writer.writeHeaderText("", this.reporterStyle);
                            this.writer.addSeparator();
                        }
                        this.writer.write(reporterIonQuantification.getSample(sampleIndex), this.reporterStyle);
                    }
                    continue;
                }
                if (firstColumn) {
                    firstColumn = false;
                    continue;
                }
                this.writer.writeHeaderText("", this.reporterStyle);
                this.writer.addSeparator();
            }
        }
        this.writer.newLine();
    }
}

