/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.modifications.Modification;
import com.compomics.util.experiment.biology.modifications.ModificationFactory;
import com.compomics.util.experiment.biology.proteins.Peptide;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.matches_iterators.PeptideMatchesIterator;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.identification.utils.ModificationUtils;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.mass_spectrometry.MsFileHandler;
import com.compomics.util.experiment.io.mass_spectrometry.cms.CmsFolder;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.identification.advanced.SequenceMatchingParameters;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.io.ProjectImporter;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

public class LabellingEfficiencyDialog
extends JDialog {
    private Frame parentFrame;
    private Image normalIcon;
    private Image waitingIcon;
    private LastSelectedFolder lastSelectedFolder;
    private ProgressDialogX progressDialog;
    private PsdbParent psdbParent;
    private ArrayList<File> spectrumFiles = new ArrayList();
    private ModificationFactory modificationFactory = ModificationFactory.getInstance();
    private ArrayList<String> sortedModifications;
    private HashMap<String, Double> labellingEfficiency;
    private MsFileHandler msFileHandler = new MsFileHandler();
    private JButton addDbButton;
    private JButton addIdFilesButton;
    private JButton addSpectraFilesJButton;
    private JPanel backgroundPanel;
    private JButton closeButton;
    private JLabel databaseFileLabel;
    private JPanel efficiencyPanel;
    private JTable efficiencyTable;
    private JScrollPane efficiencyTableScrollPane;
    private JTextField fastaTxt;
    private JPanel fileSelectiontPanel;
    private JLabel idFilesLabel;
    private JLabel spectrumFilesLabel;
    private JTextField txtIdFileLocation;
    private JTextField txtSpectraFileLocation;

    public LabellingEfficiencyDialog(Dialog owner, JFrame parentFrame, Image normalIcon, Image waitingIcon, LastSelectedFolder lastSelectedFolder) {
        super(owner, true);
        this.parentFrame = parentFrame;
        this.normalIcon = normalIcon;
        this.waitingIcon = waitingIcon;
        this.initComponents();
        this.setUpGui();
    }

    private void setUpGui() {
        this.setTableProperties();
    }

    private void setTableProperties() {
        this.efficiencyTable.getColumn(" ").setMaxWidth(30);
        this.efficiencyTable.getColumn("Name").setMaxWidth(100);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.closeButton = new JButton();
        this.fileSelectiontPanel = new JPanel();
        this.spectrumFilesLabel = new JLabel();
        this.txtSpectraFileLocation = new JTextField();
        this.idFilesLabel = new JLabel();
        this.txtIdFileLocation = new JTextField();
        this.addIdFilesButton = new JButton();
        this.addSpectraFilesJButton = new JButton();
        this.databaseFileLabel = new JLabel();
        this.fastaTxt = new JTextField();
        this.addDbButton = new JButton();
        this.efficiencyPanel = new JPanel();
        this.efficiencyTableScrollPane = new JScrollPane();
        this.efficiencyTable = new JTable();
        this.setDefaultCloseOperation(2);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabellingEfficiencyDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.fileSelectiontPanel.setBorder(BorderFactory.createTitledBorder("Files Selection"));
        this.fileSelectiontPanel.setOpaque(false);
        this.spectrumFilesLabel.setText("Spectrum File(s)");
        this.txtSpectraFileLocation.setEditable(false);
        this.txtSpectraFileLocation.setHorizontalAlignment(0);
        this.idFilesLabel.setText("Project File");
        this.txtIdFileLocation.setEditable(false);
        this.txtIdFileLocation.setHorizontalAlignment(0);
        this.txtIdFileLocation.setText("Please import a project");
        this.addIdFilesButton.setText("Browse");
        this.addIdFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabellingEfficiencyDialog.this.addIdFilesButtonActionPerformed(evt);
            }
        });
        this.addSpectraFilesJButton.setText("Browse");
        this.addSpectraFilesJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabellingEfficiencyDialog.this.addSpectraFilesJButtonActionPerformed(evt);
            }
        });
        this.databaseFileLabel.setText("Database File");
        this.fastaTxt.setEditable(false);
        this.fastaTxt.setHorizontalAlignment(0);
        this.addDbButton.setText("Browse");
        this.addDbButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LabellingEfficiencyDialog.this.addDbButtonActionPerformed(evt);
            }
        });
        GroupLayout fileSelectiontPanelLayout = new GroupLayout(this.fileSelectiontPanel);
        this.fileSelectiontPanel.setLayout(fileSelectiontPanelLayout);
        fileSelectiontPanelLayout.setHorizontalGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileSelectiontPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumFilesLabel, -2, 120, -2).addComponent(this.databaseFileLabel, -2, 120, -2).addComponent(this.idFilesLabel, -2, 120, -2)).addGap(10, 10, 10).addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtIdFileLocation).addComponent(this.txtSpectraFileLocation, -1, 504, Short.MAX_VALUE).addComponent(this.fastaTxt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addSpectraFilesJButton, GroupLayout.Alignment.TRAILING).addComponent(this.addIdFilesButton, GroupLayout.Alignment.TRAILING).addComponent(this.addDbButton)).addContainerGap()));
        fileSelectiontPanelLayout.setVerticalGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileSelectiontPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.idFilesLabel).addComponent(this.txtIdFileLocation, -2, -1, -2).addComponent(this.addIdFilesButton)).addGap(0, 0, 0).addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumFilesLabel).addComponent(this.txtSpectraFileLocation, -2, -1, -2).addComponent(this.addSpectraFilesJButton)).addGap(0, 0, 0).addGroup(fileSelectiontPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.databaseFileLabel).addComponent(this.fastaTxt, -2, -1, -2).addComponent(this.addDbButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.efficiencyPanel.setBorder(BorderFactory.createTitledBorder("Labelling Efficiency"));
        this.efficiencyPanel.setOpaque(false);
        this.efficiencyTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.efficiencyTableScrollPane.setViewportView(this.efficiencyTable);
        GroupLayout efficiencyPanelLayout = new GroupLayout(this.efficiencyPanel);
        this.efficiencyPanel.setLayout(efficiencyPanelLayout);
        efficiencyPanelLayout.setHorizontalGroup(efficiencyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(efficiencyPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.efficiencyTableScrollPane).addContainerGap()));
        efficiencyPanelLayout.setVerticalGroup(efficiencyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(efficiencyPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.efficiencyTableScrollPane, -2, 138, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.efficiencyPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.closeButton)).addComponent(this.fileSelectiontPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fileSelectiontPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.efficiencyPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.closeButton).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void addIdFilesButtonActionPerformed(ActionEvent evt) {
        String psdbFileFilterDescription = "PeptideShaker (.psdb)";
        String lastSelectedFolderPath = this.lastSelectedFolder.getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile(this, new String[]{".psdb"}, new String[]{psdbFileFilterDescription}, "Select Identification File(s)", lastSelectedFolderPath, null, true, false, false, 0);
        if (selectedFileAndFilter != null) {
            File selectedFile = selectedFileAndFilter.getFile();
            this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getParent());
            if (!selectedFile.getName().endsWith(".zip")) {
                if (selectedFile.getName().endsWith(".psdb")) {
                    this.importPeptideShakerFile(selectedFile);
                } else {
                    JOptionPane.showMessageDialog(this, "Not a PeptideShaker file (.psdb).", "Unsupported File.", 2);
                }
            }
        }
    }

    private void addSpectraFilesJButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.lastSelectedFolder.getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Spectrum File(s)");
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith(".mgf") || myFile.getName().toLowerCase().endsWith(".mgf.gz") || myFile.getName().toLowerCase().endsWith(".mzml") || myFile.getName().toLowerCase().endsWith(".mzml.gz") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "mgf or mzML (.mgf, .mgf.gz, .mzml, .mzml.gz)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this, "Add");
        if (returnVal == 0) {
            final ArrayList<File> selectedFiles = new ArrayList<File>();
            for (File newFile : fileChooser.getSelectedFiles()) {
                if (newFile.isDirectory()) {
                    File[] tempFiles;
                    for (File file : tempFiles = newFile.listFiles()) {
                        if (!file.getName().toLowerCase().endsWith(".mgf") && !file.getName().toLowerCase().endsWith(".mgf.gz") && !file.getName().toLowerCase().endsWith(".mzml") && !file.getName().toLowerCase().endsWith(".mzml.gz")) continue;
                        selectedFiles.add(file);
                    }
                    continue;
                }
                selectedFiles.add(newFile);
            }
            this.progressDialog = new ProgressDialogX(this, this.parentFrame, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/peptide-shaker-orange.gif")), true);
            this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
            this.progressDialog.setTitle("Loading Files. Please Wait...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        LabellingEfficiencyDialog.this.progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("loadingThread"){

                @Override
                public void run() {
                    boolean allLoaded = true;
                    for (File file : selectedFiles) {
                        try {
                            File folder = CmsFolder.getParentFolder() == null ? file.getParentFile() : new File(CmsFolder.getParentFolder());
                            LabellingEfficiencyDialog.this.msFileHandler.register(file, folder, LabellingEfficiencyDialog.this.progressDialog);
                        }
                        catch (Exception e) {
                            LabellingEfficiencyDialog.this.progressDialog.setRunCanceled();
                            allLoaded = false;
                            JOptionPane.showMessageDialog(null, "An error occurred while reading the following file.\n" + file.getAbsolutePath() + "\n\nError:\n" + e.getLocalizedMessage(), "File error", 0);
                            e.printStackTrace();
                        }
                    }
                    LabellingEfficiencyDialog.this.progressDialog.setRunFinished();
                    if (allLoaded) {
                        LabellingEfficiencyDialog.this.spectrumFiles.addAll(selectedFiles);
                        LabellingEfficiencyDialog.this.txtSpectraFileLocation.setText(LabellingEfficiencyDialog.this.spectrumFiles.size() + " file(s) selected");
                    }
                }
            }.start();
        }
    }

    private void addDbButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser(this.lastSelectedFolder.getLastSelectedFolder());
        fileChooser.setDialogTitle("Select FASTA File(s)");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                return myFile.getName().toLowerCase().endsWith("fasta") || myFile.getName().toLowerCase().endsWith("fast") || myFile.getName().toLowerCase().endsWith("fas") || myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Supported formats: FASTA (.fasta)";
            }
        };
        fileChooser.setFileFilter(filter);
        int returnVal = fileChooser.showDialog(this.getParent(), "Open");
        if (returnVal == 0) {
            File fastaFile = fileChooser.getSelectedFile();
            this.lastSelectedFolder.setLastSelectedFolder(fastaFile.getAbsolutePath());
            this.fastaTxt.setText(fastaFile.getName());
            this.psdbParent.getProjectDetails().setFastaFile(fastaFile);
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void importPeptideShakerFile(final File psFile) {
        this.progressDialog = new ProgressDialogX(this, this.parentFrame, this.normalIcon, this.waitingIcon, true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Importing Project. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LabellingEfficiencyDialog.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ImportThread"){

            @Override
            public void run() {
                try {
                    LabellingEfficiencyDialog.this.psdbParent = new PsdbParent(Reporter.getMatchesFolder());
                    LabellingEfficiencyDialog.this.psdbParent.setPsdbFile(psFile);
                    ProjectImporter projectImporter = new ProjectImporter(LabellingEfficiencyDialog.this);
                    projectImporter.importPeptideShakerProject(LabellingEfficiencyDialog.this.psdbParent, LabellingEfficiencyDialog.this.spectrumFiles, LabellingEfficiencyDialog.this.progressDialog);
                    projectImporter.importReporterProject(LabellingEfficiencyDialog.this.psdbParent, LabellingEfficiencyDialog.this.progressDialog);
                    if (LabellingEfficiencyDialog.this.progressDialog.isRunCanceled()) {
                        LabellingEfficiencyDialog.this.progressDialog.setRunFinished();
                        LabellingEfficiencyDialog.this.progressDialog.dispose();
                        return;
                    }
                    LabellingEfficiencyDialog.this.txtSpectraFileLocation.setText(LabellingEfficiencyDialog.this.psdbParent.getProjectDetails().getSpectrumFileNames().size() + " files loaded");
                    LabellingEfficiencyDialog.this.fastaTxt.setText(LabellingEfficiencyDialog.this.psdbParent.getProjectDetails().getFastaFile());
                    LabellingEfficiencyDialog.this.txtIdFileLocation.setText(LabellingEfficiencyDialog.this.psdbParent.getPsdbFile().getName());
                    LabellingEfficiencyDialog.this.estimateLabellingEfficiency();
                    LabellingEfficiencyDialog.this.refresh();
                    LabellingEfficiencyDialog.this.progressDialog.setRunFinished();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LabellingEfficiencyDialog.this.progressDialog.setRunCanceled();
                    JOptionPane.showMessageDialog(LabellingEfficiencyDialog.this, "An error occurred while estimating the labelling efficiency.", "Error", 0);
                }
            }
        }.start();
    }

    private void estimateLabellingEfficiency() throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        PeptideMatch peptideMatch;
        IdentificationParameters identificationParameters = this.psdbParent.getIdentificationParameters();
        SequenceProvider sequenceProvider = this.psdbParent.getSequenceProvider();
        SequenceMatchingParameters proteinSequenceMatchingPreferences = identificationParameters.getSequenceMatchingParameters();
        ModificationParameters modificationParameters = identificationParameters.getSearchParameters().getModificationParameters();
        this.sortedModifications = new ArrayList<String>(modificationParameters.getAllNotFixedModifications());
        Collections.sort(this.sortedModifications);
        HashMap<String, Integer> nModifiedMap = new HashMap<String, Integer>(this.sortedModifications.size());
        HashMap<String, Integer> nPossibleMap = new HashMap<String, Integer>(this.sortedModifications.size());
        ArrayList<Modification> modifications = new ArrayList<Modification>(this.sortedModifications.size());
        for (String ptmName : this.sortedModifications) {
            nModifiedMap.put(ptmName, 0);
            nPossibleMap.put(ptmName, 0);
            modifications.add(this.modificationFactory.getModification(ptmName));
        }
        Identification identification = this.psdbParent.getIdentification();
        PSParameter psParameter = new PSParameter();
        ArrayList<PSParameter> parameters = new ArrayList<PSParameter>(1);
        parameters.add(psParameter);
        PeptideMatchesIterator peptideMatchesIterator = identification.getPeptideMatchesIterator(this.progressDialog);
        while ((peptideMatch = peptideMatchesIterator.next()) != null) {
            Peptide peptide = peptideMatch.getPeptide();
            for (Modification modification : modifications) {
                String modificationName = modification.getName();
                int nNew = ModificationUtils.getPossibleModificationSites(peptide, modification, sequenceProvider, proteinSequenceMatchingPreferences).length;
                if (nNew > 0) {
                    Integer n2 = (Integer)nPossibleMap.get(modificationName);
                    n2 = n2 + nNew;
                    nPossibleMap.put(modificationName, n2);
                }
                nNew = 0;
                if (peptide.getNVariableModifications() > 0) {
                    for (ModificationMatch modificationMatch : peptide.getVariableModifications()) {
                        if (!modificationMatch.getModification().equals(modificationName)) continue;
                        ++nNew;
                    }
                }
                if (nNew <= 0) continue;
                Integer n3 = (Integer)nModifiedMap.get(modificationName);
                n3 = n3 + nNew;
                nModifiedMap.put(modificationName, n3);
            }
        }
        for (String ptmName : this.sortedModifications) {
            Integer nModified = (Integer)nModifiedMap.get(ptmName);
            Integer nPossible = (Integer)nPossibleMap.get(ptmName);
            Double efficiency = nModified.doubleValue() / (double)nPossible.intValue();
            this.labellingEfficiency.put(ptmName, efficiency);
        }
    }

    private void refresh() {
        this.efficiencyTable.setModel(new LabellingEfficiencyTableModel());
        this.setTableProperties();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LabellingEfficiencyDialog.this.efficiencyTable.revalidate();
                LabellingEfficiencyDialog.this.efficiencyTable.repaint();
            }
        });
    }

    private class LabellingEfficiencyTableModel
    extends DefaultTableModel {
        private LabellingEfficiencyTableModel() {
        }

        @Override
        public int getRowCount() {
            if (LabellingEfficiencyDialog.this.sortedModifications == null || LabellingEfficiencyDialog.this.psdbParent == null) {
                return 0;
            }
            return LabellingEfficiencyDialog.this.sortedModifications.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Efficiency";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String ptmName = (String)LabellingEfficiencyDialog.this.sortedModifications.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ptmName;
                }
                case 2: {
                    Double efficiency = (Double)LabellingEfficiencyDialog.this.labellingEfficiency.get(ptmName);
                    Double efficiencyInPercent = Util.roundDouble(100.0 * efficiency, 2);
                    return efficiencyInPercent;
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

