/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.util.experiment.biology.ions.impl.ElementaryIon;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import eu.isas.reporter.gui.NewDialog;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import org.xmlpull.v1.XmlPullParserException;

public class MethodSettingsDialog
extends JDialog {
    private NewDialog newDialog;
    private ReporterMethodFactory methodsFactory = ReporterMethodFactory.getInstance();
    private boolean valuesChanged = false;
    private JPanel backgroundPanel;
    private JButton browseConfigButton;
    private JPanel configFilePanel;
    private JPanel isotopeCorrectionPanel;
    private JButton okButton;
    private JTable reagentsTable;
    private JScrollPane reagentsTableJScrollPane;
    private JButton saveConfigButton;
    private JTextField txtConfigurationFileLocation;

    public MethodSettingsDialog(NewDialog newDialog, boolean modal) {
        super((Dialog)newDialog, modal);
        this.newDialog = newDialog;
        this.initComponents();
        this.setUpGui();
        this.setLocationRelativeTo(newDialog);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.reagentsTableJScrollPane.getViewport().setOpaque(false);
        this.reagentsTable.getTableHeader().setReorderingAllowed(false);
        if (this.newDialog.getMethodsFile() != null) {
            this.txtConfigurationFileLocation.setText(this.newDialog.getMethodsFile().getAbsolutePath());
        } else {
            this.txtConfigurationFileLocation.setText("(not saved to file)");
        }
        this.reagentsTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.reagentsTable.getColumnModel().getColumn(1).setMaxWidth(100);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.isotopeCorrectionPanel = new JPanel();
        this.reagentsTableJScrollPane = new JScrollPane();
        this.reagentsTable = new JTable();
        this.configFilePanel = new JPanel();
        this.txtConfigurationFileLocation = new JTextField();
        this.browseConfigButton = new JButton();
        this.saveConfigButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reporter Method Settings");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.isotopeCorrectionPanel.setBorder(BorderFactory.createTitledBorder("Reagents"));
        this.isotopeCorrectionPanel.setOpaque(false);
        this.reagentsTable.setModel(new CorrectionTableModel());
        this.reagentsTable.setOpaque(false);
        this.reagentsTableJScrollPane.setViewportView(this.reagentsTable);
        GroupLayout isotopeCorrectionPanelLayout = new GroupLayout(this.isotopeCorrectionPanel);
        this.isotopeCorrectionPanel.setLayout(isotopeCorrectionPanelLayout);
        isotopeCorrectionPanelLayout.setHorizontalGroup(isotopeCorrectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(isotopeCorrectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reagentsTableJScrollPane, -1, 804, Short.MAX_VALUE).addContainerGap()));
        isotopeCorrectionPanelLayout.setVerticalGroup(isotopeCorrectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(isotopeCorrectionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reagentsTableJScrollPane, -1, 308, Short.MAX_VALUE).addContainerGap()));
        this.configFilePanel.setBorder(BorderFactory.createTitledBorder("Settings File"));
        this.configFilePanel.setOpaque(false);
        this.txtConfigurationFileLocation.setEditable(false);
        this.browseConfigButton.setText("Browse");
        this.browseConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodSettingsDialog.this.browseConfigButtonActionPerformed(evt);
            }
        });
        this.saveConfigButton.setText("Save As");
        this.saveConfigButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodSettingsDialog.this.saveConfigButtonActionPerformed(evt);
            }
        });
        GroupLayout configFilePanelLayout = new GroupLayout(this.configFilePanel);
        this.configFilePanel.setLayout(configFilePanelLayout);
        configFilePanelLayout.setHorizontalGroup(configFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configFilePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.txtConfigurationFileLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseConfigButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveConfigButton).addContainerGap()));
        configFilePanelLayout.setVerticalGroup(configFilePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(configFilePanelLayout.createSequentialGroup().addContainerGap().addGroup(configFilePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtConfigurationFileLocation, -2, -1, -2).addComponent(this.saveConfigButton).addComponent(this.browseConfigButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MethodSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configFilePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.isotopeCorrectionPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 66, -2))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.configFilePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.isotopeCorrectionPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void browseConfigButtonActionPerformed(ActionEvent evt) {
        File selectedFile;
        if (this.txtConfigurationFileLocation.getText().length() > 0) {
            this.newDialog.getReporterGui().getLastSelectedFolder().setLastSelectedFolder(this.txtConfigurationFileLocation.getText());
        }
        if ((selectedFile = FileChooserUtil.getUserSelectedFile(this, ".xml", "Reporter Method File (*.xml)", "Select Settings File", this.newDialog.getReporterGui().getLastSelectedFolder().getLastSelectedFolder(), null, true)) != null) {
            try {
                this.methodsFactory.importMethods(selectedFile);
                this.newDialog.setSelectedMethod(this.methodsFactory.getReporterMethod(this.newDialog.getSelectedMethod().getName()));
                this.newDialog.setReagents(this.newDialog.getSelectedMethod().getReagentsSortedByMass());
                this.refresh();
                this.txtConfigurationFileLocation.setText(selectedFile.getAbsolutePath());
                this.newDialog.setMethodsFile(selectedFile);
                this.newDialog.getReporterGui().getLastSelectedFolder().setLastSelectedFolder(selectedFile.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "File " + selectedFile.getAbsolutePath() + " not found.", "File Not Found", 2);
            }
            catch (XmlPullParserException e) {
                JOptionPane.showMessageDialog(null, "An error occurred while parsing " + selectedFile.getAbsolutePath() + " at line " + e.getLineNumber() + ".", "Parsing Error", 2);
                e.printStackTrace();
            }
        }
    }

    private void saveConfigButtonActionPerformed(ActionEvent evt) {
        File selectedFile;
        String tempFileName = null;
        if (this.txtConfigurationFileLocation.getText().length() > 0) {
            this.newDialog.getReporterGui().getLastSelectedFolder().setLastSelectedFolder(this.txtConfigurationFileLocation.getText());
            tempFileName = new File(this.txtConfigurationFileLocation.getText()).getName();
        }
        if ((selectedFile = FileChooserUtil.getUserSelectedFile(this, ".xml", "Reporter Method File (*.xml)", "Save Settings File", this.newDialog.getReporterGui().getLastSelectedFolder().getLastSelectedFolder(), tempFileName, false)) != null) {
            try {
                this.methodsFactory.saveFile(selectedFile);
                this.newDialog.setMethodsFile(selectedFile);
                this.txtConfigurationFileLocation.setText(selectedFile.getAbsolutePath());
                this.valuesChanged = false;
                JOptionPane.showMessageDialog(null, "Settings saved to " + selectedFile.getAbsolutePath() + ".", "Settings Saved", 1);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "An error occured when saving the file.", "File Error", 2);
                ex.printStackTrace();
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.valuesChanged) {
            int selection = JOptionPane.showConfirmDialog(this, "Do you want to save the new settings to a file?", "Save File?", 1);
            switch (selection) {
                case 0: {
                    this.saveConfigButtonActionPerformed(null);
                    break;
                }
                case 2: {
                    return;
                }
                case 1: {
                    this.newDialog.setMethodsFile(null);
                    break;
                }
            }
        }
        this.newDialog.updateReagentNames();
        this.dispose();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MethodSettingsDialog.this.reagentsTable.revalidate();
                MethodSettingsDialog.this.reagentsTable.repaint();
            }
        });
    }

    private class CorrectionTableModel
    extends DefaultTableModel {
        private CorrectionTableModel() {
        }

        @Override
        public int getRowCount() {
            return MethodSettingsDialog.this.newDialog.getReagents().size();
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Mass";
                }
                case 3: {
                    return "-2 C13 [%]";
                }
                case 4: {
                    return "-1 C13 [%]";
                }
                case 5: {
                    return "Monoisotopic [%]";
                }
                case 6: {
                    return "+1 C13 [%]";
                }
                case 7: {
                    return "+2 C13 [%]";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String reagentName = MethodSettingsDialog.this.newDialog.getReagents().get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getReporterIon().getName();
                }
                case 2: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getReporterIon().getTheoreticMass() + ElementaryIon.proton.getTheoreticMass();
                }
                case 3: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getMinus2();
                }
                case 4: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getMinus1();
                }
                case 5: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getRef();
                }
                case 6: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getPlus1();
                }
                case 7: {
                    return MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getPlus2();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            String reagentName = MethodSettingsDialog.this.newDialog.getReagents().get(row);
            switch (column) {
                case 1: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getReporterIon().setName((String)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 2: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).getReporterIon().setTheoreticMass((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 3: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).setMinus2((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 4: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).setMinus1((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 5: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).setRef((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 6: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).setPlus1((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
                case 7: {
                    MethodSettingsDialog.this.newDialog.getSelectedMethod().getReagent(reagentName).setPlus2((Double)aValue);
                    MethodSettingsDialog.this.valuesChanged = true;
                    break;
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }
}

