/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.util.experiment.biology.ions.impl.ReporterIon;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.experiment.quantification.reporterion.ReporterMethodFactory;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.gui.ReporterGUI;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.extra.TrueFalseIconRenderer;
import org.xmlpull.v1.XmlPullParserException;

public class ReagentOrderDialog
extends JDialog {
    private ArrayList<String> reagents;
    private ReporterMethod selectedMethod;
    private ReporterIonQuantification reporterIonQuantification;
    private ArrayList<String> controlSamples;
    private ArrayList<String> sampleAssignmentTableToolTips;
    private File methodsFile;
    private ReporterMethodFactory methodsFactory = ReporterMethodFactory.getInstance();
    private boolean cancelled = false;
    private ReporterGUI reporterGUI;
    private JButton cancelButton;
    private JButton moveBottomButton;
    private JButton moveDownButton;
    private JButton moveTopButton;
    private JButton moveUpButton;
    private JButton okButton;
    private JPanel orderSettingsPanel;
    private JComboBox reporterMethodComboBox;
    private JLabel reporterMethodLabel;
    private JScrollPane sampleAssignmentJScrollPane;
    private JTable sampleAssignmentTable;
    private JPanel samplePanel;

    public ReagentOrderDialog(ReporterGUI reporterGUI, boolean modal, ArrayList<String> reagents, ReporterMethod aSelectedMethod, ReporterIonQuantification reporterIonQuantification, ArrayList<String> controlSamples) {
        super((Frame)reporterGUI, modal);
        this.reporterGUI = reporterGUI;
        this.reagents = new ArrayList();
        this.reagents.addAll(reagents);
        this.selectedMethod = aSelectedMethod;
        this.reporterIonQuantification = reporterIonQuantification;
        this.controlSamples = controlSamples;
        this.methodsFile = Reporter.getMethodsFile();
        this.importMethods();
        this.initComponents();
        this.setUpGui();
        this.reporterMethodComboBox.setSelectedItem(aSelectedMethod.getName());
        this.setTableProperties();
        this.setLocationRelativeTo(reporterGUI);
        this.setVisible(true);
    }

    private void setUpGui() {
        this.sampleAssignmentTableToolTips = new ArrayList();
        this.sampleAssignmentTableToolTips.add(null);
        this.sampleAssignmentTableToolTips.add("The reporter label");
        this.sampleAssignmentTableToolTips.add("The sample name");
        this.sampleAssignmentTableToolTips.add("The reference sample(s)");
        this.sampleAssignmentJScrollPane.getViewport().setOpaque(false);
        this.reporterMethodComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.sampleAssignmentTable.getTableHeader().setReorderingAllowed(false);
    }

    private void setTableProperties() {
        this.sampleAssignmentTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.sampleAssignmentTable.getColumnModel().getColumn(1).setMinWidth(150);
        this.sampleAssignmentTable.getColumnModel().getColumn(1).setMaxWidth(150);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setMinWidth(80);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setMaxWidth(80);
        this.sampleAssignmentTable.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)new TrueFalseIconRenderer(new ImageIcon(this.getClass().getResource("/icons/selected_green-new.png")), null, "Yes", "No"));
    }

    public ArrayList<String> getReagentOrder() {
        return this.reagents;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void importMethods() {
        try {
            this.methodsFactory.importMethods(this.methodsFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.importMethodsError();
        }
    }

    private void importMethodsError() {
        JOptionPane.showMessageDialog(this, "Default reporter methods file could not be parsed, please select a method file.", "No Spectrum File Selected", 2);
        JFileChooser fileChooser = new JFileChooser(this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder());
        fileChooser.setDialogTitle("Select Methods file");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        int returnVal = fileChooser.showDialog(this.getParent(), "Add");
        if (returnVal == 0) {
            File newFile = fileChooser.getSelectedFile();
            try {
                this.methodsFactory.importMethods(newFile);
                this.reporterGUI.getLastSelectedFolder().setLastSelectedFolder(newFile.getPath());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(null, "File " + newFile + " could not be parsed.", "Methods file error", 2);
                this.importMethodsError();
            }
            catch (XmlPullParserException e) {
                JOptionPane.showMessageDialog(this, "An error occurred while parsing " + newFile + " at line " + e.getLineNumber() + ".", "Parsing error", 2);
                this.importMethodsError();
            }
        }
    }

    private void initComponents() {
        this.samplePanel = new JPanel();
        this.sampleAssignmentJScrollPane = new JScrollPane();
        this.sampleAssignmentTable = new JTable(){

            @Override
            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    @Override
                    public String getToolTipText(MouseEvent e) {
                        Point p = e.getPoint();
                        int index = this.columnModel.getColumnIndexAtX(p.x);
                        int realIndex = this.columnModel.getColumn(index).getModelIndex();
                        String tip = (String)ReagentOrderDialog.this.sampleAssignmentTableToolTips.get(realIndex);
                        return tip;
                    }
                };
            }
        };
        this.reporterMethodLabel = new JLabel();
        this.reporterMethodComboBox = new JComboBox();
        this.orderSettingsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveTopButton = new JButton();
        this.moveDownButton = new JButton();
        this.moveBottomButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reagents Order");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ReagentOrderDialog.this.formWindowClosing(evt);
            }
        });
        this.samplePanel.setBorder(BorderFactory.createTitledBorder("Sample Assignment"));
        this.samplePanel.setOpaque(false);
        this.sampleAssignmentTable.setModel(new AssignementTableModel());
        this.sampleAssignmentTable.setOpaque(false);
        this.sampleAssignmentTable.setSelectionMode(0);
        this.sampleAssignmentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ReagentOrderDialog.this.sampleAssignmentTableMouseReleased(evt);
            }
        });
        this.sampleAssignmentJScrollPane.setViewportView(this.sampleAssignmentTable);
        this.reporterMethodLabel.setText("Reporter Method");
        this.reporterMethodComboBox.setModel(new DefaultComboBoxModel<String>(this.methodsFactory.getMethodsNamesAsArray()));
        this.reporterMethodComboBox.setEnabled(false);
        this.orderSettingsPanel.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.orderSettingsPanel.setOpaque(false);
        this.moveUpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp_grey.png")));
        this.moveUpButton.setToolTipText("Move Up");
        this.moveUpButton.setBorderPainted(false);
        this.moveUpButton.setContentAreaFilled(false);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUp.png")));
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.moveUpButtonActionPerformed(evt);
            }
        });
        this.moveTopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop_grey.png")));
        this.moveTopButton.setToolTipText("Move to Top");
        this.moveTopButton.setBorderPainted(false);
        this.moveTopButton.setContentAreaFilled(false);
        this.moveTopButton.setEnabled(false);
        this.moveTopButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowUpTop.png")));
        this.moveTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.moveTopButtonActionPerformed(evt);
            }
        });
        this.moveDownButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown_grey.png")));
        this.moveDownButton.setToolTipText("Move Down");
        this.moveDownButton.setBorderPainted(false);
        this.moveDownButton.setContentAreaFilled(false);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDown.png")));
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.moveDownButtonActionPerformed(evt);
            }
        });
        this.moveBottomButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom_grey.png")));
        this.moveBottomButton.setToolTipText("Move to Bottom");
        this.moveBottomButton.setBorderPainted(false);
        this.moveBottomButton.setContentAreaFilled(false);
        this.moveBottomButton.setEnabled(false);
        this.moveBottomButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/arrowDownBottom.png")));
        this.moveBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.moveBottomButtonActionPerformed(evt);
            }
        });
        GroupLayout orderSettingsPanelLayout = new GroupLayout(this.orderSettingsPanel);
        this.orderSettingsPanel.setLayout(orderSettingsPanelLayout);
        orderSettingsPanelLayout.setHorizontalGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, orderSettingsPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.moveUpButton, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.moveDownButton, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE).addComponent(this.moveBottomButton, GroupLayout.Alignment.TRAILING, -2, 36, -2).addComponent(this.moveTopButton, -2, 36, -2))));
        orderSettingsPanelLayout.setVerticalGroup(orderSettingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, orderSettingsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.moveTopButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveUpButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveBottomButton, -2, 20, -2).addContainerGap()));
        GroupLayout samplePanelLayout = new GroupLayout(this.samplePanel);
        this.samplePanel.setLayout(samplePanelLayout);
        samplePanelLayout.setHorizontalGroup(samplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, samplePanelLayout.createSequentialGroup().addContainerGap().addGroup(samplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(samplePanelLayout.createSequentialGroup().addComponent(this.reporterMethodLabel, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reporterMethodComboBox, 0, -1, Short.MAX_VALUE)).addComponent(this.sampleAssignmentJScrollPane, -1, 657, Short.MAX_VALUE)).addGap(22, 22, 22).addComponent(this.orderSettingsPanel, -2, -1, -2).addGap(18, 18, 18)));
        samplePanelLayout.setVerticalGroup(samplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(samplePanelLayout.createSequentialGroup().addContainerGap().addGroup(samplePanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.reporterMethodLabel).addComponent(this.reporterMethodComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(samplePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sampleAssignmentJScrollPane, -1, 342, Short.MAX_VALUE).addGroup(samplePanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.orderSettingsPanel, -2, -1, -2))).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReagentOrderDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.samplePanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.samplePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void sampleAssignmentTableMouseReleased(MouseEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0) {
            this.moveUpButton.setEnabled(selectedRows[0] > 0);
            this.moveTopButton.setEnabled(selectedRows[0] > 0);
            this.moveDownButton.setEnabled(selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1);
            this.moveBottomButton.setEnabled(selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveTopButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveBottomButton.setEnabled(false);
        }
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            String toMove = this.reagents.get(selectedRows[0]);
            String toReplace = this.reagents.get(selectedRows[0] - 1);
            this.reagents.set(selectedRows[0] - 1, toMove);
            this.reagents.set(selectedRows[0], toReplace);
            this.sampleAssignmentTable.setRowSelectionInterval(selectedRows[0] - 1, selectedRows[0] - 1 + selectedRows.length - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveTopButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[0] > 0) {
            String toMove = this.reagents.get(selectedRows[0]);
            this.reagents.remove(selectedRows[0]);
            this.reagents.add(0, toMove);
            this.sampleAssignmentTable.setRowSelectionInterval(0, selectedRows.length - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1) {
            String toMove = this.reagents.get(selectedRows[0]);
            String toReplace = this.reagents.get(selectedRows[0] + 1);
            this.reagents.set(selectedRows[0] + 1, toMove);
            this.reagents.set(selectedRows[0], toReplace);
            this.sampleAssignmentTable.setRowSelectionInterval(selectedRows[0] + 1, selectedRows[0] + selectedRows.length);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void moveBottomButtonActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.sampleAssignmentTable.getSelectedRows();
        if (selectedRows.length > 0 && selectedRows[selectedRows.length - 1] < this.sampleAssignmentTable.getRowCount() - 1) {
            String toMove = this.reagents.get(selectedRows[0]);
            this.reagents.remove(selectedRows[0]);
            this.reagents.add(toMove);
            this.sampleAssignmentTable.setRowSelectionInterval(this.sampleAssignmentTable.getRowCount() - selectedRows.length, this.sampleAssignmentTable.getRowCount() - 1);
            this.resetTableIndexes();
            this.sampleAssignmentTableMouseReleased(null);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void resetTableIndexes() {
        for (int i = 0; i < this.sampleAssignmentTable.getRowCount(); ++i) {
            this.sampleAssignmentTable.setValueAt(i + 1, i, 0);
        }
    }

    private class AssignementTableModel
    extends DefaultTableModel {
        private AssignementTableModel() {
        }

        @Override
        public int getRowCount() {
            return ReagentOrderDialog.this.reagents.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Label";
                }
                case 2: {
                    return "Sample";
                }
                case 3: {
                    return "Ref";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String reagentName = (String)ReagentOrderDialog.this.reagents.get(row);
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    ReporterIon reporterIon = ReagentOrderDialog.this.selectedMethod.getReporterIon(reagentName);
                    return reporterIon.getName();
                }
                case 2: {
                    return ReagentOrderDialog.this.reporterIonQuantification.getSample(reagentName);
                }
                case 3: {
                    return ReagentOrderDialog.this.controlSamples.contains(reagentName);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

