/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.software.dialogs.JavaParametersDialog;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.exceptions.exception_handlers.FrameExceptionHandler;
import com.compomics.util.experiment.ProjectParameters;
import com.compomics.util.experiment.biology.genes.GeneMaps;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.peptide_shaker.Metrics;
import com.compomics.util.experiment.io.biology.protein.ProteinDetailsProvider;
import com.compomics.util.experiment.io.biology.protein.SequenceProvider;
import com.compomics.util.experiment.io.temp.TempFilesManager;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.normalization.NormalizationFactors;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.gui.PrivacyParametersDialog;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.error_handlers.BugReport;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.filtering.FilterParameters;
import com.compomics.util.gui.parameters.tools.ProcessingParametersDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.IoUtil;
import com.compomics.util.io.file.LastSelectedFolder;
import com.compomics.util.math.clustering.KMeansClustering;
import com.compomics.util.math.clustering.settings.KMeansClusteringSettings;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.parameters.quantification.spectrum_counting.SpectrumCountingParameters;
import com.compomics.util.parameters.tools.ProcessingParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.PeptideShaker;
import eu.isas.peptideshaker.preferences.DisplayParameters;
import eu.isas.peptideshaker.preferences.ProjectDetails;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import eu.isas.peptideshaker.utils.PsdbParent;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.ReporterWrapper;
import eu.isas.reporter.calculation.QuantificationFeaturesCache;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.calculation.clustering.ClusterBuilder;
import eu.isas.reporter.calculation.normalization.Normalizer;
import eu.isas.reporter.gui.JumpToPanel;
import eu.isas.reporter.gui.NewDialog;
import eu.isas.reporter.gui.ReagentOrderDialog;
import eu.isas.reporter.gui.WelcomeDialog;
import eu.isas.reporter.gui.export.ReportDialog;
import eu.isas.reporter.gui.resultpanels.OverviewPanel;
import eu.isas.reporter.gui.settings.display.ClusteringSettingsDialog;
import eu.isas.reporter.io.ProjectSaver;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.settings.ClusteringSettings;
import eu.isas.reporter.settings.ReporterSettings;
import eu.isas.reporter.utils.Properties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import net.jimmc.jshortcut.JShellLink;

public class ReporterGUI
extends JFrame
implements JavaHomeOrMemoryDialogParent {
    private static boolean useLogFile = true;
    private LastSelectedFolder lastSelectedFolder = new LastSelectedFolder();
    private ProgressDialogX progressDialog;
    private UtilitiesUserParameters utilitiesUserParameters = null;
    private ExceptionHandler exceptionHandler = new FrameExceptionHandler(this, "https://github.com/compomics/reporter/issues");
    private PsdbParent psdbParent = null;
    private ReporterSettings reporterSettings;
    private ReporterIonQuantification reporterIonQuantification;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
    private boolean projectSaved = true;
    private DisplayPreferences displayPreferences;
    private ProcessingParameters processingParameters = new ProcessingParameters();
    public static String TITLED_BORDER_HORIZONTAL_PADDING = "";
    private OverviewPanel overviewPanel;
    private DecimalFormat scoreAndConfidenceDecimalFormat = new DecimalFormat("0");
    private KMeansClustering kMeansClutering;
    private ArrayList<Long> selectedProteins;
    private ArrayList<Long> selectedPeptides;
    private ArrayList<Long> selectedPsms;
    private JumpToPanel jumpToPanel;
    private ClusterBuilder clusterBuilder;
    private JMenuItem aboutMenuItem;
    private JPanel backgroundPanel;
    private JMenuItem categoriesMenuItem;
    private JMenuItem exitMenuItem;
    private JMenuItem exportFollowUpJMenuItem;
    private JMenu exportMenu;
    private JMenuItem exportQuantificationFeaturesMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JMenuItem javaOptionsMenuItem;
    private JMenuItem logReportMenu;
    private JMenuBar menuBar;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JPanel overviewJPanel;
    private JMenuItem privacyMenuItem;
    private JMenuItem processingSettingsMenuItem;
    private JMenu quantificationOptionsMenu;
    private JMenuItem reagentOrderMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JTabbedPane tabPanel;

    public ReporterGUI() {
        try {
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            Long offset = (Long)unsafeClass.getMethod("staticFieldOffset", Field.class).invoke(unsafe, loggerField);
            unsafeClass.getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class).invoke(unsafe, loggerClass, offset, null);
        }
        catch (Throwable loggerClass) {
            // empty catch block
        }
        this.setUpLogFile();
        ReporterGUI.setLookAndFeel();
        try {
            ReporterGUI reporterGUI = this;
            this.utilitiesUserParameters = reporterGUI.utilitiesUserParameters.loadUserParameters();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occurred when reading the user preferences.", "File Error", 0);
            e.printStackTrace();
        }
        boolean newVersion = false;
        if (!Reporter.getConfigFolder().toString().equalsIgnoreCase(".") && this.utilitiesUserParameters.isAutoUpdate()) {
            newVersion = this.checkForNewVersion();
        }
        if (!newVersion) {
            if (!Reporter.getJarFilePath().equalsIgnoreCase(".")) {
                this.utilitiesUserParameters.setReporterPath(new File(Reporter.getJarFilePath(), "Reporter-" + new Properties().getVersion() + ".jar").getAbsolutePath());
                UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
            }
            if (!Reporter.getJarFilePath().equalsIgnoreCase(".") && System.getProperty("os.name").lastIndexOf("Windows") != -1 && new File(Reporter.getJarFilePath() + "/resources/conf/firstRun").exists()) {
                new File(Reporter.getJarFilePath() + "/resources/conf/firstRun").delete();
                int value = JOptionPane.showConfirmDialog(null, "Create a shortcut to Reporter on the desktop?", "Create Desktop Shortcut?", 0, 3);
                if (value == 0) {
                    this.addShortcutAtDeskTop();
                }
            }
            PeptideShaker.instantiateFacories((UtilitiesUserParameters)this.utilitiesUserParameters);
            this.initComponents();
            this.overviewPanel = new OverviewPanel(this);
            this.overviewJPanel.add(this.overviewPanel);
            this.jumpToPanel = new JumpToPanel(this);
            this.jumpToPanel.setEnabled(false);
            this.menuBar.add(Box.createHorizontalGlue());
            this.menuBar.add(this.jumpToPanel);
            this.setTitle("Reporter " + new Properties().getVersion());
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")));
            this.setExtendedState(6);
            this.overviewPanel.autoResizeComponents();
            boolean java64bit = CompomicsWrapper.is64BitJava();
            boolean memoryOk = this.utilitiesUserParameters.getMemoryParameter() >= 4000;
            String javaVersion = System.getProperty("java.version");
            boolean javaVersionWarning = javaVersion.startsWith("1.5") || javaVersion.startsWith("1.6");
            new WelcomeDialog(this, !java64bit || !memoryOk, javaVersionWarning, true);
        }
    }

    public void createNewProject(PsdbParent psdbParent, ReporterSettings reporterSettings, ReporterIonQuantification reporterIonQuantification, ProcessingParameters processingParameters, DisplayPreferences displayPreferences) {
        if (psdbParent != null) {
            this.closeOpenedProject();
        }
        this.projectSaved = true;
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.psdbParent = psdbParent;
        this.reporterSettings = reporterSettings;
        this.reporterIonQuantification = reporterIonQuantification;
        this.processingParameters = processingParameters;
        this.displayPreferences = displayPreferences;
        this.identificationFeaturesGenerator = new IdentificationFeaturesGenerator(this.getIdentification(), psdbParent.getIdentificationParameters(), psdbParent.getSequenceProvider(), psdbParent.getSpectrumProvider(), psdbParent.getMetrics(), psdbParent.getSpectrumCountingParameters());
        this.displayFeaturesGenerator = new DisplayFeaturesGenerator(psdbParent.getIdentificationParameters(), psdbParent.getDisplayParameters(), psdbParent.getSequenceProvider(), psdbParent.getProteinDetailsProvider());
        this.selectedProteins = new ArrayList();
        this.selectedPeptides = new ArrayList();
        this.selectedPsms = new ArrayList();
        this.projectSaved = false;
        this.quantificationFeaturesGenerator = new QuantificationFeaturesGenerator(new QuantificationFeaturesCache(), this.getIdentification(), this.getIdentificationFeaturesGenerator(), reporterSettings, reporterIonQuantification, psdbParent.getIdentificationParameters().getSearchParameters(), psdbParent.getIdentificationParameters().getSequenceMatchingParameters());
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Quantifying Proteins. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ImportThread"){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.displayResults(ReporterGUI.this.progressDialog);
                }
                catch (Exception e) {
                    ReporterGUI.this.catchException(e);
                    ReporterGUI.this.progressDialog.setRunCanceled();
                }
                finally {
                    ReporterGUI.this.progressDialog.setRunFinished();
                }
            }
        }.start();
    }

    public IdentificationFeaturesGenerator getIdentificationFeaturesGenerator() {
        return this.identificationFeaturesGenerator;
    }

    public ProjectParameters getProjectParameters() {
        return this.psdbParent.getProjectParameters();
    }

    public DisplayFeaturesGenerator getDisplayFeaturesGenerator() {
        return this.displayFeaturesGenerator;
    }

    public QuantificationFeaturesGenerator getQuantificationFeaturesGenerator() {
        return this.quantificationFeaturesGenerator;
    }

    public ReporterIonQuantification getReporterIonQuantification() {
        return this.reporterIonQuantification;
    }

    private void displayResults(WaitingHandler waitingHandler) throws SQLException, IOException, ClassNotFoundException, InterruptedException {
        NormalizationFactors normalizationFactors = this.reporterIonQuantification.getNormalizationFactors();
        if (!normalizationFactors.hasNormalizationFactors()) {
            Normalizer normalizer = new Normalizer();
            if (!normalizationFactors.hasPsmNormalisationFactors()) {
                normalizer.setPsmNormalizationFactors(this.reporterIonQuantification, this.reporterSettings.getRatioEstimationSettings(), this.reporterSettings.getNormalizationSettings(), this.getIdentificationParameters().getSequenceMatchingParameters(), this.getIdentification(), this.getSpectrumProvider(), this.quantificationFeaturesGenerator, this.processingParameters, this.psdbParent.getIdentificationParameters().getSearchParameters(), this.psdbParent.getIdentificationParameters().getFastaParameters(), this.psdbParent.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, this.progressDialog);
            }
            if (!normalizationFactors.hasPeptideNormalisationFactors()) {
                normalizer.setPeptideNormalizationFactors(this.reporterIonQuantification, this.reporterSettings.getRatioEstimationSettings(), this.reporterSettings.getNormalizationSettings(), this.getIdentificationParameters().getSequenceMatchingParameters(), this.getIdentification(), this.getSpectrumProvider(), this.quantificationFeaturesGenerator, this.processingParameters, this.psdbParent.getIdentificationParameters().getSearchParameters(), this.psdbParent.getIdentificationParameters().getFastaParameters(), this.psdbParent.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, this.progressDialog);
            }
            if (!normalizationFactors.hasProteinNormalisationFactors()) {
                normalizer.setProteinNormalizationFactors(this.reporterIonQuantification, this.reporterSettings.getRatioEstimationSettings(), this.reporterSettings.getNormalizationSettings(), this.getIdentification(), this.getSpectrumProvider(), this.getMetrics(), this.quantificationFeaturesGenerator, this.processingParameters, this.psdbParent.getIdentificationParameters().getSearchParameters(), this.psdbParent.getIdentificationParameters().getFastaParameters(), this.psdbParent.getIdentificationParameters().getPeptideVariantsParameters(), this.exceptionHandler, this.progressDialog);
            }
        }
        this.clusterBuilder = new ClusterBuilder();
        this.kMeansClutering = this.clusterBuilder.clusterProfiles(this.getIdentification(), this.getIdentificationParameters(), this.getSequenceProvider(), this.getSpectrumProvider(), this.getMetrics(), this.reporterIonQuantification, this.quantificationFeaturesGenerator, this.displayPreferences, true, this.progressDialog);
        if (waitingHandler.isRunCanceled()) {
            return;
        }
        this.overviewPanel.updateDisplay();
        this.saveMenuItem.setEnabled(true);
        this.saveAsMenuItem.setEnabled(true);
        this.exportMenu.setEnabled(true);
        this.jumpToPanel.setEnabled(true);
        this.jumpToPanel.setType(JumpToPanel.JumpType.proteinAndPeptides);
        ArrayList<Long> filteredProteinKeysArray = new ArrayList<Long>(this.clusterBuilder.getFilteredProteins());
        this.jumpToPanel.setProteinKeys(filteredProteinKeysArray);
    }

    public ClusterBuilder getClusterBuilder() {
        return this.clusterBuilder;
    }

    public ReporterSettings getReporterSettings() {
        return this.reporterSettings;
    }

    public Identification getIdentification() {
        if (this.psdbParent == null) {
            return null;
        }
        return this.psdbParent.getIdentification();
    }

    public GeneMaps getGeneMaps() {
        if (this.psdbParent == null) {
            return null;
        }
        return this.psdbParent.getGeneMaps();
    }

    public ProjectDetails getProjectDetails() {
        if (this.psdbParent == null) {
            return null;
        }
        return this.psdbParent.getProjectDetails();
    }

    public ProteinDetailsProvider getProteinDetailsProvider() {
        return this.psdbParent.getProteinDetailsProvider();
    }

    public DisplayParameters getIdentificationDisplayPreferences() {
        if (this.psdbParent == null || this.psdbParent.getDisplayParameters() == null) {
            return new DisplayParameters();
        }
        return this.psdbParent.getDisplayParameters();
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public SpectrumCountingParameters getSpectrumCountingParameters() {
        return this.psdbParent.getSpectrumCountingParameters();
    }

    public DisplayPreferences getDisplayParameters() {
        return this.displayPreferences;
    }

    public FilterParameters getFilterParameters() {
        return this.psdbParent.getFilterParameters();
    }

    public Color getSparklineColor() {
        return this.utilitiesUserParameters.getSparklineColor();
    }

    public Color getSparklineColorNonValidated() {
        return this.utilitiesUserParameters.getSparklineColorNonValidated();
    }

    public Color getSparklineColorNotFound() {
        return this.utilitiesUserParameters.getSparklineColorNotFound();
    }

    public Color getSparklineColorDoubtful() {
        return this.utilitiesUserParameters.getSparklineColorDoubtful();
    }

    public DecimalFormat getScoreAndConfidenceDecimalFormat() {
        return this.scoreAndConfidenceDecimalFormat;
    }

    public Metrics getMetrics() {
        return this.psdbParent.getMetrics();
    }

    public SequenceProvider getSequenceProvider() {
        return this.psdbParent.getSequenceProvider();
    }

    public SpectrumProvider getSpectrumProvider() {
        return this.psdbParent.getSpectrumProvider();
    }

    public IdentificationParameters getIdentificationParameters() {
        if (this.psdbParent == null) {
            return null;
        }
        return this.psdbParent.getIdentificationParameters();
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.tabPanel = new JTabbedPane();
        this.overviewJPanel = new JPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.openMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.quantificationOptionsMenu = new JMenu();
        this.categoriesMenuItem = new JMenuItem();
        this.reagentOrderMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.processingSettingsMenuItem = new JMenuItem();
        this.javaOptionsMenuItem = new JMenuItem();
        this.privacyMenuItem = new JMenuItem();
        this.exportMenu = new JMenu();
        this.exportQuantificationFeaturesMenuItem = new JMenuItem();
        this.exportFollowUpJMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.logReportMenu = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(1280, 750));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ReporterGUI.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.tabPanel.setTabPlacement(4);
        this.overviewJPanel.setOpaque(false);
        this.overviewJPanel.setLayout(new BoxLayout(this.overviewJPanel, 2));
        this.tabPanel.addTab("Overview", this.overviewJPanel);
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPanel, -1, 1278, Short.MAX_VALUE));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabPanel, -1, 864, Short.MAX_VALUE));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        this.newMenuItem.setMnemonic('N');
        this.newMenuItem.setText("New");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.openMenuItem.setMnemonic('O');
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveMenuItem.setMnemonic('S');
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.setEnabled(false);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As...");
        this.saveAsMenuItem.setEnabled(false);
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator3);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.quantificationOptionsMenu.setMnemonic('E');
        this.quantificationOptionsMenu.setText("Edit");
        this.categoriesMenuItem.setText("Cluster Settings");
        this.categoriesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.categoriesMenuItemActionPerformed(evt);
            }
        });
        this.quantificationOptionsMenu.add(this.categoriesMenuItem);
        this.reagentOrderMenuItem.setText("Reagent Order");
        this.reagentOrderMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.reagentOrderMenuItemActionPerformed(evt);
            }
        });
        this.quantificationOptionsMenu.add(this.reagentOrderMenuItem);
        this.quantificationOptionsMenu.add(this.jSeparator4);
        this.processingSettingsMenuItem.setText("Processing Settings");
        this.processingSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.processingSettingsMenuItemActionPerformed(evt);
            }
        });
        this.quantificationOptionsMenu.add(this.processingSettingsMenuItem);
        this.javaOptionsMenuItem.setText("Java Settings");
        this.javaOptionsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.javaOptionsMenuItemActionPerformed(evt);
            }
        });
        this.quantificationOptionsMenu.add(this.javaOptionsMenuItem);
        this.privacyMenuItem.setText("Privacy Settings");
        this.privacyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.privacyMenuItemActionPerformed(evt);
            }
        });
        this.quantificationOptionsMenu.add(this.privacyMenuItem);
        this.menuBar.add(this.quantificationOptionsMenu);
        this.exportMenu.setMnemonic('E');
        this.exportMenu.setText("Export");
        this.exportMenu.setEnabled(false);
        this.exportQuantificationFeaturesMenuItem.setMnemonic('P');
        this.exportQuantificationFeaturesMenuItem.setText("Quantification Features");
        this.exportQuantificationFeaturesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.exportQuantificationFeaturesMenuItemActionPerformed(evt);
            }
        });
        this.exportMenu.add(this.exportQuantificationFeaturesMenuItem);
        this.exportFollowUpJMenuItem.setText("Follow Up Analysis");
        this.exportFollowUpJMenuItem.setEnabled(false);
        this.exportMenu.add(this.exportFollowUpJMenuItem);
        this.menuBar.add(this.exportMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.jSeparator17);
        this.logReportMenu.setMnemonic('B');
        this.logReportMenu.setText("Bug Report");
        this.logReportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.logReportMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.logReportMenu);
        this.helpMenu.add(this.jSeparator16);
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterGUI.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        new NewDialog(this, true);
    }

    private void exportQuantificationFeaturesMenuItemActionPerformed(ActionEvent evt) {
        new ReportDialog(this);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.closeReporter();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.closeReporter();
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog(this, this.getClass().getResource("/helpFiles/Reporter.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), "ReporterGUI - Help");
    }

    private void logReportMenuActionPerformed(ActionEvent evt) {
        new BugReport(this, this.lastSelectedFolder, "Reporter", "reporter", new Properties().getVersion(), "reporter_software", "Reporter", new File(Reporter.getConfigFolder() + "/resources/Reporter.log"));
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog(this, this.getClass().getResource("/helpFiles/AboutReporter.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), "About ReporterGUI");
    }

    private void privacyMenuItemActionPerformed(ActionEvent evt) {
        new PrivacyParametersDialog((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")));
    }

    private void javaOptionsMenuItemActionPerformed(ActionEvent evt) {
        new JavaParametersDialog(this, this, null, "Reporter", true);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        if (this.psdbParent.getPsdbFile() != null && this.psdbParent.getPsdbFile().exists()) {
            this.saveProject(false, false);
        } else {
            this.saveProjectAs(false, false);
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        new NewDialog(this, true);
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveProjectAs(false, false);
    }

    private void processingSettingsMenuItemActionPerformed(ActionEvent evt) {
        ProcessingParametersDialog processingParametersDialog = new ProcessingParametersDialog((Frame)this, this.processingParameters, true);
        if (!processingParametersDialog.isCanceled()) {
            this.processingParameters = processingParametersDialog.getProcessingParameters();
        }
    }

    private void categoriesMenuItemActionPerformed(ActionEvent evt) {
        ClusteringSettingsDialog clusteringSettingsDialog = new ClusteringSettingsDialog(this, this.displayPreferences.getClusteringSettings(), true);
        if (!clusteringSettingsDialog.isCanceled()) {
            KMeansClusteringSettings kMeansClusteringSettings = this.displayPreferences.getClusteringSettings().getKMeansClusteringSettings();
            ClusteringSettings newSettings = clusteringSettingsDialog.getClusteringSettings();
            newSettings.setKMeansClusteringSettings(kMeansClusteringSettings);
            this.displayPreferences.setClusteringSettings(newSettings);
            this.recluster(kMeansClusteringSettings.getnClusters(), true);
        }
    }

    private void reagentOrderMenuItemActionPerformed(ActionEvent evt) {
        ReagentOrderDialog reagentOrderDialog = new ReagentOrderDialog(this, true, this.displayPreferences.getReagents(), this.reporterIonQuantification.getReporterMethod(), this.reporterIonQuantification, this.reporterIonQuantification.getControlSamples());
        if (!reagentOrderDialog.isCancelled()) {
            this.displayPreferences.setReagents(reagentOrderDialog.getReagentOrder());
            KMeansClusteringSettings kMeansClusteringSettings = this.displayPreferences.getClusteringSettings().getKMeansClusteringSettings();
            this.recluster(kMeansClusteringSettings.getnClusters(), false);
        }
    }

    private void saveProject(boolean aCloseWhenDone, boolean aExportToZipWhenDone) {
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), true);
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setTitle("Saving. Please Wait...");
        final boolean closeWhenDone = aCloseWhenDone;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("SaveThread"){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setWaitingText("Saving Results. Please Wait...");
                    ProjectSaver.saveProject(ReporterGUI.this.reporterSettings, ReporterGUI.this.reporterIonQuantification, ReporterGUI.this.displayPreferences, ReporterGUI.this.psdbParent, ReporterGUI.this.progressDialog);
                    if (!ReporterGUI.this.progressDialog.isRunCanceled()) {
                        if (closeWhenDone) {
                            ReporterGUI.this.closeReporter();
                        } else {
                            ReporterGUI.this.progressDialog.setRunFinished();
                            JOptionPane.showMessageDialog(ReporterGUI.this, "Project successfully saved.", "Save Successful", 1);
                            ReporterGUI.this.projectSaved = true;
                        }
                    }
                }
                catch (Exception e) {
                    ReporterGUI.this.progressDialog.setRunFinished();
                    e.printStackTrace();
                    ReporterGUI.this.catchException(e);
                }
            }
        }.start();
    }

    public void saveProjectAs(boolean closeWhenDone, boolean aExportToZipWhenDone) {
        File selectedFile = this.getUserSelectedFile(this.psdbParent.getProjectParameters().getProjectUniqueName(), ".psdb", "Peptide Shaker Database format (*.psdb)", "Save As...", false);
        this.psdbParent.setPsdbFile(selectedFile);
        if (selectedFile != null) {
            this.saveProject(closeWhenDone, aExportToZipWhenDone);
        }
    }

    public void closeReporter() {
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        this.progressDialog.setTitle("Closing. Please Wait...");
        this.progressDialog.setPrimaryProgressCounterIndeterminate(true);
        this.progressDialog.setUnstoppable(true);
        final ReporterGUI finalRef = this;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.overviewPanel.deactivateSelfUpdatingTableModels();
                    if (!ReporterGUI.this.progressDialog.isRunCanceled()) {
                        TempFilesManager.deleteTempFolders();
                        ReporterGUI.this.closeOpenedProject();
                        ReporterGUI.this.saveUserPreferences();
                    }
                    if (ReporterGUI.this.progressDialog.isRunCanceled()) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ReporterGUI.this.catchException(e);
                }
                finally {
                    ReporterGUI.this.progressDialog.setRunFinished();
                    finalRef.setVisible(false);
                    ReporterGUI.this.clearData(true);
                    System.exit(0);
                }
            }
        });
    }

    private void closeOpenedProject() {
    }

    public void clearData(boolean clearDatabaseFolder) {
        if (this.psdbParent != null) {
            this.psdbParent.setProjectDetails(null);
        }
        if (clearDatabaseFolder) {
            this.clearDatabaseFolder();
        }
        if (this.psdbParent != null) {
            this.psdbParent.setPsdbFile(null);
        }
    }

    private void clearDatabaseFolder() {
        File matchFolder;
        boolean databaseClosed = true;
        if (this.getIdentification() != null) {
            try {
                this.getIdentification().close(false);
                this.psdbParent.setIdentification(null);
            }
            catch (Exception e) {
                databaseClosed = false;
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Failed to close the database.", "Database Error", 2);
            }
        }
        if (databaseClosed && (matchFolder = Reporter.getMatchesFolder()).exists()) {
            File[] tempFiles = matchFolder.listFiles();
            if (tempFiles != null) {
                for (File currentFile : tempFiles) {
                    IoUtil.deleteDir(currentFile);
                }
            }
            if (matchFolder.listFiles() != null && matchFolder.listFiles().length > 0) {
                JOptionPane.showMessageDialog(null, "Failed to empty the database folder:\n" + matchFolder.getPath() + ".", "Database Cleanup Failed", 2);
            }
        }
    }

    public void catchException(Exception e) {
        this.exceptionHandler.catchException(e);
    }

    public void saveUserPreferences() {
        UtilitiesUserParameters.saveUserParameters(this.utilitiesUserParameters);
    }

    public static void main(String[] args) {
        new ReporterGUI();
    }

    public LastSelectedFolder getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
            this.utilitiesUserParameters.setLastSelectedFolder(this.lastSelectedFolder);
        }
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    public File getUserSelectedFile(String aSuggestedFileName, String aFileEnding, String aFileFormatDescription, String aDialogTitle, boolean openDialog) {
        File selectedFile = FileChooserUtil.getUserSelectedFile(this, aFileEnding, aFileFormatDescription, aDialogTitle, this.lastSelectedFolder.getLastSelectedFolder(), aSuggestedFileName, openDialog);
        if (selectedFile != null) {
            if (selectedFile.isDirectory()) {
                this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getAbsolutePath());
            } else {
                this.lastSelectedFolder.setLastSelectedFolder(selectedFile.getParentFile().getAbsolutePath());
            }
        }
        return selectedFile;
    }

    private static void setLookAndFeel() {
        try {
            UtilitiesGUIDefaults.setLookAndFeel();
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            UIDefaults defaults = lookAndFeel.getDefaults();
            defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUpLogFile() {
        try {
            if (useLogFile && !Reporter.getConfigFolder().toString().equalsIgnoreCase(".")) {
                String path = Reporter.getConfigFolder() + "/resources/Reporter.log";
                File file = new File(path);
                System.setOut(new PrintStream(new FileOutputStream(file, true)));
                System.setErr(new PrintStream(new FileOutputStream(file, true)));
                if (!file.exists()) {
                    file.createNewFile();
                    FileWriter w = new FileWriter(file);
                    BufferedWriter bw = new BufferedWriter(w);
                    bw.close();
                    w.close();
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occurred when trying to create the Reporter log file.", "Error Creating Log File", 0);
            e.printStackTrace();
        }
    }

    private void addShortcutAtDeskTop() {
        String jarFilePath = Reporter.getJarFilePath();
        if (!jarFilePath.equalsIgnoreCase(".")) {
            if (jarFilePath.startsWith("\\") && !jarFilePath.startsWith("\\\\")) {
                jarFilePath = jarFilePath.substring(1);
            }
            String iconFileLocation = jarFilePath + "\\resources\\reporter.ico";
            String jarFileLocation = jarFilePath + "\\Reporter-" + new Properties().getVersion() + ".jar";
            try {
                JShellLink link = new JShellLink();
                link.setFolder(JShellLink.getDirectory((String)"desktop"));
                link.setName("Reporter " + new Properties().getVersion());
                link.setIconLocation(iconFileLocation);
                link.setPath(jarFileLocation);
                link.save();
            }
            catch (Exception e) {
                System.out.println("An error occurred when trying to create a desktop shortcut...");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void restart() {
        if (this.getExtendedState() == 1 || !this.isActive()) {
            this.setExtendedState(6);
        }
        this.progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        this.progressDialog.getProgressBar().setStringPainted(false);
        this.progressDialog.getProgressBar().setIndeterminate(true);
        this.progressDialog.setTitle("Closing. Please Wait...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("RestartThread"){

            @Override
            public void run() {
                ReporterGUI.this.progressDialog.setRunFinished();
                ReporterGUI.this.dispose();
                new ReporterWrapper(null);
                System.exit(0);
            }
        }.start();
    }

    @Override
    public UtilitiesUserParameters getUtilitiesUserParameters() {
        return this.utilitiesUserParameters;
    }

    public boolean checkForNewVersion() {
        try {
            File jarFile = new File(ReporterGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());
            URL jarRepository = new URL("https", "genesis.ugent.be", "/archiva/repository/maven2/");
            return CompomicsWrapper.checkForNewDeployedVersion("Reporter", oldMavenJarFile, jarRepository, "reporter.ico", false, true, true, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
        }
        catch (UnknownHostException ex) {
            System.out.println("Checking for new version failed. No internet connection.");
            return false;
        }
        catch (ConnectException ex) {
            System.out.println("Checking for new version failed. Connection refused.");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public KMeansClustering getkMeansClutering() {
        return this.kMeansClutering;
    }

    public void recluster(int numberOfClusters, final boolean loadData) {
        this.displayPreferences.getClusteringSettings().getKMeansClusteringSettings().setnClusters(numberOfClusters);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("ClusterThread"){

            @Override
            public void run() {
                try {
                    ReporterGUI.this.kMeansClutering = ReporterGUI.this.clusterBuilder.clusterProfiles(ReporterGUI.this.getIdentification(), ReporterGUI.this.getIdentificationParameters(), ReporterGUI.this.getSequenceProvider(), ReporterGUI.this.getSpectrumProvider(), ReporterGUI.this.getMetrics(), ReporterGUI.this.reporterIonQuantification, ReporterGUI.this.quantificationFeaturesGenerator, ReporterGUI.this.displayPreferences, loadData, ReporterGUI.this.progressDialog);
                    if (!ReporterGUI.this.progressDialog.isRunCanceled()) {
                        ReporterGUI.this.overviewPanel.updateDisplay();
                    }
                }
                catch (Exception e) {
                    ReporterGUI.this.catchException(e);
                    ReporterGUI.this.progressDialog.setRunCanceled();
                }
                finally {
                    ReporterGUI.this.progressDialog.setRunFinished();
                }
            }
        }.start();
    }

    public ArrayList<Long> getSelectedProteins() {
        return this.selectedProteins;
    }

    public ArrayList<Long> getSelectedPeptides() {
        return this.selectedPeptides;
    }

    public ArrayList<Long> getSelectedPsms() {
        return this.selectedPsms;
    }

    public void minimizeChart() {
        this.overviewPanel.minimizeChart();
    }

    public void setSelectedProteins(ArrayList<Long> selectedProteins, boolean updateSelection, boolean clearSelection) {
        this.selectedProteins = selectedProteins;
        if (updateSelection) {
            this.overviewPanel.updateSelection(clearSelection);
        }
    }

    public void setSelectedPeptides(ArrayList<Long> selectedPeptides, boolean updateSelection, boolean clearSelection) {
        this.selectedPeptides = selectedPeptides;
        if (updateSelection) {
            this.overviewPanel.updateSelection(clearSelection);
        }
    }

    public void setSelectedPsms(ArrayList<Long> selectedPsms, boolean updateSelection, boolean clearSelection) {
        this.selectedPsms = selectedPsms;
        if (updateSelection) {
            this.overviewPanel.updateSelection(clearSelection);
        }
    }
}

