/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.export;

import com.compomics.util.gui.ExportFormatSelectionDialog;
import com.compomics.util.gui.export.report.ReportEditor;
import com.compomics.util.gui.file_handling.FileAndFileFilter;
import com.compomics.util.gui.file_handling.FileChooserUtil;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.io.export.ExportFormat;
import com.compomics.util.io.export.ExportScheme;
import eu.isas.reporter.export.report.ReporterExportFactory;
import eu.isas.reporter.gui.ReporterGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;

public class ReportDialog
extends JDialog {
    private ReporterExportFactory exportFactory = ReporterExportFactory.getInstance();
    private ReporterGUI reporterGUI;
    private static ProgressDialogX progressDialog;
    private ArrayList<String> exportSchemesNames;
    private JLabel addReportLabel;
    private JMenuItem addReportMenuItem;
    private JPanel backgroundPanel;
    private JPanel customReportsPanel;
    private JMenuItem editReportMenuItem;
    private JButton exitButton;
    private JButton exportReportButton;
    private JLabel helpLabel;
    private JMenuItem removeReportMenuItem;
    private JMenuItem reportDocumentationMenuItem;
    private JPopupMenu reportDocumentationPopupMenu;
    private JPopupMenu.Separator reportPopUpMenuSeparator;
    private JTable reportsTable;
    private JScrollPane reportsTableScrollPane;

    public ReportDialog(ReporterGUI reporterGUI) {
        super((Frame)reporterGUI, true);
        this.reporterGUI = reporterGUI;
        this.updateReportsList();
        this.initComponents();
        this.setUpGUI();
        this.setLocationRelativeTo(reporterGUI);
        this.setVisible(true);
    }

    private void setUpGUI() {
        this.reportsTableScrollPane.getViewport().setOpaque(false);
        this.reportsTable.getTableHeader().setReorderingAllowed(false);
        this.reportsTable.getColumn(" ").setMaxWidth(50);
        this.reportsTable.getColumn(" ").setMinWidth(50);
    }

    private void initComponents() {
        this.reportDocumentationPopupMenu = new JPopupMenu();
        this.addReportMenuItem = new JMenuItem();
        this.removeReportMenuItem = new JMenuItem();
        this.editReportMenuItem = new JMenuItem();
        this.reportPopUpMenuSeparator = new JPopupMenu.Separator();
        this.reportDocumentationMenuItem = new JMenuItem();
        this.backgroundPanel = new JPanel();
        this.exitButton = new JButton();
        this.customReportsPanel = new JPanel();
        this.reportsTableScrollPane = new JScrollPane();
        this.reportsTable = new JTable();
        this.exportReportButton = new JButton();
        this.helpLabel = new JLabel();
        this.addReportLabel = new JLabel();
        this.addReportMenuItem.setText("Add");
        this.addReportMenuItem.setToolTipText("Add a new report type");
        this.addReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.addReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.addReportMenuItem);
        this.removeReportMenuItem.setText("Remove");
        this.removeReportMenuItem.setToolTipText("Remove the report type");
        this.removeReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.removeReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.removeReportMenuItem);
        this.editReportMenuItem.setText("Edit");
        this.editReportMenuItem.setToolTipText("Edit the report");
        this.editReportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.editReportMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.editReportMenuItem);
        this.reportDocumentationPopupMenu.add(this.reportPopUpMenuSeparator);
        this.reportDocumentationMenuItem.setText("Documentation");
        this.reportDocumentationMenuItem.setToolTipText("Export the report documentation to file");
        this.reportDocumentationMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.reportDocumentationMenuItemActionPerformed(evt);
            }
        });
        this.reportDocumentationPopupMenu.add(this.reportDocumentationMenuItem);
        this.setDefaultCloseOperation(2);
        this.setTitle("Export Ratios");
        this.setMinimumSize(new Dimension(600, 350));
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.exitButtonActionPerformed(evt);
            }
        });
        this.customReportsPanel.setBackground(new Color(230, 230, 230));
        this.customReportsPanel.setBorder(BorderFactory.createTitledBorder("Quantification Report"));
        this.reportsTable.setModel(new ReportsTableModel());
        this.reportsTable.setSelectionMode(0);
        this.reportsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReportDialog.this.reportsTableMouseClicked(evt);
            }
        });
        this.reportsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ReportDialog.this.reportsTableKeyReleased(evt);
            }
        });
        this.reportsTableScrollPane.setViewportView(this.reportsTable);
        this.exportReportButton.setText("Export");
        this.exportReportButton.setEnabled(false);
        this.exportReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReportDialog.this.exportReportButtonActionPerformed(evt);
            }
        });
        this.helpLabel.setFont(this.helpLabel.getFont().deriveFont(this.helpLabel.getFont().getStyle() | 2));
        this.helpLabel.setText("Right click on a row in the table for additional options.");
        this.addReportLabel.setText("<html> <a href>Add new report type.</a> </html>");
        this.addReportLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReportDialog.this.addReportLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                ReportDialog.this.addReportLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ReportDialog.this.addReportLabelMouseExited(evt);
            }
        });
        GroupLayout customReportsPanelLayout = new GroupLayout(this.customReportsPanel);
        this.customReportsPanel.setLayout(customReportsPanelLayout);
        customReportsPanelLayout.setHorizontalGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customReportsPanelLayout.createSequentialGroup().addContainerGap().addGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reportsTableScrollPane, GroupLayout.Alignment.TRAILING, -1, 553, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, customReportsPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.addReportLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.helpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 101, Short.MAX_VALUE).addComponent(this.exportReportButton))).addContainerGap()));
        customReportsPanelLayout.setVerticalGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(customReportsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reportsTableScrollPane, -1, 242, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(customReportsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.exportReportButton).addComponent(this.helpLabel).addComponent(this.addReportLabel, -2, -1, -2)).addContainerGap()));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.exitButton).addComponent(this.customReportsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.customReportsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        try {
            ReporterExportFactory.saveFactory(this.exportFactory);
        }
        catch (Exception e) {
            this.reporterGUI.catchException(e);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void reportsTableMouseClicked(MouseEvent evt) {
        if (evt != null && this.reportsTable.rowAtPoint(evt.getPoint()) != -1) {
            this.reportsTable.setRowSelectionInterval(this.reportsTable.rowAtPoint(evt.getPoint()), this.reportsTable.rowAtPoint(evt.getPoint()));
        }
        if (evt != null && evt.getButton() == 3 && this.reportsTable.getSelectedRow() != -1) {
            String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
            ExportScheme exportScheme = this.exportFactory.getExportScheme(schemeName);
            this.editReportMenuItem.setVisible(exportScheme.isEditable());
            this.removeReportMenuItem.setVisible(exportScheme.isEditable());
            this.reportDocumentationPopupMenu.show(this.reportsTable, evt.getX(), evt.getY());
        }
        if (evt != null && evt.getButton() == 1 && evt.getClickCount() == 2) {
            this.writeSelectedReport();
        }
        this.exportReportButton.setEnabled(this.reportsTable.getSelectedRow() != -1);
    }

    private void reportsTableKeyReleased(KeyEvent evt) {
        this.reportsTableMouseClicked(null);
    }

    private void exportReportButtonActionPerformed(ActionEvent evt) {
        this.writeSelectedReport();
    }

    private void addReportLabelMouseClicked(MouseEvent evt) {
        this.addReportMenuItemActionPerformed(null);
    }

    private void addReportLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void addReportLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void addReportMenuItemActionPerformed(ActionEvent evt) {
        new ReportEditor((Frame)this.reporterGUI, this.exportFactory);
        int selectedRow = this.reportsTable.getSelectedRow();
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        if (selectedRow != -1) {
            this.reportsTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.reportsTableMouseClicked(null);
    }

    private void removeReportMenuItemActionPerformed(ActionEvent evt) {
        String reportName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        this.exportFactory.removeExportScheme(reportName);
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        this.reportsTableMouseClicked(null);
    }

    private void editReportMenuItemActionPerformed(ActionEvent evt) {
        String reportName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        new ReportEditor((Frame)this.reporterGUI, this.exportFactory, reportName, true);
        int selectedRow = this.reportsTable.getSelectedRow();
        this.updateReportsList();
        ((DefaultTableModel)this.reportsTable.getModel()).fireTableDataChanged();
        if (selectedRow != -1) {
            this.reportsTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.reportsTableMouseClicked(null);
    }

    private void reportDocumentationMenuItemActionPerformed(ActionEvent evt) {
        this.writeDocumentationOfSelectedReport();
    }

    private void updateReportsList() {
        this.exportSchemesNames = new ArrayList();
        this.exportSchemesNames.addAll(this.exportFactory.getDefaultExportSchemesNames());
        this.exportSchemesNames.addAll(this.exportFactory.getUserSchemesNames());
    }

    private void writeSelectedReport() {
        final String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
        String excelFileFilterDescription = "Excel Workbook (.xls)";
        String textFileFilterDescription = "Tab separated text file (.txt)";
        String lastSelectedFolderPath = this.reporterGUI.getLastSelectedFolder().getLastSelectedFolder();
        FileAndFileFilter selectedFileAndFilter = FileChooserUtil.getUserSelectedFile(this, new String[]{".xls", ".txt"}, new String[]{excelFileFilterDescription, textFileFilterDescription}, "Export Report", lastSelectedFolderPath, schemeName, false, true, false, 1);
        if (selectedFileAndFilter != null) {
            final File selectedFile = selectedFileAndFilter.getFile();
            final ExportFormat exportFormat = selectedFileAndFilter.getFileFilter().getDescription().equalsIgnoreCase(textFileFilterDescription) ? ExportFormat.text : ExportFormat.excel;
            progressDialog = new ProgressDialogX(this, this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
            progressDialog.setTitle("Exporting Report. Please Wait...");
            final String filePath = selectedFile.getPath();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ExportThread"){

                @Override
                public void run() {
                    try {
                        ExportScheme exportScheme = ReportDialog.this.exportFactory.getExportScheme(schemeName);
                        progressDialog.setTitle("Exporting. Please Wait...");
                        ReporterExportFactory.writeExport(exportScheme, selectedFile, exportFormat, ReportDialog.this.reporterGUI.getProjectParameters().getProjectUniqueName(), ReportDialog.this.reporterGUI.getProjectDetails(), ReportDialog.this.reporterGUI.getIdentification(), ReportDialog.this.reporterGUI.getIdentificationFeaturesGenerator(), ReportDialog.this.reporterGUI.getSequenceProvider(), ReportDialog.this.reporterGUI.getSpectrumProvider(), ReportDialog.this.reporterGUI.getProteinDetailsProvider(), ReportDialog.this.reporterGUI.getGeneMaps(), ReportDialog.this.reporterGUI.getQuantificationFeaturesGenerator(), ReportDialog.this.reporterGUI.getReporterIonQuantification(), ReportDialog.this.reporterGUI.getReporterSettings(), ReportDialog.this.reporterGUI.getIdentificationParameters(), null, null, null, null, ReportDialog.this.reporterGUI.getIdentificationDisplayPreferences().getnAASurroundingPeptides(), ReportDialog.this.reporterGUI.getSpectrumCountingParameters(), progressDialog);
                        boolean processCancelled = progressDialog.isRunCanceled();
                        progressDialog.setRunFinished();
                        if (!processCancelled) {
                            JOptionPane.showMessageDialog(ReportDialog.this.reporterGUI, "Data copied to file:\n" + filePath, "Data Exported.", 1);
                        }
                    }
                    catch (Exception e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(ReportDialog.this.reporterGUI, "An error occurred while generating the output.", "Output Error.", 0);
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private void writeDocumentationOfSelectedReport() {
        ExportFormatSelectionDialog exportFormatSelectionDialog = new ExportFormatSelectionDialog(this, true);
        if (!exportFormatSelectionDialog.isCanceled()) {
            final ExportFormat exportFormat = exportFormatSelectionDialog.getFormat();
            final String schemeName = (String)this.reportsTable.getValueAt(this.reportsTable.getSelectedRow(), 1);
            final File selectedFile = exportFormat == ExportFormat.text ? this.reporterGUI.getUserSelectedFile(schemeName + ".txt", ".txt", "Tab separated text file (.txt)", "Export...", false) : this.reporterGUI.getUserSelectedFile(schemeName + ".xls", ".xls", "Excel Workbook (.xls)", "Export...", false);
            if (selectedFile != null) {
                progressDialog = new ProgressDialogX(this, this.reporterGUI, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/reporter-orange.gif")), true);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            progressDialog.setVisible(true);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }, "ProgressDialog").start();
                new Thread("ExportThread"){

                    @Override
                    public void run() {
                        boolean error = false;
                        try {
                            ExportScheme exportScheme = ReportDialog.this.exportFactory.getExportScheme(schemeName);
                            ReporterExportFactory.writeDocumentation(exportScheme, exportFormat, selectedFile);
                        }
                        catch (Exception e) {
                            error = true;
                            ReportDialog.this.reporterGUI.catchException(e);
                        }
                        progressDialog.setRunFinished();
                        if (!error) {
                            JOptionPane.showMessageDialog(ReportDialog.this.reporterGUI, "Documentation saved to '" + selectedFile.getAbsolutePath() + "'.", "Documentation Saved", 1);
                        }
                    }
                }.start();
            }
        }
    }

    private class ReportsTableModel
    extends DefaultTableModel {
        @Override
        public int getRowCount() {
            if (ReportDialog.this.exportSchemesNames == null) {
                return 0;
            }
            return ReportDialog.this.exportSchemesNames.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Name";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return ReportDialog.this.exportSchemesNames.get(row);
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

