/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.settings;

import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.parameters.identification.search.ModificationParameters;
import eu.isas.reporter.gui.settings.quantification.NormalizationSettingsDialog;
import eu.isas.reporter.gui.settings.quantification.RatioEstimationSettingsDialog;
import eu.isas.reporter.gui.settings.quantification.ReporterIonSelectionSettingsDialog;
import eu.isas.reporter.settings.NormalizationSettings;
import eu.isas.reporter.settings.RatioEstimationSettings;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterSettings;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class ReporterSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private ReporterMethod reporterMethod = null;
    private ModificationParameters modificationParameters;
    private ReporterIonSelectionSettings reporterIonSelectionSettings;
    private RatioEstimationSettings ratioEstimationSettings;
    private NormalizationSettings normalizationSettings;
    private boolean editable;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JButton normalizationButton;
    private JButton okButton;
    private JButton ratioEstimationButton;
    private JButton reporterIonSelectionButton;
    private JPanel settingsPanel;

    public ReporterSettingsDialog(JDialog parentDialog, ReporterSettings reporterSettings, ModificationParameters modificationParameters, ReporterMethod reporterMethod, boolean editable) {
        super((Dialog)parentDialog, true);
        this.reporterIonSelectionSettings = reporterSettings.getReporterIonSelectionSettings();
        this.ratioEstimationSettings = reporterSettings.getRatioEstimationSettings();
        this.normalizationSettings = reporterSettings.getNormalizationSettings();
        this.modificationParameters = modificationParameters;
        this.reporterMethod = reporterMethod;
        this.editable = editable;
        this.initComponents();
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.settingsPanel = new JPanel();
        this.reporterIonSelectionButton = new JButton();
        this.ratioEstimationButton = new JButton();
        this.normalizationButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Quantification Advanced Settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ReporterSettingsDialog.this.formWindowClosing(evt);
            }
        });
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.settingsPanel.setBackground(new Color(230, 230, 230));
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("Reporter Ion Quantification Settings"));
        this.reporterIonSelectionButton.setFont(this.reporterIonSelectionButton.getFont().deriveFont(this.reporterIonSelectionButton.getFont().getStyle() | 1, this.reporterIonSelectionButton.getFont().getSize() + 3));
        this.reporterIonSelectionButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/RatioPencil.png")));
        this.reporterIonSelectionButton.setText("Reporter Ions");
        this.reporterIonSelectionButton.setHorizontalAlignment(2);
        this.reporterIonSelectionButton.setIconTextGap(40);
        this.reporterIonSelectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterSettingsDialog.this.reporterIonSelectionButtonActionPerformed(evt);
            }
        });
        this.ratioEstimationButton.setFont(this.ratioEstimationButton.getFont().deriveFont(this.ratioEstimationButton.getFont().getStyle() | 1, this.ratioEstimationButton.getFont().getSize() + 3));
        this.ratioEstimationButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/RatioRuler.png")));
        this.ratioEstimationButton.setText("Ratio Estimation");
        this.ratioEstimationButton.setHorizontalAlignment(2);
        this.ratioEstimationButton.setIconTextGap(38);
        this.ratioEstimationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterSettingsDialog.this.ratioEstimationButtonActionPerformed(evt);
            }
        });
        this.normalizationButton.setFont(this.normalizationButton.getFont().deriveFont(this.normalizationButton.getFont().getStyle() | 1, this.normalizationButton.getFont().getSize() + 3));
        this.normalizationButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/RatioCalculator.png")));
        this.normalizationButton.setText("Normalization");
        this.normalizationButton.setHorizontalAlignment(2);
        this.normalizationButton.setIconTextGap(40);
        this.normalizationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterSettingsDialog.this.normalizationButtonActionPerformed(evt);
            }
        });
        GroupLayout settingsPanelLayout = new GroupLayout(this.settingsPanel);
        this.settingsPanel.setLayout(settingsPanelLayout);
        settingsPanelLayout.setHorizontalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(45, 45, 45).addGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterIonSelectionButton, -1, -1, Short.MAX_VALUE).addComponent(this.ratioEstimationButton, -1, 376, Short.MAX_VALUE).addComponent(this.normalizationButton, -1, -1, Short.MAX_VALUE)).addGap(45, 45, 45)));
        settingsPanelLayout.setVerticalGroup(settingsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(settingsPanelLayout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.reporterIonSelectionButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ratioEstimationButton, -2, 75, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.normalizationButton, -2, 75, -2).addContainerGap(25, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.settingsPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void reporterIonSelectionButtonActionPerformed(ActionEvent evt) {
        ReporterIonSelectionSettingsDialog reporterIonSelectionSettingsDialog = new ReporterIonSelectionSettingsDialog(this, this.reporterIonSelectionSettings, this.reporterMethod, this.editable);
        if (!reporterIonSelectionSettingsDialog.isCanceled()) {
            this.reporterIonSelectionSettings = reporterIonSelectionSettingsDialog.getReporterIonSelectionSettings();
        }
    }

    private void ratioEstimationButtonActionPerformed(ActionEvent evt) {
        RatioEstimationSettingsDialog ratioEstimationSettingsDialog = new RatioEstimationSettingsDialog(this, this.ratioEstimationSettings, this.modificationParameters, this.editable);
        if (!ratioEstimationSettingsDialog.isCanceled()) {
            this.ratioEstimationSettings = ratioEstimationSettingsDialog.getRatioEstimationSettings();
        }
    }

    private void normalizationButtonActionPerformed(ActionEvent evt) {
        NormalizationSettingsDialog normalizationSettingsDialog = new NormalizationSettingsDialog(this, this.normalizationSettings, this.editable);
        if (!normalizationSettingsDialog.isCanceled()) {
            this.normalizationSettings = normalizationSettingsDialog.getNormalizationSettings();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.canceled = true;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public ReporterSettings getReporterSettings() {
        ReporterSettings reporterSettings = new ReporterSettings();
        reporterSettings.setReporterIonSelectionSettings(this.reporterIonSelectionSettings);
        reporterSettings.setRatioEstimationSettings(this.ratioEstimationSettings);
        reporterSettings.setNormalizationSettings(this.normalizationSettings);
        return reporterSettings;
    }
}

