/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.settings.quantification;

import com.compomics.util.experiment.quantification.reporterion.ReporterMethod;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import eu.isas.reporter.settings.ReporterIonSelectionSettings;
import eu.isas.reporter.settings.ReporterIonsLocationType;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ReporterIonSelectionSettingsDialog
extends JDialog {
    private boolean canceled = false;
    private ReporterMethod reporterMethod = null;
    private JPanel backgroundPanel;
    private JButton cancelButton;
    private JComboBox ionSelectionComboBox;
    private JLabel ionSelectionLabel;
    private JTextField ionToleranceTxt;
    private JRadioButton ms2SpectrumReportersOption;
    private JRadioButton ms3SpectrumReportersOption;
    private JTextField mzTolTxt;
    private JLabel mzToleranceLabel;
    private JButton okButton;
    private JComboBox ppmCmb;
    private JRadioButton precursorMatchingReportersOption;
    private JLabel reporterIonMzToleranceLabel;
    private ButtonGroup reporterLocationButtonGroup;
    private JPanel reporterLocationPanel;
    private JTextField rtTolTxt;
    private JLabel rtToleranceLabel;
    private JPanel spectrumAnalysisPanel;

    public ReporterIonSelectionSettingsDialog(JDialog parentDialog, ReporterIonSelectionSettings reporterIonSelectionSettings, ReporterMethod reporterMethod, boolean editable) {
        super((Dialog)parentDialog, true);
        this.reporterMethod = reporterMethod;
        this.initComponents();
        this.setUpGui(editable);
        this.populateGUI(reporterIonSelectionSettings);
        this.setLocationRelativeTo(parentDialog);
        this.setVisible(true);
    }

    public ReporterIonSelectionSettingsDialog(JDialog parentDialog, ReporterIonSelectionSettings reporterIonSelectionSettings, boolean editable) {
        this(parentDialog, reporterIonSelectionSettings, null, editable);
    }

    private void setUpGui(boolean editable) {
        this.ionSelectionComboBox.setRenderer(new AlignedListCellRenderer(0));
    }

    private void populateGUI(ReporterIonSelectionSettings reporterIonSelectionSettings) {
        this.ionToleranceTxt.setText(reporterIonSelectionSettings.getReporterIonsMzTolerance() + "");
        if (reporterIonSelectionSettings.isMostAccurate()) {
            this.ionSelectionComboBox.setSelectedIndex(0);
        } else {
            this.ionSelectionComboBox.setSelectedIndex(1);
        }
        switch (reporterIonSelectionSettings.getReporterIonsLocation()) {
            case ms2Spectra: {
                this.ms2SpectrumReportersOption.setSelected(true);
                break;
            }
            case ms3Spectra: {
                this.ms3SpectrumReportersOption.setSelected(true);
                break;
            }
            case precursorMatching: {
                this.precursorMatchingReportersOption.setSelected(true);
                this.mzTolTxt.setText(reporterIonSelectionSettings.getPrecursorMzTolerance() + "");
                this.rtTolTxt.setText(reporterIonSelectionSettings.getPrecursorRTTolerance() + "");
                break;
            }
        }
        this.updateReporterLocationOptions();
    }

    private void initComponents() {
        this.reporterLocationButtonGroup = new ButtonGroup();
        this.backgroundPanel = new JPanel();
        this.okButton = new JButton();
        this.spectrumAnalysisPanel = new JPanel();
        this.reporterIonMzToleranceLabel = new JLabel();
        this.ionToleranceTxt = new JTextField();
        this.ionSelectionLabel = new JLabel();
        this.ionSelectionComboBox = new JComboBox();
        this.reporterLocationPanel = new JPanel();
        this.ms2SpectrumReportersOption = new JRadioButton();
        this.precursorMatchingReportersOption = new JRadioButton();
        this.mzToleranceLabel = new JLabel();
        this.mzTolTxt = new JTextField();
        this.ppmCmb = new JComboBox();
        this.rtToleranceLabel = new JLabel();
        this.rtTolTxt = new JTextField();
        this.ms3SpectrumReportersOption = new JRadioButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Reporter Ion Selection Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.spectrumAnalysisPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Analysis"));
        this.spectrumAnalysisPanel.setOpaque(false);
        this.reporterIonMzToleranceLabel.setText("Reporter Tolerance (m/z)");
        this.ionToleranceTxt.setHorizontalAlignment(0);
        this.ionSelectionLabel.setText("Ion Selection");
        this.ionSelectionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Most Accurate", "Most Intense"}));
        GroupLayout spectrumAnalysisPanelLayout = new GroupLayout(this.spectrumAnalysisPanel);
        this.spectrumAnalysisPanel.setLayout(spectrumAnalysisPanelLayout);
        spectrumAnalysisPanelLayout.setHorizontalGroup(spectrumAnalysisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAnalysisPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumAnalysisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAnalysisPanelLayout.createSequentialGroup().addComponent(this.reporterIonMzToleranceLabel, -2, 150, -2).addGap(18, 18, 18).addComponent(this.ionToleranceTxt)).addGroup(spectrumAnalysisPanelLayout.createSequentialGroup().addComponent(this.ionSelectionLabel, -2, 150, -2).addGap(18, 18, 18).addComponent(this.ionSelectionComboBox, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        spectrumAnalysisPanelLayout.setVerticalGroup(spectrumAnalysisPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumAnalysisPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumAnalysisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reporterIonMzToleranceLabel).addComponent(this.ionToleranceTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(spectrumAnalysisPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ionSelectionLabel).addComponent(this.ionSelectionComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.reporterLocationPanel.setBorder(BorderFactory.createTitledBorder("Reporter Location"));
        this.reporterLocationPanel.setOpaque(false);
        this.reporterLocationButtonGroup.add(this.ms2SpectrumReportersOption);
        this.ms2SpectrumReportersOption.setText("MS2 Spectrum");
        this.ms2SpectrumReportersOption.setIconTextGap(10);
        this.ms2SpectrumReportersOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.ms2SpectrumReportersOptionActionPerformed(evt);
            }
        });
        this.reporterLocationButtonGroup.add(this.precursorMatchingReportersOption);
        this.precursorMatchingReportersOption.setText("Precursor Matching");
        this.precursorMatchingReportersOption.setIconTextGap(10);
        this.precursorMatchingReportersOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.precursorMatchingReportersOptionReportersOptionActionPerformed(evt);
            }
        });
        this.mzToleranceLabel.setText("m/z tolerance");
        this.mzTolTxt.setHorizontalAlignment(0);
        this.ppmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"ppm", "m/z"}));
        this.rtToleranceLabel.setText("RT tolerance (s)");
        this.rtTolTxt.setHorizontalAlignment(0);
        this.rtTolTxt.setText("10");
        this.rtTolTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.rtTolTxtActionPerformed(evt);
            }
        });
        this.reporterLocationButtonGroup.add(this.ms3SpectrumReportersOption);
        this.ms3SpectrumReportersOption.setSelected(true);
        this.ms3SpectrumReportersOption.setText("MS3 Spectrum");
        this.ms3SpectrumReportersOption.setIconTextGap(10);
        this.ms3SpectrumReportersOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.ms3SpectrumReportersOptionActionPerformed(evt);
            }
        });
        GroupLayout reporterLocationPanelLayout = new GroupLayout(this.reporterLocationPanel);
        this.reporterLocationPanel.setLayout(reporterLocationPanelLayout);
        reporterLocationPanelLayout.setHorizontalGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterLocationPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ms2SpectrumReportersOption, -2, 150, -2).addComponent(this.precursorMatchingReportersOption, -2, 150, -2).addGroup(reporterLocationPanelLayout.createSequentialGroup().addGap(27, 27, 27).addGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.rtToleranceLabel, -1, 144, Short.MAX_VALUE).addComponent(this.mzToleranceLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rtTolTxt, -2, 150, -2).addGroup(reporterLocationPanelLayout.createSequentialGroup().addComponent(this.mzTolTxt, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ppmCmb, -2, -1, -2)))).addComponent(this.ms3SpectrumReportersOption, -2, 150, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        reporterLocationPanelLayout.setVerticalGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterLocationPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ms2SpectrumReportersOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ms3SpectrumReportersOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.precursorMatchingReportersOption).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mzToleranceLabel).addComponent(this.mzTolTxt, -2, -1, -2).addComponent(this.ppmCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(reporterLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rtToleranceLabel).addComponent(this.rtTolTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterIonSelectionSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterLocationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.spectrumAnalysisPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 69, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, 69, -2))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spectrumAnalysisPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterLocationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addGap(9, 9, 9)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            this.dispose();
        }
    }

    private void ms2SpectrumReportersOptionActionPerformed(ActionEvent evt) {
        this.updateReporterLocationOptions();
    }

    private void precursorMatchingReportersOptionReportersOptionActionPerformed(ActionEvent evt) {
        this.updateReporterLocationOptions();
    }

    private void rtTolTxtActionPerformed(ActionEvent evt) {
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.dispose();
    }

    private void ms3SpectrumReportersOptionActionPerformed(ActionEvent evt) {
        this.updateReporterLocationOptions();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private void updateReporterLocationOptions() {
        this.mzToleranceLabel.setEnabled(this.precursorMatchingReportersOption.isSelected());
        this.mzTolTxt.setEnabled(this.precursorMatchingReportersOption.isSelected());
        this.ppmCmb.setEnabled(this.precursorMatchingReportersOption.isSelected());
        this.rtToleranceLabel.setEnabled(this.precursorMatchingReportersOption.isSelected());
        this.rtTolTxt.setEnabled(this.precursorMatchingReportersOption.isSelected());
    }

    private boolean validateInput() {
        Double input;
        try {
            input = Double.valueOf(this.ionToleranceTxt.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please input a number for the ion tolerance.", "Ion Tolerance Error", 0);
            return false;
        }
        if (input <= 0.0) {
            JOptionPane.showMessageDialog(this, "Please input a positive number for the ion tolerance.", "Ion Tolerance Error", 0);
            return false;
        }
        if (this.reporterMethod != null) {
            for (String reagent1 : this.reporterMethod.getReagentNames()) {
                for (String reagent2 : this.reporterMethod.getReagentNames()) {
                    if (reagent1.equals(reagent2) || !(Math.abs(this.reporterMethod.getReagent(reagent1).getReporterIon().getTheoreticMass() - this.reporterMethod.getReagent(reagent2).getReporterIon().getTheoreticMass()) <= input)) continue;
                    JOptionPane.showMessageDialog(this, "The selected ion tolerance does not make it possible to distinguish " + reagent1 + " and " + reagent2 + ".", "Ion Tolerance Error", 2);
                    return false;
                }
            }
        }
        if (this.precursorMatchingReportersOption.isSelected()) {
            try {
                input = Double.valueOf(this.mzTolTxt.getText().trim());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Please input a number for the precursor m/z tolerance.", "Matching Tolerance Error", 0);
                return false;
            }
            if (input <= 0.0) {
                JOptionPane.showMessageDialog(this, "Please input a positive number for the precursor m/z tolerance.", "Matching Tolerance Error", 0);
                return false;
            }
            try {
                input = Double.valueOf(this.rtTolTxt.getText().trim());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Please input a number for the precursor RT tolerance.", "Matching Tolerance Error", 0);
                return false;
            }
            if (input <= 0.0) {
                JOptionPane.showMessageDialog(this, "Please input a positive number for the precursor RT tolerance.", "Matching Tolerance Error", 0);
                return false;
            }
        }
        return true;
    }

    public ReporterIonSelectionSettings getReporterIonSelectionSettings() {
        ReporterIonSelectionSettings reporterIonSelectionSettings = new ReporterIonSelectionSettings();
        Double ionTolerance = Double.valueOf(this.ionToleranceTxt.getText().trim());
        reporterIonSelectionSettings.setReporterIonsMzTolerance(ionTolerance);
        reporterIonSelectionSettings.setMostAccurate(this.ionSelectionComboBox.getSelectedIndex() == 0);
        if (this.ms2SpectrumReportersOption.isSelected()) {
            reporterIonSelectionSettings.setReporterIonsLocation(ReporterIonsLocationType.ms2Spectra);
        } else if (this.ms3SpectrumReportersOption.isSelected()) {
            reporterIonSelectionSettings.setReporterIonsLocation(ReporterIonsLocationType.ms3Spectra);
        } else if (this.precursorMatchingReportersOption.isSelected()) {
            Double matchingMzTolerance = Double.valueOf(this.mzTolTxt.getText().trim());
            reporterIonSelectionSettings.setPrecursorMzTolerance(matchingMzTolerance);
            Double matchingRtTolerance = Double.valueOf(this.rtTolTxt.getText().trim());
            reporterIonSelectionSettings.setPrecursorMzTolerance(matchingRtTolerance);
            reporterIonSelectionSettings.setPrecursorMzPpm(this.ppmCmb.getSelectedIndex() == 0);
            reporterIonSelectionSettings.setReporterIonsLocation(ReporterIonsLocationType.precursorMatching);
        }
        return reporterIonSelectionSettings;
    }
}

