/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.gui.tablemodels;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Identification;
import com.compomics.util.experiment.identification.features.IdentificationFeaturesGenerator;
import com.compomics.util.experiment.identification.matches.PeptideMatch;
import com.compomics.util.experiment.identification.peptide_shaker.PSParameter;
import com.compomics.util.experiment.mass_spectrometry.SpectrumProvider;
import com.compomics.util.experiment.quantification.reporterion.ReporterIonQuantification;
import com.compomics.util.gui.tablemodels.SelfUpdatingTableModel;
import com.compomics.util.math.BasicMathFunctions;
import com.compomics.util.parameters.identification.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.peptideshaker.utils.DisplayFeaturesGenerator;
import eu.isas.reporter.calculation.QuantificationFeaturesGenerator;
import eu.isas.reporter.preferences.DisplayPreferences;
import eu.isas.reporter.quantificationdetails.PeptideQuantificationDetails;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.stream.Collectors;
import no.uib.jsparklines.data.ArrrayListDataPoints;
import no.uib.jsparklines.data.JSparklinesDataSeries;
import no.uib.jsparklines.renderers.JSparklinesArrayListBarChartTableCellRenderer;

public class PeptideTableModel
extends SelfUpdatingTableModel {
    private Identification identification;
    private SpectrumProvider spectrumProvider;
    private IdentificationFeaturesGenerator identificationFeaturesGenerator;
    private DisplayFeaturesGenerator displayFeaturesGenerator;
    private IdentificationParameters identificationParameters;
    private QuantificationFeaturesGenerator quantificationFeaturesGenerator;
    private ReporterIonQuantification reporterIonQuantification;
    private ArrayList<String> sampleIndexes;
    private long[] peptideKeys = null;
    private String proteinAccession;
    private boolean showScores = false;
    private int batchSize = 20;
    private ExceptionHandler exceptionHandler;
    private DisplayPreferences displayPreferences;

    public PeptideTableModel(Identification identification, SpectrumProvider spectrumProvider, IdentificationFeaturesGenerator identificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, DisplayFeaturesGenerator displayFeaturesGenerator, DisplayPreferences displayPreferences, IdentificationParameters identificationParameters, String proteinAccession, long[] peptideKeys, boolean displayScores, ExceptionHandler exceptionHandler) {
        this.identification = identification;
        this.spectrumProvider = spectrumProvider;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.reporterIonQuantification = reporterIonQuantification;
        this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.displayPreferences = displayPreferences;
        this.identificationParameters = identificationParameters;
        this.peptideKeys = peptideKeys;
        this.proteinAccession = proteinAccession;
        this.showScores = displayScores;
        this.exceptionHandler = exceptionHandler;
        this.sampleIndexes = new ArrayList<String>(reporterIonQuantification.getSampleIndexes());
        Collections.sort(this.sampleIndexes);
    }

    public void updateDataModel(Identification identification, IdentificationFeaturesGenerator identificationFeaturesGenerator, ReporterIonQuantification reporterIonQuantification, QuantificationFeaturesGenerator quantificationFeaturesGenerator, DisplayFeaturesGenerator displayFeaturesGenerator, DisplayPreferences displayPreferences, IdentificationParameters identificationParameters, String proteinAccession, long[] peptideKeys, boolean showScores) {
        this.identification = identification;
        this.identificationFeaturesGenerator = identificationFeaturesGenerator;
        this.reporterIonQuantification = reporterIonQuantification;
        this.quantificationFeaturesGenerator = quantificationFeaturesGenerator;
        this.displayFeaturesGenerator = displayFeaturesGenerator;
        this.displayPreferences = displayPreferences;
        this.identificationParameters = identificationParameters;
        this.proteinAccession = proteinAccession;
        this.peptideKeys = peptideKeys;
        this.showScores = showScores;
        this.sampleIndexes = new ArrayList<String>(reporterIonQuantification.getSampleIndexes());
        Collections.sort(this.sampleIndexes);
    }

    public void reset() {
        this.peptideKeys = null;
    }

    public PeptideTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.peptideKeys == null ? 0 : this.peptideKeys.length;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return " ";
            }
            case 1: {
                return "Quant";
            }
            case 2: {
                return "PI";
            }
            case 3: {
                return "Accession";
            }
            case 4: {
                return "Sequence";
            }
            case 5: {
                return "#Spectra";
            }
            case 6: {
                if (this.showScores) {
                    return "Score";
                }
                return "Confidence";
            }
            case 7: {
                return "";
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int row, int column) {
        int viewIndex = this.getViewIndex(row);
        if (viewIndex < this.peptideKeys.length) {
            if (column == 0) {
                return viewIndex + 1;
            }
            long peptideKey = this.peptideKeys[viewIndex];
            PeptideMatch peptideMatch = this.identification.getPeptideMatch(peptideKey);
            switch (column) {
                case 1: {
                    ArrayList<Double> data = new ArrayList<Double>();
                    PeptideQuantificationDetails quantificationDetails = this.quantificationFeaturesGenerator.getPeptideMatchQuantificationDetails(this.spectrumProvider, peptideMatch, null);
                    ArrayList<String> reagentsOrder = this.displayPreferences.getReagents();
                    for (String tempReagent : reagentsOrder) {
                        int sampleIndex = this.sampleIndexes.indexOf(tempReagent);
                        Double ratio = quantificationDetails.getRatio(this.sampleIndexes.get(sampleIndex), this.reporterIonQuantification.getNormalizationFactors());
                        if (ratio == null) continue;
                        if (ratio != 0.0) {
                            ratio = BasicMathFunctions.log(ratio, 2.0);
                        }
                        data.add(ratio);
                    }
                    return new JSparklinesDataSeries(data, Color.BLACK, null);
                }
                case 2: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getProteinInferenceGroupClass();
                }
                case 3: {
                    TreeMap<String, int[]> proteinMapping = peptideMatch.getPeptide().getProteinMapping();
                    return proteinMapping.navigableKeySet().stream().collect(Collectors.joining(","));
                }
                case 4: {
                    return this.displayFeaturesGenerator.getTaggedPeptideSequence(peptideMatch, true, true, true);
                }
                case 5: {
                    double nConfidentSpectra = this.identificationFeaturesGenerator.getNConfidentSpectraForPeptide(peptideKey);
                    double nDoubtfulSpectra = (double)this.identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideKey) - nConfidentSpectra;
                    int nSpectra = peptideMatch.getSpectrumMatchesKeys().length;
                    ArrayList<Double> doubleValues = new ArrayList<Double>(3);
                    doubleValues.add(nConfidentSpectra);
                    doubleValues.add(nDoubtfulSpectra);
                    doubleValues.add((double)nSpectra - nConfidentSpectra - nDoubtfulSpectra);
                    ArrrayListDataPoints arrrayListDataPoints = new ArrrayListDataPoints(doubleValues, JSparklinesArrayListBarChartTableCellRenderer.ValueDisplayType.sumOfNumbers);
                    return arrrayListDataPoints;
                }
                case 6: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    return this.showScores ? psParameter.getTransformedScore() : psParameter.getConfidence();
                }
                case 7: {
                    PSParameter psParameter = (PSParameter)peptideMatch.getUrParam(PSParameter.dummy);
                    return psParameter.getMatchValidationLevel().getIndex();
                }
            }
            return null;
        }
        return null;
    }

    public boolean isInstantiated() {
        return this.identification != null;
    }

    public Class getColumnClass(int columnIndex) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getValueAt(i, columnIndex) == null) continue;
            return this.getValueAt(i, columnIndex).getClass();
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    protected void catchException(Exception e) {
        this.setSelfUpdating(false);
        this.exceptionHandler.catchException(e);
    }

    @Override
    protected int loadDataForRows(ArrayList<Integer> rows, WaitingHandler waitingHandler) {
        boolean canceled = rows.parallelStream().map(i -> this.identification.getPeptideMatch(this.peptideKeys[i])).map(peptideMatch -> this.identificationFeaturesGenerator.getNValidatedSpectraForPeptide(peptideMatch.getKey())).anyMatch(dummy -> waitingHandler.isRunCanceled());
        return canceled ? rows.get(0) : rows.get(rows.size() - 1);
    }
}

