/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.preferences;

import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathParameters;
import com.compomics.util.io.flat.SimpleFileReader;
import com.compomics.util.io.flat.SimpleFileWriter;
import eu.isas.peptideshaker.preferences.PeptideShakerPathParameters;
import eu.isas.reporter.export.report.ReporterExportFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class ReporterPathPreferences {
    public static void loadPathParametersFromFile(File inputFile) throws FileNotFoundException, IOException {
        try (SimpleFileReader reader = SimpleFileReader.getFileReader(inputFile);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                ReporterPathPreferences.loadPathParametersFromLine(line);
            }
        }
    }

    public static void loadPathParametersFromLine(String line) throws FileNotFoundException, IOException {
        String id = UtilitiesPathParameters.getPathID(line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        ReporterPathKey reporterPathKey = ReporterPathKey.getKeyFromId(id);
        if (reporterPathKey == null) {
            PeptideShakerPathParameters.loadPathParametersFromLine((String)line);
        } else {
            String path = UtilitiesPathParameters.getPath(line);
            if (!path.equals("default")) {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileNotFoundException("File " + path + " not found.");
                }
                if (reporterPathKey.isDirectory && !file.isDirectory()) {
                    throw new FileNotFoundException("Found a file when expecting a directory for " + reporterPathKey.id + ".");
                }
                ReporterPathPreferences.setPathPreference(reporterPathKey, path);
            }
        }
    }

    public static void setPathPreference(ReporterPathKey reporterPathKey, String path) {
        switch (reporterPathKey.ordinal()) {
            case 0: {
                ReporterExportFactory.setJsonFolder(path);
                return;
            }
        }
        throw new UnsupportedOperationException("Path " + reporterPathKey.id + " not implemented.");
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (ReporterPathKey reporterPathKey : ReporterPathKey.values()) {
            String subDirectory = reporterPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + "could not be created.");
            }
            ReporterPathPreferences.setPathPreference(reporterPathKey, newFile.getAbsolutePath());
        }
        UtilitiesPathParameters.setAllPathsIn(path);
    }

    public static void writeConfigurationToFile(File file) throws IOException {
        try (SimpleFileWriter writer = new SimpleFileWriter(file, false);){
            ReporterPathPreferences.writeConfigurationToFile(writer);
        }
    }

    public static void writeConfigurationToFile(SimpleFileWriter writer) throws IOException {
        for (ReporterPathKey pathKey : ReporterPathKey.values()) {
            ReporterPathPreferences.writePathToFile(writer, pathKey);
        }
        PeptideShakerPathParameters.writeConfigurationToFile((SimpleFileWriter)writer);
    }

    public static void writePathToFile(SimpleFileWriter writer, ReporterPathKey pathKey) throws IOException {
        writer.write(pathKey.id + "=");
        switch (pathKey.ordinal()) {
            case 0: {
                String toWrite = ReporterExportFactory.getJsonFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                writer.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        writer.newLine();
    }

    public static String getPathPreference(ReporterPathKey reporterPathKey, String jarFilePath) {
        switch (reporterPathKey.ordinal()) {
            case 0: {
                return ReporterExportFactory.getJsonFolder();
            }
        }
        throw new UnsupportedOperationException("Path " + reporterPathKey.id + " not implemented.");
    }

    public static ArrayList<PathKey> getErrorKeys(String jarFilePath) throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>();
        for (ReporterPathKey pathKey : ReporterPathKey.values()) {
            String folder = ReporterPathPreferences.getPathPreference(pathKey, jarFilePath);
            if (folder == null || UtilitiesPathParameters.testPath(folder)) continue;
            result.add(pathKey);
        }
        result.addAll(UtilitiesPathParameters.getErrorKeys());
        return result;
    }

    public static enum ReporterPathKey implements PathKey
    {
        reporterExports("reporter_exports", "Folder containing the user custom exports file.", "", true);

        private String id;
        private String description;
        private String defaultSubDirectory;
        private boolean isDirectory;

        private ReporterPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        public static ReporterPathKey getKeyFromId(String id) {
            for (ReporterPathKey pathKey : ReporterPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

