/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.quantificationdetails;

public enum ProteinRatioType {
    all(0, "All", "Ratio calculated using all peptides."),
    unique(1, "Unique", "Ratio calculated using peptides unique to the protein group."),
    shared(2, "Shared", "Ratio calculated using peptides shared with other protein groups.");

    public final int index;
    public final String name;
    public final String description;

    private ProteinRatioType(int index, String name, String description) {
        this.index = index;
        this.name = name;
        this.description = description;
    }

    public static String[] names() {
        ProteinRatioType[] values = ProteinRatioType.values();
        String[] names = new String[values.length];
        int i = 0;
        for (ProteinRatioType proteinRatioType : values) {
            names[i] = proteinRatioType.name;
            ++i;
        }
        return names;
    }

    public static ProteinRatioType getProteinRatioType(int index) {
        for (ProteinRatioType proteinRatioType : ProteinRatioType.values()) {
            if (proteinRatioType.index != index) continue;
            return proteinRatioType;
        }
        return null;
    }
}

