/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

import com.compomics.util.experiment.identification.protein_inference.fm_index.FMIndex;
import com.compomics.util.experiment.io.biology.protein.FastaParameters;
import com.compomics.util.parameters.identification.advanced.PeptideVariantsParameters;
import com.compomics.util.parameters.identification.search.SearchParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.reporter.Reporter;
import eu.isas.reporter.calculation.normalization.NormalizationType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;

public class NormalizationSettings
implements Serializable {
    private NormalizationType psmNormalization = NormalizationType.none;
    private NormalizationType peptideNormalization = NormalizationType.median;
    private NormalizationType proteinNormalization = NormalizationType.median;
    private File stableProteinsFastaFile = null;
    private File contaminantsFastaFile = NormalizationSettings.getDefaultContaminantFile();

    public NormalizationSettings clone() throws CloneNotSupportedException {
        NormalizationSettings clone = new NormalizationSettings();
        clone.setPsmNormalization(this.psmNormalization);
        clone.setPeptideNormalization(this.peptideNormalization);
        clone.setProteinNormalization(this.proteinNormalization);
        clone.setStableProteinsFastaFile(this.stableProteinsFastaFile);
        clone.setContaminantsFastaFile(this.contaminantsFastaFile);
        return clone;
    }

    public boolean isSameAs(NormalizationSettings anotherSetting) {
        if (this.stableProteinsFastaFile == null && anotherSetting.getStableProteinsFastaFile() != null || this.stableProteinsFastaFile != null && anotherSetting.getStableProteinsFastaFile() == null) {
            return false;
        }
        if (this.contaminantsFastaFile == null && anotherSetting.getContaminantsFastaFile() != null || this.contaminantsFastaFile != null && anotherSetting.getContaminantsFastaFile() == null) {
            return false;
        }
        if (this.stableProteinsFastaFile != null && anotherSetting.getStableProteinsFastaFile() != null && !this.stableProteinsFastaFile.getAbsolutePath().equals(anotherSetting.getStableProteinsFastaFile().getAbsolutePath())) {
            return false;
        }
        if (this.contaminantsFastaFile != null && anotherSetting.getContaminantsFastaFile() != null && !this.contaminantsFastaFile.getAbsolutePath().equals(anotherSetting.getContaminantsFastaFile().getAbsolutePath())) {
            return false;
        }
        return this.psmNormalization == anotherSetting.getPsmNormalization() && this.peptideNormalization == anotherSetting.getPeptideNormalization() && this.proteinNormalization == anotherSetting.getProteinNormalization();
    }

    public NormalizationType getPsmNormalization() {
        return this.psmNormalization;
    }

    public void setPsmNormalization(NormalizationType psmNormalization) {
        this.psmNormalization = psmNormalization;
    }

    public NormalizationType getPeptideNormalization() {
        return this.peptideNormalization;
    }

    public void setPeptideNormalization(NormalizationType peptideNormalization) {
        this.peptideNormalization = peptideNormalization;
    }

    public NormalizationType getProteinNormalization() {
        return this.proteinNormalization;
    }

    public void setProteinNormalization(NormalizationType proteinNormalization) {
        this.proteinNormalization = proteinNormalization;
    }

    public File getStableProteinsFastaFile() {
        return this.stableProteinsFastaFile;
    }

    public void setStableProteinsFastaFile(File stableProteinsFastaFile) {
        this.stableProteinsFastaFile = stableProteinsFastaFile;
    }

    public File getContaminantsFastaFile() {
        return this.contaminantsFastaFile;
    }

    public void setContaminantsFastaFile(File contaminantsFastaFile) {
        this.contaminantsFastaFile = contaminantsFastaFile;
    }

    public Collection<String> getStableProteins(SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsPreferences, WaitingHandler waitingHandler) throws IOException {
        if (this.stableProteinsFastaFile != null) {
            FMIndex fmIndex = new FMIndex(this.stableProteinsFastaFile, fastaParameters, waitingHandler, true, peptideVariantsPreferences, searchParameters);
            return fmIndex.getAccessions();
        }
        return null;
    }

    public Collection<String> getContaminants(SearchParameters searchParameters, FastaParameters fastaParameters, PeptideVariantsParameters peptideVariantsPreferences, WaitingHandler waitingHandler) throws IOException {
        if (this.contaminantsFastaFile != null) {
            FMIndex fmIndex = new FMIndex(this.contaminantsFastaFile, fastaParameters, waitingHandler, true, peptideVariantsPreferences, searchParameters);
            return fmIndex.getAccessions();
        }
        return null;
    }

    public static File getDefaultContaminantFile() {
        return new File(Reporter.getConfigFolder(), "resources/crap.fasta");
    }
}

