/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.reporter.settings;

import com.compomics.util.experiment.identification.validation.MatchValidationLevel;
import java.io.Serializable;
import java.util.HashSet;

public class RatioEstimationSettings
implements Serializable {
    private boolean ignoreNullIntensities = false;
    private boolean ignoreMissedCleavages = false;
    private double percentile = 68.0;
    private double ratioResolution = 0.01;
    private int minUnique = 3;
    private HashSet<String> excludingPTM = new HashSet();
    private MatchValidationLevel proteinValidation = MatchValidationLevel.doubtful;
    private MatchValidationLevel peptideValidation = MatchValidationLevel.doubtful;
    private MatchValidationLevel psmValidation = MatchValidationLevel.doubtful;

    public RatioEstimationSettings clone() {
        RatioEstimationSettings clone = new RatioEstimationSettings();
        clone.setIgnoreNullIntensities(this.ignoreNullIntensities);
        clone.setIgnoreMissedCleavages(this.ignoreMissedCleavages);
        clone.setPercentile(this.percentile);
        clone.setRatioResolution(this.ratioResolution);
        for (String excludingPtm : this.excludingPTM) {
            clone.addExcludingPtm(excludingPtm);
        }
        clone.setProteinValidationLevel(this.proteinValidation);
        clone.setPeptideValidationLevel(this.peptideValidation);
        clone.setPsmValidationLevel(this.psmValidation);
        return clone;
    }

    public boolean isSameAs(RatioEstimationSettings anotherSetting) {
        if (this.ignoreNullIntensities != anotherSetting.isIgnoreNullIntensities() || this.percentile != anotherSetting.getPercentile() || this.ratioResolution != anotherSetting.getRatioResolution() || this.proteinValidation != anotherSetting.getProteinValidationLevel() || this.peptideValidation != anotherSetting.getPeptideValidationLevel() || this.psmValidation != anotherSetting.getPsmValidationLevel() || this.excludingPTM.size() != anotherSetting.getExcludingPtms().size() || this.ignoreMissedCleavages != anotherSetting.isIgnoreMissedCleavages() || this.minUnique != anotherSetting.getMinUnique()) {
            return false;
        }
        for (String ptm : anotherSetting.getExcludingPtms()) {
            if (this.excludingPTM.contains(ptm)) continue;
            return false;
        }
        return true;
    }

    public boolean isIgnoreMissedCleavages() {
        return this.ignoreMissedCleavages;
    }

    public void setIgnoreMissedCleavages(boolean ignoreMissedCleavages) {
        this.ignoreMissedCleavages = ignoreMissedCleavages;
    }

    public boolean isIgnoreNullIntensities() {
        return this.ignoreNullIntensities;
    }

    public void setIgnoreNullIntensities(boolean ignoreNullIntensities) {
        this.ignoreNullIntensities = ignoreNullIntensities;
    }

    public double getPercentile() {
        return this.percentile;
    }

    public void setPercentile(double percentile) {
        this.percentile = percentile;
    }

    public double getRatioResolution() {
        return this.ratioResolution;
    }

    public void setRatioResolution(double ratioResolution) {
        this.ratioResolution = ratioResolution;
    }

    public HashSet<String> getExcludingPtms() {
        return this.excludingPTM;
    }

    public void addExcludingPtm(String ptmName) {
        this.excludingPTM.add(ptmName);
    }

    public void emptyPTMList() {
        this.excludingPTM.clear();
    }

    public MatchValidationLevel getProteinValidationLevel() {
        return this.proteinValidation;
    }

    public void setProteinValidationLevel(MatchValidationLevel matchValidationLevel) {
        this.proteinValidation = matchValidationLevel;
    }

    public MatchValidationLevel getPeptideValidationLevel() {
        return this.peptideValidation;
    }

    public void setPeptideValidationLevel(MatchValidationLevel matchValidationLevel) {
        this.peptideValidation = matchValidationLevel;
    }

    public MatchValidationLevel getPsmValidationLevel() {
        return this.psmValidation;
    }

    public void setPsmValidationLevel(MatchValidationLevel matchValidationLevel) {
        this.psmValidation = matchValidationLevel;
    }

    public int getMinUnique() {
        return this.minUnique;
    }

    public void setMinUnique(int minUnique) {
        this.minUnique = minUnique;
    }
}

