/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.bigdecimalmatrix.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import org.ujmp.core.Matrix;
import org.ujmp.core.bigdecimalmatrix.stub.AbstractDenseBigDecimalMatrix2D;

public class DefaultDenseBigDecimalMatrix2D
extends AbstractDenseBigDecimalMatrix2D {
    private static final long serialVersionUID = -5227328974882402868L;
    private final BigDecimal[] values;
    private int rows = 0;
    private int cols = 0;

    public DefaultDenseBigDecimalMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseBigDecimalMatrix2D) {
            BigDecimal[] v = ((DefaultDenseBigDecimalMatrix2D)m).values;
            this.values = new BigDecimal[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new BigDecimal[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setBigDecimal(m.getAsBigDecimal(c), c);
            }
        }
    }

    public DefaultDenseBigDecimalMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new BigDecimal[rows * columns];
        Arrays.fill(this.values, BigDecimal.ZERO);
    }

    public DefaultDenseBigDecimalMatrix2D(BigDecimal[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    public BigDecimal getBigDecimal(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setBigDecimal(BigDecimal value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public BigDecimal getBigDecimal(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setBigDecimal(BigDecimal value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }
}

