/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.booleanmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.stub.AbstractDenseBooleanMatrix2D;

public class ArrayDenseBooleanMatrix2D
extends AbstractDenseBooleanMatrix2D {
    private static final long serialVersionUID = -4334380160318525360L;
    private final boolean[][] values;

    public ArrayDenseBooleanMatrix2D(boolean[] ... v) {
        super((long)v.length, (long)v[0].length);
        this.values = v;
    }

    public ArrayDenseBooleanMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.values = new boolean[rows][columns];
    }

    public ArrayDenseBooleanMatrix2D(boolean ... v) {
        super((long)v.length, 1L);
        this.values = new boolean[v.length][1];
        int r = v.length;
        while (--r >= 0) {
            this.values[r][0] = v[r];
        }
    }

    public boolean getBoolean(long row, long column) {
        return this.values[(int)row][(int)column];
    }

    public void setBoolean(boolean value, long row, long column) {
        this.values[(int)row][(int)column] = value;
    }

    public boolean getBoolean(int row, int column) {
        return this.values[row][column];
    }

    public void setBoolean(boolean value, int row, int column) {
        this.values[row][column] = value;
    }

    public final Matrix transpose() {
        boolean[][] result = new boolean[this.values[0].length][this.values.length];
        int r = result.length;
        while (--r >= 0) {
            int c = result[0].length;
            while (--c >= 0) {
                result[r][c] = this.values[c][r];
            }
        }
        return new ArrayDenseBooleanMatrix2D(result);
    }
}

