/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.longmatrix.calculation.DocTerm;
import org.ujmp.core.util.MathUtil;

public class TfIdf
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 4262822624560201379L;
    private Matrix docTerm = null;
    private Matrix sumPerDoc = null;
    private Matrix sumPerTerm = null;
    private boolean calculateTf = false;
    private boolean calculateIdf = false;
    private boolean normalize = false;

    public TfIdf(Matrix matrix, boolean calculateTf, boolean calculateIdf, boolean normalize) {
        super(matrix);
        this.calculateTf = calculateTf;
        this.calculateIdf = calculateIdf;
        this.normalize = normalize;
        if (normalize) {
            throw new RuntimeException("not yet implemented");
        }
    }

    public double getDouble(long ... coordinates) {
        double result;
        if (this.docTerm == null) {
            this.calculate();
        }
        double tf = this.docTerm.getAsDouble(coordinates);
        double idf = 1.0;
        double numDocs = this.docTerm.getRowCount();
        if (this.calculateTf) {
            tf = this.docTerm.getAsDouble(coordinates) / this.sumPerDoc.getAsDouble(coordinates[0], 0L);
        }
        if (this.calculateIdf) {
            idf = MathUtil.log10(numDocs / this.sumPerTerm.getAsDouble(0L, coordinates[1]));
        }
        return MathUtil.isNaNOrInfinite(result = tf * idf) ? 0.0 : result;
    }

    private void calculate() {
        this.docTerm = new DocTerm(this.getSource()).calcNew();
        if (this.calculateTf) {
            this.sumPerDoc = this.docTerm.sum(Calculation.Ret.NEW, 1, true);
        }
        if (this.calculateIdf) {
            this.sumPerTerm = this.docTerm.toBooleanMatrix().sum(Calculation.Ret.NEW, 0, true);
        }
    }

    public long[] getSize() {
        if (this.docTerm == null) {
            this.calculate();
        }
        return this.docTerm.getSize();
    }
}

