/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.statistical;

import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.util.MathUtil;

public class Cumsum
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 5652893080805473737L;
    private Matrix cumsum = null;
    private boolean ignoreNaN = true;

    public Cumsum(Matrix m, boolean ignoreNaN) {
        super(m);
        this.ignoreNaN = ignoreNaN;
    }

    public double getDouble(long ... coordinates) {
        if (this.cumsum == null) {
            this.createMatrix();
        }
        return this.cumsum.getAsDouble(coordinates);
    }

    private void createMatrix() {
        Matrix source = this.getSource();
        DenseMatrix m = Matrix.Factory.zeros(source.getSize());
        for (long c = 0L; c < source.getColumnCount(); ++c) {
            double sum = 0.0;
            long r = 0L;
            while (r < source.getRowCount()) {
                m.setAsDouble(sum += this.ignoreNaN ? MathUtil.ignoreNaN(source.getAsDouble(r, c)) : source.getAsDouble(r, c), r++, c);
            }
        }
        this.cumsum = m;
    }
}

