/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.stub;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.calculation.DivideMatrix;
import org.ujmp.core.calculation.DivideScalar;
import org.ujmp.core.calculation.MinusMatrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.Mtimes;
import org.ujmp.core.calculation.PlusMatrix;
import org.ujmp.core.calculation.PlusScalar;
import org.ujmp.core.calculation.TimesMatrix;
import org.ujmp.core.calculation.TimesScalar;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.entrywise.creators.Zeros;
import org.ujmp.core.doublematrix.stub.AbstractDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDenseDoubleMatrix2D
extends AbstractDoubleMatrix2D
implements DenseDoubleMatrix2D {
    private static final long serialVersionUID = 4518790844453035022L;

    public AbstractDenseDoubleMatrix2D(long rows, long columns) {
        super(rows, columns);
    }

    @Override
    public final Double getObject(long row, long column) {
        return this.getDouble(row, column);
    }

    @Override
    public final void setObject(Double o, long row, long column) {
        this.setDouble((double)o, row, column);
    }

    @Override
    public final Double getObject(int row, int column) {
        return this.getDouble(row, column);
    }

    @Override
    public final void setObject(Double o, int row, int column) {
        this.setDouble((double)o, row, column);
    }

    public double getAsDouble(long row, long column) {
        return this.getDouble(row, column);
    }

    public double getAsDouble(int row, int column) {
        return this.getDouble(row, column);
    }

    public void setAsDouble(double value, int row, int column) {
        this.setDouble(value, row, column);
    }

    public void setAsDouble(double value, long row, long column) {
        this.setDouble(value, row, column);
    }

    @Override
    public final boolean isSparse() {
        return false;
    }

    @Override
    public Matrix mtimes(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), m2.getColumnCount());
            Mtimes.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.mtimes(m2);
    }

    @Override
    public Matrix times(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
            TimesMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.times(m2);
    }

    @Override
    public Matrix divide(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
            DivideMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.divide(m2);
    }

    @Override
    public Matrix plus(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
            PlusMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.plus(m2);
    }

    @Override
    public Matrix minus(Matrix m2) {
        if (m2 instanceof DenseDoubleMatrix2D) {
            DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
            MinusMatrix.DENSEDOUBLEMATRIX2D.calc(this, (DenseDoubleMatrix2D)m2, result);
            return result;
        }
        return super.minus(m2);
    }

    @Override
    public Matrix minus(double v) {
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
        MinusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix plus(double v) {
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
        PlusScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix times(double v) {
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
        TimesScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix divide(double v) {
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getRowCount(), this.getColumnCount());
        DivideScalar.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)this, v, result);
        return result;
    }

    @Override
    public Matrix transpose() {
        DenseDoubleMatrix2D result = (DenseDoubleMatrix2D)DenseDoubleMatrix2D.Factory.zeros(this.getColumnCount(), this.getRowCount());
        Transpose.DENSEDOUBLEMATRIX2D.calc(this, result);
        return result;
    }

    @Override
    public final int getDimensionCount() {
        return 2;
    }

    @Override
    public final boolean containsCoordinates(long ... coordinates) {
        return Coordinates.isSmallerThan(coordinates, this.getSize());
    }

    @Override
    public final Iterable<long[]> availableCoordinates() {
        return this.allCoordinates();
    }

    @Override
    public final void clear() {
        new Zeros((Matrix)this).calc(Calculation.Ret.ORIG);
    }
}

