/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.genericmatrix.stub;

import org.ujmp.core.AbstractMatrix;
import org.ujmp.core.genericmatrix.GenericMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenericMatrix<T>
extends AbstractMatrix
implements GenericMatrix<T> {
    private static final long serialVersionUID = -7498575238134186845L;

    protected AbstractGenericMatrix(long ... size) {
        super(size);
    }

    public final T getAsObject(long ... coordinates) {
        return this.getObject(coordinates);
    }

    @Override
    public T getObject(long row, long column) {
        return this.getAsObject(row, column);
    }

    @Override
    public void setObject(T value, long row, long column) {
        this.setAsObject(value, row, column);
    }

    @Override
    public T getObject(int row, int column) {
        return this.getAsObject(row, column);
    }

    @Override
    public void setObject(T value, int row, int column) {
        this.setAsObject(value, row, column);
    }

    @Override
    public void setObject(T value, long ... coordinates) {
        this.setAsObject(value, coordinates);
    }

    @Override
    public final void setAsObject(Object o, long ... coordinates) {
        switch (this.getValueType()) {
            case BOOLEAN: {
                this.setAsBoolean(MathUtil.getBoolean(o), coordinates);
                break;
            }
            case BIGINTEGER: {
                this.setAsBigInteger(MathUtil.getBigInteger(o), coordinates);
                break;
            }
            case BIGDECIMAL: {
                this.setAsBigDecimal(MathUtil.getBigDecimal(o), coordinates);
                break;
            }
            case BYTE: {
                this.setAsByte(MathUtil.getByte(o), coordinates);
                break;
            }
            case CHAR: {
                this.setAsChar(MathUtil.getChar(o), coordinates);
                break;
            }
            case DOUBLE: {
                this.setAsDouble(MathUtil.getDouble(o), coordinates);
                break;
            }
            case FLOAT: {
                this.setAsFloat(MathUtil.getFloat(o), coordinates);
                break;
            }
            case INT: {
                this.setAsInt(MathUtil.getInt(o), coordinates);
                break;
            }
            case LONG: {
                this.setAsLong(MathUtil.getLong(o), coordinates);
                break;
            }
            case OBJECT: {
                this.setObject(o, coordinates);
                break;
            }
            case SHORT: {
                this.setAsShort(MathUtil.getShort(o), coordinates);
                break;
            }
            case STRING: {
                this.setAsString(StringUtil.convert(o), coordinates);
            }
        }
    }
}

