/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import org.ujmp.core.Matrix;

public abstract class ImportMatrixM {
    public static Matrix fromString(String string, Object ... parameters) {
        string = string.replaceAll("[\\[\\]\\(\\)\\{\\}]", "");
        String[] rows = string.split("\\s*[;\\n]\\s*");
        String[] cols = rows[0].split("[,\\s*]");
        Object[][] values = new String[rows.length][cols.length];
        for (int r = 0; r < rows.length; ++r) {
            cols = rows[r].split("[,\\s*]");
            for (int c = 0; c < cols.length; ++c) {
                values[r][c] = cols[c];
            }
        }
        return Matrix.Factory.linkToArray(values);
    }

    public static Matrix fromFile(File file, Object ... parameters) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        Matrix matrix = ImportMatrixM.fromReader(reader, parameters);
        ((Reader)reader).close();
        return matrix;
    }

    public static Matrix fromStream(InputStream stream, Object ... parameters) throws IOException {
        InputStreamReader r = new InputStreamReader(stream);
        Matrix matrix = ImportMatrixM.fromReader(r, parameters);
        r.close();
        return matrix;
    }

    public static Matrix fromReader(Reader reader, Object ... parameters) throws IOException {
        String EOL = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        LineNumberReader lr = new LineNumberReader(reader);
        String line = null;
        while ((line = lr.readLine()) != null) {
            sb.append(line + EOL);
        }
        return ImportMatrixM.fromString(sb.toString(), parameters);
    }
}

