/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.calculation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.ujmp.core.Matrix;
import org.ujmp.core.stringmatrix.calculation.AbstractStringCalculation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveWords
extends AbstractStringCalculation {
    private static final long serialVersionUID = 4976043243302036392L;
    public Set<String> wordsToRemove = null;

    public RemoveWords(Matrix m, Collection<String> words) {
        super(m);
        this.wordsToRemove = words instanceof Set ? (Set<Object>)words : new HashSet<String>(words);
    }

    @Override
    public String getString(long ... coordinates) {
        String s = this.getSource().getAsString(coordinates);
        if (s != null) {
            StringBuilder result = new StringBuilder(s.length());
            String[] words = s.split("\\s+");
            for (int i = 0; i < words.length; ++i) {
                String w = words[i];
                if (w.length() == 0) continue;
                if (!this.wordsToRemove.contains(w)) {
                    result.append(w);
                }
                if (i >= words.length - 1) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return "";
    }
}

