/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.List;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;
import org.ujmp.core.util.LongArrayList;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.StringUtil;
import org.ujmp.core.util.io.ByteBufferConcatenation;
import org.ujmp.core.util.io.MemoryByteBufferConcatenation;
import org.ujmp.core.util.io.WeakMappedByteBuffer;
import org.ujmp.core.util.io.WeakMappedByteBufferConcatenation;

public class DenseCSVStringMatrix2D
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = -1966465041178705488L;
    public static final int DEFAULTBUFFERSIZE = 0x800000;
    private final ByteBufferConcatenation byteBufferConcatenation;
    private char columnSeparator;
    private char enclosingCharacter;
    private final LongArrayList rowIndexList = new LongArrayList(4096);
    private long rowCacheId = -1L;
    private List<String> rowCache = null;

    public DenseCSVStringMatrix2D(byte[] bytes) {
        this(ByteBuffer.wrap(bytes));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, char enclosingCharacter, byte[] bytes) {
        this(columnSeparator, enclosingCharacter, ByteBuffer.wrap(bytes));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, byte[] bytes) {
        this(columnSeparator, ByteBuffer.wrap(bytes));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, WeakMappedByteBuffer ... byteBuffers) {
        this(columnSeparator, '\u0000', byteBuffers);
    }

    public DenseCSVStringMatrix2D(char columnSeparator, ByteBuffer ... byteBuffers) {
        this(columnSeparator, '\u0000', byteBuffers);
    }

    public DenseCSVStringMatrix2D(char columnSeparator, char enclosingCharacter, WeakMappedByteBuffer ... byteBuffers) {
        super(0L, 0L);
        this.byteBufferConcatenation = new WeakMappedByteBufferConcatenation(byteBuffers);
        this.columnSeparator = columnSeparator;
        this.enclosingCharacter = enclosingCharacter;
    }

    public DenseCSVStringMatrix2D(char columnSeparator, char enclosingCharacter, ByteBuffer ... byteBuffers) {
        super(0L, 0L);
        this.byteBufferConcatenation = new MemoryByteBufferConcatenation(byteBuffers);
        this.columnSeparator = columnSeparator;
        this.enclosingCharacter = enclosingCharacter;
    }

    public DenseCSVStringMatrix2D(ByteBuffer ... byteBuffers) {
        this('\u0000', byteBuffers);
    }

    public DenseCSVStringMatrix2D(WeakMappedByteBuffer ... byteBuffers) {
        this('\u0000', byteBuffers);
    }

    public DenseCSVStringMatrix2D(String filename) throws IOException {
        this(new File(filename));
    }

    public DenseCSVStringMatrix2D(File file) throws IOException {
        this(new RandomAccessFile(file, "r"));
    }

    public DenseCSVStringMatrix2D(RandomAccessFile randomAccessFile) throws IOException {
        this(WeakMappedByteBuffer.create(randomAccessFile));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, String filename) throws IOException {
        this(columnSeparator, new File(filename));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, File file) throws IOException {
        this(columnSeparator, new RandomAccessFile(file, "r"));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, char enclosingCharacter, File file) throws IOException {
        this(columnSeparator, enclosingCharacter, new RandomAccessFile(file, "r"));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, RandomAccessFile randomAccessFile) throws IOException {
        this(columnSeparator, WeakMappedByteBuffer.create(randomAccessFile));
    }

    public DenseCSVStringMatrix2D(char columnSeparator, char enclosingCharacter, RandomAccessFile randomAccessFile) throws IOException {
        this(columnSeparator, enclosingCharacter, WeakMappedByteBuffer.create(randomAccessFile));
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public synchronized String getString(long row, long column) {
        this.countRowsAndColumns();
        if (this.rowCacheId == row) {
            if (column < (long)this.rowCache.size()) {
                return this.rowCache.get(MathUtil.longToInt(column));
            }
            return null;
        }
        long rowPos1 = this.rowIndexList.get(MathUtil.longToInt(row));
        long rowPos2 = row == this.size[0] - 1L ? this.byteBufferConcatenation.getLength() : this.rowIndexList.get(MathUtil.longToInt(row + 1L));
        int length = MathUtil.longToInt(rowPos2 - rowPos1);
        byte[] buffer = new byte[length];
        this.byteBufferConcatenation.getBytes(buffer, rowPos1, length);
        this.rowCacheId = row;
        this.rowCache = StringUtil.split(new String(buffer, 0, length), this.columnSeparator, this.enclosingCharacter);
        if (column < (long)this.rowCache.size()) {
            return this.rowCache.get(MathUtil.longToInt(column));
        }
        return null;
    }

    public void setString(String value, long row, long column) {
        throw new RuntimeException("matrix is read only");
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void countRowsAndColumns() {
        if (this.size[0] == 0L) {
            DenseCSVStringMatrix2D denseCSVStringMatrix2D = this;
            synchronized (denseCSVStringMatrix2D) {
                if (this.size[0] == 0L) {
                    long rows = 0L;
                    long minTabCount = Long.MAX_VALUE;
                    long minCommaCount = Long.MAX_VALUE;
                    long minSemicolonCount = Long.MAX_VALUE;
                    long minSpaceCount = Long.MAX_VALUE;
                    long minSepCount = Long.MAX_VALUE;
                    long maxTabCount = 0L;
                    long maxCommaCount = 0L;
                    long maxSemicolonCount = 0L;
                    long maxSpaceCount = 0L;
                    long maxSepCount = 0L;
                    long tabCount = 0L;
                    long commaCount = 0L;
                    long semicolonCount = 0L;
                    long spaceCount = 0L;
                    long sepCount = 0L;
                    boolean active = true;
                    byte[] buffer = new byte[0x800000];
                    this.rowIndexList.add(0L);
                    for (long pos = 0L; pos < this.byteBufferConcatenation.getLength(); pos += (long)buffer.length) {
                        long remaining = this.byteBufferConcatenation.getLength() - pos;
                        int lengthToRead = MathUtil.longToInt(Math.min(remaining, (long)buffer.length));
                        this.byteBufferConcatenation.getBytes(buffer, pos, lengthToRead);
                        block12: for (int i = 0; i < lengthToRead; ++i) {
                            if (buffer[i] == this.enclosingCharacter) {
                                active = !active;
                                continue;
                            }
                            if (!active) continue;
                            if (buffer[i] == this.columnSeparator) {
                                ++sepCount;
                                continue;
                            }
                            switch (buffer[i]) {
                                case 92: {
                                    ++i;
                                    continue block12;
                                }
                                case 10: {
                                    maxTabCount = Math.max(maxTabCount, tabCount);
                                    minTabCount = Math.min(minTabCount, tabCount);
                                    maxCommaCount = Math.max(maxCommaCount, commaCount);
                                    minCommaCount = Math.min(minCommaCount, commaCount);
                                    maxSemicolonCount = Math.max(maxSemicolonCount, semicolonCount);
                                    minSemicolonCount = Math.min(minSemicolonCount, semicolonCount);
                                    maxSpaceCount = Math.max(maxSpaceCount, spaceCount);
                                    minSpaceCount = Math.min(minSpaceCount, spaceCount);
                                    maxSepCount = Math.max(maxSepCount, sepCount);
                                    minSepCount = Math.min(minSepCount, sepCount);
                                    tabCount = 0L;
                                    commaCount = 0L;
                                    semicolonCount = 0L;
                                    spaceCount = 0L;
                                    sepCount = 0L;
                                    this.rowIndexList.add(pos + (long)i + 1L);
                                    ++rows;
                                    continue block12;
                                }
                                case 9: {
                                    ++tabCount;
                                    continue block12;
                                }
                                case 59: {
                                    ++semicolonCount;
                                    continue block12;
                                }
                                case 44: {
                                    ++commaCount;
                                    continue block12;
                                }
                                case 32: {
                                    ++spaceCount;
                                    continue block12;
                                }
                            }
                        }
                    }
                    if (this.byteBufferConcatenation.getByte(this.byteBufferConcatenation.getLength() - 1L) != 10) {
                        ++rows;
                    }
                    if (sepCount > 0L || tabCount > 0L || commaCount > 0L || semicolonCount > 0L || spaceCount > 0L) {
                        maxTabCount = Math.max(maxTabCount, tabCount);
                        minTabCount = Math.min(minTabCount, tabCount);
                        maxCommaCount = Math.max(maxCommaCount, commaCount);
                        minCommaCount = Math.min(minCommaCount, commaCount);
                        maxSemicolonCount = Math.max(maxSemicolonCount, semicolonCount);
                        minSemicolonCount = Math.min(minSemicolonCount, semicolonCount);
                        maxSpaceCount = Math.max(maxSpaceCount, spaceCount);
                        minSpaceCount = Math.min(minSpaceCount, spaceCount);
                        maxSepCount = Math.max(maxSepCount, sepCount);
                        minSepCount = Math.min(minSepCount, sepCount);
                    }
                    if (this.columnSeparator == '\u0000') {
                        this.columnSeparator = tabCount > 0L ? (char)9 : (minSemicolonCount == maxSemicolonCount && minSemicolonCount > 0L ? (char)59 : (minCommaCount == maxCommaCount && minCommaCount > 0L ? (char)44 : (minSpaceCount == maxSpaceCount && minSpaceCount > 0L ? (char)32 : (char)9)));
                        if (this.columnSeparator == '\t') {
                            this.size[0] = rows;
                            this.size[1] = maxTabCount + 1L;
                        } else if (this.columnSeparator == ',') {
                            this.size[0] = rows;
                            this.size[1] = maxCommaCount + 1L;
                        } else if (this.columnSeparator == ';') {
                            this.size[0] = rows;
                            this.size[1] = maxSemicolonCount + 1L;
                        } else if (this.columnSeparator == ' ') {
                            this.size[0] = rows;
                            this.size[1] = maxSpaceCount + 1L;
                        } else {
                            this.size[0] = rows;
                            this.size[1] = maxSepCount + 1L;
                        }
                    } else {
                        this.size[0] = rows;
                        this.size[1] = maxSepCount + 1L;
                    }
                }
            }
            System.out.println(this.size[0] + " rows, " + this.size[1] + " columns");
        }
    }

    public long[] getSize() {
        this.countRowsAndColumns();
        return this.size;
    }
}

