/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import org.ujmp.core.util.DistanceMeasure;

public class ManhattanDistance
implements DistanceMeasure {
    public double getDistance(double[] sample1, double[] sample2) throws IllegalArgumentException {
        int n = sample1.length;
        if (n != sample2.length || n < 1) {
            throw new IllegalArgumentException("Input arrays must have the same length.");
        }
        double sumOfDifferences = 0.0;
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(sample1[i]) || Double.isNaN(sample2[i])) continue;
            sumOfDifferences += Math.abs(sample1[i] - sample2[i]);
        }
        return sumOfDifferences;
    }
}

