/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.Matrix;

public class R {
    public static String[] SEARCH = new String[0];
    public static final int POLLINTERVAL = 100;
    public static final int MAXPOLLS = 10;
    private BufferedReader input = null;
    private BufferedWriter output = null;
    private BufferedReader error = null;
    private Process rProcess = null;
    private boolean running = false;
    private static R r;
    private static String pathToR;

    public static synchronized R getInstance() throws Exception {
        if (r == null) {
            r = R.getInstance(R.findR());
        }
        return r;
    }

    public static synchronized R getInstance(String pathToR) throws Exception {
        if (r == null) {
            r = new R(pathToR);
        }
        return r;
    }

    private R(String pathToR) throws Exception {
        this.rProcess = Runtime.getRuntime().exec(pathToR + " --no-save --no-readline");
        this.output = new BufferedWriter(new OutputStreamWriter(this.rProcess.getOutputStream()));
        this.input = new BufferedReader(new InputStreamReader(this.rProcess.getInputStream()));
        this.error = new BufferedReader(new InputStreamReader(this.rProcess.getErrorStream()));
        String startMessage = this.getFromR();
        if (startMessage != null && startMessage.length() > 0) {
            this.running = true;
            return;
        }
        throw new Exception("could not start R");
    }

    private synchronized String getFromR() throws Exception {
        boolean lfSeen = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 10 && !this.input.ready(); ++i) {
            Thread.sleep(100L);
        }
        while (this.input.ready()) {
            char c = (char)this.input.read();
            sb.append(c);
            if (lfSeen) {
                if (c == '>') {
                    return sb.toString();
                }
                lfSeen = false;
            }
            if (c != '\n') continue;
            lfSeen = true;
        }
        return sb.toString();
    }

    public String execute(String command) throws Exception {
        this.sendToR(command);
        String cur = "";
        String last = "";
        cur = this.getFromR();
        while (cur != null && cur.length() > 0) {
            last = cur;
            cur = this.getFromR();
        }
        this.executeNewLine();
        return last;
    }

    private String executeNewLine() throws Exception {
        this.sendToR("");
        String cur = "";
        String last = "";
        cur = this.getFromR();
        while (cur != null && cur.length() > 0) {
            last = cur;
            cur = this.getFromR();
        }
        return last;
    }

    public synchronized void shutdown() throws Exception {
        r = null;
        this.sendToR("q()");
        this.rProcess.waitFor();
        this.output.close();
        this.input.close();
    }

    private synchronized void sendToR(String command) throws Exception {
        if (r != null) {
            try {
                if (!command.endsWith("\n")) {
                    command = command + "\n";
                }
                this.output.write(command, 0, command.length());
                this.output.flush();
            }
            catch (IOException e) {
                this.shutdown();
            }
        }
    }

    public void setMatrix(String label, Matrix matrix) throws Exception {
        this.execute(matrix.exportTo().string().asRScript(label));
    }

    private static String findR() {
        if (pathToR == null) {
            File file = null;
            for (String s : SEARCH) {
                if (s == null || !(file = new File(s)).exists()) continue;
                pathToR = file.getAbsolutePath();
                return pathToR;
            }
        }
        return pathToR;
    }

    public Matrix getMatrix(String label) throws Exception {
        try {
            String rawRows = this.execute("cat(nrow(" + label + "))");
            String rString = rawRows.split("\n")[1].replaceAll("\\>", "").trim();
            int rows = Integer.parseInt(rString);
            String rawCols = this.execute("cat(ncol(" + label + "))");
            String cString = rawCols.split("\n")[1].replaceAll("\\>", "").trim();
            int cols = Integer.parseInt(cString);
            String rawText = this.execute("cat(" + label + ")");
            String[] rawValues = rawText.split("\n")[1].split("[\\s]+");
            DenseMatrix matrix = Matrix.Factory.zeros((long)rows, (long)cols);
            int i = 0;
            for (int r = 0; r < rows; ++r) {
                for (int c = 0; c < cols; ++c) {
                    matrix.setAsDouble(Double.parseDouble(rawValues[i++].replaceAll("\\>", "").trim()), r, c);
                }
            }
            return matrix;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAvailable() {
        return R.findR() != null;
    }

    public static String toString(String[] strings) {
        if (strings.length != 0) {
            return "," + strings[0];
        }
        return "";
    }

    public void plot(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("plot(ujmpmatrix" + R.toString(format) + ")");
    }

    public void pairs(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("pairs(ujmpmatrix" + R.toString(format) + ")");
    }

    public void qqnorm(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("qqnorm(ujmpmatrix" + R.toString(format) + ")");
    }

    public void hist(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("hist(ujmpmatrix" + R.toString(format) + ")");
    }

    public void image(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("image(ujmpmatrix" + R.toString(format) + ")");
    }

    public void boxplot(Matrix matrix, String ... format) throws Exception {
        this.execute("X11()");
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("boxplot(ujmpmatrix" + R.toString(format) + ")");
    }

    public void closeLastFigure() throws Exception {
        this.execute("dev.off()");
    }

    static {
        try {
            SEARCH = new String[]{System.getProperty("R"), "/usr/bin/R", "/opt/R/bin/R"};
        }
        catch (Exception exception) {
            // empty catch block
        }
        r = null;
        pathToR = null;
    }
}

