/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.io;

import org.ujmp.core.util.io.AbstractByteBufferConcatenation;
import org.ujmp.core.util.io.WeakMappedByteBuffer;

public abstract class AbstractWeakMappedByteBufferConcatenation
extends AbstractByteBufferConcatenation {
    protected WeakMappedByteBuffer[] byteBuffers;
    protected final long totalLength;

    public AbstractWeakMappedByteBufferConcatenation(WeakMappedByteBuffer ... byteBuffers) {
        if (byteBuffers.length == 0) {
            throw new IllegalArgumentException("byteBuffers is empty");
        }
        for (WeakMappedByteBuffer bb : byteBuffers) {
            if (bb == null) {
                throw new IllegalArgumentException("cannot use ByteBuffer which is null");
            }
            if (bb.capacity() != 0L) continue;
            throw new IllegalArgumentException("cannot use ByteBuffer which has no capacity");
        }
        this.byteBuffers = byteBuffers;
        long length = 0L;
        for (int i = 0; i < byteBuffers.length; ++i) {
            length += byteBuffers[i].capacity();
        }
        this.totalLength = length;
    }

    public final long getLength() {
        return this.totalLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteBytes(long position, int count) {
        AbstractWeakMappedByteBufferConcatenation abstractWeakMappedByteBufferConcatenation = this;
        synchronized (abstractWeakMappedByteBufferConcatenation) {
            byte[] copyBuffer = new byte[0x800000];
            for (long pos = position; pos < this.totalLength; pos += 0x800000L) {
                int length = (int)Math.min(0x800000L, this.totalLength - pos - (long)count);
                this.getBytes(copyBuffer, pos + (long)count, length);
                this.setBytes(copyBuffer, pos, length);
            }
            this.shrink(count);
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.byteBuffers.length; ++i) {
            sb.append(this.byteBuffers[i].capacity());
            sb.append(",");
        }
        sb.append(" total: ");
        sb.append(this.totalLength);
        return sb.toString();
    }

    public final byte getByte(long position) {
        long offset;
        int byteBufferId = 0;
        for (offset = position; offset >= this.byteBuffers[byteBufferId].capacity(); offset -= this.byteBuffers[byteBufferId++].capacity()) {
        }
        return this.byteBuffers[byteBufferId].get((int)offset);
    }

    public final void setByte(byte b, long position) {
        long offset;
        int byteBufferId = 0;
        for (offset = position; offset >= this.byteBuffers[byteBufferId].capacity(); offset -= this.byteBuffers[byteBufferId++].capacity()) {
        }
        this.byteBuffers[byteBufferId].put((int)offset, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getBytes(byte[] bytes, long position, int length) {
        long offset;
        if (position + (long)length > this.totalLength) {
            throw new IllegalArgumentException("cannot read beyond buffer size");
        }
        int byteBufferId = 0;
        for (offset = position; offset >= this.byteBuffers[byteBufferId].capacity(); offset -= this.byteBuffers[byteBufferId++].capacity()) {
        }
        int remaining = length;
        int pos = 0;
        while (remaining > 0) {
            int byteCount = Math.min((int)(this.byteBuffers[byteBufferId].capacity() - offset), remaining);
            WeakMappedByteBuffer weakMappedByteBuffer = this.byteBuffers[byteBufferId];
            synchronized (weakMappedByteBuffer) {
                this.byteBuffers[byteBufferId].position((int)offset);
                this.byteBuffers[byteBufferId].get(bytes, pos, byteCount);
            }
            remaining -= byteCount;
            pos += byteCount;
            ++byteBufferId;
            offset = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBytes(byte[] bytes, long position, int length) {
        AbstractWeakMappedByteBufferConcatenation abstractWeakMappedByteBufferConcatenation = this;
        synchronized (abstractWeakMappedByteBufferConcatenation) {
            long offset;
            int byteBufferId = 0;
            for (offset = position; offset >= this.byteBuffers[byteBufferId].capacity(); offset -= this.byteBuffers[byteBufferId++].capacity()) {
            }
            int remaining = length;
            int pos = 0;
            while (remaining > 0) {
                int byteCount = Math.min((int)(this.byteBuffers[byteBufferId].capacity() - offset), remaining);
                WeakMappedByteBuffer weakMappedByteBuffer = this.byteBuffers[byteBufferId];
                synchronized (weakMappedByteBuffer) {
                    this.byteBuffers[byteBufferId].position((int)offset);
                    this.byteBuffers[byteBufferId].put(bytes, pos, byteCount);
                }
                remaining -= byteCount;
                pos += byteCount;
                ++byteBufferId;
                offset = 0L;
            }
        }
    }
}

