/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.extra;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.Chromosome;

public class ChromosomeTableCellRenderer
extends JLabel
implements TableCellRenderer {
    private Color selectedFontColor;
    private Color notSelectedFontColor;

    public ChromosomeTableCellRenderer(Color selectedFontColor, Color notSelectedFontColor) {
        this.selectedFontColor = selectedFontColor;
        this.notSelectedFontColor = notSelectedFontColor;
    }

    public void setFontColors(Color selectedFontColor, Color notSelectedFontColor) {
        this.selectedFontColor = selectedFontColor;
        this.notSelectedFontColor = notSelectedFontColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        JLabel valueLabel = new JLabel();
        valueLabel.setHorizontalAlignment(0);
        valueLabel.setFont(valueLabel.getFont().deriveFont((float)valueLabel.getFont().getSize() - 2.0f));
        Color bg = c.getBackground();
        valueLabel.setBorder(c.getBorder());
        valueLabel.setOpaque(c.isOpaque());
        valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        if (isSelected) {
            valueLabel.setForeground(this.selectedFontColor);
        } else {
            valueLabel.setForeground(this.notSelectedFontColor);
        }
        if (value != null && value instanceof Chromosome) {
            valueLabel.setText("" + ((Chromosome)value).toString());
        }
        return valueLabel;
    }
}

