/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.renderers.util.BarChartColorRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class JSparklinesColorTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private Color plotBackgroundColor = null;
    private HashMap<Color, String> tooltips;

    public JSparklinesColorTableCellRenderer() {
        this.tooltips = new HashMap();
        this.setUpRendererAndChart();
    }

    public JSparklinesColorTableCellRenderer(HashMap<Color, String> tooltips) {
        this.tooltips = tooltips;
        this.setUpRendererAndChart();
    }

    private void setUpRendererAndChart() {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add((Component)this.chartPanel);
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null || !(value instanceof Color)) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (this.tooltips.get((Color)value) != null) {
            this.setToolTipText(this.tooltips.get((Color)value));
        } else {
            this.setToolTipText(null);
        }
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue((Number)1, (Comparable)((Object)"1"), (Comparable)((Object)"1"));
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.setDataset((CategoryDataset)dataset);
        plot.setOutlineVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        BarChartColorRenderer renderer = new BarChartColorRenderer((Color)value);
        if (this.plotBackgroundColor != null && !isSelected) {
            plot.setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            plot.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        plot.setRenderer((CategoryItemRenderer)renderer);
        return this;
    }
}

