/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.software.settings.UtilitiesPathParameters;
import eu.isas.searchgui.parameters.SearchGUIPathParameters;
import java.util.ArrayList;
import org.apache.commons.cli.Options;

public enum PathSettingsCLIParams {
    ALL("temp_folder", "A folder for temporary file storage. Use only if you encounter problems with the default configuration."),
    LOG_FOLDER("log", "Folder where the log files are written."),
    USE_LOG_FOLDER("use_log_folder", "Use the log folder. 0: write to standard output, 1: use the log folder. Default: 1.");

    public String id;
    public String description;

    private PathSettingsCLIParams(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (PathSettingsCLIParams pathSettingsCLIParams : PathSettingsCLIParams.values()) {
            aOptions.addOption(pathSettingsCLIParams.id, true, pathSettingsCLIParams.description);
        }
        for (Enum enum_ : SearchGUIPathParameters.SearchGUIPathKey.values()) {
            aOptions.addOption(((SearchGUIPathParameters.SearchGUIPathKey)enum_).getId(), true, ((SearchGUIPathParameters.SearchGUIPathKey)enum_).getDescription());
        }
        for (Enum enum_ : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            aOptions.addOption(enum_.getId(), true, enum_.getDescription());
        }
    }

    public static ArrayList<String> getOptionIDs() {
        ArrayList<String> options = new ArrayList<String>();
        for (PathSettingsCLIParams pathSettingsCLIParams : PathSettingsCLIParams.values()) {
            options.add("-" + pathSettingsCLIParams.id);
        }
        for (Enum enum_ : SearchGUIPathParameters.SearchGUIPathKey.values()) {
            options.add("-" + ((SearchGUIPathParameters.SearchGUIPathKey)enum_).getId());
        }
        for (Enum enum_ : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            options.add("-" + enum_.getId());
        }
        return options;
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Log Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.LOG_FOLDER.id) + " " + PathSettingsCLIParams.LOG_FOLDER.description + "\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.USE_LOG_FOLDER.id) + " " + PathSettingsCLIParams.USE_LOG_FOLDER.description + "\n";
        output = output + "Generic Temporary Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        output = output + "\n\nSpecific Path Setting:\n\n";
        for (SearchGUIPathParameters.SearchGUIPathKey searchGUIPathKey : SearchGUIPathParameters.SearchGUIPathKey.values()) {
            output = output + "-" + String.format(formatter, searchGUIPathKey.getId()) + " " + searchGUIPathKey.getDescription() + System.getProperty("line.separator");
        }
        for (SearchGUIPathParameters.SearchGUIPathKey searchGUIPathKey : UtilitiesPathParameters.UtilitiesPathKey.values()) {
            output = output + "-" + String.format(formatter, searchGUIPathKey.getId()) + " " + searchGUIPathKey.getDescription() + System.getProperty("line.separator");
        }
        return output;
    }
}

