/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.gui;

import com.compomics.util.gui.GuiUtilities;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.renderers.AlignedListCellRenderer;
import com.compomics.util.parameters.UtilitiesUserParameters;
import com.compomics.util.parameters.searchgui.OutputParameters;
import eu.isas.searchgui.gui.SearchGUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class AdvancedParametersDialog
extends JDialog {
    private JPanel advancedParamatersPanel;
    private JComboBox checkMgfFileSizeComboBox;
    private JLabel checkMgfFileSizeLabel;
    private JComboBox checkSpectrumChargesComboBox;
    private JLabel checkSpectrumChargesLabel;
    private JButton closeButton;
    private JComboBox duplicateTitlesComboBox;
    private JLabel duplicateTitlesLabel;
    private JComboBox groupResultFilesCmb;
    private JLabel groupResultFilesTxt;
    private JTextField highSpectrumChargeRangeTxt;
    private JPanel identificationParametersPanel;
    private JComboBox includeDataCmb;
    private JLabel includeDataTxt;
    private JComboBox includeDateCmb;
    private JLabel includeDateLbl;
    private JTextField lowSpectrumChargeRangeTxt;
    private JLabel maxMgfFileSizeLabel;
    private JLabel maxSpectraPerFileLabel;
    private JTextField mgfMaxSizeTxt;
    private JTextField mgfReducedSizeTxt;
    private JButton okButton;
    private JButton openDialogHelpJButton;
    private JPanel outputPanel;
    private JComboBox peakPickingComboBox;
    private JLabel peakPickingLabel;
    private JLabel refMassLbl;
    private JTextField refMassTxt;
    private JComboBox renameCmb;
    private JLabel renameXTandemFileLabel;
    private JLabel spectrumChargeRangeDelimiterLabel;
    private JLabel spectrumChargeRangeLabel;
    private JPanel spectrumProcessingPanel;
    private JComboBox zipIdFilesCmb;
    private JLabel zipIdFilesLabel;

    public AdvancedParametersDialog(SearchGUI searchGUI, boolean modal) {
        super((Frame)searchGUI, modal);
        this.initComponents();
        UtilitiesUserParameters userParameters = UtilitiesUserParameters.loadUserParameters();
        this.mgfMaxSizeTxt.setText(userParameters.getMgfMaxSize() + "");
        this.mgfReducedSizeTxt.setText(userParameters.getMgfNSpectra() + "");
        if (userParameters.renameXTandemFile()) {
            this.renameCmb.setSelectedIndex(0);
        } else {
            this.renameCmb.setSelectedIndex(1);
        }
        if (userParameters.checkPeakPicking()) {
            this.peakPickingComboBox.setSelectedIndex(0);
        } else {
            this.peakPickingComboBox.setSelectedIndex(1);
        }
        if (userParameters.checkDuplicateTitles()) {
            this.duplicateTitlesComboBox.setSelectedIndex(0);
        } else {
            this.duplicateTitlesComboBox.setSelectedIndex(1);
        }
        if (userParameters.checkMgfSize()) {
            this.checkMgfFileSizeComboBox.setSelectedIndex(0);
        } else {
            this.checkMgfFileSizeComboBox.setSelectedIndex(1);
        }
        if (userParameters.isCheckSpectrumCharges()) {
            this.checkSpectrumChargesComboBox.setSelectedIndex(0);
        } else {
            this.checkSpectrumChargesComboBox.setSelectedIndex(1);
        }
        this.lowSpectrumChargeRangeTxt.setText(userParameters.getMinSpectrumChargeRange() + "");
        this.highSpectrumChargeRangeTxt.setText(userParameters.getMaxSpectrumChargeRange() + "");
        this.refMassTxt.setText(userParameters.getRefMass() + "");
        this.groupResultFilesCmb.setSelectedIndex(userParameters.getSearchGuiOutputParameters().id);
        if (userParameters.outputData()) {
            this.includeDataCmb.setSelectedIndex(0);
        } else {
            this.includeDataCmb.setSelectedIndex(1);
        }
        if (userParameters.isIncludeDateInOutputName()) {
            this.includeDateCmb.setSelectedIndex(0);
        } else {
            this.includeDateCmb.setSelectedIndex(1);
        }
        if (userParameters.isGzip()) {
            this.zipIdFilesCmb.setSelectedIndex(0);
        } else {
            this.zipIdFilesCmb.setSelectedIndex(1);
        }
        this.renameCmb.setRenderer(new AlignedListCellRenderer(0));
        this.groupResultFilesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.includeDataCmb.setRenderer(new AlignedListCellRenderer(0));
        this.includeDateCmb.setRenderer(new AlignedListCellRenderer(0));
        this.peakPickingComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.duplicateTitlesComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.checkSpectrumChargesComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.checkMgfFileSizeComboBox.setRenderer(new AlignedListCellRenderer(0));
        this.zipIdFilesCmb.setRenderer(new AlignedListCellRenderer(0));
        this.setLocationRelativeTo(searchGUI);
        this.setVisible(true);
    }

    private void initComponents() {
        this.advancedParamatersPanel = new JPanel();
        this.spectrumProcessingPanel = new JPanel();
        this.peakPickingLabel = new JLabel();
        this.peakPickingComboBox = new JComboBox();
        this.duplicateTitlesLabel = new JLabel();
        this.duplicateTitlesComboBox = new JComboBox();
        this.maxMgfFileSizeLabel = new JLabel();
        this.maxSpectraPerFileLabel = new JLabel();
        this.mgfMaxSizeTxt = new JTextField();
        this.mgfReducedSizeTxt = new JTextField();
        this.checkSpectrumChargesLabel = new JLabel();
        this.checkSpectrumChargesComboBox = new JComboBox();
        this.spectrumChargeRangeLabel = new JLabel();
        this.lowSpectrumChargeRangeTxt = new JTextField();
        this.highSpectrumChargeRangeTxt = new JTextField();
        this.spectrumChargeRangeDelimiterLabel = new JLabel();
        this.checkMgfFileSizeLabel = new JLabel();
        this.checkMgfFileSizeComboBox = new JComboBox();
        this.openDialogHelpJButton = new JButton();
        this.okButton = new JButton();
        this.outputPanel = new JPanel();
        this.groupResultFilesTxt = new JLabel();
        this.groupResultFilesCmb = new JComboBox();
        this.includeDataTxt = new JLabel();
        this.includeDataCmb = new JComboBox();
        this.includeDateLbl = new JLabel();
        this.includeDateCmb = new JComboBox();
        this.renameXTandemFileLabel = new JLabel();
        this.renameCmb = new JComboBox();
        this.zipIdFilesLabel = new JLabel();
        this.zipIdFilesCmb = new JComboBox();
        this.identificationParametersPanel = new JPanel();
        this.refMassLbl = new JLabel();
        this.refMassTxt = new JTextField();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Advanced Settings");
        this.setMinimumSize(new Dimension(500, 300));
        this.setResizable(false);
        this.advancedParamatersPanel.setBackground(new Color(230, 230, 230));
        this.spectrumProcessingPanel.setBorder(BorderFactory.createTitledBorder("Spectrum Processing"));
        this.spectrumProcessingPanel.setOpaque(false);
        this.peakPickingLabel.setText("Peak Picking Check");
        this.peakPickingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.duplicateTitlesLabel.setText("Duplicate Titles Check");
        this.duplicateTitlesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.maxMgfFileSizeLabel.setText("Maximum Mgf File Size (MB)");
        this.maxSpectraPerFileLabel.setText("Maximum Spectra in Mgf File");
        this.mgfMaxSizeTxt.setHorizontalAlignment(0);
        this.mgfMaxSizeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.mgfMaxSizeTxtActionPerformed(evt);
            }
        });
        this.mgfMaxSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AdvancedParametersDialog.this.mgfMaxSizeTxtKeyReleased(evt);
            }
        });
        this.mgfReducedSizeTxt.setHorizontalAlignment(0);
        this.mgfReducedSizeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.mgfReducedSizeTxtActionPerformed(evt);
            }
        });
        this.mgfReducedSizeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AdvancedParametersDialog.this.mgfReducedSizeTxtKeyReleased(evt);
            }
        });
        this.checkSpectrumChargesLabel.setText("Spectrum Charges Check");
        this.checkSpectrumChargesComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.checkSpectrumChargesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.checkSpectrumChargesComboBoxActionPerformed(evt);
            }
        });
        this.spectrumChargeRangeLabel.setText("Spectrum Charge Range");
        this.lowSpectrumChargeRangeTxt.setHorizontalAlignment(0);
        this.lowSpectrumChargeRangeTxt.setText("2");
        this.lowSpectrumChargeRangeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.lowSpectrumChargeRangeTxtActionPerformed(evt);
            }
        });
        this.lowSpectrumChargeRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AdvancedParametersDialog.this.lowSpectrumChargeRangeTxtKeyReleased(evt);
            }
        });
        this.highSpectrumChargeRangeTxt.setHorizontalAlignment(0);
        this.highSpectrumChargeRangeTxt.setText("4");
        this.highSpectrumChargeRangeTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.highSpectrumChargeRangeTxtActionPerformed(evt);
            }
        });
        this.highSpectrumChargeRangeTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AdvancedParametersDialog.this.highSpectrumChargeRangeTxtKeyReleased(evt);
            }
        });
        this.spectrumChargeRangeDelimiterLabel.setText("-");
        this.checkMgfFileSizeLabel.setText("Mgf File Size Check");
        this.checkMgfFileSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.checkMgfFileSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.checkMgfFileSizeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout spectrumProcessingPanelLayout = new GroupLayout(this.spectrumProcessingPanel);
        this.spectrumProcessingPanel.setLayout(spectrumProcessingPanelLayout);
        spectrumProcessingPanelLayout.setHorizontalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.peakPickingLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peakPickingComboBox, -2, 150, -2)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.duplicateTitlesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.duplicateTitlesComboBox, -2, 150, -2)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.checkSpectrumChargesLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkSpectrumChargesComboBox, -2, 150, -2)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(206, 206, 206).addComponent(this.lowSpectrumChargeRangeTxt, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spectrumChargeRangeDelimiterLabel)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.checkMgfFileSizeLabel, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkMgfFileSizeComboBox, -2, 150, -2))).addGap(0, 0, Short.MAX_VALUE)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGap(10, 10, 10).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addComponent(this.spectrumChargeRangeLabel, -1, -1, Short.MAX_VALUE).addGap(137, 137, 137).addComponent(this.highSpectrumChargeRangeTxt, -2, 55, -2)).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.maxMgfFileSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.maxSpectraPerFileLabel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mgfMaxSizeTxt, -2, 150, -2).addComponent(this.mgfReducedSizeTxt, -2, 150, -2)))))).addContainerGap()));
        spectrumProcessingPanelLayout.linkSize(0, this.highSpectrumChargeRangeTxt, this.lowSpectrumChargeRangeTxt);
        spectrumProcessingPanelLayout.setVerticalGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(spectrumProcessingPanelLayout.createSequentialGroup().addContainerGap().addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peakPickingComboBox, -2, -1, -2).addComponent(this.peakPickingLabel)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.duplicateTitlesComboBox, -2, -1, -2).addComponent(this.duplicateTitlesLabel)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkSpectrumChargesLabel).addComponent(this.checkSpectrumChargesComboBox, -2, -1, -2)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectrumChargeRangeLabel).addComponent(this.lowSpectrumChargeRangeTxt, -2, -1, -2).addComponent(this.highSpectrumChargeRangeTxt, -2, -1, -2).addComponent(this.spectrumChargeRangeDelimiterLabel)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.checkMgfFileSizeComboBox, -2, -1, -2).addComponent(this.checkMgfFileSizeLabel)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxMgfFileSizeLabel).addComponent(this.mgfMaxSizeTxt, -2, -1, -2)).addGap(0, 0, 0).addGroup(spectrumProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.maxSpectraPerFileLabel).addComponent(this.mgfReducedSizeTxt, -2, -1, -2)).addContainerGap()));
        this.openDialogHelpJButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/help.GIF")));
        this.openDialogHelpJButton.setToolTipText("Help");
        this.openDialogHelpJButton.setBorder(null);
        this.openDialogHelpJButton.setBorderPainted(false);
        this.openDialogHelpJButton.setContentAreaFilled(false);
        this.openDialogHelpJButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                AdvancedParametersDialog.this.openDialogHelpJButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                AdvancedParametersDialog.this.openDialogHelpJButtonMouseExited(evt);
            }
        });
        this.openDialogHelpJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.openDialogHelpJButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.outputPanel.setBorder(BorderFactory.createTitledBorder("Output"));
        this.outputPanel.setOpaque(false);
        this.groupResultFilesTxt.setText("Group Identification Files");
        this.groupResultFilesCmb.setModel(new DefaultComboBoxModel<String>(OutputParameters.getOutputParametersNames()));
        this.groupResultFilesCmb.setToolTipText("Output files grouping options");
        this.groupResultFilesCmb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.groupResultFilesCmbActionPerformed(evt);
            }
        });
        this.includeDataTxt.setText("Include Spectra and Database");
        this.includeDataTxt.setToolTipText("");
        this.includeDataCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.includeDataCmb.setSelectedIndex(1);
        this.includeDataCmb.setToolTipText("Copy the spectra and fasta files along with the identification results");
        this.includeDateLbl.setText("Include Date in File Name");
        this.includeDateCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.includeDateCmb.setSelectedIndex(1);
        this.renameXTandemFileLabel.setText("Rename X! Tandem File");
        this.renameCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        this.zipIdFilesLabel.setText("Zip Individual ID Files");
        this.zipIdFilesCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Yes", "No"}));
        GroupLayout outputPanelLayout = new GroupLayout(this.outputPanel);
        this.outputPanel.setLayout(outputPanelLayout);
        outputPanelLayout.setHorizontalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(outputPanelLayout.createSequentialGroup().addComponent(this.renameXTandemFileLabel, -2, 200, -2).addGap(4, 4, 4).addComponent(this.renameCmb, 0, -1, Short.MAX_VALUE)).addGroup(outputPanelLayout.createSequentialGroup().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupResultFilesTxt, -2, 200, -2).addComponent(this.includeDataTxt, GroupLayout.Alignment.TRAILING, -2, 190, -2).addComponent(this.includeDateLbl, -2, 200, -2)).addGap(4, 4, 4).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includeDateCmb, -2, 150, -2).addComponent(this.includeDataCmb, -2, 150, -2).addComponent(this.groupResultFilesCmb, -2, 150, -2)))).addGap(0, 2, Short.MAX_VALUE)).addGroup(outputPanelLayout.createSequentialGroup().addComponent(this.zipIdFilesLabel, -2, 200, -2).addGap(4, 4, 4).addComponent(this.zipIdFilesCmb, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        outputPanelLayout.setVerticalGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(outputPanelLayout.createSequentialGroup().addContainerGap().addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.groupResultFilesCmb, -2, -1, -2).addComponent(this.groupResultFilesTxt)).addGap(0, 0, 0).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includeDataTxt).addComponent(this.includeDataCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includeDateLbl).addComponent(this.includeDateCmb, -2, -1, -2)).addGap(0, 0, 0).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.renameCmb, -2, -1, -2).addComponent(this.renameXTandemFileLabel)).addGap(0, 0, 0).addGroup(outputPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.zipIdFilesCmb, -2, -1, -2).addComponent(this.zipIdFilesLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.identificationParametersPanel.setBorder(BorderFactory.createTitledBorder("Search"));
        this.identificationParametersPanel.setOpaque(false);
        this.refMassLbl.setText("Reference Mass (Da)");
        this.refMassLbl.setToolTipText("Reference mass used to convert tolerances from ppm to Da");
        this.refMassTxt.setHorizontalAlignment(0);
        this.refMassTxt.setToolTipText("Reference mass used to convert tolerances from ppm to Da");
        this.refMassTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.refMassTxtActionPerformed(evt);
            }
        });
        this.refMassTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AdvancedParametersDialog.this.refMassTxtKeyReleased(evt);
            }
        });
        GroupLayout identificationParametersPanelLayout = new GroupLayout(this.identificationParametersPanel);
        this.identificationParametersPanel.setLayout(identificationParametersPanelLayout);
        identificationParametersPanelLayout.setHorizontalGroup(identificationParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(identificationParametersPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.refMassLbl, -2, 200, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refMassTxt, -2, 150, -2).addContainerGap(-1, Short.MAX_VALUE)));
        identificationParametersPanelLayout.setVerticalGroup(identificationParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(identificationParametersPanelLayout.createSequentialGroup().addContainerGap().addGroup(identificationParametersPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refMassLbl).addComponent(this.refMassTxt, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedParametersDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout advancedParamatersPanelLayout = new GroupLayout(this.advancedParamatersPanel);
        this.advancedParamatersPanel.setLayout(advancedParamatersPanelLayout);
        advancedParamatersPanelLayout.setHorizontalGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.openDialogHelpJButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addComponent(this.spectrumProcessingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addComponent(this.outputPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, advancedParamatersPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.identificationParametersPanel, -2, -1, -2))))).addContainerGap()));
        advancedParamatersPanelLayout.linkSize(0, this.closeButton, this.okButton);
        advancedParamatersPanelLayout.linkSize(0, this.identificationParametersPanel, this.outputPanel, this.spectrumProcessingPanel);
        advancedParamatersPanelLayout.setVerticalGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addContainerGap().addGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spectrumProcessingPanel, -1, -1, Short.MAX_VALUE).addGroup(advancedParamatersPanelLayout.createSequentialGroup().addComponent(this.outputPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.identificationParametersPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(advancedParamatersPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.okButton).addComponent(this.openDialogHelpJButton).addComponent(this.closeButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advancedParamatersPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.advancedParamatersPanel, -2, -1, -2));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateAdvancedParametersInput(true)) {
            UtilitiesUserParameters userParameters = UtilitiesUserParameters.loadUserParameters();
            userParameters.setRenameXTandemFile(this.renameCmb.getSelectedIndex() == 0);
            userParameters.setCheckPeakPicking(this.peakPickingComboBox.getSelectedIndex() == 0);
            userParameters.setCheckDuplicateTitles(this.duplicateTitlesComboBox.getSelectedIndex() == 0);
            userParameters.setCheckMgfSize(this.checkMgfFileSizeComboBox.getSelectedIndex() == 0);
            userParameters.setMgfMaxSize(Double.parseDouble(this.mgfMaxSizeTxt.getText().trim()));
            userParameters.setMgfNSpectra(Integer.parseInt(this.mgfReducedSizeTxt.getText().trim()));
            OutputParameters outputParameters = OutputParameters.getOutputParameters((int)this.groupResultFilesCmb.getSelectedIndex());
            userParameters.setSearchGuiOutputParameters(outputParameters);
            userParameters.setOutputData(this.includeDataCmb.getSelectedIndex() == 0);
            userParameters.setIncludeDateInOutputName(this.includeDateCmb.getSelectedIndex() == 0);
            userParameters.setRefMass(Double.parseDouble(this.refMassTxt.getText()));
            userParameters.setCheckSpectrumCharges(this.checkSpectrumChargesComboBox.getSelectedIndex() == 0);
            userParameters.setMinSpectrumChargeRange(Integer.parseInt(this.lowSpectrumChargeRangeTxt.getText()));
            userParameters.setMaxSpectrumChargeRange(Integer.parseInt(this.highSpectrumChargeRangeTxt.getText()));
            userParameters.setGzip(this.zipIdFilesCmb.getSelectedIndex() == 0);
            UtilitiesUserParameters.saveUserParameters((UtilitiesUserParameters)userParameters);
            this.dispose();
        }
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void openDialogHelpJButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        new HelpDialog((JDialog)this, this.getClass().getResource("/helpFiles/AdvancedSettingsDialog.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "Advanced Settings - Help", 500, 50);
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void openDialogHelpJButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void refMassTxtActionPerformed(ActionEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void refMassTxtKeyReleased(KeyEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void highSpectrumChargeRangeTxtKeyReleased(KeyEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void highSpectrumChargeRangeTxtActionPerformed(ActionEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void lowSpectrumChargeRangeTxtKeyReleased(KeyEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void lowSpectrumChargeRangeTxtActionPerformed(ActionEvent evt) {
        this.validateAdvancedParametersInput(false);
    }

    private void checkSpectrumChargesComboBoxActionPerformed(ActionEvent evt) {
        this.spectrumChargeRangeLabel.setEnabled(this.checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        this.lowSpectrumChargeRangeTxt.setEnabled(this.checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        this.spectrumChargeRangeDelimiterLabel.setEnabled(this.checkSpectrumChargesComboBox.getSelectedIndex() == 0);
        this.highSpectrumChargeRangeTxt.setEnabled(this.checkSpectrumChargesComboBox.getSelectedIndex() == 0);
    }

    private void mgfReducedSizeTxtKeyReleased(KeyEvent evt) {
        this.mgfReducedSizeTxtActionPerformed(null);
    }

    private void mgfReducedSizeTxtActionPerformed(ActionEvent evt) {
        try {
            Integer.valueOf(this.mgfReducedSizeTxt.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Maximum amount of spectra could not be parsed.", "Input Error", 2);
            this.mgfReducedSizeTxt.setText(this.mgfReducedSizeTxt.getText());
        }
    }

    private void mgfMaxSizeTxtKeyReleased(KeyEvent evt) {
        this.mgfMaxSizeTxtActionPerformed(null);
    }

    private void mgfMaxSizeTxtActionPerformed(ActionEvent evt) {
        try {
            Double.valueOf(this.mgfMaxSizeTxt.getText().trim());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Maximum MGF file size could not be parsed.", "Input Error", 2);
            this.mgfMaxSizeTxt.setText(this.mgfMaxSizeTxt.getText());
        }
    }

    private void checkMgfFileSizeComboBoxActionPerformed(ActionEvent evt) {
        this.maxMgfFileSizeLabel.setEnabled(this.checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        this.mgfMaxSizeTxt.setEnabled(this.checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        this.maxSpectraPerFileLabel.setEnabled(this.checkMgfFileSizeComboBox.getSelectedIndex() == 0);
        this.mgfReducedSizeTxt.setEnabled(this.checkMgfFileSizeComboBox.getSelectedIndex() == 0);
    }

    private void groupResultFilesCmbActionPerformed(ActionEvent evt) {
        boolean enabled = !((String)this.groupResultFilesCmb.getSelectedItem()).equalsIgnoreCase(OutputParameters.no_zip.name);
        this.includeDataTxt.setEnabled(enabled);
        this.includeDataCmb.setEnabled(enabled);
    }

    public boolean validateAdvancedParametersInput(boolean showMessage) {
        boolean valid = true;
        valid = GuiUtilities.validateDoubleInput((Component)this, (JLabel)this.maxMgfFileSizeLabel, (JTextField)this.mgfMaxSizeTxt, (String)"mgf max size", (String)"Mgf Max Size Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        valid = GuiUtilities.validateDoubleInput((Component)this, (JLabel)this.maxSpectraPerFileLabel, (JTextField)this.mgfReducedSizeTxt, (String)"max spectra in mgf file", (String)"Max Spectra Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        valid = GuiUtilities.validateDoubleInput((Component)this, (JLabel)this.refMassLbl, (JTextField)this.refMassTxt, (String)"reference mass", (String)"Reference Mass Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        boolean lowerChargeValid = GuiUtilities.validateIntegerInput((Component)this, (JLabel)this.spectrumChargeRangeLabel, (JTextField)this.lowSpectrumChargeRangeTxt, (String)"lower bound for the precursor charge", (String)"Precursor Charge Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        valid = GuiUtilities.validateIntegerInput((Component)this, (JLabel)this.spectrumChargeRangeLabel, (JTextField)this.highSpectrumChargeRangeTxt, (String)"upper bound for the precursor charge", (String)"Precursor Charge Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        if (!lowerChargeValid) {
            GuiUtilities.validateIntegerInput((Component)this, (JLabel)this.spectrumChargeRangeLabel, (JTextField)this.lowSpectrumChargeRangeTxt, (String)"lower bound for the precursor charge", (String)"Precursor Charge Error", (boolean)true, (boolean)showMessage, (boolean)valid);
        }
        try {
            int chargeLowerBound = Integer.parseInt(this.lowSpectrumChargeRangeTxt.getText().trim());
            int chargeUpperBound = Integer.parseInt(this.highSpectrumChargeRangeTxt.getText().trim());
            if (chargeUpperBound < chargeLowerBound) {
                if (showMessage && valid) {
                    JOptionPane.showMessageDialog(this, "The minimum precursor charge must be lower than or equal to the maximum precursor charge.", "Precursor Charge Error", 2);
                }
                valid = false;
                this.spectrumChargeRangeLabel.setForeground(Color.RED);
                this.spectrumChargeRangeLabel.setToolTipText("Minimum precursor charge > Maximum precursor charge!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return valid;
    }
}

